/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import javax.wbem.client.adapter.http.transport.Executor;
import javax.wbem.client.adapter.http.transport.GetThreadPoolAction;
import javax.wbem.client.adapter.http.transport.TimedConnection;
import javax.wbem.client.adapter.http.transport.TimedMap;

public class ConnectionTimer {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction());
    private TimeoutMap timeouts;

    public ConnectionTimer(long timeout) {
        this.timeouts = new TimeoutMap(timeout);
    }

    public void scheduleTimeout(TimedConnection conn, boolean force) {
        if (conn == null) {
            throw new NullPointerException();
        }
        this.timeouts.put(conn, new Boolean(force));
    }

    public boolean cancelTimeout(TimedConnection conn) {
        if (conn == null) {
            throw new NullPointerException();
        }
        return this.timeouts.remove(conn) != null;
    }

    private static final class TimeoutMap
    extends TimedMap {
        TimeoutMap(long timeout) {
            super(systemThreadPool, timeout);
        }

        void evicted(Object key, Object value) {
            boolean force = (Boolean)value;
            ((TimedConnection)key).shutdown(force);
        }
    }
}

