/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.PopupActionListener;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.RolloverActionListener;
import org.pushingpixels.flamingo.api.common.model.ActionRepeatableButtonModel;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;
import org.pushingpixels.flamingo.api.common.popup.model.AbstractPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.flamingo.api.common.projection.CommandPopupMenuProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.projection.RibbonApplicationMenuCommandButtonProjection;
import org.pushingpixels.flamingo.internal.substance.common.ui.SubstanceCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.CommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuPopupPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.RibbonApplicationMenuPanelProjection;

public class JCommandButton
extends AbstractCommandButton {
    public static final String uiClassID = "CommandButtonUI";
    private PopupPanelCallback popupCallback;
    private CommandButtonKind commandButtonKind;
    private CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind;
    private boolean isAutoRepeatAction;
    private int autoRepeatInitialInterval;
    private int autoRepeatSubsequentInterval;
    private boolean isFireActionOnRollover;
    private PopupButtonModel popupModel;
    private PopupHandler popupHandler;
    private RichTooltip popupRichTooltip;
    private String popupKeyTip;

    public JCommandButton(Projection<AbstractCommandButton, ? extends Command, CommandButtonPresentationModel> projection) {
        super(projection);
        boolean hasPopup;
        ActionRepeatableButtonModel actionButtonModel = new ActionRepeatableButtonModel(this);
        actionButtonModel.setEnabled(this.command.isActionEnabled());
        actionButtonModel.setSelected(this.command.isToggleSelected());
        this.setActionModel(actionButtonModel);
        this.popupHandler = new PopupHandler();
        DefaultPopupButtonModel popupButtonModel = new DefaultPopupButtonModel(this);
        popupButtonModel.setEnabled(((Command)projection.getContentModel()).isSecondaryEnabled());
        this.setPopupModel(popupButtonModel);
        boolean hasAction = this.command.getAction() != null;
        boolean bl = hasPopup = this.command.getSecondaryContentModel() != null;
        if (hasPopup) {
            if (this.command.getSecondaryContentModel() != null) {
                CommandMenuContentModel popupMenuContentModel = this.command.getSecondaryContentModel();
                AbstractPopupMenuPresentationModel popupMenuPresentationModel = this.commandPresentation.getPopupMenuPresentationModel();
                if (popupMenuContentModel instanceof RibbonApplicationMenu) {
                    RibbonApplicationMenuCommandButtonProjection ribbonApplicationMenuProjection = (RibbonApplicationMenuCommandButtonProjection)this.projection;
                    if (popupMenuPresentationModel == null) {
                        popupMenuPresentationModel = CommandPopupMenuPresentationModel.builder().build();
                    }
                    RibbonApplicationMenuPanelProjection menuPanelProjection = new RibbonApplicationMenuPanelProjection((RibbonApplicationMenu)popupMenuContentModel, (CommandPopupMenuPresentationModel)popupMenuPresentationModel);
                    menuPanelProjection.setCommandOverlays(ribbonApplicationMenuProjection.getCommandOverlays());
                    menuPanelProjection.setSecondaryLevelCommandPresentationState(ribbonApplicationMenuProjection.getSecondaryLevelCommandPresentationState());
                    this.setPopupCallback(commandButton -> (JRibbonApplicationMenuPopupPanel)menuPanelProjection.buildComponent());
                } else if (popupMenuContentModel instanceof CommandMenuContentModel) {
                    CommandButtonProjection commandProjection = (CommandButtonProjection)this.projection;
                    if (popupMenuPresentationModel == null) {
                        popupMenuPresentationModel = CommandPopupMenuPresentationModel.builder().build();
                    }
                    CommandPopupMenuProjection commandPopupMenuProjection = new CommandPopupMenuProjection(popupMenuContentModel, (CommandPopupMenuPresentationModel)popupMenuPresentationModel);
                    commandPopupMenuProjection.setCommandOverlays(this.projection.getCommandOverlays());
                    if (commandProjection.getPopupMenuSupplier() != null) {
                        commandPopupMenuProjection.setComponentSupplier(commandProjection.getPopupMenuSupplier());
                    }
                    if (commandProjection.getPopupMenuCustomizer() != null) {
                        commandPopupMenuProjection.setComponentCustomizer(commandProjection.getPopupMenuCustomizer());
                    }
                    this.setPopupCallback(commandButton -> (JCommandPopupMenu)commandPopupMenuProjection.buildComponent());
                }
            }
            this.setPopupRichTooltip(this.command.getSecondaryRichTooltip());
            this.setPopupKeyTip(this.commandPresentation.getPopupKeyTip());
        }
        if (hasAction && hasPopup) {
            this.setCommandButtonKind(this.commandPresentation.isTextClickAction() ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
        } else if (hasPopup) {
            this.setCommandButtonKind(CommandButtonKind.POPUP_ONLY);
        } else {
            this.setCommandButtonKind(CommandButtonKind.ACTION_ONLY);
        }
        if (this.commandPresentation.isAutoRepeatAction()) {
            this.setAutoRepeatAction(true);
            if (this.commandPresentation.hasAutoRepeatIntervalsSet()) {
                this.setAutoRepeatActionIntervals(this.commandPresentation.getAutoRepeatInitialInterval(), this.commandPresentation.getAutoRepeatSubsequentInterval());
            }
        }
        this.setFireActionOnRollover(this.commandPresentation.isFireActionOnRollover());
        this.getActionModel().setFireActionOnPress(this.commandPresentation.isFireActionOnPress());
        this.setPopupOrientationKind(this.commandPresentation.getPopupOrientationKind());
        if (this.command.getActionPreview() != null) {
            this.getActionModel().addChangeListener(new ChangeListener(){
                boolean wasRollover = false;

                @Override
                public void stateChanged(ChangeEvent e) {
                    boolean isRollover = JCommandButton.this.getActionModel().isRollover();
                    if (this.wasRollover && !isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewCanceled(JCommandButton.this.command);
                    }
                    if (!this.wasRollover && isRollover) {
                        JCommandButton.this.command.getActionPreview().onCommandPreviewActivated(JCommandButton.this.command);
                    }
                    this.wasRollover = isRollover;
                }
            });
        }
        this.updateUI();
    }

    public CommandButtonKind getCommandButtonKind() {
        return this.commandButtonKind;
    }

    public void setCommandButtonKind(CommandButtonKind commandButtonKind) {
        CommandButtonKind old = this.commandButtonKind;
        this.commandButtonKind = commandButtonKind;
        if (old != this.commandButtonKind) {
            this.firePropertyChange("commandButtonKind", (Object)old, (Object)this.commandButtonKind);
        }
    }

    public CommandButtonPresentationModel.PopupOrientationKind getPopupOrientationKind() {
        return this.popupOrientationKind;
    }

    public void setPopupOrientationKind(CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind) {
        CommandButtonPresentationModel.PopupOrientationKind old = this.popupOrientationKind;
        this.popupOrientationKind = popupOrientationKind;
        if (old != this.popupOrientationKind) {
            this.firePropertyChange("popupOrientationKind", (Object)old, (Object)this.popupOrientationKind);
        }
    }

    @Override
    public void updateUI() {
        this.setUI(SubstanceCommandButtonUI.createUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public PopupPanelCallback getPopupCallback() {
        return this.popupCallback;
    }

    public void setPopupCallback(PopupPanelCallback popupCallback) {
        this.popupCallback = popupCallback;
        if (this.command != null) {
            boolean hasPopup;
            boolean hasAction = this.command.getAction() != null;
            boolean bl = hasPopup = this.popupCallback != null;
            if (hasPopup) {
                this.setPopupRichTooltip(this.command.getSecondaryRichTooltip());
                this.setPopupKeyTip(this.commandPresentation.getPopupKeyTip());
            }
            if (hasAction && hasPopup) {
                this.setCommandButtonKind(this.commandPresentation.isTextClickAction() ? CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION : CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            } else if (hasPopup) {
                this.setCommandButtonKind(CommandButtonKind.POPUP_ONLY);
            } else {
                this.setCommandButtonKind(CommandButtonKind.ACTION_ONLY);
            }
        }
    }

    public void setAutoRepeatAction(boolean isAutoRepeatAction) {
        this.isAutoRepeatAction = isAutoRepeatAction;
    }

    public void setAutoRepeatActionIntervals(int initial, int subsequent) {
        this.autoRepeatInitialInterval = initial;
        this.autoRepeatSubsequentInterval = subsequent;
    }

    public boolean isAutoRepeatAction() {
        return this.isAutoRepeatAction;
    }

    public int getAutoRepeatInitialInterval() {
        return this.autoRepeatInitialInterval;
    }

    public int getAutoRepeatSubsequentInterval() {
        return this.autoRepeatSubsequentInterval;
    }

    public void setFireActionOnRollover(boolean isFireActionOnRollover) {
        this.isFireActionOnRollover = isFireActionOnRollover;
    }

    public boolean isFireActionOnRollover() {
        return this.isFireActionOnRollover;
    }

    public PopupButtonModel getPopupModel() {
        return this.popupModel;
    }

    public void setPopupModel(PopupButtonModel newModel) {
        PopupButtonModel oldModel = this.getPopupModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.popupHandler);
            oldModel.removeActionListener(this.popupHandler);
        }
        this.popupModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.popupHandler);
            newModel.addActionListener(this.popupHandler);
        }
        this.firePropertyChange("popupModel", oldModel, newModel);
        if (newModel != oldModel) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean b) {
        if (this.popupModel != null && !b && this.popupModel.isRollover()) {
            this.popupModel.setRollover(false);
        }
        super.setEnabled(b);
        if (this.popupModel != null) {
            this.popupModel.setEnabled(b);
        }
    }

    protected void firePopupActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PopupActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    boolean hasRichTooltips() {
        return super.hasRichTooltips() || this.popupRichTooltip != null;
    }

    public void setPopupRichTooltip(RichTooltip richTooltip) {
        this.popupRichTooltip = richTooltip;
    }

    @Override
    public RichTooltip getRichTooltip(MouseEvent event) {
        CommandButtonUI ui = this.getUI();
        if (ui.getLayoutInfo().actionClickArea.contains(event.getPoint())) {
            return super.getRichTooltip(event);
        }
        if (ui.getLayoutInfo().popupClickArea.contains(event.getPoint())) {
            return this.popupRichTooltip;
        }
        return null;
    }

    public String getPopupKeyTip() {
        return this.popupKeyTip;
    }

    public void setPopupKeyTip(String popupKeyTip) {
        String old = this.popupKeyTip;
        this.popupKeyTip = popupKeyTip;
        this.firePropertyChange("popupKeyTip", old, this.popupKeyTip);
    }

    public void doPopupClick() {
        Dimension size = this.getSize();
        PopupButtonModel popupModel = this.getPopupModel();
        popupModel.setArmed(true);
        popupModel.setPressed(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        popupModel.setPressed(false);
        popupModel.setArmed(false);
        popupModel.setPopupShowing(true);
        this.paintImmediately(new Rectangle(0, 0, size.width, size.height));
    }

    public boolean isPopupVisible() {
        List<PopupPanelManager.PopupInfo> popupInfos = PopupPanelManager.defaultManager().getShownPath();
        for (PopupPanelManager.PopupInfo popupInfo : popupInfos) {
            if (popupInfo.getPopupOriginator() != this) continue;
            return true;
        }
        return false;
    }

    public void addRolloverActionListener(RolloverActionListener l) {
        this.listenerList.add(RolloverActionListener.class, l);
    }

    public void removeRolloverActionListener(RolloverActionListener l) {
        this.listenerList.remove(RolloverActionListener.class, l);
    }

    public void doActionRollover() {
        ActionEvent ae = new ActionEvent(this, 1001, this.getActionModel().getActionCommand());
        RolloverActionListener[] listeners = (RolloverActionListener[])this.getListeners(RolloverActionListener.class);
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].actionPerformed(ae);
        }
    }

    class PopupHandler
    implements PopupActionListener,
    ChangeListener {
        PopupHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JCommandButton.this.fireStateChanged();
            JCommandButton.this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JCommandButton.this.firePopupActionPerformed(event);
        }
    }

    private static class DefaultPopupButtonModel
    extends DefaultButtonModel
    implements PopupButtonModel {
        public static final int POPUP_SHOWING = 256;
        private JCommandButton commandButton;

        public DefaultPopupButtonModel(JCommandButton commandButton) {
            this.commandButton = commandButton;
        }

        @Override
        public void addPopupActionListener(PopupActionListener l) {
            this.listenerList.add(PopupActionListener.class, l);
        }

        @Override
        public void removePopupActionListener(PopupActionListener l) {
            this.listenerList.remove(PopupActionListener.class, l);
        }

        protected void firePopupActionPerformed(ActionEvent e) {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != PopupActionListener.class) continue;
                ((PopupActionListener)listeners[i + 1]).actionPerformed(e);
            }
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.commandButton.getUI().setInnerFocusOnAction(false);
                this.firePopupActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
            this.fireStateChanged();
        }

        @Override
        public boolean isPopupShowing() {
            return (this.stateMask & 0x100) != 0;
        }

        @Override
        public void setPopupShowing(boolean b) {
            if (this.isPopupShowing() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 0x100) : (this.stateMask &= 0xFFFFFEFF);
            this.fireStateChanged();
        }
    }

    public static enum CommandButtonKind {
        ACTION_ONLY(true, false),
        POPUP_ONLY(false, true),
        ACTION_AND_POPUP_MAIN_ACTION(true, true),
        ACTION_AND_POPUP_MAIN_POPUP(true, true);

        private boolean hasAction;
        private boolean hasPopup;

        private CommandButtonKind(boolean hasAction, boolean hasPopup) {
            this.hasAction = hasAction;
            this.hasPopup = hasPopup;
        }

        public boolean hasAction() {
            return this.hasAction;
        }

        public boolean hasPopup() {
            return this.hasPopup;
        }
    }
}

