/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.ribbon.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.ContentModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;

public class RibbonGalleryContentModel
implements ContentModel {
    private List<CommandGroup> commandGroups;
    private List<CommandGroup> extraPopupCommandGroups;
    private Command selectedCommand;
    private ResizableIcon.Factory iconFactory;
    private EventListenerList listenerList = new EventListenerList();
    private CommandGroup.CommandGroupListener commandGroupListener;

    public RibbonGalleryContentModel(ResizableIcon.Factory iconFactory, List<CommandGroup> commands) {
        this.iconFactory = iconFactory;
        this.commandGroups = new ArrayList<CommandGroup>(commands);
        this.commandGroupListener = new CommandGroup.CommandGroupListener(){

            @Override
            public void onCommandAdded(Command command) {
                RibbonGalleryContentModel.this.fireStateChanged();
            }

            @Override
            public void onCommandRemoved(Command command) {
                RibbonGalleryContentModel.this.fireStateChanged();
            }

            @Override
            public void onAllCommandsRemoved() {
                RibbonGalleryContentModel.this.fireStateChanged();
            }
        };
        for (CommandGroup commandGroupModel : this.commandGroups) {
            commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        }
        this.extraPopupCommandGroups = new ArrayList<CommandGroup>();
    }

    public ResizableIcon.Factory getIconFactory() {
        return this.iconFactory;
    }

    public List<CommandGroup> getCommandGroups() {
        return Collections.unmodifiableList(this.commandGroups);
    }

    public CommandGroup getCommandGroupByTitle(String commandGroupTitle) {
        for (CommandGroup commandGroupModel : this.commandGroups) {
            if (!commandGroupModel.getTitle().equals(commandGroupTitle)) continue;
            return commandGroupModel;
        }
        return null;
    }

    public void addCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.add(commandGroupModel);
        commandGroupModel.addCommandGroupListener(this.commandGroupListener);
        this.fireStateChanged();
    }

    public void removeCommandGroup(CommandGroup commandGroupModel) {
        this.commandGroups.remove(commandGroupModel);
        commandGroupModel.removeCommandGroupListener(this.commandGroupListener);
        this.fireStateChanged();
    }

    public void addExtraPopupCommandGroup(CommandGroup commandGroupModel) {
        this.extraPopupCommandGroups.add(commandGroupModel);
    }

    public void removeExtraPopupCommandGroup(CommandGroup commandGroupModel) {
        this.extraPopupCommandGroups.remove(commandGroupModel);
    }

    public List<CommandGroup> getExtraPopupCommandGroups() {
        return Collections.unmodifiableList(this.extraPopupCommandGroups);
    }

    public void addCommandPreviewListener(GalleryCommandActionPreview l) {
        this.listenerList.add(GalleryCommandActionPreview.class, l);
    }

    public void removeCommandPreviewListener(GalleryCommandActionPreview l) {
        this.listenerList.remove(GalleryCommandActionPreview.class, l);
    }

    public void addCommandActivationListener(GalleryCommandAction l) {
        this.listenerList.add(GalleryCommandAction.class, l);
    }

    public void removeCommandActivationListener(GalleryCommandAction l) {
        this.listenerList.remove(GalleryCommandAction.class, l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void setSelectedCommand(Command command) {
        if (this.selectedCommand != command) {
            if (this.selectedCommand != null) {
                this.selectedCommand.setToggleSelected(false);
            }
            this.selectedCommand = command;
            if (this.selectedCommand != null) {
                this.selectedCommand.setToggleSelected(true);
            }
            this.fireCommandSelected(this.selectedCommand);
        }
    }

    public Command getSelectedCommand() {
        return this.selectedCommand;
    }

    public void activatePreview(Command command) {
        this.fireCommandPreviewActivated(command);
    }

    public void cancelPreview(Command command) {
        this.fireCommandPreviewCanceled(command);
    }

    private void fireCommandPreviewActivated(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GalleryCommandActionPreview.class) continue;
            ((GalleryCommandActionPreview)listeners[i + 1]).onCommandPreviewActivated(command);
        }
    }

    private void fireCommandPreviewCanceled(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GalleryCommandActionPreview.class) continue;
            ((GalleryCommandActionPreview)listeners[i + 1]).onCommandPreviewCanceled(command);
        }
    }

    private void fireCommandSelected(Command command) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GalleryCommandAction.class) continue;
            ((GalleryCommandAction)listeners[i + 1]).onCommandActivated(command);
        }
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public static interface GalleryCommandAction
    extends EventListener {
        public void onCommandActivated(Command var1);
    }

    public static interface GalleryCommandActionPreview
    extends EventListener {
        public void onCommandPreviewActivated(Command var1);

        public void onCommandPreviewCanceled(Command var1);
    }
}

