/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandStripPresentationModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.internal.substance.common.GlowingResizableIcon;
import org.pushingpixels.flamingo.internal.substance.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.AnimationConfigurationManager;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

public class CommandButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> imageCache = new LazyResettableHashMap("Substance.Flamingo.CommandButtonBackgroundDelegate");

    public static BufferedImage getFullAlphaBackground(AbstractCommandButton commandButton, ButtonModel buttonModel, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, StateTransitionTracker stateTransitionTracker, boolean ignoreSelections) {
        HashMapKey baseKey;
        BufferedImage baseLayer;
        Map activeStates;
        StateTransitionTracker.ModelStateInfo modelStateInfo;
        StateTransitionTracker.ModelStateInfo modelStateInfo2 = modelStateInfo = stateTransitionTracker == null ? null : stateTransitionTracker.getModelStateInfo();
        Map map = modelStateInfo == null ? null : (activeStates = ignoreSelections ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap());
        ComponentState currState = modelStateInfo == null ? ComponentState.getState((ButtonModel)buttonModel, (JComponent)commandButton) : (ignoreSelections ? modelStateInfo.getCurrModelStateNoSelection() : modelStateInfo.getCurrModelState());
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ComponentState)currState);
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)currState);
        float radius = ((CommandButtonPresentationModel)commandButton.getProjection().getPresentationModel()).isMenu() ? 0.0f : SubstanceSizeUtils.getClassicButtonCornerRadius((int)SubstanceSizeUtils.getComponentFontSize((Component)commandButton));
        Set straightSides = SubstanceCoreUtilities.getSides((JComponent)commandButton, (String)"substancelaf.internal.buttonStraightSide");
        AbstractCommandButton.CommandButtonLocationOrderKind locationOrderKind = commandButton.getLocationOrderKind();
        int dx = 0;
        int dy = 0;
        int dw = 0;
        int dh = 0;
        boolean isVertical = false;
        if (locationOrderKind != null && locationOrderKind != AbstractCommandButton.CommandButtonLocationOrderKind.ONLY) {
            Container parent = commandButton.getParent();
            if (parent instanceof JCommandButtonStrip && ((CommandStripPresentationModel)((JCommandButtonStrip)parent).getProjection().getPresentationModel()).getOrientation() == CommandStripPresentationModel.StripOrientation.VERTICAL) {
                isVertical = true;
                switch (locationOrderKind) {
                    case FIRST: {
                        dh = commandButton.getHeight() / 2;
                        break;
                    }
                    case MIDDLE: {
                        dy = -commandButton.getHeight() / 2;
                        dh = commandButton.getHeight();
                        break;
                    }
                    case LAST: {
                        dy = -commandButton.getHeight() / 2;
                        dh = commandButton.getHeight() / 2;
                    }
                }
            } else {
                boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
                if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                    dx = -commandButton.getWidth() / 2;
                    dw = commandButton.getWidth();
                } else {
                    boolean curveOnLeft;
                    boolean bl = curveOnLeft = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST;
                    if (curveOnLeft) {
                        dw = commandButton.getWidth() / 2;
                    } else {
                        dx = -commandButton.getWidth() / 2;
                        dw = commandButton.getWidth() / 2;
                    }
                }
            }
        }
        if ((baseLayer = (BufferedImage)imageCache.get(baseKey = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{currState, width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), commandButton.getClass().getName(), Float.valueOf(radius), straightSides, SubstanceSizeUtils.getComponentFontSize((Component)commandButton), locationOrderKind, dx, dy, dw, dh, isVertical}))) == null) {
            baseLayer = CommandButtonBackgroundDelegate.getSingleLayer(commandButton, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, radius, straightSides, locationOrderKind, dx, dy, dw, dh, isVertical);
            imageCache.put(baseKey, (Object)baseLayer);
        }
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return baseLayer;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D g2d = result.createGraphics();
        NeonCortex.drawImage((Graphics)g2d, (Image)baseLayer, (int)0, (int)0);
        for (Map.Entry activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = (ComponentState)activeEntry.getKey();
            if (activeState == currState || (contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution()) == 0.0f) continue;
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (ComponentState)activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)commandButton, (SubstanceSlices.ColorSchemeAssociationKind)SubstanceSlices.ColorSchemeAssociationKind.BORDER, (ComponentState)activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey((Object[])new Object[]{activeState, width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), commandButton.getClass().getName(), Float.valueOf(radius), straightSides, SubstanceSizeUtils.getComponentFontSize((Component)commandButton), locationOrderKind, dx, dy, dw, dh, isVertical});
            BufferedImage layer = (BufferedImage)imageCache.get(key);
            if (layer == null) {
                layer = CommandButtonBackgroundDelegate.getSingleLayer(commandButton, fillPainter, borderPainter, width, height, fillScheme, borderScheme, radius, straightSides, locationOrderKind, dx, dy, dw, dh, isVertical);
                imageCache.put(key, (Object)layer);
            }
            g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
            NeonCortex.drawImage((Graphics)g2d, (Image)layer, (int)0, (int)0);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage getSingleLayer(AbstractCommandButton commandButton, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, float radius, Set<SubstanceSlices.Side> straightSides, AbstractCommandButton.CommandButtonLocationOrderKind locationOrderKind, int dx, int dy, int dw, int dh, boolean isVertical) {
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline((float)(width + dw), (float)(height + dh), (float)radius, straightSides, (float)borderDelta);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage((int)width, (int)height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        finalGraphics.translate(dx, dy);
        fillPainter.paintContourBackground((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), (Shape)contour, false, fillScheme, true);
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline((float)(width + dw), (float)(height + dh), (float)radius, straightSides, (float)(borderDelta + borderThickness));
        borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), (Shape)contour, (Shape)contourInner, borderScheme);
        if (isVertical) {
            Line2D.Double upper;
            float xe;
            float xs;
            float y;
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                y = (float)(-dy + commandButton.getHeight()) - borderDelta - borderThickness;
                xs = borderDelta;
                xe = (float)commandButton.getWidth() - borderDelta;
                upper = new Line2D.Double(xs + borderThickness, y, xe - borderThickness, y);
                Line2D.Double lower = new Line2D.Double(xs, y += borderThickness, xe, y);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), (Shape)lower, (Shape)upper, borderScheme);
            }
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST) {
                y = (float)(-dy) + borderDelta;
                xs = borderDelta;
                xe = (float)commandButton.getWidth() - borderDelta;
                upper = new Line2D.Double(xs + borderThickness, y, xe - borderThickness, y);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), null, (Shape)upper, borderScheme);
            }
        } else {
            boolean rightmost;
            boolean leftmost;
            boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
            boolean bl = leftmost = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST;
            if (leftmost || locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE) {
                float x = (float)(-dx + commandButton.getWidth()) - borderDelta - borderThickness;
                float ys = borderDelta;
                float ye = (float)commandButton.getHeight() - borderDelta;
                Line2D.Double upper = new Line2D.Double(x, ys + borderThickness, x, ye - borderThickness);
                Line2D.Double lower = new Line2D.Double(x += borderThickness, ys, x, ye);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), (Shape)lower, (Shape)upper, borderScheme);
            }
            boolean bl2 = rightmost = ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.LAST || !ltr && locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.FIRST;
            if (locationOrderKind == AbstractCommandButton.CommandButtonLocationOrderKind.MIDDLE || rightmost) {
                float x = (float)(-dx) + borderDelta;
                float ys = borderDelta;
                float ye = (float)commandButton.getHeight() - borderDelta;
                Line2D.Double upper = new Line2D.Double(x, ys + borderThickness, x, ye - borderThickness);
                borderPainter.paintBorder((Graphics)finalGraphics, (Component)commandButton, (float)(width + dw), (float)(height + dh), null, (Shape)upper, borderScheme);
            }
        }
        return newBackground;
    }

    public static BufferedImage getCombinedCommandButtonBackground(AbstractCommandButton commandButton, ButtonModel actionModel, Rectangle actionArea, PopupButtonModel popupModel, Rectangle popupArea) {
        DefaultButtonModel backgroundModel = new DefaultButtonModel();
        backgroundModel.setEnabled(actionModel.isEnabled() && popupModel.isEnabled());
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter((Component)commandButton);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter((Component)commandButton);
        boolean ignoreSelections = ((Command)commandButton.getProjection().getContentModel()).isToggle() && ((CommandButtonPresentationModel)commandButton.getProjection().getPresentationModel()).isMenu();
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, backgroundModel, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), null, ignoreSelections);
        BufferedImage layers = SubstanceCoreUtilities.getBlankImage((int)fullAlphaBackground.getWidth(), (int)fullAlphaBackground.getHeight());
        Graphics2D combinedGraphics = layers.createGraphics();
        NeonCortex.drawImage((Graphics)combinedGraphics, (Image)fullAlphaBackground, (int)0, (int)0);
        ActionPopupTransitionAwareUI ui = (ActionPopupTransitionAwareUI)((Object)commandButton.getUI());
        if (actionModel.isEnabled() && popupModel.isEnabled()) {
            backgroundModel.setRollover(actionModel.isRollover() || popupModel.isRollover() || popupModel.isPopupShowing());
            combinedGraphics.setComposite(AlphaComposite.SrcOver.derive(0.6f));
            BufferedImage rolloverBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, backgroundModel, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getTransitionTracker(), ignoreSelections);
            NeonCortex.drawImage((Graphics)combinedGraphics, (Image)rolloverBackground, (int)0, (int)0);
        }
        if (actionArea != null && !actionArea.isEmpty()) {
            float actionAlpha;
            Graphics2D graphicsAction = (Graphics2D)combinedGraphics.create();
            graphicsAction.clip(actionArea);
            float f = actionAlpha = actionModel.isSelected() ? 1.0f : 0.4f;
            if (popupModel != null && !popupModel.isEnabled()) {
                actionAlpha = 1.0f;
            }
            if (!actionModel.isEnabled()) {
                actionAlpha = 0.0f;
            }
            graphicsAction.setComposite(AlphaComposite.SrcOver.derive(actionAlpha));
            BufferedImage actionAreaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, null, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getActionTransitionTracker(), ignoreSelections);
            NeonCortex.drawImage((Graphics)graphicsAction, (Image)actionAreaBackground, (int)0, (int)0);
            graphicsAction.dispose();
        }
        if (popupArea != null && !popupArea.isEmpty()) {
            Graphics2D graphicsPopup = (Graphics2D)combinedGraphics.create();
            graphicsPopup.clip(popupArea);
            float popupAlpha = 0.4f;
            if (!actionModel.isEnabled()) {
                popupAlpha = 1.0f;
            }
            if (popupModel != null && !popupModel.isEnabled()) {
                popupAlpha = 0.0f;
            }
            graphicsPopup.setComposite(AlphaComposite.SrcOver.derive(popupAlpha));
            BufferedImage popupAreaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(commandButton, null, fillPainter, borderPainter, commandButton.getWidth(), commandButton.getHeight(), ui.getPopupTransitionTracker(), ignoreSelections);
            NeonCortex.drawImage((Graphics)graphicsPopup, (Image)popupAreaBackground, (int)0, (int)0);
            graphicsPopup.dispose();
        }
        combinedGraphics.dispose();
        return layers;
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + imageCache.size() + " regular");
        return sb.toString();
    }

    public static void paintCommandButtonIcon(Graphics2D g, Rectangle iconRect, AbstractCommandButton commandButton, Icon regular, GlowingResizableIcon glowingIcon, ButtonModel model, StateTransitionTracker stateTransitionTracker) {
        boolean useThemed = SubstanceCoreUtilities.useThemedDefaultIcon((JComponent)commandButton);
        Icon themed = useThemed ? SubstanceCoreUtilities.getThemedIcon((Component)commandButton, (Icon)regular) : regular;
        boolean useRegularVersion = model.isArmed() || model.isPressed() || model.isSelected() || regular.getClass().isAnnotationPresent(TransitionAware.class);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(iconRect.x, iconRect.y);
        float alpha = stateTransitionTracker.getActiveStrength();
        if (alpha > 0.0f && glowingIcon != null && model.isEnabled() && AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceSlices.AnimationFacet.ICON_GLOW, (Component)commandButton) && stateTransitionTracker.getIconGlowTracker().isPlaying()) {
            glowingIcon.paintIcon(commandButton, g2d, 0, 0);
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (useRegularVersion) {
            regular.paintIcon(commandButton, g2d, 0, 0);
        } else {
            double scaleFactor = NeonCortex.getScaleFactor();
            if (alpha < 1.0f) {
                BufferedImage themedImage = SubstanceCoreUtilities.getBlankImage((int)themed.getIconWidth(), (int)themed.getIconHeight());
                themed.paintIcon(commandButton, themedImage.createGraphics(), 0, 0);
                g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)commandButton, (float)(1.0f - alpha), (Graphics)g));
                g2d.drawImage(themedImage, 0, 0, (int)((double)themedImage.getWidth() / scaleFactor), (int)((double)themedImage.getHeight() / scaleFactor), null);
            }
            if (alpha > 0.0f) {
                BufferedImage regularImage = SubstanceCoreUtilities.getBlankImage((int)regular.getIconWidth(), (int)regular.getIconHeight());
                regular.paintIcon(commandButton, regularImage.createGraphics(), 0, 0);
                g2d.setComposite(WidgetUtilities.getAlphaComposite((Component)commandButton, (float)alpha, (Graphics)g));
                g2d.drawImage(regularImage, 0, 0, (int)((double)regularImage.getWidth() / scaleFactor), (int)((double)regularImage.getHeight() / scaleFactor), null);
            }
        }
        g2d.dispose();
    }
}

