/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;
import org.pushingpixels.flamingo.api.bcb.JBreadcrumbBar;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JScrollablePanel;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.PopupButtonModel;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbBarUI;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbItemChoices;
import org.pushingpixels.flamingo.internal.ui.common.JCircularProgress;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;

public abstract class BasicBreadcrumbBarUI
extends BreadcrumbBarUI {
    private JBreadcrumbBar<Object> breadcrumbBar;
    private JCircularProgress circularProgress;
    private JPanel mainPanel;
    private JScrollablePanel<JPanel> scrollerPanel;
    private ComponentListener componentListener;
    private AbstractCommandButton dummy;
    private LinkedList<Object> modelStack;
    private LinkedList<JCommandButton> buttonStack;
    private LinkedList<Command> commandStack;
    private BreadcrumbPathListener<Object> pathListener;
    private AtomicInteger atomicCounter;
    private Timer loadingTimer;
    private boolean isShowingProgress;

    @Override
    public void installUI(JComponent c) {
        this.breadcrumbBar = (JBreadcrumbBar)c;
        this.modelStack = new LinkedList();
        this.buttonStack = new LinkedList();
        this.commandStack = new LinkedList();
        this.installDefaults(this.breadcrumbBar);
        this.installComponents(this.breadcrumbBar);
        this.installListeners(this.breadcrumbBar);
        c.setLayout(this.createLayoutManager());
        if (this.breadcrumbBar.getCallback() != null) {
            SwingWorker<List<StringValuePair<Object>>, Void> worker = new SwingWorker<List<StringValuePair<Object>>, Void>(){

                @Override
                protected List<StringValuePair<Object>> doInBackground() throws Exception {
                    BasicBreadcrumbBarUI.this.startLoadingTimer();
                    return BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                }

                @Override
                protected void done() {
                    try {
                        BasicBreadcrumbBarUI.this.stopLoadingTimer();
                        BasicBreadcrumbBarUI.this.pushChoices(new BreadcrumbItemChoices<Object>(null, (List)this.get()));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace(System.err);
                    }
                }
            };
            worker.execute();
        }
        this.dummy = (AbstractCommandButton)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText("Dummy")).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> {})).build().project(CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).build()).buildComponent();
        int preferredHeight = this.dummy.getPreferredSize().height;
        this.circularProgress.setBorder(new EmptyBorder((preferredHeight - 12) / 2, 10, (preferredHeight - 12) / 2, 10));
        this.circularProgress.setPreferredSize(new Dimension(32, preferredHeight));
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setLayout(null);
        this.uninstallListeners((JBreadcrumbBar)c);
        this.uninstallComponents((JBreadcrumbBar)c);
        this.uninstallDefaults((JBreadcrumbBar)c);
        this.breadcrumbBar = null;
    }

    protected void installDefaults(JBreadcrumbBar<?> bar) {
        Font currFont = bar.getFont();
        if (currFont == null || currFont instanceof UIResource) {
            bar.setFont(SubstanceCortex.GlobalScope.getFontPolicy().getFontSet().getControlFont());
        }
    }

    protected void installComponents(JBreadcrumbBar<?> bar) {
        FlowLayout mainPanelLayout = new FlowLayout(0, 0, 0);
        mainPanelLayout.setAlignOnBaseline(true);
        this.mainPanel = new JPanel(mainPanelLayout);
        this.mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mainPanel.setOpaque(false);
        this.scrollerPanel = new JScrollablePanel<JPanel>(this.mainPanel, JScrollablePanel.ScrollType.HORIZONTALLY);
        this.circularProgress = new JCircularProgress();
        this.circularProgress.setPreferredSize(new Dimension(12, 12));
        bar.add(this.scrollerPanel, "Center");
    }

    protected void installListeners(JBreadcrumbBar<?> bar) {
        this.atomicCounter = new AtomicInteger(0);
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BasicBreadcrumbBarUI.this.updateComponents();
            }
        };
        bar.addComponentListener(this.componentListener);
        this.pathListener = new BreadcrumbPathListener<Object>(){
            private SwingWorker<Void, Object> pathChangeWorker;

            @Override
            public void breadcrumbPathEvent(BreadcrumbPathEvent<Object> event) {
                BasicBreadcrumbBarUI.this.startLoadingTimer();
                final int indexOfFirstChange = event.getIndexOfFirstChange();
                if (this.pathChangeWorker != null && !this.pathChangeWorker.isDone()) {
                    this.pathChangeWorker.cancel(true);
                }
                this.pathChangeWorker = new SwingWorker<Void, Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void doInBackground() throws Exception {
                        List items;
                        BasicBreadcrumbBarUI.this.atomicCounter.incrementAndGet();
                        BasicBreadcrumbBarUI basicBreadcrumbBarUI = BasicBreadcrumbBarUI.this;
                        synchronized (basicBreadcrumbBarUI) {
                            if (indexOfFirstChange == 0) {
                                BasicBreadcrumbBarUI.this.modelStack.clear();
                            } else {
                                int toLeave = indexOfFirstChange * 2 + 1;
                                while (BasicBreadcrumbBarUI.this.modelStack.size() > toLeave) {
                                    BasicBreadcrumbBarUI.this.modelStack.removeLast();
                                }
                            }
                        }
                        SwingUtilities.invokeLater(BasicBreadcrumbBarUI.this::updateComponents);
                        if (indexOfFirstChange == 0) {
                            List rootChoices = BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(null);
                            BreadcrumbItemChoices bic = new BreadcrumbItemChoices(null, rootChoices);
                            if (!this.isCancelled()) {
                                this.publish(bic);
                            }
                        }
                        if ((items = BasicBreadcrumbBarUI.this.breadcrumbBar.getModel().getItems()) != null) {
                            for (int itemIndex = indexOfFirstChange; itemIndex < items.size() && !this.isCancelled(); ++itemIndex) {
                                BreadcrumbItem item = items.get(itemIndex);
                                this.publish(item);
                                ArrayList subPath = new ArrayList();
                                for (int j = 0; j <= itemIndex; ++j) {
                                    subPath.add(items.get(j));
                                }
                                BreadcrumbItemChoices bic = new BreadcrumbItemChoices(item, BasicBreadcrumbBarUI.this.breadcrumbBar.getCallback().getPathChoices(subPath));
                                if (bic.getChoices() == null || bic.getChoices().size() <= 0) continue;
                                this.publish(bic);
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void process(List<Object> chunks) {
                        if (chunks != null) {
                            for (Object chunk : chunks) {
                                if (this.isCancelled() || BasicBreadcrumbBarUI.this.atomicCounter.get() > 1) break;
                                if (chunk instanceof BreadcrumbItemChoices) {
                                    BasicBreadcrumbBarUI.this.pushChoices((BreadcrumbItemChoices)chunk, false);
                                }
                                if (!(chunk instanceof BreadcrumbItem)) continue;
                                BasicBreadcrumbBarUI.this.pushChoice((BreadcrumbItem)chunk, false);
                            }
                        }
                        BasicBreadcrumbBarUI.this.updateComponents();
                    }

                    @Override
                    protected void done() {
                        BasicBreadcrumbBarUI.this.atomicCounter.decrementAndGet();
                        BasicBreadcrumbBarUI.this.stopLoadingTimer();
                    }
                };
                this.pathChangeWorker.execute();
            }
        };
        this.breadcrumbBar.getModel().addPathListener(this.pathListener);
    }

    protected void uninstallDefaults(JBreadcrumbBar<?> bar) {
    }

    protected void uninstallComponents(JBreadcrumbBar<?> bar) {
        this.stopLoadingTimer();
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        this.commandStack.clear();
        bar.remove(this.scrollerPanel);
    }

    protected void uninstallListeners(JBreadcrumbBar<?> bar) {
        bar.removeComponentListener(this.componentListener);
        this.componentListener = null;
        this.breadcrumbBar.getModel().removePathListener(this.pathListener);
        this.pathListener = null;
    }

    private synchronized void startLoadingTimer() {
        if (this.loadingTimer == null) {
            this.loadingTimer = new Timer(100, e -> {
                this.loadingTimer.stop();
                this.circularProgress.setVisible(false);
                this.mainPanel.remove(this.circularProgress);
                this.circularProgress.setVisible(true);
                this.isShowingProgress = true;
                this.mainPanel.add(this.circularProgress);
                this.mainPanel.revalidate();
                this.mainPanel.repaint();
            });
        }
        if (this.loadingTimer.isRunning()) {
            this.loadingTimer.stop();
        }
        this.loadingTimer.start();
    }

    private synchronized void stopLoadingTimer() {
        if (this.loadingTimer != null && this.loadingTimer.isRunning()) {
            this.loadingTimer.stop();
        }
        this.isShowingProgress = false;
        this.mainPanel.remove(this.circularProgress);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    protected LayoutManager createLayoutManager() {
        return new BreadcrumbBarLayout();
    }

    protected synchronized void updateComponents() {
        if (!this.breadcrumbBar.isVisible()) {
            return;
        }
        this.mainPanel.removeAll();
        this.buttonStack.clear();
        this.commandStack.clear();
        CommandButtonPresentationModel commandPresentation = CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.MEDIUM).setPopupOrientationKind(CommandButtonPresentationModel.PopupOrientationKind.SIDEWARD).setHorizontalGapScaleFactor(0.75).setPopupMenuPresentationModel(CommandPopupMenuPresentationModel.builder().setMaxVisibleMenuCommands(10).build()).build();
        for (int i = 0; i < this.modelStack.size(); ++i) {
            BreadcrumbItemChoices lastBic;
            List choices;
            JCommandButton button;
            Command command;
            Object element = this.modelStack.get(i);
            if (element instanceof BreadcrumbItemChoices) {
                BreadcrumbItemChoices bic = (BreadcrumbItemChoices)element;
                if (this.buttonStack.isEmpty()) {
                    command = ((Command.Builder)Command.builder().setSecondaryContentModel(new CommandMenuContentModel(new CommandGroup(new Command[0])))).build();
                    button = (JCommandButton)command.project(commandPresentation).buildComponent();
                    button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                    this.configureBreadcrumbButton(button);
                    this.configurePopupAction(command, bic);
                    this.configurePopupRollover(button);
                    this.buttonStack.add(button);
                    this.commandStack.add(command);
                    continue;
                }
                JCommandButton button2 = this.buttonStack.getLast();
                Command command2 = this.commandStack.getLast();
                button2.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
                this.configurePopupAction(command2, bic);
                this.configurePopupRollover(button2);
                continue;
            }
            if (!(element instanceof BreadcrumbItem)) continue;
            BreadcrumbItem bi = (BreadcrumbItem)element;
            command = ((Command.Builder)((Command.Builder)Command.builder().setText(bi.getKey())).setSecondaryContentModel(new CommandMenuContentModel(new CommandGroup(new Command[0])))).build();
            button = (JCommandButton)command.project(commandPresentation).buildComponent();
            this.configureBreadcrumbButton(button);
            this.configureMainAction(command, bi);
            final Icon icon = bi.getIcon();
            if (icon != null) {
                button.setIcon(new ResizableIcon(){
                    int iw;
                    int ih;
                    {
                        this.iw = icon.getIconWidth();
                        this.ih = icon.getIconHeight();
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        int dx = (this.iw - icon.getIconWidth()) / 2;
                        int dy = (this.ih - icon.getIconHeight()) / 2;
                        icon.paintIcon(c, g, x + dx, y + dy);
                    }

                    public int getIconWidth() {
                        return this.iw;
                    }

                    public int getIconHeight() {
                        return this.ih;
                    }

                    public void setDimension(Dimension newDimension) {
                        this.iw = newDimension.width;
                        this.ih = newDimension.height;
                    }
                });
            }
            if (i > 0 && (choices = (lastBic = (BreadcrumbItemChoices)this.modelStack.get(i - 1)).getChoices()) != null) {
                for (int j = 0; j < choices.size(); ++j) {
                    if (!bi.getKey().equals(choices.get(j).getKey())) continue;
                    lastBic.setSelectedIndex(j);
                    break;
                }
            }
            this.buttonStack.addLast(button);
            this.commandStack.addLast(command);
        }
        for (JCommandButton jcb : this.buttonStack) {
            this.mainPanel.add(jcb);
        }
        if (this.isShowingProgress) {
            this.mainPanel.add(this.circularProgress);
        }
        this.scrollerPanel.revalidate();
        this.scrollerPanel.repaint();
        SwingUtilities.invokeLater(() -> {
            this.scrollerPanel.scrollToIfNecessary(this.mainPanel.getPreferredSize().width, 0);
            this.scrollerPanel.repaint();
        });
    }

    private void configureMainAction(Command command, BreadcrumbItem<Object> bi) {
        command.setAction(e -> SwingUtilities.invokeLater(() -> {
            BreadcrumbBarModel<Object> barModel = this.breadcrumbBar.getModel();
            int itemIndex = barModel.indexOf(bi);
            int toLeave = itemIndex < 0 ? 0 : itemIndex + 1;
            barModel.setCumulative(true);
            while (barModel.getItemCount() > toLeave) {
                barModel.removeLast();
            }
            barModel.setCumulative(false);
        }));
    }

    private void configurePopupAction(Command command, BreadcrumbItemChoices<Object> bic) {
        ArrayList<Command> menuCommands = new ArrayList<Command>();
        CommandPopupMenuPresentationModel.Builder menuPresentationModel = CommandPopupMenuPresentationModel.builder();
        List<BreadcrumbItem<Object>> items = bic.getChoices();
        int i = 0;
        while (i < items.size()) {
            BreadcrumbItem<Object> bi = items.get(i);
            Command.Builder commandBuilder = Command.builder();
            commandBuilder.setText(bi.getKey());
            final Icon icon = bi.getIcon();
            if (icon != null) {
                commandBuilder.setIconFactory(() -> new ResizableIcon(){
                    int iw;
                    int ih;
                    {
                        this.iw = icon.getIconWidth();
                        this.ih = icon.getIconHeight();
                    }

                    public void paintIcon(Component c, Graphics g, int x, int y) {
                        int dx = (this.iw - icon.getIconWidth()) / 2;
                        int dy = (this.ih - icon.getIconHeight()) / 2;
                        icon.paintIcon(c, g, x + dx, y + dy);
                    }

                    public int getIconWidth() {
                        return this.iw;
                    }

                    public int getIconHeight() {
                        return this.ih;
                    }

                    public void setDimension(Dimension newDimension) {
                        this.iw = newDimension.width;
                        this.ih = newDimension.height;
                    }
                });
            }
            int biIndex = i++;
            commandBuilder.setAction(e -> SwingUtilities.invokeLater(() -> {
                int toLeave;
                BreadcrumbBarModel<Object> barModel = this.breadcrumbBar.getModel();
                barModel.setCumulative(true);
                int itemIndex = barModel.indexOf(bic.getAncestor());
                int n = toLeave = bic.getAncestor() == null || itemIndex < 0 ? 0 : itemIndex + 1;
                while (barModel.getItemCount() > toLeave) {
                    barModel.removeLast();
                }
                barModel.addLast(bi);
                bic.setSelectedIndex(biIndex);
                barModel.setCumulative(false);
            }));
            Command menuCommand = commandBuilder.build();
            menuCommands.add(menuCommand);
        }
        menuPresentationModel.setMaxVisibleMenuCommands(10);
        CommandMenuContentModel popupMenuContentModel = new CommandMenuContentModel(new CommandGroup(menuCommands));
        if (bic.getSelectedIndex() >= 0) {
            popupMenuContentModel.setHighlightedCommand((Command)menuCommands.get(bic.getSelectedIndex()));
        }
        CommandMenuContentModel commandPopupMenuContentModel = command.getSecondaryContentModel();
        commandPopupMenuContentModel.removeAllCommandGroups();
        commandPopupMenuContentModel.addCommandGroup(new CommandGroup(menuCommands));
    }

    private void configurePopupRollover(final JCommandButton button) {
        button.getPopupModel().addChangeListener(new ChangeListener(){
            boolean rollover;
            {
                this.rollover = button.getPopupModel().isRollover();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(() -> {
                    boolean isRollover = button.getPopupModel().isRollover();
                    if (isRollover == this.rollover) {
                        return;
                    }
                    if (isRollover) {
                        for (JCommandButton bcbButton : BasicBreadcrumbBarUI.this.buttonStack) {
                            if (bcbButton == button || !bcbButton.getPopupModel().isPopupShowing()) continue;
                            BasicBreadcrumbBarUI.this.scrollerPanel.scrollToIfNecessary(button2.getBounds().x, button.getWidth());
                            button.doPopupClick();
                        }
                    }
                    this.rollover = isRollover;
                });
            }
        });
    }

    private void configureBreadcrumbButton(JCommandButton button) {
        button.getPopupModel().addChangeListener(e -> {
            PopupButtonModel model = button.getPopupModel();
            boolean displayDownwards = model.isRollover() || model.isPopupShowing();
            CommandButtonPresentationModel.PopupOrientationKind popupOrientationKind = displayDownwards ? CommandButtonPresentationModel.PopupOrientationKind.DOWNWARD : CommandButtonPresentationModel.PopupOrientationKind.SIDEWARD;
            button.setPopupOrientationKind(popupOrientationKind);
        });
    }

    protected Object pushChoices(BreadcrumbItemChoices<Object> bic) {
        return this.pushChoices(bic, true);
    }

    protected synchronized Object pushChoices(BreadcrumbItemChoices<Object> bic, boolean toUpdateUI) {
        if (bic == null) {
            return null;
        }
        if (this.modelStack.size() % 2 == 1) {
            this.modelStack.pop();
        }
        this.modelStack.addLast(bic);
        if (toUpdateUI) {
            this.updateComponents();
        }
        return bic;
    }

    protected synchronized Object pushChoice(BreadcrumbItem bi, boolean toUpdateUI) {
        assert (bi != null);
        if (!this.modelStack.isEmpty() && this.modelStack.size() % 2 == 0) {
            this.modelStack.pop();
        }
        bi.setIndex(this.modelStack.size());
        this.modelStack.addLast(bi);
        return bi;
    }

    protected class BreadcrumbBarLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = ((BasicBreadcrumbBarUI)BasicBreadcrumbBarUI.this).dummy.getPreferredSize().height;
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int buttonHeight = ((BasicBreadcrumbBarUI)BasicBreadcrumbBarUI.this).dummy.getPreferredSize().height;
            return new Dimension(10, buttonHeight);
        }

        @Override
        public void layoutContainer(Container c) {
            int width = c.getWidth();
            int height = c.getHeight();
            BasicBreadcrumbBarUI.this.scrollerPanel.setBounds(0, 0, width, height);
        }
    }
}

