/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.bcb;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.common.StringValuePair;

final class BreadcrumbItemChoices<T> {
    private List<BreadcrumbItem<T>> choices;
    private BreadcrumbItem<T> ancestor;
    private int selectedIndex = 0;

    public BreadcrumbItemChoices(BreadcrumbItem<T> ancestor, List<StringValuePair<T>> entries) {
        this.ancestor = ancestor;
        this.choices = new ArrayList<BreadcrumbItem<T>>(entries.size());
        int index = 0;
        for (StringValuePair<T> pair : entries) {
            BreadcrumbItem li = new BreadcrumbItem((String)pair.getKey(), pair.getValue());
            li.setIcon((Icon)pair.get("icon"));
            this.choices.add(index, li);
            ++index;
        }
        this.selectedIndex = -1;
    }

    public int getPosition(String s) {
        assert (s != null && s.length() > 0);
        for (int i = 0; i < this.choices.size(); ++i) {
            BreadcrumbItem<T> it = this.choices.get(i);
            if (!s.equals(it.getKey())) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public List<BreadcrumbItem<T>> getChoices() {
        return this.choices;
    }

    public BreadcrumbItem<T> getAncestor() {
        return this.ancestor;
    }
}

