/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common.popup;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.internal.ui.common.popup.BasicColorSelectorPopupMenuUI;
import org.pushingpixels.flamingo.internal.ui.common.popup.JColorSelectorComponent;

public class ColorSelectorPopupMenuSingleRowSelector
extends JPanel {
    public ColorSelectorPopupMenuSingleRowSelector(final JColorSelectorPopupMenu colorSelectorPopupMenu, final Color ... colors) {
        ColorSelectorPopupMenuContentModel contentModel = (ColorSelectorPopupMenuContentModel)colorSelectorPopupMenu.getProjection().getContentModel();
        final JColorSelectorComponent[] comps = new JColorSelectorComponent[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            comps[i] = new JColorSelectorComponent(colors[i], contentModel.getColorPreviewListener(), contentModel.getColorActivationListener());
            comps[i].addColorActivationListener(JColorSelectorPopupMenu::addColorToRecentlyUsed);
            this.add(comps[i]);
        }
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(10, 10);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                return new Dimension(colors.length * size + (colors.length + 1) * gap, size + 2 * gap);
            }

            @Override
            public void layoutContainer(Container parent) {
                BasicColorSelectorPopupMenuUI ui = (BasicColorSelectorPopupMenuUI)colorSelectorPopupMenu.getUI();
                int gap = ui.getColorSelectorCellGap();
                int size = ui.getColorSelectorCellSize();
                if (parent.getComponentOrientation().isLeftToRight()) {
                    int x = gap;
                    int y = gap;
                    for (int i = 0; i < colors.length; ++i) {
                        comps[i].setBounds(x, y, size, size);
                        x += size + gap;
                    }
                } else {
                    int x = ColorSelectorPopupMenuSingleRowSelector.this.getWidth() - gap;
                    int y = gap;
                    for (int i = 0; i < colors.length; ++i) {
                        comps[i].setBounds(x - size, y, size, size);
                        x -= size + gap;
                    }
                }
            }
        });
    }

    public void focusOn(int column) {
        this.getComponent(column).requestFocus();
    }

    public int getEntryCount() {
        return this.getComponentCount();
    }
}

