/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.pushingpixels.flamingo.api.common.JCommandButtonStrip;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.internal.ui.ribbon.SequentialFocusTraversalPolicy;

public abstract class BasicFlowBandControlPanelUI
extends AbstractBandControlPanelUI {
    @Override
    protected LayoutManager createLayoutManager() {
        return new FlowControlPanelLayout();
    }

    private class FlowControlPanelLayout
    implements LayoutManager {
        private FlowControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int buttonHeight = BasicFlowBandControlPanelUI.this.dummy.getPreferredSize().height;
            int vGap = BasicFlowBandControlPanelUI.this.getLayoutGap() * 3 / 4;
            int minusGaps = buttonHeight - 2 * vGap;
            switch (minusGaps % 3) {
                case 1: {
                    buttonHeight += 2;
                    break;
                }
                case 2: {
                    ++buttonHeight;
                }
            }
            Insets ins = c.getInsets();
            return new Dimension(c.getWidth(), buttonHeight + ins.top + ins.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            JFlowBandControlPanel flowBandControlPanel = (JFlowBandControlPanel)c;
            AbstractRibbonBand ribbonBand = flowBandControlPanel.getRibbonBand();
            RibbonBandResizePolicy currentResizePolicy = ribbonBand.getCurrentResizePolicy();
            if (currentResizePolicy == null) {
                return;
            }
            boolean ltr = c.getComponentOrientation().isLeftToRight();
            Insets ins = c.getInsets();
            int x = ins.left;
            int gap = BasicFlowBandControlPanelUI.this.getLayoutGap();
            int availableHeight = c.getHeight() - ins.top - ins.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, c) != null) {
                List<RibbonBandResizePolicy> resizePolicies = ribbonBand.getResizePolicies();
                resizePolicies.get(0).install(availableHeight, gap);
            } else {
                if (currentResizePolicy instanceof CoreRibbonResizePolicies.IconRibbonBandResizePolicy) {
                    return;
                }
                currentResizePolicy.install(availableHeight, gap);
            }
            int maxHeight = 0;
            int rowCount = 1;
            for (JComponent flowComponent : flowBandControlPanel.getFlowComponents()) {
                Dimension prefSize = flowComponent.getPreferredSize();
                if (x + prefSize.width > c.getWidth() - ins.right) {
                    x = ins.left;
                    ++rowCount;
                }
                x += prefSize.width + gap;
                maxHeight = Math.max(maxHeight, prefSize.height);
            }
            int vGap = (availableHeight - rowCount * maxHeight) / rowCount;
            if (vGap < 0) {
                vGap = 2;
                maxHeight = (availableHeight - vGap * (rowCount - 1)) / rowCount;
            }
            int y = ins.top + vGap / 2;
            x = ltr ? ins.left : c.getWidth() - ins.right;
            int rowIndex = 0;
            for (JComponent flowComponent : flowBandControlPanel.getFlowComponents()) {
                Dimension dimension = flowComponent.getPreferredSize();
                if (ltr) {
                    if (x + dimension.width > c.getWidth() - ins.right) {
                        x = ins.left;
                        y += maxHeight + vGap;
                        ++rowIndex;
                    }
                } else if (x - dimension.width < ins.left) {
                    x = c.getWidth() - ins.right;
                    y += maxHeight + vGap;
                    ++rowIndex;
                }
                int height = Math.min(maxHeight, dimension.height);
                if (ltr) {
                    flowComponent.setBounds(x, y + (maxHeight - height) / 2, dimension.width, height);
                } else {
                    flowComponent.setBounds(x - dimension.width, y + (maxHeight - height) / 2, dimension.width, height);
                }
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", rowIndex == 0);
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", rowIndex > 0 && rowIndex < rowCount - 1);
                flowComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", rowIndex == rowCount - 1);
                if (ltr) {
                    x += dimension.width + gap;
                    continue;
                }
                x -= dimension.width + gap;
            }
            ArrayList<Component> components = new ArrayList<Component>();
            for (Component component : flowBandControlPanel.getFlowComponents()) {
                if (component instanceof JRibbonComponent) {
                    components.add(((JRibbonComponent)component).getMainComponent());
                    continue;
                }
                if (component instanceof JCommandButtonStrip) {
                    JCommandButtonStrip buttonStrip = (JCommandButtonStrip)component;
                    for (int i = 0; i < buttonStrip.getButtonCount(); ++i) {
                        components.add(buttonStrip.getButton(i));
                    }
                    continue;
                }
                components.add(component);
            }
            c.setFocusTraversalPolicyProvider(true);
            c.setFocusTraversalPolicy(new SequentialFocusTraversalPolicy(components));
        }
    }
}

