/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.bcb;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbTreeAdapterSelector;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class JTreeAdapterBreadCrumbTest
extends JFrame {
    private static FileSystemView fsv = FileSystemView.getFileSystemView();
    private JList<File> fileList;
    private BreadcrumbTreeAdapterSelector<FileTreeNode> bar;

    private JTreeAdapterBreadCrumbTest() {
        super("BreadCrumb test");
        File[] roots = File.listRoots();
        FileTreeNode rootTreeNode = new FileTreeNode(roots);
        JTree tree = new JTree(rootTreeNode);
        tree.setRootVisible(false);
        tree.setCellRenderer(new FileTreeCellRenderer());
        this.bar = new BreadcrumbTreeAdapterSelector(tree);
        this.bar.getModel().addPathListener(event -> SwingUtilities.invokeLater(() -> {
            final List newPath = event.getSource().getItems();
            System.out.println("New path is ");
            for (BreadcrumbItem item : newPath) {
                FileTreeNode node = (FileTreeNode)item.getData();
                if (node.file == null) continue;
                System.out.println("\t" + node.file.getName());
            }
            if (newPath.size() > 0) {
                SwingWorker<List<StringValuePair<FileTreeNode>>, Void> worker = new SwingWorker<List<StringValuePair<FileTreeNode>>, Void>(){

                    @Override
                    protected List<StringValuePair<FileTreeNode>> doInBackground() throws Exception {
                        return JTreeAdapterBreadCrumbTest.this.bar.getCallback().getLeafs(newPath);
                    }

                    @Override
                    protected void done() {
                        try {
                            FileListModel model = new FileListModel();
                            List leafs = (List)this.get();
                            for (StringValuePair leaf : leafs) {
                                FileTreeNode node = (FileTreeNode)leaf.getValue();
                                model.add(node.file);
                            }
                            model.sort();
                            JTreeAdapterBreadCrumbTest.this.fileList.setModel(model);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                worker.execute();
            }
        }));
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        this.fileList = new JList();
        this.fileList.setCellRenderer((ListCellRenderer<File>)((Object)new FileListRenderer()));
        JScrollPane fileListScrollPane = new JScrollPane(this.fileList);
        fileListScrollPane.setBorder(new TitledBorder("File list"));
        this.add((Component)fileListScrollPane, "Center");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            JTreeAdapterBreadCrumbTest test = new JTreeAdapterBreadCrumbTest();
            test.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
            test.setSize(700, 400);
            test.setLocation(300, 100);
            test.setVisible(true);
            test.setDefaultCloseOperation(3);
        });
    }

    public class FileListRenderer
    extends SubstanceDefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            File file = (File)value;
            this.setIcon(FileSystemView.getFileSystemView().getSystemIcon(file));
            this.setText(FileSystemView.getFileSystemView().getSystemDisplayName(file));
            return this;
        }
    }

    private static class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Map<File, String> rootNameCache = new HashMap<File, String>();

        private FileTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FileTreeNode ftn = (FileTreeNode)value;
            File file = ftn.file;
            String filename = "";
            if (file != null) {
                if (ftn.isFileSystemRoot) {
                    filename = this.rootNameCache.get(file);
                    if (filename == null) {
                        filename = fsv.getSystemDisplayName(file);
                        if (filename.length() == 0) {
                            filename = file.getPath();
                        }
                        this.rootNameCache.put(file, filename);
                    }
                } else {
                    filename = file.getName();
                }
            }
            JLabel result = (JLabel)super.getTreeCellRendererComponent(tree, filename, sel, expanded, leaf, row, hasFocus);
            if (file != null) {
                Icon icon = this.iconCache.get(filename);
                if (icon == null) {
                    icon = fsv.getSystemIcon(file);
                    this.iconCache.put(filename, icon);
                }
                result.setIcon(icon);
            }
            return result;
        }
    }

    public class FileListModel
    extends AbstractListModel<File> {
        private ArrayList<File> files = new ArrayList();

        public void add(File file) {
            this.files.add(file);
        }

        private void sort() {
            this.files.sort((o1, o2) -> {
                if (o1.isDirectory() && !o2.isDirectory()) {
                    return -1;
                }
                if (o2.isDirectory() && !o1.isDirectory()) {
                    return 1;
                }
                return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
            });
        }

        @Override
        public File getElementAt(int index) {
            return this.files.get(index);
        }

        @Override
        public int getSize() {
            return this.files.size();
        }
    }

    private static class FileTreeNode
    implements TreeNode {
        private File file;
        private File[] children;
        private TreeNode parent;
        private boolean isFileSystemRoot;

        private FileTreeNode(File file, boolean isFileSystemRoot, TreeNode parent) {
            this.file = file;
            this.isFileSystemRoot = isFileSystemRoot;
            this.parent = parent;
            this.children = this.file.listFiles();
            if (this.children == null) {
                this.children = new File[0];
            }
        }

        private FileTreeNode(File[] children) {
            this.file = null;
            this.parent = null;
            this.children = children;
        }

        public Enumeration<FileTreeNode> children() {
            final int elementCount = this.children.length;
            return new Enumeration<FileTreeNode>(){
                int count = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.count < elementCount;
                }

                @Override
                public FileTreeNode nextElement() {
                    if (this.count < elementCount) {
                        return new FileTreeNode(children[this.count++], false, this);
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            };
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return new FileTreeNode(this.children[childIndex], this.parent == null, this);
        }

        @Override
        public int getChildCount() {
            return this.children.length;
        }

        @Override
        public int getIndex(TreeNode node) {
            FileTreeNode ftn = (FileTreeNode)node;
            for (int i = 0; i < this.children.length; ++i) {
                if (!ftn.file.equals(this.children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            boolean isNotFolder = this.file != null && this.file.isFile();
            return this.getChildCount() == 0 && isNotFolder;
        }
    }
}

