/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.pushingpixels.demo.flamingo.LocaleSwitcher;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.model.ColorSelectorCommand;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.JColorSelectorPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuContentModel;
import org.pushingpixels.flamingo.api.common.popup.model.ColorSelectorPopupMenuGroupModel;
import org.pushingpixels.flamingo.api.common.projection.ColorSelectorCommandButtonProjection;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestColorSelector
extends JFrame {
    private ResourceBundle resourceBundle;
    private Locale currLocale;
    private ColorSelectorCommand colorSelectorCommand;
    private Color backgroundColor;

    private TestColorSelector() {
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        JPanel top = new JPanel(new FlowLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
        final JPanel centerPanel = new JPanel();
        SubstanceCortex.ComponentOrParentChainScope.setColorizationFactor((JComponent)centerPanel, (double)1.0);
        this.backgroundColor = centerPanel.getBackground();
        this.add((Component)top, "North");
        this.add((Component)centerPanel, "Center");
        JCheckBox hasTheme = new JCheckBox("theme");
        hasTheme.setSelected(true);
        JCheckBox hasStandard = new JCheckBox("standard");
        hasStandard.setSelected(true);
        JCheckBox hasRecent = new JCheckBox("recent");
        hasRecent.setSelected(true);
        ColorSelectorPopupMenuContentModel.ColorActivationListener colorActivationListener = color -> {
            this.backgroundColor = color;
            centerPanel.setBackground(this.backgroundColor);
            this.colorSelectorCommand.setIconFactory(ColorIcon.factory(this.backgroundColor));
        };
        final ColorSelectorPopupMenuContentModel.ColorPreviewListener colorPreviewListener = new ColorSelectorPopupMenuContentModel.ColorPreviewListener(){

            public void onColorPreviewActivated(Color color) {
                centerPanel.setBackground(color);
            }

            public void onColorPreviewCanceled() {
                centerPanel.setBackground(TestColorSelector.this.backgroundColor);
            }
        };
        final Color defaultPanelColor = centerPanel.getBackground();
        ColorSelectorPopupMenuGroupModel.Builder selectorBuilder = ColorSelectorPopupMenuGroupModel.builder();
        selectorBuilder.addCommand(((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("ColorSelector.textAutomatic"))).setIconFactory(ColorIcon.factory(defaultPanelColor))).setAction(e -> {
            colorActivationListener.onColorActivated(defaultPanelColor);
            JColorSelectorPopupMenu.addColorToRecentlyUsed((Color)defaultPanelColor);
        })).setActionPreview(new Command.CommandActionPreview(){

            public void onCommandPreviewActivated(Command command) {
                colorPreviewListener.onColorPreviewActivated(defaultPanelColor);
            }

            public void onCommandPreviewCanceled(Command command) {
                colorPreviewListener.onColorPreviewCanceled();
            }
        })).build());
        if (hasTheme.isSelected()) {
            selectorBuilder.addColorSectionWithDerived(new ColorSelectorPopupMenuGroupModel.ColorSectionModel(this.resourceBundle.getString("ColorSelector.textThemeCaption"), new Color[]{new Color(255, 255, 255), new Color(0, 0, 0), new Color(160, 160, 160), new Color(16, 64, 128), new Color(80, 128, 192), new Color(180, 80, 80), new Color(160, 192, 80), new Color(128, 92, 160), new Color(80, 160, 208), new Color(255, 144, 64)}));
        }
        if (hasStandard.isSelected()) {
            selectorBuilder.addColorSection(new ColorSelectorPopupMenuGroupModel.ColorSectionModel(this.resourceBundle.getString("ColorSelector.textStandardCaption"), new Color[]{new Color(140, 0, 0), new Color(253, 0, 0), new Color(255, 160, 0), new Color(255, 255, 0), new Color(144, 240, 144), new Color(0, 128, 0), new Color(160, 224, 224), new Color(0, 0, 255), new Color(0, 0, 128), new Color(128, 0, 128)}));
        }
        if (hasRecent.isSelected()) {
            selectorBuilder.addRecentsSection(new ColorSelectorPopupMenuGroupModel.ColorSectionModel(this.resourceBundle.getString("ColorSelector.textRecentCaption")));
        }
        selectorBuilder.addCommand(((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("ColorSelector.textMoreColor"))).setAction(e -> SwingUtilities.invokeLater(() -> {
            Color color = JColorChooser.showDialog(this, "Color chooser", this.backgroundColor);
            if (color != null) {
                colorActivationListener.onColorActivated(color);
                JColorSelectorPopupMenu.addColorToRecentlyUsed((Color)color);
            }
        }))).build());
        ColorSelectorPopupMenuContentModel selectorModel = new ColorSelectorPopupMenuContentModel(Collections.singletonList(selectorBuilder.build()));
        selectorModel.setColorActivationListener(colorActivationListener);
        selectorModel.setColorPreviewListener(colorPreviewListener);
        this.colorSelectorCommand = ((ColorSelectorCommand.Builder)ColorSelectorCommand.colorSelectorBuilder().setIconFactory(ColorIcon.factory(this.backgroundColor))).setColorSelectorPopupMenuContentModel(selectorModel).build();
        AbstractCommandButton colorButton = (AbstractCommandButton)new ColorSelectorCommandButtonProjection(this.colorSelectorCommand, CommandButtonPresentationModel.builder().setPresentationState(CommandButtonPresentationState.SMALL).setFlat(false).build()).buildComponent();
        top.add((Component)colorButton);
        top.add(hasTheme);
        top.add(hasStandard);
        top.add(hasRecent);
        JComboBox<LocaleSwitcher.LocaleInfo> localeSwitcher = LocaleSwitcher.getLocaleSwitcher(selected -> {
            this.currLocale = selected;
            this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
            this.applyComponentOrientation(ComponentOrientation.getOrientation(selected));
            SwingUtilities.updateComponentTreeUI(this);
        });
        top.add(localeSwitcher);
        this.setSize(500, 400);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            new TestColorSelector().setVisible(true);
        });
    }

    private static class ColorIcon
    implements ResizableIcon {
        private int w;
        private int h;
        private Color color;

        private ColorIcon(Color color) {
            this.color = color;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.color);
            g2d.fillRect(x, y, this.w, this.h);
            float borderThickness = 1.0f / (float)NeonCortex.getScaleFactor();
            g2d.setColor(this.color.darker());
            g2d.setStroke(new BasicStroke(borderThickness, 1, 1));
            g2d.draw(new Rectangle2D.Double(x, y, (float)this.w - borderThickness, (float)this.h - borderThickness));
            g2d.dispose();
        }

        public int getIconWidth() {
            return this.w;
        }

        public int getIconHeight() {
            return this.h;
        }

        public void setDimension(Dimension newDimension) {
            this.w = newDimension.width;
            this.h = newDimension.height;
        }

        public static ResizableIcon.Factory factory(Color color) {
            return () -> new ColorIcon(color);
        }
    }
}

