/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.demo.flamingo.common.SamplePopupMenu;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_paste;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandButtonProjection;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.renderer.SubstanceDefaultListCellRenderer;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestCommandButtonsSizing
extends JPanel {
    private List<Mapping> model = new LinkedList<Mapping>();
    private JScrollPane central;

    private TestCommandButtonsSizing() {
        for (CommandButtonPresentationState state : new CommandButtonPresentationState[]{CommandButtonPresentationState.BIG, CommandButtonPresentationState.MEDIUM, CommandButtonPresentationState.TILE, CommandButtonPresentationState.SMALL}) {
            for (JCommandButton.CommandButtonKind commandButtonKind : JCommandButton.CommandButtonKind.values()) {
                this.model.add(new Mapping(state.getDisplayName() + " + " + commandButtonKind.name(), fontSize -> this.createActionOnlyButton("Sample", state, commandButtonKind, fontSize)));
            }
        }
        JList<Mapping> list = new JList<Mapping>(new AbstractListModel<Mapping>(){

            @Override
            public Mapping getElementAt(int index) {
                return (Mapping)TestCommandButtonsSizing.this.model.get(index);
            }

            @Override
            public int getSize() {
                return TestCommandButtonsSizing.this.model.size();
            }
        });
        list.setCellRenderer((ListCellRenderer<Mapping>)new SubstanceDefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, (Object)((Mapping)value).caption, index, isSelected, cellHasFocus);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(list), "West");
        list.setSelectionMode(0);
        list.getSelectionModel().addListSelectionListener(e -> SwingUtilities.invokeLater(() -> {
            if (this.central != null) {
                this.remove(this.central);
            }
            this.central = null;
            int selIndex = list.getSelectedIndex();
            if (selIndex >= 0) {
                Mapping sel = (Mapping)list.getSelectedValue();
                Object rowSpec = "p";
                for (int fontSize = 12; fontSize < 25; ++fontSize) {
                    rowSpec = (String)rowSpec + ", $lg, p";
                }
                FormBuilder builder = FormBuilder.create().columns("right:pref, 4dlu, left:pref:grow", new Object[0]).rows((String)rowSpec, new Object[0]).padding((EmptyBorder)Paddings.DIALOG);
                for (int fontSize = 11; fontSize < 25; ++fontSize) {
                    int row = (fontSize - 11) * 2 + 1;
                    builder.add(fontSize + " pixels", new Object[0]).xy(1, row);
                    builder.add((Component)sel.creator.create(fontSize)).xy(3, row);
                }
                this.central = new JScrollPane(builder.build(), 22, 31);
                this.add((Component)this.central, "Center");
                this.doLayout();
                this.revalidate();
            }
        }));
    }

    private AbstractCommandButton createActionOnlyButton(String text, CommandButtonPresentationState state, JCommandButton.CommandButtonKind commandButtonKind, int fontSize) {
        Command.Builder commandBuilder = (Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(text)).setExtraText("Extra for " + text.toLowerCase())).setIconFactory(Edit_paste.factory());
        switch (commandButtonKind) {
            case ACTION_ONLY: {
                commandBuilder.setAction(e -> System.out.println("Action invoked"));
                break;
            }
            case ACTION_AND_POPUP_MAIN_ACTION: {
                ((Command.Builder)commandBuilder.setAction(e -> System.out.println("Action invoked"))).setSecondaryContentModel(SamplePopupMenu.getSamplePopupMenuContentModel());
                break;
            }
            case ACTION_AND_POPUP_MAIN_POPUP: {
                ((Command.Builder)commandBuilder.setAction(e -> System.out.println("Action invoked"))).setSecondaryContentModel(SamplePopupMenu.getSamplePopupMenuContentModel());
                break;
            }
            case POPUP_ONLY: {
                commandBuilder.setSecondaryContentModel(SamplePopupMenu.getSamplePopupMenuContentModel());
            }
        }
        CommandButtonPresentationModel.Builder commandButtonPresentationBuilder = CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false);
        switch (commandButtonKind) {
            case ACTION_AND_POPUP_MAIN_ACTION: {
                commandButtonPresentationBuilder.setTextClickAction();
                break;
            }
            case ACTION_AND_POPUP_MAIN_POPUP: {
                commandButtonPresentationBuilder.setTextClickPopup();
            }
        }
        CommandButtonProjection commandProjection = commandBuilder.build().project(commandButtonPresentationBuilder.build());
        commandProjection.setComponentCustomizer(button -> button.setFont(button.getFont().deriveFont((float)fontSize)));
        return (AbstractCommandButton)commandProjection.buildComponent();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            JFrame frame = new JFrame("Testing command button fonts");
            frame.setSize(800, 600);
            frame.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
            frame.add(new TestCommandButtonsSizing());
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }

    private static class Mapping {
        private String caption;
        private Creator creator;

        private Mapping(String caption, Creator creator) {
            this.caption = caption;
            this.creator = creator;
        }
    }

    private static interface Creator {
        public JComponent create(int var1);
    }
}

