/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.common;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.pushingpixels.demo.flamingo.common.QuickStylesPanel;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Address_book_new;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Edit_paste;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.Text_x_generic;
import org.pushingpixels.demo.flamingo.svg.tango.transcoded.X_office_document;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandButtonPresentationModel;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandMenuContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.model.AbstractPopupMenuPresentationModel;
import org.pushingpixels.flamingo.api.common.popup.model.CommandPopupMenuPresentationModel;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class TestPopupCommandButtons
extends JFrame {
    private ResourceBundle resourceBundle;
    private Locale currLocale;
    private Command popupSimpleCommand;
    private Command popupScrollableCommand;
    private Command popupComplexCommand;

    private TestPopupCommandButtons() {
        super("Command button test");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.setLayout(new BorderLayout());
        this.currLocale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle("org.pushingpixels.demo.flamingo.resource.Resources", this.currLocale);
        this.popupSimpleCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("SelectAll.text"))).setIconFactory(Edit_paste.factory())).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setSecondaryContentModel(this.getPopupMenuContentModel(PopupKind.SIMPLE))).build();
        this.popupScrollableCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("SelectAll.text"))).setIconFactory(Edit_paste.factory())).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setSecondaryContentModel(this.getPopupMenuContentModel(PopupKind.SCROLLABLE))).build();
        this.popupComplexCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("SelectAll.text"))).setIconFactory(Edit_paste.factory())).setExtraText(this.resourceBundle.getString("SelectAll.textExtra"))).setSecondaryContentModel(this.getPopupMenuContentModel(PopupKind.COMPLEX))).build();
        this.add((Component)this.getButtonPanel(), "Center");
    }

    private CommandMenuContentModel getPopupMenuContentModel(PopupKind popupKind) {
        MessageFormat mf = new MessageFormat(this.resourceBundle.getString("TestMenuItem.text"));
        mf.setLocale(this.currLocale);
        switch (popupKind) {
            case SIMPLE: {
                ArrayList<Command> simpleEntries1 = new ArrayList<Command>();
                ArrayList<Command> simpleEntries2 = new ArrayList<Command>();
                simpleEntries1.add(((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"1"}))).setIconFactory(Address_book_new.factory())).build());
                simpleEntries1.add(((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"2"}))).setIconFactory(EmptyResizableIcon.factory())).build());
                simpleEntries1.add(((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"3"}))).setIconFactory(EmptyResizableIcon.factory())).build());
                simpleEntries2.add(((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"4"}))).setIconFactory(EmptyResizableIcon.factory())).build());
                simpleEntries2.add(((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{"5"}))).setIconFactory(Text_x_generic.factory())).build());
                return new CommandMenuContentModel(Arrays.asList(new CommandGroup(simpleEntries1), new CommandGroup(simpleEntries2)));
            }
            case SCROLLABLE: {
                ArrayList<Command> scrollableEntries = new ArrayList<Command>();
                for (int i = 0; i < 20; ++i) {
                    int index = i;
                    scrollableEntries.add(((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(mf.format(new Object[]{i}))).setIconFactory(Text_x_generic.factory())).setAction(e -> System.out.println("Invoked action on '" + index + "'"))).build());
                }
                return new CommandMenuContentModel(new CommandGroup(scrollableEntries));
            }
        }
        ArrayList<CommandGroup> extraEntries = new ArrayList<CommandGroup>();
        extraEntries.add(new CommandGroup(new Command[]{((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("SaveSelection.text"))).setIconFactory(X_office_document.factory())).build(), ((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("ClearSelection.text"))).setIconFactory(EmptyResizableIcon.factory())).build()}));
        extraEntries.add(new CommandGroup(new Command[]{((Command.Builder)((Command.Builder)Command.builder().setText(this.resourceBundle.getString("ApplyStyles.text"))).setIconFactory(EmptyResizableIcon.factory())).build()}));
        return new CommandMenuContentModel(QuickStylesPanel.getQuickStylesContentModel(this.resourceBundle, this.currLocale), extraEntries);
    }

    private CommandPopupMenuPresentationModel getPopupMenuPresentationModel(PopupKind popupKind) {
        switch (popupKind) {
            case SIMPLE: {
                return CommandPopupMenuPresentationModel.builder().build();
            }
            case SCROLLABLE: {
                return CommandPopupMenuPresentationModel.builder().setMaxVisibleMenuCommands(8).build();
            }
        }
        return CommandPopupMenuPresentationModel.builder().setPanelPresentationModel(CommandPanelPresentationModel.builder().setToShowGroupLabels(false).setCommandPresentationState(CommandButtonPresentationState.FIT_TO_ICON).setCommandIconDimension(Integer.valueOf(48)).setMaxColumns(4).setMaxRows(3).build()).build();
    }

    private JPanel getButtonPanel() {
        FormBuilder builder = FormBuilder.create().columns("center:pref, 4dlu, center:pref, 4dlu, center:pref", new Object[0]).rows("p, $lg, p, $lg, p, $lg, p, $lg, p", new Object[0]).padding((EmptyBorder)Paddings.DIALOG);
        this.addButtons(builder, CommandButtonPresentationState.BIG, 1);
        this.addButtons(builder, CommandButtonPresentationState.TILE, 3);
        this.addButtons(builder, CommandButtonPresentationState.MEDIUM, 5);
        this.addButtons(builder, CommandButtonPresentationState.SMALL, 7);
        return builder.build();
    }

    private void addButtons(FormBuilder builder, CommandButtonPresentationState state, int row) {
        builder.add((Component)this.createSimplePopupButton(state)).xy(1, row);
        builder.add((Component)this.createScrollablePopupButton(state)).xy(3, row);
        builder.add((Component)this.createComplexPopupButton(state)).xy(5, row);
    }

    private AbstractCommandButton createSimplePopupButton(CommandButtonPresentationState state) {
        return (AbstractCommandButton)this.popupSimpleCommand.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).setPopupMenuPresentationModel((AbstractPopupMenuPresentationModel)this.getPopupMenuPresentationModel(PopupKind.SIMPLE)).build()).buildComponent();
    }

    private AbstractCommandButton createScrollablePopupButton(CommandButtonPresentationState state) {
        return (AbstractCommandButton)this.popupScrollableCommand.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).setPopupMenuPresentationModel((AbstractPopupMenuPresentationModel)this.getPopupMenuPresentationModel(PopupKind.SCROLLABLE)).build()).buildComponent();
    }

    private AbstractCommandButton createComplexPopupButton(CommandButtonPresentationState state) {
        return (AbstractCommandButton)this.popupComplexCommand.project(CommandButtonPresentationModel.builder().setPresentationState(state).setFlat(false).setPopupMenuPresentationModel((AbstractPopupMenuPresentationModel)this.getPopupMenuPresentationModel(PopupKind.COMPLEX)).build()).buildComponent();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            TestPopupCommandButtons frame = new TestPopupCommandButtons();
            frame.setSize(800, 400);
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            frame.setDefaultCloseOperation(2);
        });
    }

    private static enum PopupKind {
        SIMPLE,
        SCROLLABLE,
        COMPLEX;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

