/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.imageviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.demo.flamingo.svg.logo.RadianceLogo;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.core.BreadcrumbFileSelector;
import org.pushingpixels.flamingo.api.common.AbstractFileViewPanel;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.IcoWrapperResizableIcon;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.skin.BusinessSkin;

public class IcoViewer
extends JFrame {
    private BreadcrumbFileSelector bar;
    private AbstractFileViewPanel<File> fileViewPanel;
    private JSlider iconSizeSlider;
    private int currIconSize;

    private IcoViewer() {
        super("ICO Viewer");
        this.setIconImage(RadianceLogo.getLogoImage(SubstanceCortex.GlobalScope.getCurrentSkin().getColorScheme(SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.ColorSchemeAssociationKind.FILL, ComponentState.ENABLED)));
        this.bar = new BreadcrumbFileSelector();
        this.bar.getModel().addPathListener(event -> SwingUtilities.invokeLater(() -> {
            final List newPath = event.getSource().getItems();
            System.out.println("New path is ");
            for (BreadcrumbItem item : newPath) {
                System.out.println("\t" + ((File)item.getData()).getAbsolutePath());
            }
            if (newPath.size() > 0) {
                SwingWorker<List<StringValuePair<File>>, Void> worker = new SwingWorker<List<StringValuePair<File>>, Void>(){

                    @Override
                    protected List<StringValuePair<File>> doInBackground() {
                        return IcoViewer.this.bar.getCallback().getLeafs(newPath);
                    }

                    @Override
                    protected void done() {
                        try {
                            IcoViewer.this.fileViewPanel.setFolder((List)this.get());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                worker.execute();
            }
        }));
        this.setLayout(new BorderLayout());
        this.add((Component)this.bar, "North");
        int initialSize = 32;
        this.fileViewPanel = new AbstractFileViewPanel<File>(32){

            protected InputStream getLeafContent(File leaf) {
                try {
                    return new FileInputStream(leaf);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return null;
                }
            }

            protected ResizableIcon getResizableIcon(AbstractFileViewPanel.Leaf leaf, InputStream stream, CommandButtonPresentationState state, Dimension dimension) {
                int prefSize = state.getPreferredIconSize();
                if (prefSize > 0) {
                    dimension = new Dimension(prefSize, prefSize);
                }
                return IcoWrapperResizableIcon.getIcon((InputStream)stream, (Dimension)dimension);
            }

            protected boolean toShowFile(StringValuePair<File> pair) {
                String name = ((String)pair.getKey()).toLowerCase();
                return name.endsWith(".ico");
            }
        };
        JScrollPane jsp = new JScrollPane((Component)this.fileViewPanel, 22, 32);
        this.add((Component)jsp, "Center");
        this.iconSizeSlider = new JSlider();
        this.iconSizeSlider.setMinimum(16);
        this.iconSizeSlider.setMaximum(256);
        this.iconSizeSlider.setSnapToTicks(true);
        this.iconSizeSlider.setPaintLabels(true);
        this.iconSizeSlider.setPaintTicks(true);
        this.iconSizeSlider.setMajorTickSpacing(64);
        this.iconSizeSlider.setMinorTickSpacing(16);
        this.iconSizeSlider.setValue(initialSize);
        this.currIconSize = initialSize;
        this.iconSizeSlider.addChangeListener(e -> {
            int newValue;
            if (!this.iconSizeSlider.getModel().getValueIsAdjusting() && (newValue = this.iconSizeSlider.getValue()) != this.currIconSize) {
                this.currIconSize = newValue;
                SwingUtilities.invokeLater(() -> {
                    ((CommandPanelPresentationModel)this.fileViewPanel.getProjection().getPresentationModel()).setCommandIconDimension(Integer.valueOf(this.currIconSize));
                    this.invalidate();
                    this.doLayout();
                });
            }
        });
        this.add((Component)this.iconSizeSlider, "South");
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            JFrame.setDefaultLookAndFeelDecorated(true);
            SubstanceCortex.GlobalScope.setSkin((SubstanceSkin)new BusinessSkin());
            IcoViewer test = new IcoViewer();
            test.setSize(800, 650);
            test.setLocationRelativeTo(null);
            test.setVisible(true);
            test.setDefaultCloseOperation(2);
        });
    }
}

