/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.common.CommandButtonPresentationState;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.StringValuePair;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.api.common.model.Command;
import org.pushingpixels.flamingo.api.common.model.CommandGroup;
import org.pushingpixels.flamingo.api.common.model.CommandPanelContentModel;
import org.pushingpixels.flamingo.api.common.model.CommandPanelPresentationModel;
import org.pushingpixels.flamingo.api.common.projection.CommandPanelProjection;
import org.pushingpixels.flamingo.api.common.projection.Projection;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.photon.api.icon.SvgBatikResizableIcon;
import org.pushingpixels.photon.api.transcoder.LanguageRenderer;
import org.pushingpixels.photon.api.transcoder.SvgStreamTranscoder;
import org.pushingpixels.photon.api.transcoder.java.JavaLanguageRenderer;

public class SvgFileViewPanel
extends JCommandButtonPanel {
    private BreadcrumbBarCallBack<File> callback;
    private SwingWorker<Void, StringValuePair<InputStream>> mainWorker;

    public SvgFileViewPanel(BreadcrumbBarCallBack<File> callback, int startingDimension) {
        super((Projection)new CommandPanelProjection(new CommandPanelContentModel(new ArrayList()), CommandPanelPresentationModel.builder().setToShowGroupLabels(false).setLayoutKind(CommandPanelPresentationModel.LayoutKind.ROW_FILL).setCommandPresentationState(CommandButtonPresentationState.FIT_TO_ICON).setCommandIconDimension(Integer.valueOf(startingDimension)).build()));
        this.callback = callback;
    }

    public void setFolder(final List<StringValuePair<File>> leafs) {
        ((CommandPanelContentModel)this.getProjection().getContentModel()).removeAllCommandGroups();
        ArrayList<Command> commands = new ArrayList<Command>();
        final HashMap<String, Command> newCommands = new HashMap<String, Command>();
        for (StringValuePair<File> leaf : leafs) {
            String name = (String)leaf.getKey();
            if (!name.endsWith(".svg") && !name.endsWith(".svgz")) continue;
            Command svgCommand = ((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)Command.builder().setText(name.replace('-', ' '))).setIconFactory(EmptyResizableIcon.factory())).setAction(e -> {
                try {
                    ResizableIcon icon = e.getCommand().getIconFactory().createNewIcon();
                    if (!(icon instanceof SvgBatikResizableIcon)) {
                        return;
                    }
                    SvgBatikResizableIcon svgIcon = (SvgBatikResizableIcon)icon;
                    System.out.println(name);
                    String svgClassName = name.substring(0, name.lastIndexOf(46));
                    svgClassName = svgClassName.replace('-', '_');
                    svgClassName = svgClassName.replace(' ', '_');
                    String javaClassFilename = System.getProperty("java.io.tmpdir") + File.separator + svgClassName + ".java";
                    PrintWriter pw = new PrintWriter(javaClassFilename);
                    SvgStreamTranscoder transcoder = new SvgStreamTranscoder((InputStream)new ByteArrayInputStream(svgIcon.getSvgBytes()), svgClassName, (LanguageRenderer)new JavaLanguageRenderer());
                    transcoder.setPrintWriter(pw);
                    transcoder.transcode(((Object)((Object)this)).getClass().getResourceAsStream("/org/pushingpixels/photon/api/transcoder/java/SvgTranscoderTemplateResizable.templ"));
                    JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), "Finished with '" + javaClassFilename + "'");
                }
                catch (Throwable exc) {
                    exc.printStackTrace();
                }
            })).setActionRichTooltip(RichTooltip.builder().setTitle("Transcode").addDescriptionSection("Click to generate Java2D class").build())).build();
            commands.add(svgCommand);
            newCommands.put(name, svgCommand);
        }
        ((CommandPanelContentModel)this.getProjection().getContentModel()).addCommandGroup(new CommandGroup(commands));
        this.mainWorker = new SwingWorker<Void, StringValuePair<InputStream>>(){

            @Override
            protected Void doInBackground() throws Exception {
                for (StringValuePair leafPair : leafs) {
                    if (this.isCancelled()) break;
                    String name = (String)leafPair.getKey();
                    if (!name.endsWith(".svg") && !name.endsWith(".svgz")) continue;
                    InputStream stream = SvgFileViewPanel.this.callback.getLeafContent((Object)((File)leafPair.getValue()));
                    StringValuePair pair = new StringValuePair(name, (Object)stream);
                    this.publish(pair);
                }
                return null;
            }

            @Override
            protected void process(List<StringValuePair<InputStream>> pairs) {
                for (StringValuePair<InputStream> pair : pairs) {
                    String name = (String)pair.getKey();
                    InputStream svgStream = (InputStream)pair.getValue();
                    int iconDimension = ((CommandPanelPresentationModel)SvgFileViewPanel.this.getProjection().getPresentationModel()).getCommandIconDimension();
                    Dimension svgDim = new Dimension(iconDimension, iconDimension);
                    SvgBatikResizableIcon svgIcon = name.endsWith(".svg") ? SvgBatikResizableIcon.getSvgIcon((InputStream)svgStream, (Dimension)svgDim) : SvgBatikResizableIcon.getSvgzIcon((InputStream)svgStream, (Dimension)svgDim);
                    ((Command)newCommands.get(name)).setIconFactory(() -> svgIcon);
                }
            }
        };
        this.mainWorker.execute();
    }

    public void setIconDimension(int dimension) {
        ((CommandPanelPresentationModel)this.getProjection().getPresentationModel()).setCommandIconDimension(Integer.valueOf(dimension));
    }

    public void cancelMainWorker() {
        if (this.mainWorker == null) {
            return;
        }
        if (this.mainWorker.isDone() || this.mainWorker.isCancelled()) {
            return;
        }
        this.mainWorker.cancel(false);
    }
}

