/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.demo.flamingo.svg.tango.transcoded;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.Stack;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.neon.api.icon.ResizableIconUIResource;

public class Info
implements ResizableIcon {
    private Shape shape = null;
    private Paint paint = null;
    private Stroke stroke = null;
    private Shape clip = null;
    private Stack<AffineTransform> transformsStack = new Stack();
    private int width = (int)Info.getOrigWidth();
    private int height = (int)Info.getOrigHeight();

    private void _paint0(Graphics2D g, float origAlpha) {
        this.transformsStack.push(g.getTransform());
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -0.0f, -0.0f));
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.shape = new GeneralPath();
        ((GeneralPath)this.shape).moveTo(40.0, 77.5);
        ((GeneralPath)this.shape).curveTo(19.322, 77.5, 2.5, 60.678, 2.5, 40.0);
        ((GeneralPath)this.shape).curveTo(2.5, 19.321999, 19.322, 2.5, 40.0, 2.5);
        ((GeneralPath)this.shape).curveTo(60.678, 2.5, 77.5, 19.322, 77.5, 40.0);
        ((GeneralPath)this.shape).curveTo(77.5, 60.678, 60.678, 77.5, 40.0, 77.5);
        ((GeneralPath)this.shape).closePath();
        this.paint = new Color(139, 183, 240, 255);
        g.setPaint(this.paint);
        g.fill(this.shape);
        g.setTransform(this.transformsStack.pop());
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.shape = new GeneralPath();
        ((GeneralPath)this.shape).moveTo(40.0, 3.0);
        ((GeneralPath)this.shape).curveTo(60.402, 3.0, 77.0, 19.598, 77.0, 40.0);
        ((GeneralPath)this.shape).curveTo(77.0, 60.402, 60.402, 77.0, 40.0, 77.0);
        ((GeneralPath)this.shape).curveTo(19.598, 77.0, 3.0, 60.402, 3.0, 40.0);
        ((GeneralPath)this.shape).curveTo(3.0, 19.598, 19.598, 3.0, 40.0, 3.0);
        ((GeneralPath)this.shape).moveTo(40.0, 2.0);
        ((GeneralPath)this.shape).curveTo(19.013, 2.0, 2.0, 19.013, 2.0, 40.0);
        ((GeneralPath)this.shape).curveTo(2.0, 60.987, 19.013, 78.0, 40.0, 78.0);
        ((GeneralPath)this.shape).curveTo(60.987, 78.0, 78.0, 60.987, 78.0, 40.0);
        ((GeneralPath)this.shape).curveTo(78.0, 19.013, 60.987, 2.0, 40.0, 2.0);
        ((GeneralPath)this.shape).lineTo(40.0, 2.0);
        ((GeneralPath)this.shape).closePath();
        this.paint = new Color(78, 122, 181, 255);
        g.setPaint(this.paint);
        g.fill(this.shape);
        g.setTransform(this.transformsStack.pop());
        g.setTransform(this.transformsStack.pop());
        g.setTransform(this.transformsStack.pop());
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.shape = new Ellipse2D.Double(37.0, 21.0, 6.0, 6.0);
        this.paint = new Color(255, 255, 255, 255);
        g.setPaint(this.paint);
        g.fill(this.shape);
        g.setTransform(this.transformsStack.pop());
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        g.setComposite(AlphaComposite.getInstance(3, 1.0f * origAlpha));
        this.transformsStack.push(g.getTransform());
        g.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f));
        this.shape = new GeneralPath();
        ((GeneralPath)this.shape).moveTo(43.0, 56.0);
        ((GeneralPath)this.shape).lineTo(43.0, 31.0);
        ((GeneralPath)this.shape).lineTo(35.0, 31.0);
        ((GeneralPath)this.shape).lineTo(35.0, 33.0);
        ((GeneralPath)this.shape).lineTo(37.0, 33.0);
        ((GeneralPath)this.shape).lineTo(37.0, 56.0);
        ((GeneralPath)this.shape).lineTo(35.0, 56.0);
        ((GeneralPath)this.shape).lineTo(35.0, 58.0);
        ((GeneralPath)this.shape).lineTo(45.0, 58.0);
        ((GeneralPath)this.shape).lineTo(45.0, 56.0);
        ((GeneralPath)this.shape).closePath();
        this.paint = new Color(255, 255, 255, 255);
        g.setPaint(this.paint);
        g.fill(this.shape);
        g.setTransform(this.transformsStack.pop());
        g.setTransform(this.transformsStack.pop());
        g.setTransform(this.transformsStack.pop());
        g.setTransform(this.transformsStack.pop());
    }

    private void innerPaint(Graphics2D g) {
        AlphaComposite origAlphaComposite;
        float origAlpha = 1.0f;
        Composite origComposite = g.getComposite();
        if (origComposite instanceof AlphaComposite && (origAlphaComposite = (AlphaComposite)origComposite).getRule() == 3) {
            origAlpha = origAlphaComposite.getAlpha();
        }
        this._paint0(g, origAlpha);
        this.shape = null;
        this.paint = null;
        this.stroke = null;
        this.clip = null;
        this.transformsStack.clear();
    }

    public static double getOrigX() {
        return 2.0;
    }

    public static double getOrigY() {
        return 2.0;
    }

    public static double getOrigWidth() {
        return 76.0;
    }

    public static double getOrigHeight() {
        return 76.0;
    }

    private Info() {
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.translate(x, y);
        double coef1 = (double)this.width / Info.getOrigWidth();
        double coef2 = (double)this.height / Info.getOrigHeight();
        double coef = Math.min(coef1, coef2);
        g2d.clipRect(0, 0, this.width, this.height);
        g2d.scale(coef, coef);
        g2d.translate(-Info.getOrigX(), -Info.getOrigY());
        if (coef1 != coef2) {
            if (coef1 < coef2) {
                int extraDy = (int)((Info.getOrigWidth() - Info.getOrigHeight()) / 2.0);
                g2d.translate(0, extraDy);
            } else {
                int extraDx = (int)((Info.getOrigHeight() - Info.getOrigWidth()) / 2.0);
                g2d.translate(extraDx, 0);
            }
        }
        Graphics2D g2ForInner = (Graphics2D)g2d.create();
        this.innerPaint(g2ForInner);
        g2ForInner.dispose();
        g2d.dispose();
    }

    public static ResizableIcon of(int width, int height) {
        Info base = new Info();
        base.width = width;
        base.height = height;
        return base;
    }

    public static ResizableIconUIResource uiResourceOf(int width, int height) {
        Info base = new Info();
        base.width = width;
        base.height = height;
        return new ResizableIconUIResource((ResizableIcon)base);
    }

    public static ResizableIcon.Factory factory() {
        return Info::new;
    }
}

