/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertySetModel;
import org.openide.explorer.propertysheet.PropertySetModelEvent;
import org.openide.explorer.propertysheet.PropertySetModelListener;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class PropertySetModelImpl
implements PropertySetModel,
Runnable {
    private boolean[] expanded = null;
    private List fds = new ArrayList();
    private Comparator comparator = null;
    private transient List listenerList;
    private Node.PropertySet[] sets = null;
    private transient int setCount = 0;
    private static boolean filterHiddenProperties = !Boolean.getBoolean("netbeans.ps.showHiddenProperties");
    static Set closedSets = new HashSet(5);
    private transient PropertySetModelEvent event = null;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$PropertySetModelImpl;

    public PropertySetModelImpl() {
    }

    public PropertySetModelImpl(Node.PropertySet[] ps) {
        if (ps == null) {
            ps = new Node.PropertySet[]{};
        }
        this.setPropertySets(ps);
    }

    public int getCount() {
        return this.fds.size();
    }

    public FeatureDescriptor getFeatureDescriptor(int index) {
        if (index == -1) {
            return null;
        }
        return (FeatureDescriptor)this.fds.get(index);
    }

    public int indexOf(FeatureDescriptor fd) {
        return this.fds.indexOf(fd);
    }

    public boolean isProperty(int index) {
        return this.getFeatureDescriptor(index) instanceof Node.Property;
    }

    public void setComparator(Comparator c) {
        if (c != this.comparator) {
            this.firePendingChange(true);
            this.comparator = c;
            this.fds.clear();
            this.init();
            this.fireChange(true);
        }
    }

    public void setPropertySets(Node.PropertySet[] sets) {
        int n = this.setCount = sets == null ? 0 : sets.length;
        if (sets == null) {
            sets = new Node.PropertySet[]{};
        }
        if (this.setCount == 0 && !SwingUtilities.isEventDispatchThread()) {
            this.sets = new Node.PropertySet[0];
            this.resetArray(sets);
            this.fds.clear();
            SwingUtilities.invokeLater(this);
            return;
        }
        this.firePendingChange(false);
        this.sets = sets;
        this.resetArray(sets);
        this.init();
        this.run();
    }

    public void run() {
        this.fireChange(false);
    }

    private void init() {
        this.fds.clear();
        if (this.comparator == null) {
            this.initExpandable();
        } else {
            this.initPlain();
        }
    }

    private void initPlain() {
        if (this.sets == null) {
            return;
        }
        int pcount = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            Node.Property[] p = this.sets[i].getProperties();
            if (p == null) {
                throw new NullPointerException("Null is not a legal return value for PropertySet.getProperties()");
            }
            pcount += p.length;
        }
        Node.Property[] props = new Node.Property[pcount];
        int l = 0;
        for (int i = 0; i < this.sets.length; ++i) {
            Node.Property[] p = this.sets[i].getProperties();
            System.arraycopy(p, 0, props, l, p.length);
            l += p.length;
        }
        Arrays.sort(props, this.comparator);
        this.fds.addAll(this.propsToList(props));
    }

    private void initExpandable() {
        if (this.sets == null || this.sets.length == 0) {
            return;
        }
        for (int i = 0; i < this.sets.length; ++i) {
            if (PropUtils.hideSingleExpansion) {
                if (this.sets.length > 1 || this.sets.length == 1 && !NbBundle.getMessage(class$org$openide$explorer$propertysheet$PropertySetModelImpl == null ? PropertySetModelImpl.class$("org.openide.explorer.propertysheet.PropertySetModelImpl") : class$org$openide$explorer$propertysheet$PropertySetModelImpl, "CTL_Properties").equals(this.sets[0].getDisplayName())) {
                    this.fds.add(this.sets[i]);
                }
            } else if (!PropertySheet.forceTabs) {
                this.fds.add(this.sets[i]);
            }
            if (!this.expanded[i]) continue;
            Node.Property[] p = this.sets[i].getProperties();
            if (p == null) {
                throw new NullPointerException("Null is not a legal return value for PropertySet.getProperties()");
            }
            if (p.length > 0) {
                this.fds.addAll(this.propsToList(p));
                continue;
            }
            this.fds.remove(this.sets[i]);
        }
    }

    private List propsToList(Node.Property[] p) {
        List<Node.Property> result;
        if (filterHiddenProperties) {
            result = new ArrayList<Node.Property>();
            for (int i = 0; i < p.length; ++i) {
                if (p[i].isHidden()) continue;
                result.add(p[i]);
            }
        } else {
            result = Arrays.asList(p);
        }
        return result;
    }

    private void resetArray(Node.PropertySet[] sets) {
        int size = sets.length;
        if (this.expanded == null || this.expanded.length < size) {
            this.expanded = new boolean[size];
        }
        for (int i = 0; i < sets.length; ++i) {
            this.expanded[i] = !closedSets.contains(sets[i].getDisplayName());
        }
    }

    private int lookupSet(FeatureDescriptor fd) {
        if (this.sets != null) {
            List<Node.PropertySet> l = Arrays.asList(this.sets);
            return l.indexOf(fd);
        }
        return -1;
    }

    public boolean isExpanded(FeatureDescriptor set) {
        int index = this.lookupSet(set);
        if (index == -1) {
            return false;
        }
        return this.expanded[index];
    }

    public void toggleExpanded(int index) {
        FeatureDescriptor fd = this.getFeatureDescriptor(index);
        if (fd instanceof Node.Property) {
            throw new IllegalArgumentException("Cannot expand a property.");
        }
        int setIndex = this.lookupSet(fd);
        int eventType = this.expanded[setIndex] ? 0 : 1;
        int len = ((Node.PropertySet)fd).getProperties().length;
        this.expanded[setIndex] = !this.expanded[setIndex];
        this.firePendingChange(eventType, index + 1, index + len, false);
        if (!this.expanded[setIndex]) {
            closedSets.add(fd.getDisplayName());
        } else {
            closedSets.remove(fd.getDisplayName());
        }
        if (this.expanded[setIndex]) {
            this.fds.addAll(index + 1, Arrays.asList(this.sets[setIndex].getProperties()));
        } else {
            for (int i = index + len; i > index; --i) {
                this.fds.remove(i);
            }
        }
        this.fireChange(eventType, index + 1, index + len);
        PropUtils.putSavedClosedSetNames(closedSets);
    }

    public final void addPropertySetModelListener(PropertySetModelListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList();
        }
        this.listenerList.add(listener);
    }

    public final void removePropertySetModelListener(PropertySetModelListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    private PropertySetModelEvent getEvent() {
        if (this.event == null) {
            this.event = new PropertySetModelEvent(this);
        }
        return this.event;
    }

    private final void firePendingChange(int type, int start, int end, boolean reordering) {
        if (this.listenerList == null) {
            return;
        }
        Iterator i = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.start = start;
        this.event.end = end;
        this.event.type = type;
        this.event.reordering = reordering;
        while (i.hasNext()) {
            PropertySetModelListener curr = (PropertySetModelListener)i.next();
            curr.pendingChange(this.event);
        }
    }

    private final void fireChange(boolean reordering) {
        if (this.listenerList == null) {
            return;
        }
        Iterator i = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.reordering = reordering;
        while (i.hasNext()) {
            PropertySetModelListener curr = (PropertySetModelListener)i.next();
            curr.wholesaleChange(this.event);
        }
    }

    private final void firePendingChange(boolean reordering) {
        if (this.listenerList == null) {
            return;
        }
        Iterator i = this.listenerList.iterator();
        this.getEvent().type = 2;
        this.event.reordering = reordering;
        while (i.hasNext()) {
            PropertySetModelListener curr = (PropertySetModelListener)i.next();
            curr.pendingChange(this.event);
        }
    }

    private final void fireChange(int type, int start, int end) {
        if (this.listenerList == null) {
            return;
        }
        this.getEvent().start = start;
        this.event.end = end;
        this.event.type = type;
        this.event.reordering = false;
        Iterator i = this.listenerList.iterator();
        while (i.hasNext()) {
            PropertySetModelListener curr = (PropertySetModelListener)i.next();
            curr.boundedChange(this.event);
        }
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public int getSetCount() {
        return this.setCount;
    }

    static {
        closedSets.addAll(Arrays.asList(PropUtils.getSavedClosedSetNames()));
    }
}

