/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ComboInplaceEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

class WrapperInplaceEditor
extends JPanel
implements InplaceEditor,
ActionListener,
FocusListener {
    private EnhancedPropertyEditor enh;
    private PropertyModel mdl;
    private Component legacy = null;
    private transient List actionListenerList;
    private boolean listenerAdded = false;
    private boolean suspendEvents = false;
    private EventListenerList listenerList = null;

    WrapperInplaceEditor(EnhancedPropertyEditor enh) {
        this.enh = enh;
        this.setLayout(new BorderLayout());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "enter");
        this.getActionMap().put("enter", new EnterKbdAction());
    }

    public void focusGained(FocusEvent e) {
        e.setSource(this);
        this.fireFocusGained(e);
    }

    public void focusLost(FocusEvent e) {
        e.setSource(this);
        this.fireFocusLost(e);
    }

    public void clear() {
        if (this.legacy != null) {
            this.removeAll();
            if (this.listenerAdded) {
                this.tryRemoveActionListener(this.legacy);
            }
            this.legacy.removeFocusListener(this);
            this.legacy = null;
        }
        this.enh = null;
        this.listenerAdded = false;
    }

    private boolean tryAddActionListener(Component comp) {
        try {
            Method m = comp.getClass().getMethod("addActionListener", ActionListener.class);
            if (m != null) {
                m.invoke((Object)comp, (Object[])new ActionListener[]{this});
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean tryRemoveActionListener(Component comp) {
        try {
            Method m = comp.getClass().getMethod("removeActionListener", ActionListener.class);
            if (m != null) {
                m.invoke((Object)comp, (Object[])new ActionListener[]{this});
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void actionPerformed(ActionEvent ae) {
        this.fireAction(new ActionEvent(this, 1001, "success"));
    }

    public void connect(PropertyEditor pe, PropertyEnv env) {
        if (this.legacy != null) {
            this.clear();
        }
        if (pe != this.enh) {
            this.enh = (EnhancedPropertyEditor)pe;
        }
        Component comp = this.getLegacyInplaceEditor();
        this.add(comp, "Center");
        this.listenerAdded = this.tryAddActionListener(comp);
        comp.addFocusListener(this);
    }

    public JComponent getComponent() {
        return this;
    }

    public KeyStroke[] getKeyStrokes() {
        if (this.getLegacyInplaceEditor() instanceof JComboBox) {
            return ComboInplaceEditor.cbKeyStrokes;
        }
        return null;
    }

    public PropertyEditor getPropertyEditor() {
        return this.enh;
    }

    public PropertyModel getPropertyModel() {
        return this.mdl;
    }

    public Object getValue() {
        return this.enh.getValue();
    }

    public void handleInitialInputEvent(InputEvent e) {
    }

    public boolean isKnownComponent(Component c) {
        return this.isAncestorOf(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.suspendEvents = true;
        try {
            if (this.legacy instanceof JTextComponent) {
                ((JTextComponent)this.legacy).setText(this.enh.getAsText());
            } else if (this.legacy instanceof JComboBox) {
                if (((JComboBox)this.legacy).isEditable()) {
                    if (((JComboBox)this.legacy).getEditor().getEditorComponent().isShowing()) {
                        ((JComboBox)this.legacy).getEditor().setItem(this.enh.getValue());
                    }
                } else {
                    ((JComboBox)this.legacy).setSelectedItem(this.enh.getValue());
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate(e, 16, "Failure resetting legacy editor", null, null, null);
        }
        finally {
            this.suspendEvents = false;
        }
    }

    public void setPropertyModel(PropertyModel pm) {
        this.mdl = pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object o) {
        this.suspendEvents = true;
        try {
            if (this.legacy instanceof JTextComponent) {
                ((JTextComponent)this.legacy).setText(o.toString());
            } else if (this.legacy instanceof JComboBox) {
                if (((JComboBox)this.legacy).isEditable()) {
                    if (((JComboBox)this.legacy).getEditor().getEditorComponent().isShowing()) {
                        ((JComboBox)this.legacy).getEditor().setItem(o.toString());
                    }
                } else {
                    ((JComboBox)this.legacy).setSelectedItem(o);
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate(e, 16, "Failure resetting legacy editor", null, null, null);
        }
        finally {
            this.suspendEvents = false;
        }
    }

    public boolean supportsTextEntry() {
        if (this.legacy instanceof JTextComponent) {
            return true;
        }
        return this.legacy instanceof JComboBox && ((JComboBox)this.legacy).isEditable();
    }

    private Component getLegacyInplaceEditor() {
        if (this.legacy == null) {
            this.legacy = this.enh.getInPlaceCustomEditor();
        }
        return this.legacy;
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.actionListenerList == null) {
            this.actionListenerList = new ArrayList();
        }
        this.actionListenerList.add(listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        if (this.actionListenerList != null) {
            this.actionListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireAction(ActionEvent event) {
        List list;
        if (this.suspendEvents) {
            return;
        }
        WrapperInplaceEditor wrapperInplaceEditor = this;
        synchronized (wrapperInplaceEditor) {
            if (this.actionListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.actionListenerList).clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((ActionListener)list.get(i)).actionPerformed(event);
        }
    }

    public synchronized void addFocusListener(FocusListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(FocusListener.class, listener);
        super.addFocusListener(listener);
    }

    public synchronized void removeFocusListener(FocusListener listener) {
        this.listenerList.remove(FocusListener.class, listener);
        super.removeFocusListener(listener);
    }

    private void fireFocusGained(FocusEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$FocusListener == null ? WrapperInplaceEditor.class$("java.awt.event.FocusListener") : class$java$awt$event$FocusListener)) continue;
            ((FocusListener)listeners[i + 1]).focusGained(event);
        }
    }

    private void fireFocusLost(FocusEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$FocusListener == null ? WrapperInplaceEditor.class$("java.awt.event.FocusListener") : class$java$awt$event$FocusListener)) continue;
            ((FocusListener)listeners[i + 1]).focusLost(event);
        }
    }

    private class EnterKbdAction
    extends AbstractAction {
        private EnterKbdAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            WrapperInplaceEditor.this.fireAction(new ActionEvent(WrapperInplaceEditor.this, 1001, "success"));
        }
    }
}

