/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.DummyWindowManager;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.Workspace;

public abstract class WindowManager
implements Serializable {
    public static final String PROP_WORKSPACES = "workspaces";
    public static final String PROP_CURRENT_WORKSPACE = "currentWorkspace";
    public static final String PROP_MODES = "modes";
    private TopComponent activeComponent;
    private TopComponent.Registry registry;
    private static WindowManager dummyInstance;
    static final long serialVersionUID = -4133918059009277602L;

    public static final WindowManager getDefault() {
        WindowManager wmInstance = (WindowManager)Lookup.getDefault().lookup(WindowManager.class);
        return wmInstance != null ? wmInstance : WindowManager.getDummyInstance();
    }

    private static synchronized WindowManager getDummyInstance() {
        if (dummyInstance == null) {
            dummyInstance = new DummyWindowManager();
        }
        return dummyInstance;
    }

    public abstract Mode findMode(String var1);

    public abstract Mode findMode(TopComponent var1);

    public abstract Set getModes();

    public abstract Frame getMainWindow();

    public abstract void updateUI();

    protected abstract Component createTopComponentManager(TopComponent var1);

    protected TopComponent.Registry componentRegistry() {
        return (TopComponent.Registry)Lookup.getDefault().lookup(TopComponent.Registry.class);
    }

    public synchronized TopComponent.Registry getRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        this.registry = this.componentRegistry();
        return this.registry;
    }

    public final Workspace createWorkspace(String name) {
        return this.createWorkspace(name, name);
    }

    public abstract Workspace createWorkspace(String var1, String var2);

    public abstract Workspace findWorkspace(String var1);

    public abstract Workspace[] getWorkspaces();

    public abstract void setWorkspaces(Workspace[] var1);

    public abstract Workspace getCurrentWorkspace();

    public abstract TopComponentGroup findTopComponentGroup(String var1);

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    protected static final Component findComponentManager(TopComponent tc) {
        return null;
    }

    protected void activateComponent(TopComponent tc) {
        IllegalStateException ise;
        if (this.activeComponent == tc) {
            return;
        }
        if (this.activeComponent != null) {
            try {
                this.activeComponent.componentDeactivated();
            }
            catch (RuntimeException re) {
                ise = new IllegalStateException("[Winsys] TopComponent " + this.activeComponent + " throws runtime exception from its componentDeactivated() method. Repair it!");
                ErrorManager.getDefault().annotate((Throwable)ise, re);
                ErrorManager.getDefault().notify(1, ise);
            }
        }
        this.activeComponent = tc;
        if (this.activeComponent != null) {
            try {
                this.activeComponent.componentActivated();
            }
            catch (RuntimeException re) {
                ise = new IllegalStateException("[Winsys] TopComponent " + this.activeComponent + " throws runtime exception from its componentActivated() method. Repair it!");
                ErrorManager.getDefault().annotate((Throwable)ise, re);
                ErrorManager.getDefault().notify(1, ise);
            }
        }
    }

    protected void componentOpenNotify(TopComponent tc) {
        try {
            tc.componentOpened();
        }
        catch (RuntimeException re) {
            IllegalStateException ise = new IllegalStateException("[Winsys] TopComponent " + tc + " throws runtime exception from its componentOpened() method. Repair it!");
            ErrorManager.getDefault().annotate((Throwable)ise, re);
            ErrorManager.getDefault().notify(1, ise);
        }
    }

    protected void componentCloseNotify(TopComponent tc) {
        try {
            tc.componentClosed();
        }
        catch (RuntimeException re) {
            IllegalStateException ise = new IllegalStateException("[Winsys] TopComponent " + tc + " throws runtime exception from its componentClosed() method. Repair it!");
            ErrorManager.getDefault().annotate((Throwable)ise, re);
            ErrorManager.getDefault().notify(1, ise);
        }
        if (tc == this.activeComponent) {
            this.activateComponent(null);
        }
    }

    protected void componentShowing(TopComponent tc) {
        try {
            tc.componentShowing();
        }
        catch (RuntimeException re) {
            IllegalStateException ise = new IllegalStateException("[Winsys] TopComponent " + tc + " throws runtime exception from its componentShowing() method. Repair it!");
            ErrorManager.getDefault().annotate((Throwable)ise, re);
            ErrorManager.getDefault().notify(1, ise);
        }
    }

    protected void componentHidden(TopComponent tc) {
        try {
            tc.componentHidden();
        }
        catch (RuntimeException re) {
            IllegalStateException ise = new IllegalStateException("[Winsys] TopComponent " + tc + " throws runtime exception from its componentHidden() method. Repair it!");
            ErrorManager.getDefault().annotate((Throwable)ise, re);
            ErrorManager.getDefault().notify(1, ise);
        }
    }

    protected abstract void topComponentOpen(TopComponent var1);

    protected abstract void topComponentClose(TopComponent var1);

    protected abstract void topComponentRequestActive(TopComponent var1);

    protected abstract void topComponentRequestVisible(TopComponent var1);

    protected abstract void topComponentDisplayNameChanged(TopComponent var1, String var2);

    protected abstract void topComponentToolTipChanged(TopComponent var1, String var2);

    protected abstract void topComponentIconChanged(TopComponent var1, Image var2);

    protected abstract void topComponentActivatedNodesChanged(TopComponent var1, Node[] var2);

    protected abstract boolean topComponentIsOpened(TopComponent var1);

    protected abstract Action[] topComponentDefaultActions(TopComponent var1);

    protected abstract String topComponentID(TopComponent var1, String var2);

    protected void topComponentRequestAttention(TopComponent tc) {
    }

    protected void topComponentToFront(TopComponent tc) {
        Window parentWindow = SwingUtilities.getWindowAncestor(tc);
        if (null != parentWindow) {
            Frame parentFrame;
            int state;
            if (parentWindow instanceof Frame && ((state = (parentFrame = (Frame)parentWindow).getExtendedState()) & 1) > 0) {
                parentFrame.setExtendedState(state & 0xFFFFFFFE);
            }
            parentWindow.toFront();
        }
    }

    protected void topComponentCancelRequestAttention(TopComponent tc) {
    }

    public String findTopComponentID(TopComponent tc) {
        return this.topComponentID(tc, tc.preferredID());
    }

    public abstract TopComponent findTopComponent(String var1);

    protected static interface Component
    extends Serializable {
        public static final long serialVersionUID = 0L;

        public void open();

        public void open(Workspace var1);

        public void close(Workspace var1);

        public void requestFocus();

        public void requestVisible();

        public Node[] getActivatedNodes();

        public void setActivatedNodes(Node[] var1);

        public void nameChanged();

        public void setIcon(Image var1);

        public Image getIcon();

        public Set whereOpened();
    }
}

