/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.util.Hexdump;

class SmbComNTCreateAndX
extends AndXServerMessageBlock {
    static final int FILE_READ_DATA = 1;
    static final int FILE_WRITE_DATA = 2;
    static final int FILE_APPEND_DATA = 4;
    static final int FILE_READ_EA = 8;
    static final int FILE_WRITE_EA = 16;
    static final int FILE_EXECUTE = 32;
    static final int FILE_DELETE = 64;
    static final int FILE_READ_ATTRIBUTES = 128;
    static final int FILE_WRITE_ATTRIBUTES = 256;
    static final int DELETE = 65536;
    static final int READ_CONTROL = 131072;
    static final int WRITE_DAC = 262144;
    static final int WRITE_OWNER = 524288;
    static final int SYNCHRONIZE = 0x100000;
    static final int GENERIC_ALL = 0x10000000;
    static final int GENERIC_EXECUTE = 0x20000000;
    static final int GENERIC_WRITE = 0x40000000;
    static final int GENERIC_READ = Integer.MIN_VALUE;
    static final int FILE_SUPERSEDE = 0;
    static final int FILE_OPEN = 1;
    static final int FILE_CREATE = 2;
    static final int FILE_OPEN_IF = 3;
    static final int FILE_OVERWRITE = 4;
    static final int FILE_OVERWRITE_IF = 5;
    static final int FILE_WRITE_THROUGH = 2;
    static final int FILE_SEQUENTIAL_ONLY = 4;
    static final int FILE_SYNCHRONOUS_IO_ALERT = 16;
    static final int FILE_SYNCHRONOUS_IO_NONALERT = 32;
    static final int SECURITY_CONTEXT_TRACKING = 1;
    static final int SECURITY_EFFECTIVE_ONLY = 2;
    private int flags;
    private int rootDirectoryFid;
    private int desiredAccess;
    private int extFileAttributes;
    private int shareAccess;
    private int createDisposition;
    private int createOptions;
    private int impersonationLevel;
    private long allocationSize;
    private byte securityFlags;
    private int namelen_index;

    SmbComNTCreateAndX(String name, int flags, int shareAccess, int extFileAttributes, int createOptions, ServerMessageBlock andx) {
        super(andx);
        this.path = name;
        this.command = (byte)-94;
        this.desiredAccess = flags >>> 16 & 0xFFFF;
        this.desiredAccess |= 0x88;
        this.extFileAttributes = extFileAttributes;
        this.shareAccess = shareAccess;
        this.createDisposition = (flags & 2) == 2 ? ((flags & 0x10) == 16 ? 5 : 4) : ((flags & 0x10) == 16 ? ((flags & 1) == 1 ? 2 : 3) : 1);
        this.createOptions = (createOptions & 1) == 0 ? createOptions | 0x40 : createOptions;
        this.impersonationLevel = 2;
        this.securityFlags = (byte)3;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        dst[dstIndex++] = 0;
        this.namelen_index = dstIndex;
        SmbComNTCreateAndX.writeInt4(this.flags, dst, dstIndex += 2);
        SmbComNTCreateAndX.writeInt4(this.rootDirectoryFid, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.desiredAccess, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt8(this.allocationSize, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.extFileAttributes, dst, dstIndex += 8);
        SmbComNTCreateAndX.writeInt4(this.shareAccess, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.createDisposition, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.createOptions, dst, dstIndex += 4);
        SmbComNTCreateAndX.writeInt4(this.impersonationLevel, dst, dstIndex += 4);
        dstIndex += 4;
        dst[dstIndex++] = this.securityFlags;
        return dstIndex - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int n = this.writeString(this.path, dst, dstIndex);
        SmbComNTCreateAndX.writeInt2(this.useUnicode ? this.path.length() * 2 : n, dst, this.namelen_index);
        return n;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesDirectWireFormat(InputStream in, int byteCount, byte[] buffer, int bufferIndex) throws IOException {
        return 0;
    }

    public String toString() {
        return new String("SmbComNTCreateAndX[" + super.toString() + ",flags=0x" + Hexdump.toHexString(this.flags, 2) + ",rootDirectoryFid=" + this.rootDirectoryFid + ",desiredAccess=0x" + Hexdump.toHexString(this.desiredAccess, 4) + ",allocationSize=" + this.allocationSize + ",extFileAttributes=0x" + Hexdump.toHexString(this.extFileAttributes, 4) + ",shareAccess=0x" + Hexdump.toHexString(this.shareAccess, 4) + ",createDisposition=0x" + Hexdump.toHexString(this.createDisposition, 4) + ",createOptions=0x" + Hexdump.toHexString(this.createOptions, 8) + ",impersonationLevel=0x" + Hexdump.toHexString(this.impersonationLevel, 4) + ",securityFlags=0x" + Hexdump.toHexString(this.securityFlags, 2) + ",name=" + this.path + "]");
    }
}

