/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.IntHashtable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class PdfEncodings {
    protected static final int CIDNONE = 0;
    protected static final int CIDRANGE = 1;
    protected static final int CIDCHAR = 2;
    static final char[] winansiByteToChar = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u20ac', '\ufffd', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\ufffd', '\u017d', '\ufffd', '\ufffd', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\ufffd', '\u017e', '\u0178', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    static final char[] pdfEncodingByteToChar = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u2022', '\u2020', '\u2021', '\u2026', '\u2014', '\u2013', '\u0192', '\u2044', '\ufffd', '\ufffd', '\u2212', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\u2019', '\u201a', '\u2122', '\ufb01', '\ufb02', '\u0141', '\u0152', '\u0160', '\u0178', '\u017d', '\u0131', '\u0142', '\u0153', '\u0161', '\u017e', '\ufffd', '\u20ac', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    static final IntHashtable winansi = new IntHashtable();
    static final IntHashtable pdfEncoding = new IntHashtable();
    static final HashMap cmaps;
    public static final byte[][] CRLF_CID_NEWLINE;

    public static final byte[] convertToBytes(String string, String string2) {
        if (string == null) {
            return new byte[0];
        }
        if (string2 == null || string2.length() == 0) {
            int n = string.length();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                byArray[n2] = (byte)string.charAt(n2);
                ++n2;
            }
            return byArray;
        }
        IntHashtable intHashtable = null;
        if (string2.equals("Cp1252")) {
            intHashtable = winansi;
        } else if (string2.equals("PDF")) {
            intHashtable = pdfEncoding;
        }
        if (intHashtable != null) {
            int n = string.length();
            byte[] byArray = new byte[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                int n5 = string.charAt(n4);
                n3 = n5 < 128 || n5 >= 160 && n5 <= 255 ? n5 : intHashtable.get(n5);
                byArray[n4] = (byte)n3;
                ++n4;
            }
            return byArray;
        }
        if (string2.equals("UnicodeBig")) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            byte[] byArray = new byte[cArray.length * 2 + 2];
            byArray[0] = -2;
            byArray[1] = -1;
            int n6 = 2;
            int n7 = 0;
            while (n7 < n) {
                char c = cArray[n7];
                byArray[n6++] = (byte)(c >> 8);
                byArray[n6++] = (byte)(c & 0xFF);
                ++n7;
            }
            return byArray;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionConverter(unsupportedEncodingException);
        }
    }

    public static final String convertToString(byte[] byArray, String string) {
        if (byArray == null) {
            return "";
        }
        if (string == null || string.length() == 0) {
            char[] cArray = new char[byArray.length];
            int n = 0;
            while (n < byArray.length) {
                cArray[n] = (char)(byArray[n] & 0xFF);
                ++n;
            }
            return new String(cArray);
        }
        char[] cArray = null;
        if (string.equals("Cp1252")) {
            cArray = winansiByteToChar;
        } else if (string.equals("PDF")) {
            cArray = pdfEncodingByteToChar;
        }
        if (cArray != null) {
            int n = byArray.length;
            char[] cArray2 = new char[n];
            int n2 = 0;
            while (n2 < n) {
                cArray2[n2] = cArray[byArray[n2] & 0xFF];
                ++n2;
            }
            return new String(cArray2);
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ExceptionConverter(unsupportedEncodingException);
        }
    }

    public static boolean isPdfDocEncoding(String string) {
        if (string == null) {
            return true;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!(c < '\u0080' || c >= '\u00a0' && c <= '\u00ff' || pdfEncoding.containsKey(c))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void clearCmap(String string) {
        HashMap hashMap = cmaps;
        synchronized (hashMap) {
            if (string.length() == 0) {
                cmaps.clear();
            } else {
                cmaps.remove(string);
            }
        }
    }

    public static void loadCmap(String string, byte[][] byArray) {
        block8: {
            try {
                char[][] cArray = null;
                HashMap hashMap = cmaps;
                synchronized (hashMap) {
                    cArray = (char[][])cmaps.get(string);
                }
                if (cArray != null) break block8;
                cArray = PdfEncodings.readCmap(string, byArray);
                HashMap hashMap2 = cmaps;
                synchronized (hashMap2) {
                    cmaps.put(string, cArray);
                }
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
    }

    public static String convertCmap(String string, byte[] byArray) {
        return PdfEncodings.convertCmap(string, byArray, 0, byArray.length);
    }

    public static String convertCmap(String string, byte[] byArray, int n, int n2) {
        try {
            char[][] cArray = null;
            HashMap hashMap = cmaps;
            synchronized (hashMap) {
                cArray = (char[][])cmaps.get(string);
            }
            if (cArray == null) {
                cArray = PdfEncodings.readCmap(string, (byte[][])null);
                HashMap hashMap2 = cmaps;
                synchronized (hashMap2) {
                    cmaps.put(string, cArray);
                }
            }
            return PdfEncodings.decodeSequence(byArray, n, n2, cArray);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    static String decodeSequence(byte[] byArray, int n, int n2, char[][] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            char[] cArray2 = cArray[n4];
            int n6 = byArray[n5] & 0xFF;
            char c = cArray2[n6];
            if ((c & 0x8000) == 0) {
                stringBuffer.append(c);
                n4 = 0;
            } else {
                n4 = c & Short.MAX_VALUE;
            }
            ++n5;
        }
        return stringBuffer.toString();
    }

    static char[][] readCmap(String string, byte[][] byArray) throws IOException {
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        arrayList.add(new char[256]);
        PdfEncodings.readCmap(string, arrayList);
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                PdfEncodings.encodeSequence(byArray[n].length, byArray[n], Short.MAX_VALUE, arrayList);
                ++n;
            }
        }
        char[][] cArrayArray = new char[arrayList.size()][];
        return (char[][])arrayList.toArray((T[])cArrayArray);
    }

    static void readCmap(String string, ArrayList arrayList) throws IOException {
        String string2 = "fonts/cmaps/" + string;
        InputStream inputStream = BaseFont.getResourceStream(string2);
        if (inputStream == null) {
            throw new IOException("The Cmap " + string + " was not found.");
        }
        PdfEncodings.encodeStream(inputStream, arrayList);
        inputStream.close();
    }

    static void encodeStream(InputStream inputStream, ArrayList arrayList) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "iso-8859-1"));
        String string = null;
        int n = 0;
        byte[] byArray = new byte[7];
        block5: while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 6) continue;
            switch (n) {
                case 0: {
                    if (string.indexOf("begincidrange") >= 0) {
                        n = 1;
                        break;
                    }
                    if (string.indexOf("begincidchar") >= 0) {
                        n = 2;
                        break;
                    }
                    if (string.indexOf("usecmap") < 0) break;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    PdfEncodings.readCmap(string2.substring(1), arrayList);
                    break;
                }
                case 1: {
                    if (string.indexOf("endcidrange") >= 0) {
                        n = 0;
                        break;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    int n2 = string2.length() / 2 - 1;
                    long l = Long.parseLong(string2.substring(1, string2.length() - 1), 16);
                    string2 = stringTokenizer.nextToken();
                    long l2 = Long.parseLong(string2.substring(1, string2.length() - 1), 16);
                    string2 = stringTokenizer.nextToken();
                    int n3 = Integer.parseInt(string2);
                    long l3 = l;
                    while (l3 <= l2) {
                        PdfEncodings.breakLong(l3, n2, byArray);
                        PdfEncodings.encodeSequence(n2, byArray, (char)n3, arrayList);
                        ++n3;
                        ++l3;
                    }
                    continue block5;
                }
                case 2: {
                    if (string.indexOf("endcidchar") >= 0) {
                        n = 0;
                        break;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    int n2 = string2.length() / 2 - 1;
                    long l = Long.parseLong(string2.substring(1, string2.length() - 1), 16);
                    string2 = stringTokenizer.nextToken();
                    int n4 = Integer.parseInt(string2);
                    PdfEncodings.breakLong(l, n2, byArray);
                    PdfEncodings.encodeSequence(n2, byArray, (char)n4, arrayList);
                }
            }
        }
    }

    static void breakLong(long l, int n, byte[] byArray) {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(l >> (n - 1 - n2) * 8);
            ++n2;
        }
    }

    static void encodeSequence(int n, byte[] byArray, char c, ArrayList arrayList) {
        char c2;
        int n2;
        char[] cArray;
        --n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            cArray = (char[])arrayList.get(n3);
            c2 = cArray[n2 = byArray[n4] & 0xFF];
            if (c2 != '\u0000' && (c2 & 0x8000) == 0) {
                throw new RuntimeException("Inconsistent mapping.");
            }
            if (c2 == '\u0000') {
                arrayList.add(new char[256]);
                cArray[n2] = c2 = (char)(arrayList.size() - 1 | 0x8000);
            }
            n3 = c2 & Short.MAX_VALUE;
            ++n4;
        }
        cArray = (char[])arrayList.get(n3);
        c2 = cArray[n2 = byArray[n] & 0xFF];
        if ((c2 & 0x8000) != 0) {
            throw new RuntimeException("Inconsistent mapping.");
        }
        cArray[n2] = c;
    }

    static {
        winansi.put(8364, 128);
        winansi.put(8218, 130);
        winansi.put(402, 131);
        winansi.put(8222, 132);
        winansi.put(8230, 133);
        winansi.put(8224, 134);
        winansi.put(8225, 135);
        winansi.put(710, 136);
        winansi.put(8240, 137);
        winansi.put(352, 138);
        winansi.put(8249, 139);
        winansi.put(338, 140);
        winansi.put(381, 142);
        winansi.put(8216, 145);
        winansi.put(8217, 146);
        winansi.put(8220, 147);
        winansi.put(8221, 148);
        winansi.put(8226, 149);
        winansi.put(8211, 150);
        winansi.put(8212, 151);
        winansi.put(732, 152);
        winansi.put(8482, 153);
        winansi.put(353, 154);
        winansi.put(8250, 155);
        winansi.put(339, 156);
        winansi.put(382, 158);
        winansi.put(376, 159);
        pdfEncoding.put(8226, 128);
        pdfEncoding.put(8224, 129);
        pdfEncoding.put(8225, 130);
        pdfEncoding.put(8230, 131);
        pdfEncoding.put(8212, 132);
        pdfEncoding.put(8211, 133);
        pdfEncoding.put(402, 134);
        pdfEncoding.put(8260, 135);
        pdfEncoding.put(8722, 138);
        pdfEncoding.put(8217, 144);
        pdfEncoding.put(8218, 145);
        pdfEncoding.put(8482, 146);
        pdfEncoding.put(64257, 147);
        pdfEncoding.put(64258, 148);
        pdfEncoding.put(321, 149);
        pdfEncoding.put(338, 150);
        pdfEncoding.put(352, 151);
        pdfEncoding.put(376, 152);
        pdfEncoding.put(381, 153);
        pdfEncoding.put(305, 154);
        pdfEncoding.put(322, 155);
        pdfEncoding.put(339, 156);
        pdfEncoding.put(353, 157);
        pdfEncoding.put(382, 158);
        pdfEncoding.put(8364, 160);
        cmaps = new HashMap();
        CRLF_CID_NEWLINE = new byte[][]{{10}, {13, 10}};
    }
}

