/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.NetscapeCertTypeExtension;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class X509TrustManagerImpl
implements X509TrustManager {
    private static final String a = "2.5.29.19";
    private static final String b = "2.5.29.15";
    private static final String c = "2.5.29.37";
    private static final String d = "2.16.840.1.113730.1.1";
    private static final String e = "1.3.6.1.5.5.7.3.1";
    private static final String f = "1.3.6.1.5.5.7.3.2";
    private static final String g = "2.5.29.37.0";
    private static final String h = "ssl_client";
    private static final String i = "ssl_server";
    private static final String j = "ssl_ca";
    private static final Set k = new HashSet(1);
    private Set l = new HashSet();
    private Map m = new HashMap();
    private static final Debug n = Debug.getInstance("ssl");

    X509TrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                certificateArray = keyStore.getCertificate(string);
                if (!(certificateArray instanceof X509Certificate)) continue;
                if (n != null && Debug.isOn("trustmanager")) {
                    System.out.println("adding as trusted cert: " + certificateArray);
                }
                this.a((X509Certificate)certificateArray);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("adding private entry as trusted cert: " + certificateArray[0]);
            }
            this.a((X509Certificate)certificateArray[0]);
        }
    }

    private void a(X509Certificate x509Certificate) {
        X500Name x500Name = null;
        try {
            x500Name = X500Name.a(x509Certificate.getSubjectDN());
        }
        catch (IOException iOException) {
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("X500Name threw: " + iOException);
            }
            return;
        }
        this.l.add(x509Certificate);
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)this.m.get(x500Name);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            this.m.put(x500Name, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    private X509Certificate[] a(X509Certificate[] x509CertificateArray, Date date) {
        X509Certificate x509Certificate;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(x509CertificateArray.length);
        boolean bl = false;
        if (x509CertificateArray.length == 0) {
            return x509CertificateArray;
        }
        int n = 0;
        while (n < x509CertificateArray.length) {
            block11: {
                Object object2;
                block10: {
                    object2 = x509CertificateArray[n];
                    object = this.a((X509Certificate)object2, date);
                    if (object == null) {
                        try {
                            ((X509Certificate)object2).checkValidity(date);
                            break block10;
                        }
                        catch (CertificateException certificateException) {
                            if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                                System.out.println("out of date cert: " + object2);
                            }
                            break block11;
                        }
                    }
                    object2 = object;
                    bl = true;
                    if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                        System.out.println("updated cert with: " + object2);
                    }
                }
                arrayList.add(object2);
            }
            ++n;
        }
        int n2 = x509CertificateArray.length - 1;
        object = x509CertificateArray[n2].getSubjectDN();
        Principal principal = x509CertificateArray[n2].getIssuerDN();
        if (!principal.equals(object) && (x509Certificate = this.b(x509CertificateArray[n2], date)) != null) {
            if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                System.out.println("add missing root cert: " + x509Certificate);
            }
            bl = true;
            arrayList.add(x509Certificate);
        }
        if (bl) {
            return arrayList.toArray(new X509Certificate[arrayList.size()]);
        }
        return x509CertificateArray;
    }

    private void a(X509Certificate x509Certificate, Set set, int n) throws CertificateException {
        set.remove(a);
        if (n == 0) {
            return;
        }
        if (x509Certificate.getExtensionValue(a) == null) {
            if (x509Certificate.getVersion() >= 3) {
                throw new CertificateException("Intermediate X.509v3 certificate without basic constraints extension");
            }
        } else {
            int n2 = x509Certificate.getBasicConstraints();
            if (n2 < 0) {
                throw new CertificateException("End user tried to act as a CA");
            }
            if (n - 1 > n2) {
                throw new CertificateException("Violated path length constraints");
            }
        }
    }

    private void a(X509Certificate x509Certificate, int n, String string) throws CertificateException, Exception {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = k;
        }
        this.a(x509Certificate, set, n);
        if (n == 0) {
            this.a(x509Certificate, set, string);
        } else {
            this.a(x509Certificate, set);
        }
        if (!set.isEmpty()) {
            throw new CertificateException("Certificate contains unknown critical extensions: " + set);
        }
    }

    private void a(X509Certificate x509Certificate, Set set, String string) throws CertificateException, IOException {
        List list;
        set.remove(b);
        set.remove(d);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                throw new CertificateException("Invalid key usage extension.");
            }
            boolean bl = blArray[0];
            boolean bl2 = blArray.length >= 3 ? blArray[2] : false;
            String string2 = "Wrong key usage. Expected digitalSignature.";
            String string3 = "Wrong key usage. Expected keyEncipherment.";
            if (string.indexOf("Client") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_DSS") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_RSA") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA_EXPORT") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA") != -1) {
                if (!bl2) {
                    throw new CertificateException(string3);
                }
            } else if (string.indexOf("UNKNOWN") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else {
                throw new CertificateException("Unknown authType" + string);
            }
        }
        if ((list = this.b(x509Certificate)) != null && set.contains(c)) {
            set.remove(c);
            String string4 = "Extended key usage does not permit use for TLS ";
            if (!list.contains(g)) {
                if (string.indexOf("Client") == -1) {
                    if (!list.contains(e)) {
                        throw new CertificateException(String.valueOf(string4) + "server");
                    }
                } else if (!list.contains(f)) {
                    throw new CertificateException(String.valueOf(string4) + "client");
                }
            }
        }
        if (x509Certificate.getExtensionValue(d) != null) {
            String string5 = "Invalid Netscape CertType extension for SSL ";
            if (string.indexOf("Client") != -1) {
                if (!this.a(x509Certificate, h)) {
                    throw new CertificateException(String.valueOf(string5) + "client");
                }
            } else if (!this.a(x509Certificate, i)) {
                throw new CertificateException(String.valueOf(string5) + "server");
            }
        }
    }

    private void a(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(b);
        set.remove(d);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new CertificateException("Wrong key usage: expect keyCertSign");
        }
        List list = this.b(x509Certificate);
        if (list != null && set.contains(c)) {
            set.remove(c);
            if (!list.contains(g)) {
                throw new CertificateException("Extended key usage in CA certificates must include anyExtendedKeyUsage");
            }
        }
        if (x509Certificate.getExtensionValue(d) != null && !this.a(x509Certificate, j)) {
            throw new CertificateException("Invalid Netscape CertType extension for CA certificate");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.l.size()];
        this.l.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private List b(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(c);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            derValue = new DerValue(byArray2);
            if (derValue.tag != 48) {
                throw new IOException("Invalid encoding for ExtendedKeyUsageExtension.");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (derValue.data.available() != 0) {
                DerValue derValue2 = derValue.data.getDerValue();
                arrayList.add(derValue2.getOID().toString());
            }
            return arrayList;
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.getMessage());
            throw certificateParsingException;
        }
    }

    private boolean a(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(d);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private X509Certificate a(X509Certificate x509Certificate, Date date) {
        X500Name x500Name = null;
        try {
            x500Name = X500Name.a(x509Certificate.getSubjectDN());
        }
        catch (IOException iOException) {
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("X500Name threw: " + iOException);
            }
            return null;
        }
        List list = (List)this.m.get(x500Name);
        if (list == null) {
            return null;
        }
        X500Name x500Name2 = null;
        try {
            x500Name2 = X500Name.a(x509Certificate.getIssuerDN());
        }
        catch (IOException iOException) {
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("X500Name threw: " + iOException);
            }
            return null;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2;
            block13: {
                x509Certificate2 = (X509Certificate)iterator.next();
                if (x509Certificate2.equals(x509Certificate)) continue;
                try {
                    if (!X500Name.a(x509Certificate2.getIssuerDN()).equals(x500Name2)) {
                    }
                    break block13;
                }
                catch (IOException iOException) {
                    if (n == null || !Debug.isOn("trustmanager")) continue;
                    System.out.println("X500Name threw: " + iOException);
                }
                continue;
            }
            if (!x509Certificate2.getPublicKey().equals(publicKey)) continue;
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    private X509Certificate b(X509Certificate x509Certificate, Date date) {
        X500Name x500Name = null;
        try {
            x500Name = X500Name.a(x509Certificate.getIssuerDN());
        }
        catch (IOException iOException) {
            if (n != null && Debug.isOn("trustmanager")) {
                System.out.println("X500Name threw: " + iOException);
            }
            return null;
        }
        List list = (List)this.m.get(x500Name);
        if (list == null) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (Exception exception) {
                if (n == null || !Debug.isOn("trustmanager")) continue;
                System.out.println("local root cert is invalid: " + x509Certificate2);
                continue;
            }
            return x509Certificate2;
        }
        return null;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        return this.isClientTrusted(x509CertificateArray, "UNKNOWN");
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        return this.a(x509CertificateArray, "Client." + string);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        return this.isServerTrusted(x509CertificateArray, "UNKNOWN");
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        return this.a(x509CertificateArray, string);
    }

    private boolean a(X509Certificate[] x509CertificateArray, String string) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        Date date = new Date();
        x509CertificateArray = this.a(x509CertificateArray, date);
        int n = 0;
        while (n < x509CertificateArray.length) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = x509CertificateArray[n];
            try {
                this.a(x509Certificate2, n, string);
            }
            catch (Exception exception) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("failed extension check: " + x509Certificate2);
                    System.out.println("ext exception was: " + exception);
                }
                return false;
            }
            if (this.c(x509Certificate2)) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("stop on trusted cert: " + x509Certificate2);
                }
                return true;
            }
            Principal principal = x509Certificate2.getIssuerDN();
            X509Certificate x509Certificate3 = x509Certificate = n + 1 < x509CertificateArray.length ? x509CertificateArray[n + 1] : x509Certificate2;
            if (!principal.equals(x509Certificate.getSubjectDN())) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    if (n + 1 < x509CertificateArray.length) {
                        System.out.println("Certificate chaining error: issuer DN != subject DN");
                    } else {
                        System.out.println("Could not find trusted certificate");
                    }
                }
                return false;
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                if (X509TrustManagerImpl.n != null && Debug.isOn("trustmanager")) {
                    System.out.println("verify failed: " + x509Certificate2);
                    System.out.println("verify exception was: " + exception);
                }
                return false;
            }
            ++n;
        }
        return false;
    }

    private boolean c(X509Certificate x509Certificate) {
        return this.l.contains(x509Certificate);
    }
}

