/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FCLSupport;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ListenerList;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public abstract class FileSystem
implements Serializable {
    static final long serialVersionUID = -8931487924240189180L;
    public static final String PROP_VALID = "valid";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_SYSTEM_NAME = "systemName";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ROOT = "root";
    public static final String PROP_READ_ONLY = "readOnly";
    static final String PROP_CAPABILITIES = "capabilities";
    private transient boolean valid = false;
    transient boolean assigned = false;
    private transient Repository repository = null;
    private transient FCLSupport fclSupport;
    private FileSystemCapability capability;
    private transient PropertyChangeListener capabilityListener;
    private boolean hidden = false;
    private String systemName = "".intern();
    private transient ListenerList fileStatusList;
    private transient ListenerList vetoableChangeList;
    private transient PropertyChangeSupport changeSupport;
    private static Object internLock;
    private static transient ThreadLocal thrLocal;
    private static final Status STATUS_NONE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void refresh(boolean expected) {
    }

    public final boolean isValid() {
        return this.valid;
    }

    final void setValid(boolean v) {
        if (v != this.valid) {
            this.valid = v;
            this.firePropertyChange(PROP_VALID, !v ? Boolean.TRUE : Boolean.FALSE, v ? Boolean.TRUE : Boolean.FALSE, Boolean.FALSE);
        }
    }

    public final void setHidden(boolean hide) {
        if (hide != this.hidden) {
            this.hidden = hide;
            this.firePropertyChange(PROP_HIDDEN, !hide ? Boolean.TRUE : Boolean.FALSE, hide ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public final boolean isHidden() {
        return this.hidden;
    }

    protected boolean isPersistent() {
        return false;
    }

    public abstract String getDisplayName();

    public final String getSystemName() {
        return this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setSystemName(String name) throws PropertyVetoException {
        Class clazz = Repository.class;
        synchronized (clazz) {
            if (this.systemName.equals(name)) {
                return;
            }
            this.fireVetoableChange(PROP_SYSTEM_NAME, this.systemName, name);
            String old = this.systemName;
            this.systemName = name.intern();
            this.firePropertyChange(PROP_SYSTEM_NAME, old, this.systemName);
            this.firePropertyChange(PROP_DISPLAY_NAME, null, null);
        }
    }

    public final boolean isDefault() {
        return this == ExternalUtil.getRepository().getDefaultFileSystem();
    }

    public abstract boolean isReadOnly();

    public abstract FileObject getRoot();

    public FileObject find(String aPackage, String name, String ext) {
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
        StringBuffer bf = new StringBuffer();
        if (!aPackage.equals("")) {
            String p = aPackage.replace('.', '/');
            bf.append(p);
            bf.append('/');
        }
        if (name != null) {
            bf.append(name);
        }
        if (ext != null) {
            bf.append('.');
            bf.append(ext);
        }
        return this.findResource(bf.toString());
    }

    public abstract FileObject findResource(String var1);

    public abstract SystemAction[] getActions();

    public SystemAction[] getActions(Set foSet) {
        return this.getActions();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.capability != null) {
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    public String toString() {
        return this.getSystemName() + "[" + super.toString() + "]";
    }

    public void prepareEnvironment(Environment env) throws EnvironmentNotSupportedException {
        throw new EnvironmentNotSupportedException(this);
    }

    public Status getStatus() {
        return STATUS_NONE;
    }

    public final FileSystemCapability getCapability() {
        if (this.capability == null) {
            this.capability = new FileSystemCapability.Bean();
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
        return this.capability;
    }

    protected final void setCapability(FileSystemCapability capability) {
        if (this.capability != null) {
            this.capability.removePropertyChangeListener(this.getCapabilityChangeListener());
        }
        this.capability = capability;
        if (this.capability != null) {
            this.capability.addPropertyChangeListener(this.getCapabilityChangeListener());
        }
    }

    public final void runAtomicAction(AtomicAction run) throws IOException {
        this.getEventControl().runAtomicAction(run);
    }

    void beginAtomicAction(AtomicAction run) {
        this.getEventControl().beginAtomicAction(run);
    }

    void beginAtomicAction() {
        this.beginAtomicAction(null);
    }

    void finishAtomicAction() {
        this.getEventControl().finishAtomicAction();
    }

    void dispatchEvent(EventDispatcher run) {
        this.getEventControl().dispatchEvent(run);
    }

    private synchronized PropertyChangeListener getCapabilityChangeListener() {
        if (this.capabilityListener == null) {
            this.capabilityListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FileSystem.this.firePropertyChange(FileSystem.PROP_CAPABILITIES, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                }
            };
        }
        return this.capabilityListener;
    }

    private final EventControl getEventControl() {
        EventControl evnCtrl = (EventControl)thrLocal.get();
        if (evnCtrl == null) {
            evnCtrl = new EventControl();
            thrLocal.set(evnCtrl);
        }
        return evnCtrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addFileStatusListener(FileStatusListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.getStatus() == STATUS_NONE) {
                return;
            }
            if (this.fileStatusList == null) {
                this.fileStatusList = new ListenerList(FileStatusListener.class);
            }
            this.fileStatusList.add(listener);
        }
    }

    public final void removeFileStatusListener(FileStatusListener listener) {
        if (this.fileStatusList == null) {
            return;
        }
        this.fileStatusList.remove(listener);
    }

    protected final void fireFileStatusChanged(FileStatusEvent event) {
        if (this.fileStatusList == null) {
            return;
        }
        List<Object> listeners = Arrays.asList(this.fileStatusList.getAllListeners());
        this.dispatchEvent(new FileStatusDispatcher(listeners, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addVetoableChangeListener(VetoableChangeListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.vetoableChangeList == null) {
                this.vetoableChangeList = new ListenerList(VetoableChangeListener.class);
            }
            this.vetoableChangeList.add(listener);
        }
    }

    public final void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this.vetoableChangeList == null) {
            return;
        }
        this.vetoableChangeList.remove(listener);
    }

    protected final void fireVetoableChange(String name, Object o, Object n) throws PropertyVetoException {
        if (this.vetoableChangeList == null) {
            return;
        }
        PropertyChangeEvent e = null;
        Object[] listeners = this.vetoableChangeList.getAllListeners();
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new PropertyChangeEvent(this, name, o, n);
            }
            ((VetoableChangeListener)listeners[i]).vetoableChange(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        Object object = internLock;
        synchronized (object) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    protected final void firePropertyChange(String name, Object o, Object n) {
        this.firePropertyChange(name, o, n, null);
    }

    final void firePropertyChange(String name, Object o, Object n, Object propagationId) {
        if (this.changeSupport == null) {
            return;
        }
        if (o != null && n != null && o.equals(n)) {
            return;
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, name, o, n);
        e.setPropagationId(propagationId);
        this.changeSupport.firePropertyChange(e);
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    static String getString(String s) {
        return NbBundle.getBundle("org.openide.filesystems.Bundle", Locale.getDefault(), FileSystem.class.getClassLoader()).getString(s);
    }

    static String getString(String s, Object obj) {
        return MessageFormat.format(FileSystem.getString(s), obj);
    }

    static String getString(String s, Object obj1, Object obj2) {
        return MessageFormat.format(FileSystem.getString(s), obj1, obj2);
    }

    static String getString(String s, Object obj1, Object obj2, Object obj3) {
        return MessageFormat.format(FileSystem.getString(s), obj1, obj2, obj3);
    }

    final Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository rep) {
        this.repository = rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final FCLSupport getFCLSupport() {
        Class clazz = FCLSupport.class;
        synchronized (clazz) {
            if (this.fclSupport == null) {
                this.fclSupport = new FCLSupport();
            }
        }
        return this.fclSupport;
    }

    public final void addFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().addFileChangeListener(fcl);
    }

    public final void removeFileChangeListener(FileChangeListener fcl) {
        this.getFCLSupport().removeFileChangeListener(fcl);
    }

    static {
        $assertionsDisabled = !FileSystem.class.desiredAssertionStatus();
        internLock = new Object();
        thrLocal = new ThreadLocal();
        STATUS_NONE = new Status(){

            public String annotateName(String name, Set files) {
                return name;
            }

            public Image annotateIcon(Image icon, int iconType, Set files) {
                return icon;
            }
        };
    }

    private static class FileStatusDispatcher
    extends EventDispatcher {
        private List listeners;
        private FileStatusEvent fStatusEvent;

        public FileStatusDispatcher(List listeners, FileStatusEvent fStatusEvent) {
            this.listeners = listeners;
            this.fStatusEvent = fStatusEvent;
        }

        protected void dispatch(boolean onlyPriority) {
            if (onlyPriority) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                FileStatusListener fStatusListener = (FileStatusListener)this.listeners.get(i);
                fStatusListener.annotationChanged(this.fStatusEvent);
            }
        }

        protected void setAtomicActionLink(EventControl.AtomicActionLink propID) {
        }
    }

    static abstract class EventDispatcher
    implements Runnable {
        EventDispatcher() {
        }

        public final void run() {
            this.dispatch(false);
        }

        protected abstract void dispatch(boolean var1);

        protected abstract void setAtomicActionLink(EventControl.AtomicActionLink var1);
    }

    public static interface HtmlStatus
    extends Status {
        public String annotateNameHtml(String var1, Set var2);
    }

    public static interface Status {
        public String annotateName(String var1, Set var2);

        public Image annotateIcon(Image var1, int var2, Set var3);
    }

    public static abstract class Environment {
        static final /* synthetic */ boolean $assertionsDisabled;

        public Environment() {
            if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
                throw new AssertionError();
            }
        }

        public void addClassPath(String classPathElement) {
        }

        static {
            $assertionsDisabled = !(class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = FileSystem.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).desiredAssertionStatus();
        }
    }

    public static interface AtomicAction {
        public void run() throws IOException;
    }
}

