/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.MultiFileObject;
import org.openide.filesystems.Repository;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class URLMapper {
    public static final int INTERNAL = 0;
    public static final int EXTERNAL = 1;
    public static final int NETWORK = 2;
    private static Lookup.Result result;
    private static final List CACHE_JUST_COMPUTING;
    private static final ThreadLocal threadCache;
    private static URLMapper defMapper;
    private static List cache;

    public static URL findURL(FileObject fo, int type) {
        URL retVal;
        Iterator instances = URLMapper.getInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            if (mapper == URLMapper.getDefault() || (retVal = mapper.getURL(fo, type)) == null) continue;
            return retVal;
        }
        retVal = URLMapper.getDefault().getURL(fo, type);
        if (retVal != null) {
            return retVal;
        }
        if (type == 0) {
            try {
                retVal = FileURL.encodeFileObject(fo);
            }
            catch (FileStateInvalidException iex) {
                return null;
            }
        }
        return retVal;
    }

    public abstract URL getURL(FileObject var1, int var2);

    public static FileObject[] findFileObjects(URL url) {
        LinkedHashSet<FileObject> retSet = new LinkedHashSet<FileObject>();
        FileObject[] retVal = null;
        Iterator instances = URLMapper.getInstances().iterator();
        while (instances.hasNext()) {
            URLMapper mapper = (URLMapper)instances.next();
            if (mapper == URLMapper.getDefault() || (retVal = mapper.getFileObjects(url)) == null) continue;
            retSet.addAll(Arrays.asList(retVal));
        }
        retVal = URLMapper.getDefault().getFileObjects(url);
        if (retVal != null) {
            retSet.addAll(Arrays.asList(retVal));
        }
        retVal = new FileObject[retSet.size()];
        retSet.toArray(retVal);
        return retVal;
    }

    public static FileObject findFileObject(URL url) {
        if (url == null) {
            throw new NullPointerException("Cannot pass null URL to URLMapper.findFileObject");
        }
        FileObject[] results = null;
        Iterator instances = URLMapper.getInstances().iterator();
        while (instances.hasNext() && (results == null || results.length == 0)) {
            URLMapper mapper = (URLMapper)instances.next();
            if (mapper == URLMapper.getDefault()) continue;
            results = mapper.getFileObjects(url);
        }
        if (results == null || results.length == 0) {
            results = URLMapper.getDefault().getFileObjects(url);
        }
        return results != null && results.length > 0 ? results[0] : null;
    }

    public abstract FileObject[] getFileObjects(URL var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLMapper getDefault() {
        Class clazz = URLMapper.class;
        synchronized (clazz) {
            if (defMapper == null) {
                defMapper = new DefaultURLMapper();
            }
            return defMapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List getInstances() {
        Class clazz;
        ArrayList arrayList;
        Class clazz2 = URLMapper.class;
        synchronized (clazz2) {
            if (cache != null && (cache != CACHE_JUST_COMPUTING || threadCache.get() == CACHE_JUST_COMPUTING)) {
                return cache;
            }
            cache = CACHE_JUST_COMPUTING;
            threadCache.set(CACHE_JUST_COMPUTING);
        }
        ArrayList res = null;
        try {
            arrayList = res = new ArrayList(result.allInstances());
            Object var3_3 = null;
            clazz = URLMapper.class;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Class clazz3 = URLMapper.class;
            synchronized (clazz3) {
                if (cache == CACHE_JUST_COMPUTING) {
                    cache = res;
                }
                threadCache.set(null);
            }
            throw throwable;
        }
        synchronized (clazz) {
            if (cache == CACHE_JUST_COMPUTING) {
                cache = res;
            }
            threadCache.set(null);
        }
        return arrayList;
    }

    static {
        CACHE_JUST_COMPUTING = new ArrayList();
        threadCache = new ThreadLocal();
        result = Lookup.getDefault().lookup(new Lookup.Template(URLMapper.class));
        result.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Class clazz = class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper;
                synchronized (clazz) {
                    cache = null;
                }
            }
        });
    }

    private static class DefaultURLMapper
    extends URLMapper {
        static final /* synthetic */ boolean $assertionsDisabled;

        DefaultURLMapper() {
        }

        public FileObject[] getFileObjects(URL url) {
            FileObject[] foRes;
            File f;
            String prot = url.getProtocol();
            if (prot.equals("nbfs")) {
                FileObject[] fileObjectArray;
                FileObject retVal = FileURL.decodeURL(url);
                if (retVal == null) {
                    fileObjectArray = null;
                } else {
                    FileObject[] fileObjectArray2 = new FileObject[1];
                    fileObjectArray = fileObjectArray2;
                    fileObjectArray2[0] = retVal;
                }
                return fileObjectArray;
            }
            if (prot.equals("jar")) {
                return DefaultURLMapper.getFileObjectsForJarProtocol(url);
            }
            if (prot.equals("file") && (f = DefaultURLMapper.toFile(url)) != null && (foRes = this.findFileObjectsInRepository(f)) != null && foRes.length > 0) {
                return foRes;
            }
            return null;
        }

        private FileObject[] findFileObjectsInRepository(File f) {
            if (!f.equals(FileUtil.normalizeFile(f))) {
                throw new IllegalArgumentException("Parameter file was not normalized. Was " + f + " instead of " + FileUtil.normalizeFile(f));
            }
            Enumeration en = Repository.getDefault().getFileSystems();
            LinkedList<FileObject> list = new LinkedList<FileObject>();
            String fileName = f.getAbsolutePath();
            while (en.hasMoreElements()) {
                File file2Fo;
                FileSystem fs = (FileSystem)en.nextElement();
                String rootName = null;
                FileObject fsRoot = fs.getRoot();
                File root = DefaultURLMapper.findFileInRepository(fsRoot);
                if (root == null) {
                    Object rootPath = fsRoot.getAttribute("FileSystem.rootPath");
                    if (rootPath == null || !(rootPath instanceof String)) continue;
                    rootName = (String)rootPath;
                }
                if (rootName == null) {
                    rootName = root.getAbsolutePath();
                }
                if (fileName.indexOf(rootName) != 0) continue;
                String res = fileName.substring(rootName.length()).replace(File.separatorChar, '/');
                FileObject fo = fs.findResource(res);
                File file = file2Fo = fo != null ? DefaultURLMapper.findFileInRepository(fo) : null;
                if (fo == null || file2Fo == null || !f.equals(file2Fo)) continue;
                if (fo.getClass().toString().indexOf("org.netbeans.modules.masterfs.MasterFileObject") != -1) {
                    list.addFirst(fo);
                    continue;
                }
                list.addLast(fo);
            }
            FileObject[] results = new FileObject[list.size()];
            list.toArray(results);
            return results;
        }

        public URL getURL(FileObject fo, int type) {
            return DefaultURLMapper.getURLBasicImpl(fo, type);
        }

        private static URL getURLBasicImpl(FileObject fo, int type) {
            if (fo == null) {
                return null;
            }
            if (type == 2) {
                return null;
            }
            if (fo instanceof MultiFileObject && type == 0) {
                return null;
            }
            File fFile = DefaultURLMapper.findFileInRepository(fo);
            if (fFile != null) {
                try {
                    return DefaultURLMapper.toURL(fFile, fo);
                }
                catch (MalformedURLException mfx) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)mfx);
                    }
                    return null;
                }
            }
            URL retURL = null;
            FileSystem fs = null;
            try {
                fs = fo.getFileSystem();
            }
            catch (FileStateInvalidException fsex) {
                return null;
            }
            if (fs instanceof JarFileSystem) {
                JarFileSystem jfs = (JarFileSystem)fs;
                File f = jfs.getJarFile();
                if (f == null) {
                    return null;
                }
                try {
                    retURL = new URL("jar:" + f.toURI() + "!/" + fo.getPath() + (fo.isFolder() && !fo.isRoot() ? "/" : ""));
                }
                catch (MalformedURLException mfx) {
                    mfx.printStackTrace();
                    return null;
                }
            } else if (fs instanceof XMLFileSystem) {
                URL retVal = null;
                try {
                    retVal = ((XMLFileSystem)fs).getURL(fo.getPath());
                    if (retVal == null) {
                        return null;
                    }
                    if (type == 0) {
                        return retVal;
                    }
                    boolean isInternal = retVal.getProtocol().startsWith("nbres");
                    if (type == 1 && !isInternal) {
                        return retVal;
                    }
                    return null;
                }
                catch (FileNotFoundException fnx) {
                    return null;
                }
            }
            return retURL;
        }

        private static URL toURL(File fFile, FileObject fo) throws MalformedURLException {
            String pathSeparator;
            String urlDef;
            URL retVal = null;
            if (fo.isFolder() && !fo.isValid() && !(urlDef = fFile.toURI().toURL().toExternalForm()).endsWith(pathSeparator = "/")) {
                retVal = new URL(urlDef + pathSeparator);
            }
            return retVal == null ? fFile.toURI().toURL() : retVal;
        }

        private static File findFileInRepository(FileObject fo) {
            File f = (File)fo.getAttribute("java.io.File");
            return f != null ? FileUtil.normalizeFile(f) : null;
        }

        private static FileObject[] getFileObjectsForJarProtocol(URL url) {
            FileObject[] fileObjectArray;
            JarFileSystem fs;
            FileObject retVal = null;
            JarURLParser jarUrlParser = new JarURLParser(url);
            File file = jarUrlParser.getJarFile();
            String entryName = jarUrlParser.getEntryName();
            if (file != null && (fs = DefaultURLMapper.findJarFileSystem(file)) != null) {
                if (entryName == null) {
                    entryName = "";
                }
                retVal = fs.findResource(entryName);
            }
            if (retVal == null) {
                fileObjectArray = null;
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = retVal;
            }
            return fileObjectArray;
        }

        private static JarFileSystem findJarFileSystem(File jarFile) {
            JarFileSystem retVal = null;
            Enumeration en = Repository.getDefault().getFileSystems();
            while (en.hasMoreElements()) {
                File fsJarFile;
                FileSystem fs = (FileSystem)en.nextElement();
                if (!(fs instanceof JarFileSystem) || !(fsJarFile = ((JarFileSystem)fs).getJarFile()).equals(jarFile)) continue;
                retVal = (JarFileSystem)fs;
                break;
            }
            return retVal;
        }

        private static File toFile(URL u) {
            if (u == null) {
                throw new NullPointerException();
            }
            try {
                URI uri = new URI(u.toExternalForm());
                return FileUtil.normalizeFile(new File(uri));
            }
            catch (URISyntaxException use) {
                return null;
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }

        static {
            $assertionsDisabled = !(class$org$openide$filesystems$URLMapper == null ? (class$org$openide$filesystems$URLMapper = URLMapper.class$("org.openide.filesystems.URLMapper")) : class$org$openide$filesystems$URLMapper).desiredAssertionStatus();
        }

        private static class JarURLParser {
            private File jarFile;
            private String entryName;

            JarURLParser(URL originalURL) {
                this.parse(originalURL);
            }

            void parse(URL originalURL) {
                String spec = originalURL.getFile();
                int separator = spec.indexOf(33);
                if (separator != -1) {
                    try {
                        this.jarFile = DefaultURLMapper.toFile(new URL(spec.substring(0, separator++)));
                        this.entryName = null;
                    }
                    catch (MalformedURLException e) {
                        return;
                    }
                    if (++separator != spec.length()) {
                        this.entryName = spec.substring(separator, spec.length());
                    }
                }
            }

            File getJarFile() {
                return this.jarFile;
            }

            String getEntryName() {
                return this.entryName;
            }
        }
    }
}

