/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.List;
import java.util.WeakHashMap;
import org.openide.text.Annotatable;
import org.openide.text.DocumentLine;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public abstract class Line
extends Annotatable
implements Serializable {
    static final long serialVersionUID = 9113186289600795476L;
    public static final String PROP_LINE_NUMBER = "lineNumber";
    private Lookup dataObject;
    public static final int SHOW_TRY_SHOW = 0;
    public static final int SHOW_SHOW = 1;
    public static final int SHOW_GOTO = 2;
    public static final int SHOW_TOFRONT = 3;
    private static final Part nullPart = new NullPart();

    public Line(Lookup context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.dataObject = context;
    }

    public Line(Object source) {
        this(source instanceof Lookup ? (Lookup)source : Lookups.singleton(source));
        if (source == null) {
            throw new NullPointerException();
        }
    }

    public String getDisplayName() {
        return this.getClass().getName() + ":" + this.getLineNumber();
    }

    public final Lookup getLookup() {
        return this.dataObject;
    }

    public abstract int getLineNumber();

    public abstract void show(int var1, int var2);

    public void show(int kind) {
        this.show(kind, 0);
    }

    public abstract void setBreakpoint(boolean var1);

    public abstract boolean isBreakpoint();

    public abstract void markError();

    public abstract void unmarkError();

    public abstract void markCurrentLine();

    public abstract void unmarkCurrentLine();

    public boolean canBeMarkedCurrent(int action, Line previousLine) {
        return true;
    }

    public Part createPart(int column, int length) {
        return nullPart;
    }

    public String getText() {
        return null;
    }

    public static abstract class Set {
        private Date date = new Date();
        private WeakHashMap whm;

        public abstract List getLines();

        public final Date getDate() {
            return this.date;
        }

        public abstract Line getOriginal(int var1) throws IndexOutOfBoundsException;

        public abstract Line getCurrent(int var1) throws IndexOutOfBoundsException;

        public int getOriginalLineNumber(Line line) {
            return Set.computeOriginal(this, line);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        WeakHashMap findWeakHashMap() {
            Date date = this.date;
            synchronized (date) {
                if (this.whm != null) {
                    return this.whm;
                }
                this.whm = new WeakHashMap();
                return this.whm;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Line registerLine(Line line) {
            WeakHashMap lines;
            if (line == null) {
                throw new NullPointerException();
            }
            WeakHashMap weakHashMap = lines = this.findWeakHashMap();
            synchronized (weakHashMap) {
                Line in;
                Reference r = (Reference)lines.get(line);
                Line line2 = in = r != null ? (Line)r.get() : null;
                if (in == null) {
                    if (line instanceof DocumentLine) {
                        ((DocumentLine)line).init();
                    }
                    lines.put(line, new WeakReference<Line>(line));
                    in = line;
                }
                return in;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Line findLine(Line line) {
            WeakHashMap lines;
            WeakHashMap weakHashMap = lines = this.findWeakHashMap();
            synchronized (weakHashMap) {
                Reference r = (Reference)lines.get(line);
                Line in = r != null ? (Line)r.get() : null;
                return in;
            }
        }

        static int computeOriginal(Set set, Line line) {
            int n = line.getLineNumber();
            Line current = null;
            try {
                current = set.getOriginal(n);
                if (line.equals(current)) {
                    return n;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                // empty catch block
            }
            if (current == null) {
                return Set.binarySearch(set, n, 0, Set.findMaxLine(set));
            }
            if (n < current.getLineNumber()) {
                return Set.binarySearch(set, n, 0, current.getLineNumber());
            }
            return Set.binarySearch(set, n, current.getLineNumber(), Set.findMaxLine(set));
        }

        private static int binarySearch(Set set, int number, int from, int to) {
            while (from < to) {
                int middle = (from + to) / 2;
                Line l = set.getOriginal(middle);
                int ln = l.getLineNumber();
                if (ln == number) {
                    return middle;
                }
                if (ln < number) {
                    from = middle + 1;
                    continue;
                }
                to = middle - 1;
            }
            return from;
        }

        private static int findMaxLine(Set set) {
            int from = 0;
            int to = 32000;
            try {
                while (true) {
                    set.getOriginal(to);
                    from = to;
                    to *= 2;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                while (from < to) {
                    int middle = (from + to + 1) / 2;
                    try {
                        set.getOriginal(middle);
                        from = middle;
                    }
                    catch (IndexOutOfBoundsException ex2) {
                        to = middle - 1;
                    }
                }
                return from;
            }
        }
    }

    private static final class NullPart
    extends Part {
        NullPart() {
        }

        public int getColumn() {
            return 0;
        }

        public int getLength() {
            return 0;
        }

        public Line getLine() {
            return null;
        }

        public String getText() {
            return null;
        }
    }

    public static abstract class Part
    extends Annotatable {
        public static final String PROP_LINE = "line";
        public static final String PROP_COLUMN = "column";
        public static final String PROP_LENGTH = "length";

        public abstract int getColumn();

        public abstract int getLength();

        public abstract Line getLine();
    }
}

