/*
 * Decompiled with CFR 0.152.
 */
package com.ireasoning.protocol.snmp;

import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpOID;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.T;
import com.ireasoning.protocol.snmp.U;
import com.ireasoning.protocol.snmp.aW;
import com.ireasoning.protocol.snmp.aX;
import com.ireasoning.protocol.snmp.aZ;
import com.ireasoning.protocol.snmp.ag;
import com.ireasoning.protocol.snmp.aj;
import com.ireasoning.protocol.snmp.c;
import com.ireasoning.protocol.snmp.d;
import com.ireasoning.util.X;
import com.ireasoning.util.aU;
import com.ireasoning.util.au;
import com.ireasoning.util.ba;
import com.sysuptime.server.msp.Command;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class a0
extends aW
implements SnmpDataType {
    static aj DEFAULT_ADDRESS = null;
    SnmpOID _enterprise;
    aj _agentAddr = DEFAULT_ADDRESS;
    InetAddress _packetAddr;
    int _generic = 0;
    int _specific = 0;
    long _timestamp = 0L;
    String _community;
    static X _trapmap;
    public static final int COLD_START_TRAP = 0;
    public static final int WARM_START_TRAP = 1;
    public static final int LINK_DOWN_TRAP = 2;
    public static final int LINK_UP_TRAP = 3;
    public static final int AUTHENTICATION_FAILURE_TRAP = 4;
    public static final int EGPNEIGHBOR_LOSS_TRAP = 5;
    private static final String[] GENERIC_STRING;
    static final SnmpOID SNMP_TRAP_ADDRESS_OID;
    static final SnmpOID SNMP_TRAP_COMMUNITY_OID;
    static final SnmpOID[] V2_ADDITIONAL_OIDS;

    a0() {
    }

    public a0(SnmpOID snmpOID) {
        this();
        this._enterprise = new SnmpOID(snmpOID);
    }

    public a0(String string) {
        this(new SnmpOID(string));
    }

    public a0(a0 a02) {
        super(a02);
        this._enterprise = a02._enterprise;
        this._agentAddr = a02._agentAddr;
        this._generic = a02._generic;
        this._specific = a02._specific;
        this._timestamp = a02._timestamp;
        this._community = aU.cloneString(a02._community);
    }

    public static a0 decodeV1Trap(byte[] byArray, int n2) throws c {
        T t2 = new T(byArray, n2);
        return (a0)t2.a(false);
    }

    public static byte[] encodeV1Trap(a0 a02) throws d {
        U u2 = new U();
        u2.a(a02, a02.getCommunity());
        byte[] byArray = u2.a();
        int n2 = u2.b();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public SnmpOID getEnterprise() {
        return this._enterprise;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this._enterprise = new SnmpOID(snmpOID);
    }

    public void setEnterprise(String string) {
        this._enterprise = new SnmpOID(string);
    }

    public aj getIpAddress() {
        return this._agentAddr;
    }

    public InetAddress getTrapSenderIpAddress() {
        return this._packetAddr;
    }

    public void setTrapSenderIpAddress(InetAddress inetAddress) {
        this._packetAddr = inetAddress;
    }

    public void setIpAddress(aj aj2) {
        this._agentAddr = aj2;
    }

    public void setIpAddress(String string) {
        block3: {
            block2: {
                Command[] commandArray = SnmpVarBind.b();
                if (!aj.isValidIpAddress(string)) break block2;
                this._agentAddr = new aj(string);
                if (commandArray != null) break block3;
            }
            this._agentAddr = new aj();
        }
    }

    public void setIpAddress(InetAddress inetAddress) {
        block3: {
            block2: {
                byte[] byArray = inetAddress.getAddress();
                Command[] commandArray = SnmpVarBind.b();
                if (byArray == null || byArray.length != 4) break block2;
                this._agentAddr = new aj(inetAddress.getHostAddress());
                if (commandArray != null) break block3;
            }
            this._agentAddr = new aj();
        }
    }

    public int getGeneric() {
        return this._generic;
    }

    public String getGenericString() {
        if (this._generic < 0 || this._generic >= GENERIC_STRING.length) {
            return null;
        }
        return GENERIC_STRING[this._generic];
    }

    public void setGeneric(int n2) {
        this._generic = n2;
        if (this._generic < 6) {
            this._specific = 0;
        }
    }

    public int getSpecific() {
        return this._specific;
    }

    public void setSpecific(int n2) {
        this._specific = n2;
        if (n2 > 0) {
            this._generic = 6;
        }
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long l2) {
        this._timestamp = l2;
    }

    public String getTimestampString() {
        return "" + new ba(this._timestamp * 10L);
    }

    public String getCommunity() {
        return this._community;
    }

    public void setCommunity(String string) {
        this._community = string;
    }

    public SnmpVarBind[] getVariables() {
        return this.getVarBinds();
    }

    @Override
    public int getType() {
        return -92;
    }

    @Override
    public String getTypeString() {
        return "V1Trap";
    }

    public aZ toV2Trap() {
        return this.toV2Trap(false);
    }

    public aZ toV2Trap(boolean bl2) {
        Object object;
        block15: {
            long l2 = this._timestamp;
            SnmpOID snmpOID = null;
            Command[] commandArray = SnmpVarBind.b();
            if (this._generic == 6) {
                snmpOID = new SnmpOID(this._enterprise);
                object = new long[]{0L, this._specific};
                snmpOID.append((long[])object);
            } else {
                snmpOID = new SnmpOID((SnmpOID)_trapmap.get(this._generic));
            }
            object = new aZ(l2, snmpOID, this._varbinds.toArray());
            if (bl2) {
                SnmpDataType snmpDataType;
                int n2;
                boolean[] blArray;
                block14: {
                    int n3;
                    blArray = new boolean[3];
                    n2 = 0;
                    block0: while (true) {
                        int n4 = n2;
                        block1: while (n4 < this._varbinds.size()) {
                            snmpDataType = this._varbinds.get(n2);
                            n3 = 0;
                            if (commandArray == null) break block14;
                            for (int i2 = v434539; i2 < 3; ++i2) {
                                n4 = snmpDataType.getName().equals(V2_ADDITIONAL_OIDS[i2]) ? 1 : 0;
                                if (commandArray == null) continue block1;
                                if (n4 == 0) continue;
                                blArray[i2] = true;
                                if (commandArray != null) continue;
                            }
                            ++n2;
                            if (commandArray != null) continue block0;
                        }
                        break;
                    }
                    n3 = n2 = 0;
                }
                while (n2 < 3) {
                    if (commandArray != null) {
                        if (!blArray[n2]) {
                            snmpDataType = null;
                            if (n2 == 0) {
                                snmpDataType = this._agentAddr;
                            } else if (n2 == 1) {
                                snmpDataType = new ag(this._community);
                            } else if (n2 == 2) {
                                snmpDataType = this._enterprise;
                            }
                            SnmpVarBind snmpVarBind = new SnmpVarBind(new SnmpOID(V2_ADDITIONAL_OIDS[n2]), snmpDataType);
                            object.addVarBind(snmpVarBind);
                        }
                        ++n2;
                        if (commandArray != null) continue;
                    }
                    break block15;
                }
            }
            object.setIpAddress(this._agentAddr.toString());
        }
        return object;
    }

    @Override
    public SnmpDataType copy() {
        return new a0(this);
    }

    @Override
    public int encode(U u2) throws d {
        return u2.a(this);
    }

    public String toString() {
        Object object;
        block2: {
            Object object2 = "";
            object2 = (String)object2 + "Community:\t\t" + aU.convertNull(this._community) + "\r\n";
            object2 = (String)object2 + "Enterprise OID:\t\t" + this.getEnterprise() + "\r\n";
            object2 = (String)object2 + "Ip Address:\t\t" + this.getIpAddress() + "\r\n";
            object2 = (String)object2 + "Generic:\t\t" + this.getGenericString() + "\r\n";
            object2 = (String)object2 + "Specific:\t\t" + this.getSpecific() + "\r\n";
            object2 = (String)object2 + "TimeStamp:\t\t" + this.getTimestampString() + "\r\n";
            int n2 = this.getVarBindCount();
            Command[] commandArray = SnmpVarBind.b();
            for (int i2 = 0; i2 < n2; ++i2) {
                SnmpVarBind snmpVarBind = this.getVarBind(i2);
                object = (String)object2 + snmpVarBind.toString() + "\r\n";
                if (commandArray != null) {
                    object2 = object;
                    if (commandArray != null) continue;
                }
                break block2;
            }
            object = object2;
        }
        return object;
    }

    static {
        try {
            DEFAULT_ADDRESS = new aj(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            au.error(unknownHostException);
            DEFAULT_ADDRESS = new aj("0.0.0.0");
        }
        _trapmap = new X();
        _trapmap.put(0, aX.COLD_START_TRAP_OID);
        _trapmap.put(1, aX.WARM_START_TRAP_OID);
        _trapmap.put(2, aX.LINK_DOWN_TRAP_OID);
        _trapmap.put(3, aX.LINK_UP_TRAP_OID);
        _trapmap.put(4, aX.AUTHENTICATION_FAILURE_TRAP_OID);
        _trapmap.put(5, aX.EGPNEIGHBOR_LOSS_OID);
        GENERIC_STRING = new String[]{"coldStart", "warmStart", "linkDown", "linkUp", "authenticationFailure", "egpNeighborLoss", "enterpriseSpecific"};
        SNMP_TRAP_ADDRESS_OID = new SnmpOID(".1.3.6.1.6.3.18.1.3.0");
        SNMP_TRAP_COMMUNITY_OID = new SnmpOID(".1.3.6.1.6.3.18.1.4.0");
        V2_ADDITIONAL_OIDS = new SnmpOID[]{SNMP_TRAP_ADDRESS_OID, SNMP_TRAP_COMMUNITY_OID, aZ.SNMP_TRAP_ENTERPRISE_OID};
    }
}

