/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphPreprocessor;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkConnection;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.model.TopologyData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.layout.JGraphLayoutAlgorithm;

public abstract class NetworkGraphModel
extends DefaultGraphModel {
    public static final String TYPE_MASTER = "m";
    public static final String TYPE_CUSTOMER = "c";
    public static final String TYPE_SUBNET = "s";
    public static final String TYPE_VIEW = "v";
    protected TopologyData _data;
    protected GraphID _id;
    protected GraphID _parentGraph;
    protected Map _bean2NodeMap = new Hashtable();
    protected List _connections;
    protected String _backgroundImagePath;
    protected JGraphLayoutAlgorithm _layoutAlgorithm;
    protected Path _path;
    private transient boolean _ignoreChanges;
    private boolean _isCustomView;
    private static int[] a;

    public NetworkGraphModel() {
    }

    public NetworkGraphModel(TopologyData topologyData, GraphID graphID, GraphPreprocessor graphPreprocessor) {
        super(graphPreprocessor.getNodeList(), null, graphPreprocessor.connect());
        this._data = topologyData;
        this._id = graphID;
        this._bean2NodeMap = graphPreprocessor.getBean2NodeMap();
        this._connections = graphPreprocessor.getConnections();
    }

    public static Map createBean2NodeMap(List list) {
        Hashtable<NetworkNodeBean, NetworkNode> hashtable;
        Hashtable<NetworkNodeBean, NetworkNode> hashtable2 = new Hashtable<NetworkNodeBean, NetworkNode>();
        int[] nArray = NetworkGraphModel.b();
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                TopoNode topoNode = (TopoNode)list.get(i2);
                NetworkNodeBean networkNodeBean = topoNode.getBean();
                NetworkNode networkNode = new NetworkNode(networkNodeBean);
                hashtable = hashtable2;
                if (nArray != null) {
                    hashtable.put(networkNodeBean, networkNode);
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            hashtable = hashtable2;
        }
        return hashtable;
    }

    protected abstract void a(NetworkNodeBean var1);

    protected abstract void b(NetworkNodeBean var1);

    protected Object[] handleInsert(Object[] objectArray) {
        this.a(objectArray);
        return super.handleInsert(objectArray);
    }

    protected Object[] handleRemove(Object[] objectArray) {
        this.b(objectArray);
        return super.handleRemove(objectArray);
    }

    private void a(Object[] objectArray) {
        int[] nArray = NetworkGraphModel.b();
        if (objectArray == null) {
            return;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof NetworkNode) {
                NetworkNode networkNode = (NetworkNode)objectArray[i2];
                NetworkNodeBean networkNodeBean = networkNode.getBean();
                if (this._bean2NodeMap == null) {
                    this._bean2NodeMap = new Hashtable();
                }
                if (this._bean2NodeMap.get(networkNodeBean) == null) {
                    this._bean2NodeMap.put(networkNodeBean, objectArray[i2]);
                    this.a(networkNodeBean);
                    this.c(networkNodeBean);
                }
                if (nArray != null) continue;
            }
            if (!(objectArray[i2] instanceof NetworkConnection)) continue;
            if (this._connections != null) {
                if (this._connections.contains(objectArray[i2])) {
                    if (nArray != null) continue;
                }
            } else {
                this._connections = new ArrayList();
            }
            this._connections.add(objectArray[i2]);
            if (nArray != null) continue;
        }
    }

    private void b(Object[] objectArray) {
        int[] nArray = NetworkGraphModel.b();
        if (objectArray == null) {
            return;
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof NetworkNode) {
                NetworkNode networkNode = (NetworkNode)objectArray[i2];
                if (this._bean2NodeMap != null) {
                    this._bean2NodeMap.remove(((NetworkNode)objectArray[i2]).getUserObject());
                    this.b(networkNode.getBean());
                    this.d(networkNode.getBean());
                }
                if (nArray != null) continue;
            }
            if (!(objectArray[i2] instanceof NetworkConnection) || this._connections == null) continue;
            this._connections.remove(objectArray[i2]);
            if (nArray != null) continue;
        }
    }

    protected abstract void c(NetworkNodeBean var1);

    protected abstract void d(NetworkNodeBean var1);

    public List getBeans() {
        if (this._bean2NodeMap != null) {
            return new ArrayList(this._bean2NodeMap.keySet());
        }
        return null;
    }

    public List getBeanIDs() {
        ArrayList<String> arrayList;
        block2: {
            List list = this.getBeans();
            int[] nArray = NetworkGraphModel.b();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (Object e10 : list) {
                String string = ((NetworkNodeBean)e10).getID();
                arrayList = arrayList2;
                if (nArray != null) {
                    arrayList.add(string);
                    if (nArray != null) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public Object[] getNodes() {
        if (this._bean2NodeMap != null) {
            return this._bean2NodeMap.values().toArray();
        }
        return null;
    }

    public Object[] getVisibleCells() {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = NetworkGraphModel.b();
        List list = this.getConnections();
        if (list != null) {
            arrayList.addAll(list);
        }
        if ((objectArray = this.getNodes()) != null && objectArray.length > 0) {
            Object[] objectArray2;
            block4: {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray2 = objectArray;
                    if (nArray != null) {
                        if (!((NetworkNode)objectArray2[i2]).isVisible()) continue;
                        arrayList.add(objectArray[i2]);
                        if (nArray != null) continue;
                    }
                    break block4;
                }
                objectArray2 = arrayList.toArray();
            }
            return objectArray2;
        }
        return null;
    }

    public Object[] getInvisibleNodes() {
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int[] nArray = NetworkGraphModel.b();
        Object[] objectArray2 = this.getNodes();
        if (objectArray2 != null && objectArray2.length > 0) {
            for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                objectArray = objectArray2;
                if (nArray != null) {
                    if (((NetworkNode)objectArray[i2]).isVisible()) continue;
                    arrayList.add(objectArray2[i2]);
                    if (nArray != null) continue;
                }
                break;
            }
        } else {
            objectArray = arrayList.toArray();
        }
        return objectArray;
    }

    public List getConnections() {
        return this._connections;
    }

    public List getManuallyAddedNodes() {
        Object[] objectArray = this.getNodes();
        int[] nArray = NetworkGraphModel.b();
        ArrayList<NetworkNode> arrayList = new ArrayList<NetworkNode>();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                NetworkNode networkNode = (NetworkNode)objectArray[i2];
                if (!networkNode.isManuallyAdded()) continue;
                arrayList.add(networkNode);
                if (nArray != null) continue;
            }
        }
        return arrayList;
    }

    public void setParentGraph(GraphID graphID) {
        this._parentGraph = graphID;
    }

    public GraphID getParentGraph() {
        return this._parentGraph;
    }

    public GraphID getID() {
        return this._id;
    }

    public void setID(GraphID graphID) {
        this._id = graphID;
    }

    public NetworkNode getNodeByBean(Object object) {
        if (this._bean2NodeMap != null) {
            return (NetworkNode)this._bean2NodeMap.get(object);
        }
        return null;
    }

    public TopoNode getNode(Path path) {
        if (this._data != null) {
            return this._data.getNode(path);
        }
        return null;
    }

    public NetworkNodeBean getBean(String string) {
        return this._data.getBean(string);
    }

    public NetworkNodeBean getBean(Path path) {
        TopoNode topoNode = this.getNode(path);
        if (topoNode != null) {
            return topoNode.getBean();
        }
        return null;
    }

    public List getAllBeans() {
        if (this._data != null) {
            return new ArrayList(this._data.getAllBeans());
        }
        return new ArrayList();
    }

    public static Collection getManuallyAddedSubnets(CustomerNode customerNode) {
        ArrayList<NetworkNodeBean> arrayList = new ArrayList<NetworkNodeBean>();
        int[] nArray = NetworkGraphModel.b();
        Iterator iterator = customerNode.childrenIterator();
        while (iterator.hasNext()) {
            TopoNode topoNode = (TopoNode)iterator.next();
            NetworkNodeBean networkNodeBean = topoNode.getBean();
            if (topoNode instanceof SubnetNode && networkNodeBean.isManuallyAdded()) {
                arrayList.add(networkNodeBean);
            }
            if (nArray != null) continue;
        }
        return arrayList;
    }

    public synchronized boolean isEmpty() {
        return this._data == null;
    }

    public String getBackgroundImagePath() {
        return this._backgroundImagePath;
    }

    public void setBackgroundImagePath(String string) {
        this._backgroundImagePath = string;
    }

    public List getGraphIdsByIP(String string) {
        List list = this.getAllBeans();
        ArrayList<GraphID> arrayList = new ArrayList<GraphID>();
        int[] nArray = NetworkGraphModel.b();
        if (list != null) {
            Iterator iterator = list.iterator();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    Object e10 = iterator.next();
                    NetworkNodeBean networkNodeBean = (NetworkNodeBean)e10;
                    if (!networkNodeBean.isMyIp(string)) continue block0;
                    for (int i2 = 0; i2 < networkNodeBean.getTopoGraphCount(); ++i2) {
                        GraphID graphID = networkNodeBean.getTopoGraphIDIndex(i2);
                        bl2 = arrayList.contains(graphID);
                        if (nArray == null) continue block1;
                        if (bl2) continue;
                        arrayList.add(graphID);
                        if (nArray != null) continue;
                    }
                    if (nArray != null) continue block0;
                }
                break;
            }
        }
        return arrayList;
    }

    public boolean hasErrorConnections() {
        boolean bl2;
        int[] nArray = NetworkGraphModel.b();
        if (this._connections != null) {
            int n2 = this._connections.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NetworkConnection networkConnection = (NetworkConnection)this._connections.get(i2);
                bl2 = networkConnection.isError();
                if (nArray != null) {
                    if (!bl2) continue;
                    return true;
                }
                break;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public TopologyData getData() {
        return this._data;
    }

    public JGraphLayoutAlgorithm getLayoutAlgorithm() {
        return this._layoutAlgorithm;
    }

    public abstract String getGraphType();

    public void insertLink(NetworkConnection networkConnection) {
        if (networkConnection == null) {
            return;
        }
        ConnectionSet connectionSet = new ConnectionSet();
        NetworkInterface networkInterface = networkConnection.getNetworkInterface1();
        NetworkNodeBean networkNodeBean = null;
        if (networkInterface != null) {
            networkNodeBean = networkInterface.getHostNode();
        }
        NetworkInterface networkInterface2 = networkConnection.getNetworkInterface2();
        NetworkNodeBean networkNodeBean2 = null;
        if (networkInterface2 != null) {
            networkNodeBean2 = networkInterface2.getHostNode();
        }
        NetworkNode networkNode = null;
        if (networkNodeBean != null) {
            networkNode = (NetworkNode)this._bean2NodeMap.get(networkNodeBean);
        }
        NetworkNode networkNode2 = null;
        if (networkNodeBean2 != null) {
            networkNode2 = (NetworkNode)this._bean2NodeMap.get(networkNodeBean2);
        }
        if (networkNode != null) {
            connectionSet.connect((Object)networkConnection, (Object)networkNode.getFirstChild(), true);
        }
        if (networkNode2 != null) {
            connectionSet.connect((Object)networkConnection, (Object)networkNode2.getFirstChild(), false);
        }
        this.insert(new Object[]{networkConnection}, null, connectionSet, null, null);
    }

    public boolean existsInterface(EthernetInterface ethernetInterface, EthernetInterface ethernetInterface2) {
        int n2;
        block3: {
            Set set = this._data.getAllDevices();
            Iterator iterator = set.iterator();
            int[] nArray = NetworkGraphModel.b();
            block0: while (true) {
                boolean bl2 = iterator.hasNext();
                block1: while (bl2) {
                    NetworkNodeBean networkNodeBean = (NetworkNodeBean)iterator.next();
                    NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
                    n2 = 0;
                    if (nArray == null) break block3;
                    for (int i2 = v633204; i2 < networkInterfaceArray.length; ++i2) {
                        EthernetInterface ethernetInterface3 = (EthernetInterface)networkInterfaceArray[i2];
                        bl2 = ethernetInterface3.equals(ethernetInterface);
                        if (nArray == null) continue block1;
                        if (!bl2 || ethernetInterface3.equals(ethernetInterface2)) continue;
                        return true;
                    }
                    if (nArray != null) continue block0;
                }
                break;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    public NetworkConnection findConnection(String string, String string2) {
        int[] nArray = NetworkGraphModel.b();
        if (this._connections != null) {
            int n2 = this._connections.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NetworkConnection networkConnection = (NetworkConnection)this._connections.get(i2);
                if (networkConnection.getIP1() == null || networkConnection.getIP2() == null || (!networkConnection.getIP1().equals(string) || !networkConnection.getIP2().equals(string2)) && (!networkConnection.getIP1().equals(string2) || !networkConnection.getIP2().equals(string))) continue;
                return networkConnection;
            }
        }
        return null;
    }

    public void keepOld(NetworkGraphModel networkGraphModel) {
        int[] nArray = NetworkGraphModel.b();
        this.setBackgroundImagePath(networkGraphModel.getBackgroundImagePath());
        int[] nArray2 = nArray;
        Object[] objectArray = this.getNodes();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkNode networkNode = (NetworkNode)objectArray[i2];
            NetworkNode networkNode2 = networkGraphModel.getNodeByBean(networkNode.getBean());
            if (networkNode2 == null) continue;
            networkNode.setCurrentDefaultIcon(networkNode2.getCurrentDefaultIcon());
            networkNode.setAttributes(networkNode2.getAttributes());
            if (nArray2 != null) continue;
        }
    }

    public boolean hasBackground() {
        return this._backgroundImagePath != null;
    }

    public void setIgnoreChanges(boolean bl2) {
        this._ignoreChanges = bl2;
    }

    public boolean isIgnoreChanges() {
        return this._ignoreChanges;
    }

    public void setCustomView(boolean bl2) {
        this._isCustomView = bl2;
    }

    public boolean isCustomView() {
        return this._isCustomView;
    }

    public static void b(int[] nArray) {
        a = nArray;
    }

    public static int[] b() {
        return a;
    }

    static {
        if (NetworkGraphModel.b() == null) {
            NetworkGraphModel.b(new int[4]);
        }
    }
}

