/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.discovery;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.DeviceOption;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.mainframe.discovery.MediationDialog;
import com.sysuptime.mainframe.discovery.UpdateDeviceDialog$1;
import com.sysuptime.mainframe.discovery.UpdateDeviceDialog$2;
import com.sysuptime.mainframe.discovery.UpdateDeviceDialog$EditServiceAction;
import com.sysuptime.mainframe.discovery.UpdateSubnetDialog;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.util.AuthAlgorithmComboBox;
import com.sysuptime.mainframe.util.ConfirmDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.PrivacyAlgorithmComboBox;
import com.sysuptime.mainframe.util.SnmpVersionComboBox;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Frame;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class UpdateDeviceDialog
extends ConfirmDialog {
    private NetworkNodeBean _bean;
    private JComboBox _ipCombo;
    private JTextField _timeoutField;
    private JCheckBox _serviceCheck;
    private JCheckBox _cleanDiscoveryCheck;
    private JButton _editServiceButton;
    private JTextField _snmpPortField;
    private JPasswordField _communityField;
    private SnmpVersionComboBox _snmpVersionCombo;
    private JTextField _userField;
    private AuthAlgorithmComboBox _authAlgorithmCombo;
    private JPasswordField _authPasswordField;
    private PrivacyAlgorithmComboBox _privacyAlgorithmCombo;
    private JPasswordField _privacyPasswordField;
    private List _scanServices;
    private boolean _isOK;
    private NetworkGraphModel _graphModel;

    public UpdateDeviceDialog(Frame frame, NetworkNodeBean networkNodeBean, NetworkGraphModel networkGraphModel) {
        super(frame, "", true);
        this._bean = networkNodeBean;
        this._graphModel = networkGraphModel;
        this.e();
        this.a(networkNodeBean);
        SwingUtil.dialogBindingESC(this, null);
    }

    private void d() {
        this._ipCombo = new JComboBox();
        this._timeoutField = new JTextField();
        this._serviceCheck = new JCheckBox();
        this._cleanDiscoveryCheck = new JCheckBox();
        this._editServiceButton = new JButton(new UpdateDeviceDialog$EditServiceAction(this));
        this._snmpPortField = new JTextField();
        this._communityField = new JPasswordField();
        this._snmpVersionCombo = new SnmpVersionComboBox();
        this._userField = new JTextField();
        this._authAlgorithmCombo = new AuthAlgorithmComboBox();
        this._authPasswordField = new JPasswordField();
        this._privacyAlgorithmCombo = new PrivacyAlgorithmComboBox();
        this._privacyPasswordField = new JPasswordField();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void e() {
        block4: {
            int n2;
            block3: {
                int n3 = MediationDialog.w();
                this.setTitle(NbBundle.getMessage(UpdateSubnetDialog.class, (String)"UpdateNode_title"));
                n2 = n3;
                if (!(this._graphModel instanceof SubnetGraphModel)) break block3;
                String string = ((SubnetGraphModel)this._graphModel).getID().getGraphName();
                String string2 = this._bean.getIPInSubnet(string);
                this._ipCombo.addItem(string2);
                if (n2 != 0) break block4;
            }
            String[] stringArray = this._bean.getAllIpAddress();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this._ipCombo.addItem(stringArray[i2]);
                if (n2 == 0) return;
                if (n2 != 0) continue;
            }
        }
        this._timeoutField.setText("1.0");
        this._editServiceButton.setEnabled(false);
        this._serviceCheck.addActionListener(new UpdateDeviceDialog$1(this));
        this._snmpPortField.setText("161");
        this._communityField.setText("public");
        this._snmpVersionCombo.addItemListener(new UpdateDeviceDialog$2(this));
        this.a(false);
    }

    private void a(NetworkNodeBean networkNodeBean) {
        V3Params v3Params;
        ReadCommunity readCommunity = networkNodeBean.getReadCommunity();
        this._snmpPortField.setText(String.valueOf(readCommunity.getPort()));
        this._communityField.setText(readCommunity.getCommunity());
        this._snmpVersionCombo.setValue(readCommunity.getVersion());
        if (readCommunity.getVersion() == 3 && (v3Params = readCommunity.getV3Params()) != null) {
            this._userField.setText(v3Params.getUserName());
            this._authAlgorithmCombo.setValue(v3Params.getAuthProtocol());
            this._authPasswordField.setText(v3Params.getAuthPassword());
            this._privacyAlgorithmCombo.setValue(v3Params.getPrivProtocol());
            this._privacyPasswordField.setText(v3Params.getPrivPassword());
        }
    }

    private void a(boolean bl2) {
        this._userField.setEnabled(bl2);
        this._authAlgorithmCombo.setEnabled(bl2);
        this._authPasswordField.setEnabled(bl2);
        this._privacyAlgorithmCombo.setEnabled(bl2);
        this._privacyPasswordField.setEnabled(bl2);
    }

    private JPanel f() {
        this.d();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,RIGHT:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel();
        jLabel.setText(UpdateDeviceDialog.a("label_ipAddress"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(3, 3));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(UpdateDeviceDialog.a("UpdateNodeDialog_port"));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(3, 11));
        panelBuilder.add((Component)this._snmpPortField, cellConstraints.xywh(5, 11, 5, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(UpdateDeviceDialog.a("UpdateNodeDialog_read"));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(3, 13));
        panelBuilder.add((Component)this._communityField, cellConstraints.xywh(5, 13, 5, 1));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(UpdateDeviceDialog.a("UpdateNodeDialog_snmp_version"));
        panelBuilder.add((Component)jLabel4, cellConstraints.xy(3, 15));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(UpdateDeviceDialog.a("UpdateNodeDialog_usm_user"));
        panelBuilder.add((Component)jLabel5, cellConstraints.xy(3, 19));
        panelBuilder.add((Component)this._userField, cellConstraints.xywh(5, 19, 5, 1));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(UpdateDeviceDialog.a("UpdateNodeDialog_auth_agt"));
        panelBuilder.add((Component)jLabel6, cellConstraints.xy(3, 21));
        panelBuilder.add((Component)this._authAlgorithmCombo, cellConstraints.xywh(5, 21, 5, 1));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(UpdateDeviceDialog.a("UpdateNodeDialog_auth_pwd"));
        panelBuilder.add((Component)jLabel7, cellConstraints.xy(3, 23));
        panelBuilder.add((Component)this._authPasswordField, cellConstraints.xywh(5, 23, 5, 1));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(UpdateDeviceDialog.a("UpdateNodeDialog_priv_agt"));
        panelBuilder.add((Component)jLabel8, cellConstraints.xy(3, 25));
        panelBuilder.add((Component)this._privacyAlgorithmCombo, cellConstraints.xywh(5, 25, 5, 1));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(UpdateDeviceDialog.a("UpdateNodeDialog_priv_pwd"));
        panelBuilder.add((Component)jLabel9, cellConstraints.xy(3, 27));
        panelBuilder.add((Component)this._privacyPasswordField, cellConstraints.xywh(5, 27, 5, 1));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText(UpdateDeviceDialog.a("label_timeout"));
        panelBuilder.add((Component)jLabel10, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)new JLabel(UpdateDeviceDialog.a("lable_seconds")), cellConstraints.xy(10, 5));
        panelBuilder.add((Component)this._snmpVersionCombo, cellConstraints.xywh(5, 15, 5, 1));
        panelBuilder.add((Component)this._timeoutField, cellConstraints.xywh(5, 5, 5, 1));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText(UpdateDeviceDialog.a("label_detectServices"));
        panelBuilder.add((Component)jLabel11, cellConstraints.xy(3, 7));
        panelBuilder.add((Component)this._serviceCheck, cellConstraints.xy(5, 7));
        panelBuilder.add((Component)this._editServiceButton, cellConstraints.xywh(7, 7, 3, 1));
        panelBuilder.add((Component)this._ipCombo, cellConstraints.xywh(5, 3, 5, 1));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText(UpdateDeviceDialog.a("label_cleanDiscovery"));
        panelBuilder.add((Component)jLabel12, cellConstraints.xy(3, 9));
        panelBuilder.add((Component)this._cleanDiscoveryCheck, cellConstraints.xy(5, 9));
        panelBuilder.addSeparator(UpdateDeviceDialog.a("UpdateNodeDialog_snmpv3"), cellConstraints.xywh(3, 17, 8, 1));
        JPanel jPanel = panelBuilder.getPanel();
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29});
        return jPanel;
    }

    @Override
    protected JPanel getCenterPane() {
        return this.f();
    }

    @Override
    protected void doOK() {
        long l2 = Long.parseLong(this._bean.getCustomerID());
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        if (!this.g()) {
            return;
        }
        this._isOK = true;
        this.dispose();
    }

    private boolean g() {
        if (!this.h()) {
            return false;
        }
        return this.i();
    }

    private boolean h() {
        double d10;
        String string = this._timeoutField.getText();
        try {
            if (string.length() == 0) {
                JOptionPane.showMessageDialog(this, UpdateDeviceDialog.a("DiscoveryOptionsDialog_msg_timeoutRequired"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateDeviceDialog.a(exception);
        }
        try {
            d10 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, UpdateDeviceDialog.a("DiscoveryOptionsDialog_msg_timeoutRange"));
            return false;
        }
        try {
            if (d10 < 1.0) {
                JOptionPane.showMessageDialog(this, UpdateDeviceDialog.a("DiscoveryOptionsDialog_msg_timeoutRange"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateDeviceDialog.a(exception);
        }
        return true;
    }

    private boolean i() {
        String string = this._snmpPortField.getText();
        int n2 = 161;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, UpdateDeviceDialog.a("UpdateNodeDialog_msg_errorPort"));
            return false;
        }
        try {
            if (n2 < 1) {
                JOptionPane.showMessageDialog(this, UpdateDeviceDialog.a("UpdateNodeDialog_msg_errorPort"));
                return false;
            }
        }
        catch (Exception exception) {
            throw UpdateDeviceDialog.a(exception);
        }
        return true;
    }

    public boolean isOK() {
        return this._isOK;
    }

    public DeviceOption getOption() {
        String string = this._ipCombo.getSelectedItem().toString();
        int n2 = (int)Double.parseDouble(this._timeoutField.getText()) * 1000;
        boolean bl2 = this._serviceCheck.isSelected();
        DeviceOption deviceOption = new DeviceOption(this._bean.getID(), string, n2, this.j(), bl2, this._scanServices);
        deviceOption.setCleanDiscovery(this._cleanDiscoveryCheck.isSelected());
        return deviceOption;
    }

    private ReadCommunity j() {
        String string = this._ipCombo.getSelectedItem().toString();
        int n2 = Integer.parseInt(this._snmpPortField.getText());
        String string2 = new String(this._communityField.getPassword());
        int n3 = this._snmpVersionCombo.getSelectedVersion();
        V3Params v3Params = null;
        if (n3 == 3) {
            String string3 = this._userField.getText();
            String string4 = this._authAlgorithmCombo.getSelectedAlgorithm();
            String string5 = new String(this._authPasswordField.getPassword());
            int n4 = this._privacyAlgorithmCombo.getSelectedAlgorithm();
            String string6 = new String(this._privacyPasswordField.getPassword());
            v3Params = new V3Params(string3, string4, string5, n4, string6);
        }
        return new ReadCommunity(string, string2, n3, v3Params, n2);
    }

    public void setScanServices(List list) {
        this._scanServices = list;
    }

    private static String a(String string) {
        return NbBundle.getMessage(UpdateDeviceDialog.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

