/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.ireasoning.util.AgentProperties;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.util.CompactProperties;
import com.sysuptime.common.util.ComparablePair;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.graph.TablePanel;
import com.sysuptime.mainframe.util.JNDIClient;
import com.sysuptime.mainframe.util.RMIAdaptor;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.server.util.MBeanUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.ObjectName;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class NodeMonitorInfoDialog
extends JDialog {
    private static final Logger _logger = Logger.getLogger((String)NodeMonitorInfoDialog.class.getName());
    private static final ObjectName _objectName = MBeanUtil.create("nMaster:service=NodeMonitorInfo");
    private RMIAdaptor _adaptor;
    private String[] _hostes;
    private AgentProperties _agentProperties;
    private boolean _isSnmp;
    private ArrayList _propertyList;
    private ArrayList _interfaceList;

    public NodeMonitorInfoDialog(String[] stringArray, AgentProperties agentProperties, NetworkNodeBean networkNodeBean, boolean bl2) {
        super(Startup.getFrame(), true);
        this.setTitle(NodeMonitorInfoDialog.a("node_monitor_title"));
        this.a(stringArray, networkNodeBean);
        this._agentProperties = agentProperties;
        this._isSnmp = bl2;
        this.a(networkNodeBean);
        this.a();
    }

    private void a(String[] stringArray, NetworkNodeBean networkNodeBean) {
        block4: {
            block2: {
                int n2;
                String string;
                block3: {
                    string = networkNodeBean.getFirstIp();
                    n2 = NetworkGraph.d();
                    if (StringUtil.isIp(string)) break block2;
                    if (stringArray != null) break block3;
                    this._hostes = new String[]{string};
                    if (n2 == 0) break block4;
                }
                this._hostes = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, this._hostes, 0, stringArray.length);
                this._hostes[stringArray.length] = string;
                if (n2 == 0) break block4;
            }
            this._hostes = stringArray;
        }
    }

    private void a() {
        this.setBackground(Color.white);
        this.getContentPane().add((Component)this.e(), "South");
    }

    public void showOut() {
        this.setSize(800, 600);
        SwingUtil.centerOnScreen(this);
        this.setVisible(true);
    }

    private void b() {
        this.getContentPane().removeAll();
        this.a();
        this.validate();
    }

    private JComponent c() {
        return TablePanel.createDeviceInfoPane(this._propertyList, this._interfaceList, this.getSize().height);
    }

    private JComponent d() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        SwingUtilities.invokeLater(() -> {
            Serializable serializable;
            boolean bl2 = false;
            if (this._hostes != null && this._hostes.length > 0) {
                serializable = this.a(this._hostes);
                bl2 = TablePanel.getChartPanel((ArrayList)serializable, jPanel);
            }
            if (!bl2) {
                jPanel.setLayout(new BorderLayout());
                serializable = new JLabel(ICommonBundle.NO_AVAILABLE_DATA, 0);
                ((JComponent)serializable).setFont(((Component)serializable).getFont().deriveFont(1, 14.0f));
                jPanel.add((Component)serializable, "Center");
            }
        });
        return TablePanel.getMonitorPane(jPanel);
    }

    private JPanel e() {
        JButton jButton = new JButton(NodeMonitorInfoDialog.a("node_monitor_refresh"));
        jButton.addActionListener(actionEvent -> this.b());
        jButton.setPreferredSize(new Dimension(80, 25));
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jPanel.add(jButton2);
        jButton2.addActionListener(actionEvent -> this.dispose());
        jButton2.setPreferredSize(new Dimension(80, 25));
        return jPanel;
    }

    private void a(NetworkNodeBean networkNodeBean) {
        new Thread(() -> {
            this._propertyList = this.b(networkNodeBean);
            this._interfaceList = this.c(networkNodeBean);
            SwingUtilities.invokeLater(() -> {
                Container container = this.getContentPane();
                JSplitPane jSplitPane = new JSplitPane(0, this.c(), this.d());
                jSplitPane.setDividerLocation(170);
                jSplitPane.setOneTouchExpandable(true);
                container.add((Component)jSplitPane, "Center");
            });
        }).start();
    }

    private ArrayList b(NetworkNodeBean networkNodeBean) {
        ArrayList<CallSite> arrayList;
        CompactProperties compactProperties;
        ArrayList<CallSite> arrayList2 = null;
        int n2 = NetworkGraph.e();
        String string = networkNodeBean.getSysObjectIdValue();
        if (string != null && string != "") {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<CallSite>();
            }
            arrayList2.add((CallSite)((Object)("SysObjectIdValue<split>" + string)));
        }
        if ((compactProperties = networkNodeBean.getOtherProperties()) != null) {
            int n3 = compactProperties.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                arrayList = arrayList2;
                if (n2 != 0) {
                    if (arrayList == null) {
                        arrayList2 = new ArrayList();
                    }
                    ComparablePair comparablePair = (ComparablePair)compactProperties.getProperties().get(i2);
                    String string2 = comparablePair.name.toString();
                    String string3 = comparablePair.value.toString();
                    if (string3 == null) continue;
                    String string4 = string2.substring(0, 1);
                    string2 = string2.replaceFirst(string4, string4.toUpperCase());
                    arrayList2.add((CallSite)((Object)(string2 + "<split>" + string3)));
                    if (n2 != 0) continue;
                }
                break;
            }
        } else {
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private ArrayList c(NetworkNodeBean networkNodeBean) {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        int n2 = NetworkGraph.d();
        arrayList.add((CallSite)((Object)(NodeMonitorInfoDialog.a("LBL_ifindex") + "<split>" + NodeMonitorInfoDialog.a("LBL_ip") + "<split>" + NodeMonitorInfoDialog.a("LBL_mac"))));
        NetworkInterface[] networkInterfaceArray = networkNodeBean.getInterfaces();
        if (networkInterfaceArray != null) {
            for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
                EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
                Object object = " ";
                if (ethernetInterface.getIfIndex() != -1) {
                    object = (String)object + ethernetInterface.getIfIndex();
                }
                String string = ethernetInterface.getIpAddress() + " ";
                String string2 = ethernetInterface.getMacAddress() + " ";
                arrayList.add((CallSite)((Object)((String)object + "<split>" + string + "<split>" + string2)));
                if (n2 == 0) continue;
            }
        }
        return arrayList;
    }

    private ArrayList a(String[] stringArray) {
        this.f();
        ArrayList arrayList = null;
        if (this._adaptor != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.addAll(Arrays.asList(stringArray));
            Object[] objectArray = new Object[]{arrayList2, this._agentProperties, this._isSnmp};
            String[] stringArray2 = new String[]{ArrayList.class.getName(), AgentProperties.class.getName(), Boolean.class.getName()};
            try {
                arrayList = (ArrayList)this._adaptor.invoke(_objectName, "getMonitorInfo", objectArray, stringArray2);
            }
            catch (Exception exception) {
                _logger.error((Object)"getMonitorInfo", (Throwable)exception);
            }
        }
        return arrayList;
    }

    private void f() {
        if (this._adaptor == null) {
            try {
                this._adaptor = JNDIClient.getRMIAdaptor();
            }
            catch (Exception exception) {
                _logger.error((Object)exception, (Throwable)exception);
            }
        }
    }

    private static String a(String string) {
        return NbBundle.getMessage(NodeMonitorInfoDialog.class, (String)string);
    }
}

