/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.graph;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.InsertDeviceOption;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.graph.GraphConstants2;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.ClassMap;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.IconFactory;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.Subnet;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraph;
import com.sysuptime.mainframe.graph.VertexDialog$1;
import com.sysuptime.mainframe.graph.VertexDialog$2;
import com.sysuptime.mainframe.graph.VertexDialog$NameCharFilter;
import com.sysuptime.mainframe.msp.ProxyMBeanInvoker;
import com.sysuptime.mainframe.util.ConfirmDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import com.sysuptime.mainframe.util.validation.PositiveNumberTextField;
import com.sysuptime.mainframe.util.validation.RestrictedTextField;
import com.sysuptime.mainframe.util.validation.filter.VerifyInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jgraph.graph.AttributeMap;
import org.openide.util.NbBundle;

public class VertexDialog
extends ConfirmDialog {
    private static final Logger _logger = Logger.getLogger((String)VertexDialog.class.getName());
    private NetworkGraph _graph;
    private Point _point;
    private String _iconFileName;
    private String _type;
    private RestrictedTextField _deviceNameField;
    private JTextField _deviceIPField;
    private JCheckBox _detectOtherIfCheck;
    private PositiveNumberTextField _snmpPortField;
    private JPasswordField _communityField;
    private JComboBox _snmpVersionCombo;
    private RestrictedTextField _userField;
    private JComboBox _authAlgorithmCombo;
    private JPasswordField _authPwdField;
    private JComboBox _privacyAlgorithmCombo;
    private JPasswordField _privacyPwdField;

    public VertexDialog(NetworkGraph networkGraph, Point point, String string, String string2) {
        super(Startup.getFrame(), VertexDialog.c("vertexdialog_add_device"), true);
        this._graph = networkGraph;
        this._point = point;
        this._iconFileName = string;
        this._type = string2;
        this.d();
    }

    private void d() {
        this.f();
        SwingUtil.dialogBindingESC(this, null);
        this.pack();
        this._deviceIPField.requestFocus();
        this.showCenterOnOwner();
        this._deviceNameField.requestFocus();
    }

    private void e() {
        VertexDialog$NameCharFilter vertexDialog$NameCharFilter = new VertexDialog$NameCharFilter();
        this._deviceNameField = new RestrictedTextField(20, vertexDialog$NameCharFilter, null);
        this._deviceIPField = new JTextField();
        this._detectOtherIfCheck = new JCheckBox();
        this._snmpPortField = new PositiveNumberTextField(1L, 65535L, 161, null);
        this._communityField = new JPasswordField();
        this._snmpVersionCombo = new JComboBox();
        this._userField = new RestrictedTextField(0, vertexDialog$NameCharFilter, new VertexDialog$1(this));
        this._authAlgorithmCombo = new JComboBox();
        this._authPwdField = new JPasswordField();
        this._privacyAlgorithmCombo = new JComboBox();
        this._privacyPwdField = new JPasswordField();
    }

    private void a(boolean bl2) {
        this._detectOtherIfCheck.setEnabled(bl2);
        this._snmpPortField.setEnabled(bl2);
        this._communityField.setEnabled(bl2);
        this._snmpVersionCombo.setEnabled(bl2);
    }

    private void f() {
        this._detectOtherIfCheck.setSelected(true);
        this._communityField.setText("public");
        this._snmpVersionCombo.addItem("1");
        this._snmpVersionCombo.addItem("2");
        this._snmpVersionCombo.addItem("3");
        this._snmpVersionCombo.addItemListener(new VertexDialog$2(this));
        this._authAlgorithmCombo.addItem("HMAC-MD5");
        this._authAlgorithmCombo.addItem("HMAC-SHA-1");
        this._privacyAlgorithmCombo.addItem("DES");
        this._privacyAlgorithmCombo.addItem("AES");
        this.b(false);
        if ("subnet".equals(this._type) || "customer".equals(this._type)) {
            this.a(false);
        }
    }

    private void b(boolean bl2) {
        this._userField.setEnabled(bl2);
        this._authAlgorithmCombo.setEnabled(bl2);
        this._authPwdField.setEnabled(bl2);
        this._privacyAlgorithmCombo.setEnabled(bl2);
        this._privacyPwdField.setEnabled(bl2);
    }

    private JPanel g() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,RIGHT:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:150PX:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        JLabel jLabel = new JLabel();
        jLabel.setText(VertexDialog.c("vertexdialog_device_name"));
        panelBuilder.add((Component)jLabel, cellConstraints.xy(3, 5));
        panelBuilder.add((Component)this._deviceNameField, cellConstraints.xy(5, 5));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(VertexDialog.c("vertexdialog_device_ip"));
        panelBuilder.add((Component)jLabel2, cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this._deviceIPField, cellConstraints.xy(5, 3));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(VertexDialog.c("vertexdialog_port"));
        panelBuilder.add((Component)jLabel3, cellConstraints.xy(3, 9));
        panelBuilder.add((Component)this._snmpPortField, cellConstraints.xy(5, 9));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(VertexDialog.c("vertexdialog_read"));
        panelBuilder.add((Component)jLabel4, cellConstraints.xy(3, 11));
        panelBuilder.add((Component)this._communityField, cellConstraints.xy(5, 11));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(VertexDialog.c("vertexdialog_snmp_version"));
        panelBuilder.add((Component)jLabel5, cellConstraints.xy(3, 13));
        panelBuilder.add((Component)this._snmpVersionCombo, cellConstraints.xy(5, 13));
        panelBuilder.addSeparator(VertexDialog.c("vertexdialog_snmpv3"), cellConstraints.xywh(3, 15, 3, 1));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(VertexDialog.c("vertexdialog_usm_user"));
        panelBuilder.add((Component)jLabel6, cellConstraints.xy(3, 17));
        panelBuilder.add((Component)this._userField, cellConstraints.xy(5, 17));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(VertexDialog.c("vertexdialog_auth_agt"));
        panelBuilder.add((Component)jLabel7, cellConstraints.xy(3, 19));
        panelBuilder.add((Component)this._authAlgorithmCombo, cellConstraints.xy(5, 19));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText(VertexDialog.c("vertexdialog_auth_pwd"));
        panelBuilder.add((Component)jLabel8, cellConstraints.xy(3, 21));
        panelBuilder.add((Component)this._authPwdField, cellConstraints.xy(5, 21));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText(VertexDialog.c("vertexdialog_priv_agt"));
        panelBuilder.add((Component)jLabel9, cellConstraints.xy(3, 23));
        panelBuilder.add((Component)this._privacyAlgorithmCombo, cellConstraints.xy(5, 23));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText(VertexDialog.c("vertexdialog_priv_pwd"));
        panelBuilder.add((Component)jLabel10, cellConstraints.xy(3, 25));
        panelBuilder.add((Component)this._privacyPwdField, cellConstraints.xy(5, 25));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText(VertexDialog.c("VertexDialog_label_detectOther"));
        panelBuilder.add((Component)jLabel11, cellConstraints.xy(3, 7));
        panelBuilder.add((Component)this._detectOtherIfCheck, cellConstraints.xy(5, 7));
        FormUtils.addFillComponents(panelBuilder.getPanel(), new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27});
        return panelBuilder.getPanel();
    }

    @Override
    protected JPanel getCenterPane() {
        this.e();
        return this.g();
    }

    @Override
    protected void doOK() {
        block23: {
            block18: {
                int n2;
                block22: {
                    NetworkNode networkNode;
                    NetworkNodeBean networkNodeBean;
                    block21: {
                        GraphID graphID;
                        block19: {
                            block20: {
                                n2 = NetworkGraph.d();
                                if (!this.h()) {
                                    return;
                                }
                                String string = this._deviceNameField.getText();
                                String string2 = this._deviceIPField.getText();
                                if (string == null || string.length() < 1) {
                                    string = string2;
                                }
                                String string3 = null;
                                if (!StringUtil.isIp(string2) && (string3 = this.a(string2)) == null) {
                                    this.b(VertexDialog.c("vertexdialog_invalid_ip"));
                                    return;
                                }
                                networkNodeBean = null;
                                if (!"subnet".equals(this._type)) {
                                    networkNodeBean = this.a(string, string2, string3);
                                } else if ("subnet".equals(this._type)) {
                                    networkNodeBean = this.b(string, string2);
                                    ((Subnet)networkNodeBean).setIpAddress(string2);
                                }
                                if (networkNodeBean == null) break block18;
                                NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
                                graphID = networkGraph.getGraphID();
                                if (networkNodeBean.getCustomerID() != null) break block19;
                                if (!networkGraph.isMaster()) break block20;
                                networkNodeBean.setCustomerID(string2);
                                networkNodeBean.setDisplayName(string);
                                if (n2 == 0) break block19;
                            }
                            networkNodeBean.setCustomerID(graphID.getCustomerID());
                        }
                        networkNodeBean.addTopoGraph(graphID);
                        if (GraphLoader.getInstance().getBean(networkNodeBean.getID()) != null) break block21;
                        NetworkNode networkNode2 = this.a(networkNodeBean);
                        if (networkNode2 == null) {
                            return;
                        }
                        if (n2 == 0) break block22;
                    }
                    if (this.b(networkNodeBean)) {
                        JOptionPane.showMessageDialog(this, VertexDialog.c("vertexdialog_node_exist_this"));
                        this.dispose();
                        return;
                    }
                    int n3 = JOptionPane.showConfirmDialog(this, VertexDialog.c("vertexdialog_node_exist_other"), "", 0);
                    if (n3 == 0 && (networkNode = this.a(networkNodeBean = GraphLoader.getInstance().getBean(networkNodeBean.getID()))) == null) {
                        return;
                    }
                }
                if (n2 == 0) break block23;
            }
            JOptionPane.showMessageDialog(this, VertexDialog.c("vertesdialog_unreachable"));
            return;
        }
        this.dispose();
    }

    private NetworkNode a(NetworkNodeBean networkNodeBean) {
        NetworkGraph networkGraph = ConsoleComponent.getInstance().getCurrentGraph();
        GraphID graphID = networkGraph.getGraphID();
        if (networkGraph.isSubnet() && networkNodeBean.getIPInSubnet(graphID.getGraphName()) == null) {
            JOptionPane.showMessageDialog(this, VertexDialog.c("vertexdialog_msg_notInSubnet"));
            return null;
        }
        networkNodeBean.addTopoGraph(graphID);
        NetworkNode networkNode = new NetworkNode(networkNodeBean);
        networkNodeBean.setReadCommunity(this.i());
        AttributeMap attributeMap = networkNode.getAttributes();
        ImageIcon imageIcon = IconFactory.getIcon(this._type, this._iconFileName);
        GraphConstants2.setIcon((Map)attributeMap, (Icon)imageIcon);
        networkNode.setCurrentDefaultIcon(imageIcon);
        Rectangle2D rectangle2D = GraphConstants2.getBounds((Map)attributeMap);
        rectangle2D = attributeMap.createRect(this._point.getX(), this._point.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        GraphConstants2.setBounds((Map)attributeMap, (Rectangle2D)rectangle2D);
        networkNodeBean.setManuallyAdded(true);
        networkNode.setAttributes(attributeMap);
        this._graph.getGraphLayoutCache().insert((Object)networkNode);
        return networkNode;
    }

    private boolean b(NetworkNodeBean networkNodeBean) {
        NetworkGraphModel networkGraphModel = (NetworkGraphModel)this._graph.getModel();
        return networkGraphModel.getNodeByBean(networkNodeBean = GraphLoader.getInstance().getBean(networkNodeBean.getID())) != null;
    }

    private void a(JTextField jTextField) {
        jTextField.setText("");
        jTextField.requestFocus();
    }

    private String a(String string) {
        try {
            GraphID graphID = this._graph.getGraphID();
            long l2 = Long.parseLong(graphID.getCustomerID());
            return ProxyMBeanInvoker.INSTANCE.getCreateNodeIpByName(l2, string);
        }
        catch (Exception exception) {
            _logger.error((Object)"get node ip by name", (Throwable)exception);
            return null;
        }
    }

    private boolean h() {
        String string = this._deviceIPField.getText();
        if (string == null || string.trim().length() < 1) {
            this.b(VertexDialog.c("vertexdialog_invalid_ip"));
            this.a(this._deviceIPField);
            return false;
        }
        if ("subnet".equals(this._type) && !string.endsWith(".0")) {
            this.b(VertexDialog.c("vertexdialog_invalid_subnet_ip"));
            this.a(this._deviceIPField);
            return false;
        }
        VerifyInfo verifyInfo = this._snmpPortField.getVerifyInfo();
        if (verifyInfo != null && verifyInfo.getInfoCode() == 2) {
            this.b(verifyInfo.getInfo());
            this.a(this._snmpPortField);
            return false;
        }
        if (this._snmpVersionCombo.getSelectedItem().equals("3")) {
            verifyInfo = null;
            verifyInfo = this._userField.getVerifyInfo();
            if (verifyInfo != null && verifyInfo.getInfoCode() == 2) {
                this.b(verifyInfo.getInfo());
                this.a(this._userField);
                return false;
            }
        }
        return true;
    }

    private void b(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private InsertDeviceOption a(String string, String string2) {
        InsertDeviceOption insertDeviceOption = new InsertDeviceOption();
        insertDeviceOption.setIp(string2);
        insertDeviceOption.setName(string);
        insertDeviceOption.setReadCommunity(this.i());
        insertDeviceOption.setDeviceType(this._type);
        insertDeviceOption.setDetectOtherInterfaces(this._detectOtherIfCheck.isSelected());
        return insertDeviceOption;
    }

    private NetworkNodeBean a(String string, String string2, String string3) {
        block7: {
            int n2 = NetworkGraph.d();
            try {
                boolean bl2;
                GraphID graphID = this._graph.getGraphID();
                long l2 = Long.parseLong(graphID.getCustomerID());
                String string4 = string2;
                if (!StringUtil.isIp(string2)) {
                    string4 = string3;
                }
                if (bl2 = ProxyMBeanInvoker.INSTANCE.isNodeReachable(l2, string4)) {
                    return ProxyMBeanInvoker.INSTANCE.createNode(l2, this.a(string, string4));
                }
                if (StringUtil.isIp(string2)) {
                    int n3 = JOptionPane.showConfirmDialog(this, VertexDialog.c("vertexdialog_create_default_node"), ICommonBundle.CONFIRM, 0);
                    if (n3 == 0) {
                        return this.b(string, string2);
                    }
                    if (n2 == 0) break block7;
                }
                return ProxyMBeanInvoker.INSTANCE.createNode(l2, this.a(string, string2));
            }
            catch (Exception exception) {
                _logger.error((Object)"createNode", (Throwable)exception);
            }
        }
        return null;
    }

    private ReadCommunity i() {
        int n2 = Integer.parseInt(this._snmpPortField.getText());
        String string = new String(this._communityField.getPassword());
        String string2 = (String)this._snmpVersionCombo.getSelectedItem();
        int n3 = ReadCommunity.getVersion(string2);
        V3Params v3Params = null;
        if ("3".equals(string2)) {
            String string3 = this._userField.getText();
            String string4 = (String)this._authAlgorithmCombo.getSelectedItem();
            String string5 = new String(this._authPwdField.getPassword());
            String string6 = (String)this._privacyAlgorithmCombo.getSelectedItem();
            int n4 = V3Params.getPrivProtocol(string6);
            String string7 = new String(this._privacyPwdField.getPassword());
            v3Params = new V3Params(string3, string4, string5, n4, string7);
        }
        return new ReadCommunity(null, string, n3, v3Params, n2);
    }

    private NetworkNodeBean b(String string, String string2) {
        try {
            try {
                if (this._type == null) {
                    this._type = "Generic";
                }
            }
            catch (Exception exception) {
                throw VertexDialog.a(exception);
            }
            NetworkNodeBean networkNodeBean = (NetworkNodeBean)ClassMap.getClass(StringUtil.capitalizeFirstChar(this._type)).newInstance();
            networkNodeBean.setDisplayName(string);
            EthernetInterface ethernetInterface = new EthernetInterface(networkNodeBean, string2);
            networkNodeBean.setInterfaces(new NetworkInterface[]{ethernetInterface});
            return networkNodeBean;
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private static String c(String string) {
        return NbBundle.getMessage(VertexDialog.class, (String)string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

