/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.nodes.editors;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.nodes.editors.SnmpCustomEditor;
import com.sysuptime.mainframe.util.ConfirmDialog;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class NetInterfaceChangeDialog
extends ConfirmDialog {
    private JTextField _ipField;
    private JTextField _macField;
    private JFormattedTextField _indexField;
    private JFormattedTextField _bandwidthField;
    private boolean _isOK;
    private EthernetInterface _newInterface;

    public NetInterfaceChangeDialog(String string, Dialog dialog, EthernetInterface ethernetInterface, boolean bl2) {
        super(dialog, string, true);
        this._newInterface = ethernetInterface;
        this.a(ethernetInterface);
        if (bl2) {
            this._ipField.setEnabled(false);
            this._macField.setEnabled(false);
            this._indexField.setEnabled(false);
        }
        SwingUtil.dialogBindingESC(this, null);
    }

    public boolean isOK() {
        return this._isOK;
    }

    private void a(EthernetInterface ethernetInterface) {
        block5: {
            block4: {
                boolean bl2 = SnmpCustomEditor.h();
                if (ethernetInterface == null) break block4;
                this._ipField.setText(ethernetInterface.getIpAddress());
                this._macField.setText(ethernetInterface.getMacAddress());
                this._indexField.setValue(new Integer(ethernetInterface.getIfIndex()));
                long l2 = ethernetInterface.getIfSpeed();
                if (l2 > 0L) {
                    this._bandwidthField.setValue(l2);
                }
                if (!bl2) break block5;
            }
            this._indexField.setValue(-1L);
        }
    }

    private void d() {
        this._ipField = new JTextField();
        this._macField = new JTextField();
        this._indexField = new JFormattedTextField(NumberFormat.getIntegerInstance(Locale.US));
        this._bandwidthField = new JFormattedTextField(NumberFormat.getIntegerInstance(Locale.US));
    }

    private JPanel e() {
        this.d();
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:100PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(NetInterfaceChangeDialog.a("interfacemodicustomeditor_ip"));
        jPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        JLabel jLabel2 = new JLabel(NetInterfaceChangeDialog.a("interfacemodicustomeditor_mac"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        JLabel jLabel3 = new JLabel(NetInterfaceChangeDialog.a("interfacemodicustomeditor_index"));
        jPanel.add((Component)jLabel3, cellConstraints.xy(2, 6));
        jPanel.add((Component)new JLabel(NetInterfaceChangeDialog.a("interfacemodicustomeditor_bandwidth")), cellConstraints.xy(2, 8));
        jPanel.add((Component)new JLabel("Mbps"), cellConstraints.xy(8, 8));
        jPanel.add((Component)this._ipField, cellConstraints.xywh(3, 2, 5, 1));
        jPanel.add((Component)this._macField, cellConstraints.xywh(3, 4, 5, 1));
        jPanel.add((Component)this._indexField, cellConstraints.xywh(3, 6, 5, 1));
        jPanel.add((Component)this._bandwidthField, cellConstraints.xywh(3, 8, 5, 1));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        return jPanel;
    }

    @Override
    protected JPanel getCenterPane() {
        return this.e();
    }

    @Override
    protected void doOK() {
        String string = this._ipField.getText();
        String string2 = this._macField.getText();
        int n2 = ((Number)this._indexField.getValue()).intValue();
        if (string == null || string.length() < 1) {
            JOptionPane.showMessageDialog(this, NetInterfaceChangeDialog.a("interfaceEditor_msg_ipRequired"));
            return;
        }
        if (!StringUtil.isIp(string)) {
            JOptionPane.showMessageDialog(this, NetInterfaceChangeDialog.a("interfaceEditor_msg_invalidIP"));
            return;
        }
        if (this._newInterface == null) {
            this._newInterface = new EthernetInterface();
        }
        this._newInterface.setIpAddress(string);
        if (string2 != null && string2.trim().length() > 0) {
            this._newInterface.setMacAddress(string2);
        }
        this._newInterface.setIfIndex(n2);
        String string3 = this._bandwidthField.getValue() == null ? "0" : this._bandwidthField.getValue();
        long l2 = Long.parseLong(string3.toString());
        this._newInterface.setIfSpeed(l2);
        this._isOK = true;
        this.dispose();
    }

    public EthernetInterface getInterface() {
        return this._newInterface;
    }

    private static String a(String string) {
        return NbBundle.getMessage(NetInterfaceChangeDialog.class, (String)string);
    }
}

