/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.FlagedRemoteHost;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.RemoteHostKey;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.util.FormUtils;
import com.sysuptime.server.util.ServerBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseMonitorFirstDialog
extends JDialog {
    private final String MONITOR_NAME_LABEL = ConciseMonitorFirstDialog.fromBundle("Label_monitor_name");
    private final String TIME_OUT_LABEL = ConciseMonitorFirstDialog.fromBundle("timeout");
    private final String DEFAULT_TIME_OUT = "30";
    private static final Logger _logger = Logger.getLogger((String)ConciseMonitorFirstDialog.class.getName());
    private JPanel _mainPanel;
    private JPanel _advPanel;
    protected JTextField _monitorNameField;
    protected JTextField _timeoutField;
    protected JTextField _hostNameField;
    private JTextField _userNameField;
    private JPasswordField _passwordField;
    private JPasswordField _confirmPasswordField;
    private JTextField _commonField;
    private DefaultComboBoxModel _comboBoxModel;
    private Map _key2Host;
    protected JComboBox _remoteHostComboBox;
    private boolean _isDomain;
    private boolean _isPort;
    private String _commonLabel;
    private int _protocolId;
    protected DefaultTableModel _tableModel;

    public ConciseMonitorFirstDialog(Frame frame, String string, DefaultTableModel defaultTableModel) {
        this(frame, string);
        this._tableModel = defaultTableModel;
    }

    public ConciseMonitorFirstDialog(Frame frame, String string) {
        super(frame, string, true);
        this.initComponent();
        this.initData();
        this.pack();
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.initRemoteHostPane(), "Center");
        container.add((Component)this.getConfirmPane(), "South");
    }

    private JPanel getConfirmPane() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(ICommonBundle.NEXT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConciseMonitorFirstDialog.this.check()) {
                    ConciseMonitorFirstDialog.this.doNext();
                }
            }
        });
        JButton jButton2 = new JButton(ICommonBundle.CANCEL);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConciseMonitorFirstDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    protected abstract JPanel initRemoteHostPane();

    protected JPanel initRemoteHostPane(String string) {
        this._mainPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        this._mainPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(this.MONITOR_NAME_LABEL);
        this._mainPanel.add((Component)jLabel, cellConstraints.xy(2, 2));
        this._monitorNameField = new JTextField();
        this._mainPanel.add((Component)this._monitorNameField, cellConstraints.xy(4, 2));
        JLabel jLabel2 = new JLabel(this.TIME_OUT_LABEL);
        this._mainPanel.add((Component)jLabel2, cellConstraints.xy(2, 4));
        this._timeoutField = new JTextField();
        this._timeoutField.setText("30");
        this._mainPanel.add((Component)this._timeoutField, cellConstraints.xy(4, 4));
        JLabel jLabel3 = new JLabel(ConciseMonitorFirstDialog.fromBundle("Label_second_unit"));
        this._mainPanel.add((Component)jLabel3, cellConstraints.xy(6, 4));
        JLabel jLabel4 = new JLabel(ConciseMonitorFirstDialog.fromBundle("remote_host"));
        this._mainPanel.add((Component)jLabel4, cellConstraints.xy(2, 6));
        this._remoteHostComboBox = new JComboBox();
        this._mainPanel.add((Component)this._remoteHostComboBox, cellConstraints.xy(4, 6));
        this._advPanel = this.initAdvPane();
        FormUtils.addFillComponents(this._mainPanel, new int[]{1, 2, 3, 4, 5, 6, 7}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return this._mainPanel;
    }

    protected abstract JPanel initAdvPane();

    protected JPanel initAdvPane(String string) {
        this._commonLabel = string;
        this._isDomain = Pattern.compile("domain").matcher(string.toLowerCase()).find();
        this._isPort = Pattern.compile("port").matcher(string.toLowerCase()).find();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:134PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        JLabel jLabel = new JLabel(DialogConstants.LABEL_HOST);
        this._hostNameField = new JTextField();
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 2));
        jPanel.add((Component)this._hostNameField, cellConstraints.xy(3, 2));
        JLabel jLabel2 = new JLabel(DialogConstants.LABEL_USER_NAME);
        this._userNameField = new JTextField();
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 4));
        jPanel.add((Component)this._userNameField, cellConstraints.xy(3, 4));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 4));
        JLabel jLabel3 = new JLabel(DialogConstants.LABEL_PASSWORD);
        this._passwordField = new JPasswordField();
        jPanel.add((Component)jLabel3, cellConstraints.xy(1, 6));
        jPanel.add((Component)this._passwordField, cellConstraints.xy(3, 6));
        jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 6));
        JLabel jLabel4 = new JLabel(DialogConstants.LABEL_CONFIRM_PASSWORD);
        this._confirmPasswordField = new JPasswordField();
        jPanel.add((Component)jLabel4, cellConstraints.xy(1, 8));
        jPanel.add((Component)this._confirmPasswordField, cellConstraints.xy(3, 8));
        JLabel jLabel5 = new JLabel(string);
        this._commonField = new JTextField();
        jPanel.add((Component)jLabel5, cellConstraints.xy(1, 10));
        jPanel.add((Component)this._commonField, cellConstraints.xy(3, 10));
        if (this._isDomain) {
            jPanel.add((Component)new JLabel(DialogConstants.LABEL_ISOPTIONAL), cellConstraints.xy(5, 10));
        }
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11});
        return jPanel;
    }

    protected abstract void initData();

    protected void initData(int n2) {
        this._protocolId = n2;
        this._key2Host = new HashMap();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list = new ArrayList();
        try {
            list = ClientProxy.getInstance().getRemoteHosts(n2);
        }
        catch (Exception exception) {
            _logger.error((Object)"get remote hosts Error:", (Throwable)exception);
        }
        arrayList.add("Select one");
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            RemoteHost remoteHost = (RemoteHost)list.get(i2);
            RemoteHostKey remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
            this._key2Host.put(remoteHostKey, remoteHost);
            arrayList.add(remoteHostKey);
        }
        arrayList.add(ConciseMonitorFirstDialog.fromBundle("label_newremotehost"));
        this._comboBoxModel = new DefaultComboBoxModel<Object>(arrayList.toArray());
        this._remoteHostComboBox.setModel(this._comboBoxModel);
        this._remoteHostComboBox.setRenderer(new RemoteHostRenderer());
        this._remoteHostComboBox.addItemListener(new HostItem());
    }

    protected boolean check() {
        Object object;
        Object object2 = SingletonValidator.checkAllDialog(this, this.MONITOR_NAME_LABEL, this._monitorNameField.getText(), NonNullValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        Object object3 = SingletonValidator.checkAllDialog(this, this.TIME_OUT_LABEL, this._timeoutField.getText(), NumberValidator.CLASS);
        if (object3 == null) {
            return false;
        }
        if (this._remoteHostComboBox.getSelectedIndex() <= 0) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("message_selectremotehost"));
            return false;
        }
        Object object4 = SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_HOST, this._hostNameField.getText(), NonNullValidator.CLASS);
        if (object4 == null) {
            return false;
        }
        if (this._isPort && (object = SingletonValidator.checkAllDialog(this, this._commonLabel, this._commonField.getText(), NumberValidator.CLASS)) == null) {
            return false;
        }
        object = this._userNameField.getText().trim();
        String string = String.valueOf(this._passwordField.getPassword());
        String string2 = String.valueOf(this._confirmPasswordField.getPassword());
        if (((String)object).length() == 0 && string.length() != 0) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("message_inputusername"));
            return false;
        }
        if (((String)object).length() != 0 && string.length() == 0) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("message_needpassword"));
            return false;
        }
        if (((String)object).length() != 0 && string.length() != 0 && !string.equals(string2)) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("message_invalidpassword"));
            return false;
        }
        return true;
    }

    protected static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseMonitorFirstDialog.class, (String)string);
    }

    protected abstract void doNext();

    protected RemoteHost modifyRemoteHost() {
        RemoteHostKey remoteHostKey = (RemoteHostKey)this._remoteHostComboBox.getSelectedItem();
        RemoteHost remoteHost = (RemoteHost)this._key2Host.get(remoteHostKey);
        this.setRemoteHostParameter(remoteHost);
        try {
            if (!ClientProxy.getInstance().modifyRemoteHost(remoteHost)) {
                this.initData();
                remoteHostKey = new RemoteHostKey(remoteHost.getHostName(), remoteHost.getProtocol(), remoteHost.getUser());
                this._remoteHostComboBox.setSelectedItem(remoteHostKey);
                JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
                return null;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"modify remote host Error:", (Throwable)exception);
        }
        return remoteHost;
    }

    public boolean checkResult(ResultValue resultValue) {
        if (resultValue == null) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("MSG_connect_error"));
            return false;
        }
        if (!resultValue.isNormal()) {
            String string = String.valueOf(resultValue.getValue());
            String string2 = ServerBundle.getMessage(string);
            JOptionPane.showMessageDialog(this, string2);
            return false;
        }
        return true;
    }

    protected RemoteHost createNewRemoteHost() {
        FlagedRemoteHost flagedRemoteHost = TargetFactory.getFlagedRemoteHost();
        this.setRemoteHostParameter(flagedRemoteHost);
        RemoteHostKey remoteHostKey = new RemoteHostKey(flagedRemoteHost.getHostName(), flagedRemoteHost.getProtocol(), flagedRemoteHost.getUser());
        if (this._key2Host.keySet().contains(remoteHostKey)) {
            JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("MSG_ADD_REMOTE_HOST_FAILED"));
            return null;
        }
        if (this.putRemoteHost(flagedRemoteHost)) {
            this.initData();
            this._comboBoxModel.setSelectedItem(remoteHostKey);
            return flagedRemoteHost;
        }
        JOptionPane.showMessageDialog(this, ConciseMonitorFirstDialog.fromBundle("MSG_save_remote_host_error"));
        return null;
    }

    private void setRemoteHostParameter(RemoteHost remoteHost) {
        String string = this.getRemoteHostName();
        remoteHost.setHostName(string);
        remoteHost.setProtocol(this._protocolId);
        remoteHost.setUser(this._userNameField.getText().trim());
        List list = this.getParameterName();
        List list2 = this.getParameter();
        int n2 = list.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            remoteHost.put(list.get(i2), list2.get(i2));
        }
    }

    private String getRemoteHostName() {
        String string = this._hostNameField.getText().trim();
        String string2 = StringUtil.checkIpAddress(this._hostNameField.getText().trim());
        if (string2 != null) {
            string = string2;
        }
        return string;
    }

    private List getParameterName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DialogConstants.LABEL_HOST);
        arrayList.add("user_name");
        arrayList.add("password");
        arrayList.add("confirm_password");
        if (this._isPort) {
            arrayList.add("port_number");
        } else if (this._isDomain) {
            arrayList.add("domain_name");
        }
        return arrayList;
    }

    private List getParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, this._hostNameField.getText().trim());
        arrayList.add(1, this._userNameField.getText().trim());
        arrayList.add(2, String.valueOf(this._passwordField.getPassword()));
        arrayList.add(3, String.valueOf(this._confirmPasswordField.getPassword()));
        arrayList.add(4, this._commonField.getText().trim());
        return arrayList;
    }

    private boolean putRemoteHost(FlagedRemoteHost flagedRemoteHost) {
        long l2 = -1L;
        try {
            l2 = ClientProxy.getInstance().storeRemoteHost(flagedRemoteHost);
            flagedRemoteHost.setHostId(l2);
        }
        catch (Exception exception) {
            _logger.error((Object)"sotre remote host Error:", (Throwable)exception);
        }
        return l2 != -1L;
    }

    public int getTimeout() {
        return Integer.parseInt(this._timeoutField.getText().trim()) * 1000;
    }

    public String getMonitorName() {
        return this._monitorNameField.getText().trim();
    }

    protected class RemoteHostRenderer
    extends JLabel
    implements ListCellRenderer {
        public RemoteHostRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            if (object instanceof RemoteHostKey) {
                RemoteHostKey remoteHostKey = (RemoteHostKey)object;
                String string = remoteHostKey.getHost() + " ( " + remoteHostKey.getUser() + " )";
                this.setText(string);
                this.setToolTipText(string);
            } else if (object != null) {
                this.setText(object.toString());
                this.setToolTipText(object.toString());
            }
            if (bl2) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            return this;
        }
    }

    private class HostItem
    implements ItemListener {
        private HostItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                final int n2 = ConciseMonitorFirstDialog.this._remoteHostComboBox.getSelectedIndex();
                ConciseMonitorFirstDialog.this._remoteHostComboBox.setSelectedIndex(n2);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Object object;
                        if (n2 == 0) {
                            ConciseMonitorFirstDialog.this._mainPanel.remove(ConciseMonitorFirstDialog.this._advPanel);
                        } else {
                            object = new CellConstraints();
                            ConciseMonitorFirstDialog.this._mainPanel.add((Component)ConciseMonitorFirstDialog.this._advPanel, object.xywh(2, 8, 5, 1));
                        }
                        ConciseMonitorFirstDialog.this._mainPanel.updateUI();
                        ConciseMonitorFirstDialog.this.pack();
                        if (n2 == ConciseMonitorFirstDialog.this._remoteHostComboBox.getItemCount() - 1) {
                            object = ConciseMonitorFirstDialog.fromBundle("tip_localhost_empty_user");
                            ConciseMonitorFirstDialog.this._hostNameField.setText("");
                            ConciseMonitorFirstDialog.this._hostNameField.setToolTipText((String)object);
                            ConciseMonitorFirstDialog.this._userNameField.setToolTipText((String)object);
                            ConciseMonitorFirstDialog.this._userNameField.setText("");
                            ConciseMonitorFirstDialog.this._passwordField.setText("");
                            ConciseMonitorFirstDialog.this._passwordField.setToolTipText((String)object);
                            ConciseMonitorFirstDialog.this._confirmPasswordField.setText("");
                            ConciseMonitorFirstDialog.this._confirmPasswordField.setToolTipText((String)object);
                            ConciseMonitorFirstDialog.this._commonField.setText("");
                        } else if (n2 != 0) {
                            object = (RemoteHostKey)ConciseMonitorFirstDialog.this._remoteHostComboBox.getSelectedItem();
                            RemoteHost remoteHost = (RemoteHost)ConciseMonitorFirstDialog.this._key2Host.get(object);
                            ConciseMonitorFirstDialog.this._hostNameField.setText(remoteHost.getHostName());
                            String string = remoteHost.getUser();
                            if (string != null && string.trim().length() != 0) {
                                ConciseMonitorFirstDialog.this._userNameField.setText(string);
                            } else {
                                ConciseMonitorFirstDialog.this._userNameField.setText("");
                            }
                            String string2 = (String)remoteHost.getValue("password");
                            if (string2 != null && string2.trim().length() != 0) {
                                ConciseMonitorFirstDialog.this._passwordField.setText(string2);
                                ConciseMonitorFirstDialog.this._confirmPasswordField.setText(string2);
                            } else {
                                ConciseMonitorFirstDialog.this._passwordField.setText("");
                                ConciseMonitorFirstDialog.this._confirmPasswordField.setText("");
                            }
                            String string3 = null;
                            if (ConciseMonitorFirstDialog.this._isDomain) {
                                string3 = (String)remoteHost.getValue("domain_name");
                            } else if (ConciseMonitorFirstDialog.this._isPort) {
                                string3 = (String)remoteHost.getValue("port_number");
                            }
                            if (string3 != null && string2.trim().length() != 0) {
                                ConciseMonitorFirstDialog.this._commonField.setText(string3);
                            } else {
                                ConciseMonitorFirstDialog.this._commonField.setText("");
                            }
                        }
                    }
                });
            }
        }
    }
}

