/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.FormUtil;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.trapreceiver.AlarmActions;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.MonitorCheckBox;
import com.sysuptime.mainframe.performance.MonitorCheckBoxListener;
import com.sysuptime.mainframe.performance.SelectedActionListener;
import com.sysuptime.mainframe.trapreceiver.AlarmActionsDialog;
import com.sysuptime.mainframe.util.FormUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class DevicesMonitorPane
extends JPanel {
    protected static final String LABEL_ARM_BREAKS_1 = DevicesMonitorPane.fromBundle("label_armpermittedbreaks1");
    protected static final String LABEL_FIXED_THRESHOLD = DevicesMonitorPane.fromBundle("Label_fixed_threshold");
    private static final String DEFALUT_ALARM_BREAK = "1";
    private static final String CONFIG_ACTION = DevicesMonitorPane.fromBundle("Lable_configure_action");
    private JTextField _alarmBreakField;
    private JTextField _thresholdResultField = new JTextField();
    private JLabel _resultUnitLabel;
    private JComboBox _thresholdConditionBox;
    private AlarmActions _action;
    protected boolean _showUnit = true;
    protected boolean _useCheckboxInMainPane = true;

    protected JScrollPane getScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        return jScrollPane;
    }

    protected void createComponent(Map map) {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE", "FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        this.setLayout((LayoutManager)formLayout);
        this.add((Component)this.getMainPane(map), cellConstraints.xywh(2, 2, 1, 1));
        this.add((Component)this.initThresholdPane(), cellConstraints.xy(2, 4));
        this.add((Component)this.initActionPane(), cellConstraints.xy(2, 6));
        FormUtils.addFillComponents(this, new int[]{1, 2, 3}, new int[]{1, 2, 3, 4, 5, 6, 7});
    }

    protected JPanel initDevicesPane(Map map) {
        if (this._useCheckboxInMainPane) {
            ArrayList arrayList = new ArrayList(map.keySet());
            int n2 = arrayList.size();
            CommonUtil.sortIgnoreCase(arrayList);
            FormLayout formLayout = this.getFormLayout(n2);
            JPanel jPanel = new JPanel((LayoutManager)formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Integer n4 = (Integer)arrayList.get(i2);
                String string = (String)map.get(n4);
                MonitorCheckBox monitorCheckBox = new MonitorCheckBox(n4, string);
                monitorCheckBox.setSelected(true);
                jPanel.add((Component)monitorCheckBox, cellConstraints.xywh(1, ++n3, 3, 1));
            }
            this.fillComponents(jPanel, n2);
            return jPanel;
        }
        int n5 = map.size();
        FormLayout formLayout = this.getFormLayout(n5);
        CellConstraints cellConstraints = new CellConstraints();
        ArrayList arrayList = new ArrayList(map.keySet());
        CommonUtil.sortIgnoreCase(arrayList);
        int n6 = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        for (int i3 = 0; i3 < n5; ++i3) {
            String string = (String)arrayList.get(i3);
            JRadioButton jRadioButton = new JRadioButton(string);
            jRadioButton.addActionListener(this.getRadioActionListener());
            buttonGroup.add(jRadioButton);
            jPanel.add((Component)jRadioButton, cellConstraints.xywh(1, ++n6, 3, 1));
        }
        this.fillComponents(jPanel, n5);
        return jPanel;
    }

    protected ActionListener getRadioActionListener() {
        return new SelectedActionListener(this);
    }

    protected JComponent getMainPane(Map map) {
        if (this._useCheckboxInMainPane) {
            final JScrollPane jScrollPane = this.getScrollPane(this.initDevicesPane(map));
            FormLayout formLayout = new FormLayout("FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0)");
            CellConstraints cellConstraints = new CellConstraints();
            JPanel jPanel = new JPanel((LayoutManager)formLayout);
            jPanel.setBorder(new TitledBorder(this.getTitleBorderText()));
            jPanel.add((Component)jScrollPane, cellConstraints.xywh(1, 1, 1, 5));
            JButton jButton = new JButton(DevicesMonitorPane.fromBundle("Label_select_all"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DevicesMonitorPane.this.setAllMonitorCheckBoxSelected(jScrollPane, true);
                }
            });
            JButton jButton2 = new JButton(DevicesMonitorPane.fromBundle("Label_clear_all"));
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DevicesMonitorPane.this.setAllMonitorCheckBoxSelected(jScrollPane, false);
                }
            });
            jPanel.add((Component)jButton, cellConstraints.xy(3, 1));
            jPanel.add((Component)jButton2, cellConstraints.xy(3, 3));
            FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3}, new int[]{1, 2, 3, 4, 5});
            return jPanel;
        }
        JScrollPane jScrollPane = this.getScrollPane(this.initDevicesPane(map));
        jScrollPane.setBorder(new TitledBorder(this.getTitleBorderText()));
        return jScrollPane;
    }

    protected JPanel initActionPane() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE", "FILL:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        JButton jButton = new JButton(CONFIG_ACTION);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = "";
                    if (DevicesMonitorPane.this._action != null) {
                        string = DevicesMonitorPane.this._action.toXML();
                    }
                    AlarmActions alarmActions = AlarmActions.fromXML(string, MonitorBroker.getID2TimebucketMap());
                    AlarmActionsDialog alarmActionsDialog = new AlarmActionsDialog(Startup.getFrame(), DevicesMonitorPane.fromBundle("title_alarm_actions"), true, alarmActions, false, ClientProxy.getInstance().getProbe().getId());
                    alarmActionsDialog.pack();
                    alarmActionsDialog.showCenterOnOwner();
                    if (alarmActionsDialog.isOK()) {
                        DevicesMonitorPane.this._action = alarmActionsDialog.getAlarmActions();
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(DevicesMonitorPane.class).error((Object)exception.getMessage(), (Throwable)exception);
                    JOptionPane.showMessageDialog(DevicesMonitorPane.this, exception.getMessage());
                }
            }
        });
        jPanel.add((Component)jButton, cellConstraints.xy(2, 1));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2}, new int[]{1});
        return jPanel;
    }

    protected String getAction() {
        return this._action != null ? this._action.toXML() : null;
    }

    protected abstract String getTitleBorderText();

    protected FormLayout getFormLayout(int n2) {
        String string = "FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE";
        String string2 = "CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(string2).append(",");
        }
        stringBuffer.append(string2);
        if (stringBuffer.toString().endsWith(",")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return new FormLayout(string, stringBuffer.toString());
    }

    protected JPanel initThresholdPane() {
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:108PX:NONE,FILL:11PX:NONE,FILL:100PX:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        JPanel jPanel = new JPanel((LayoutManager)formLayout);
        jPanel.setBorder(new TitledBorder(DevicesMonitorPane.fromBundle("Title_border")));
        JLabel jLabel = new JLabel(LABEL_FIXED_THRESHOLD);
        jPanel.add((Component)jLabel, cellConstraints.xy(1, 1));
        JLabel jLabel2 = new JLabel(DevicesMonitorPane.fromBundle("Label_general_alarm_condition"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(2, 1));
        this._thresholdConditionBox = new JComboBox<String>(DialogConstants.COMBOBOX_FIXED_CONDITION);
        this._thresholdConditionBox.addItemListener(new ChangeItemListener());
        jPanel.add((Component)this._thresholdConditionBox, cellConstraints.xy(4, 1));
        jPanel.add((Component)this._thresholdResultField, cellConstraints.xy(6, 1));
        if (this._showUnit) {
            this._resultUnitLabel = new JLabel("%");
            jPanel.add((Component)this._resultUnitLabel, cellConstraints.xy(8, 1));
        }
        jLabel2 = new JLabel(LABEL_ARM_BREAKS_1 + " ");
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 3));
        this._alarmBreakField = new JTextField();
        this._alarmBreakField.setText(DEFALUT_ALARM_BREAK);
        jPanel.add((Component)this._alarmBreakField, cellConstraints.xy(2, 3));
        jLabel2 = new JLabel(DevicesMonitorPane.fromBundle("label_armpermittedbreaks2") + ".");
        jPanel.add((Component)jLabel2, cellConstraints.xyw(4, 3, 3));
        FormUtils.addFillComponents(jPanel, new int[]{3, 5, 7, 8}, new int[]{2});
        return jPanel;
    }

    protected void fillComponents(JPanel jPanel, int n2) {
        int n3;
        int[] nArray = new int[3];
        int[] nArray2 = new int[n2];
        for (n3 = 1; n3 <= nArray.length; ++n3) {
            nArray[n3 - 1] = n3;
        }
        for (n3 = 1; n3 <= nArray2.length; ++n3) {
            nArray2[n3 - 1] = n3;
        }
        FormUtil.addFillComponents(jPanel, nArray, nArray2);
    }

    private void setAllMonitorCheckBoxSelected(JComponent jComponent, boolean bl2) {
        int n2 = jComponent.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = jComponent.getComponent(i2);
            if (!(component instanceof JComponent)) continue;
            if (component instanceof MonitorCheckBox) {
                MonitorCheckBox monitorCheckBox = (MonitorCheckBox)component;
                monitorCheckBox.setSelected(bl2);
                int n3 = monitorCheckBox.getActionListeners().length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    ActionListener actionListener = monitorCheckBox.getActionListeners()[i3];
                    if (!(actionListener instanceof MonitorCheckBoxListener)) continue;
                    ((MonitorCheckBoxListener)actionListener).setTextFieldEnabled(bl2);
                }
                continue;
            }
            this.setAllMonitorCheckBoxSelected((JComponent)component, bl2);
        }
    }

    protected void setResultUnitLabelVisible(boolean bl2) {
        if (this._resultUnitLabel != null) {
            this._resultUnitLabel.setVisible(bl2);
        }
    }

    protected void setThresholdCondition(String string) {
        this._thresholdConditionBox.setSelectedItem(string);
    }

    public String getAlarmBreakText() {
        return this._alarmBreakField.getText().trim();
    }

    public short getThresholdConditionIndex() {
        return (short)this._thresholdConditionBox.getSelectedIndex();
    }

    public String getThresholdConditionString() {
        return (String)this._thresholdConditionBox.getSelectedItem();
    }

    public void setThresholdResult(String string) {
        this._thresholdResultField.setText(string);
    }

    public String getThresholdResult() {
        return this._thresholdResultField.getText().trim();
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(DevicesMonitorPane.class, (String)string);
    }

    private class ChangeItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (DevicesMonitorPane.this._thresholdConditionBox.getSelectedItem().equals(DialogConstants.EXCLUDE) || DevicesMonitorPane.this._thresholdConditionBox.getSelectedItem().equals(DialogConstants.INCLUDE)) {
                DevicesMonitorPane.this.setResultUnitLabelVisible(false);
            } else {
                DevicesMonitorPane.this.setResultUnitLabelVisible(true);
            }
        }
    }
}

