/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MonitorBroker;
import com.sysuptime.mainframe.performance.PerformanceUIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class MonitorGraphChooser
extends ConfirmDialog {
    private DefaultListModel _listModel;
    private JList _list;

    public MonitorGraphChooser(Frame frame, boolean bl2) {
        super(frame, _bundle.getString("title_monitorgraph"), bl2);
        this.initComponent();
        this.initUserData();
    }

    private void initComponent() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.getCancelButton().setText(DialogConstants.BUTTON_CLOSE);
        this.pack();
    }

    private JComponent getBodyPanel() {
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel);
        this._list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MonitorGraphChooser.this.okDialog();
                    MonitorGraphChooser.this.dispose();
                }
            }
        });
        this._list.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        jScrollPane.setPreferredSize(DialogConstants.VIEW_XLONG_SIZE);
        return jScrollPane;
    }

    private void initUserData() {
        List list = MonitorBroker.getScheduleDataList();
        try {
            int n2;
            ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
            int n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                Monitor monitor = (Monitor)list.get(n2);
                arrayList.add(monitor);
            }
            CommonUtil.sortIgnoreCase(arrayList);
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                this._listModel.addElement(arrayList.get(n2));
            }
        }
        catch (Exception exception) {
            this._logger.error((Object)" monitorGraphChooser init user data", (Throwable)exception);
        }
    }

    @Override
    protected void okDialog() {
        Monitor monitor = (Monitor)this._list.getSelectedValue();
        if (monitor != null) {
            PerformanceUIUtil.createGraphChooser(this, monitor);
        } else {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_selectmonitor"));
        }
    }
}

