/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.mainframe.performance.CalendarDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.DialogProvider;
import com.sysuptime.mainframe.performance.RepetitionValidator;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TimebucketActionDialog;
import com.sysuptime.mainframe.util.SwingUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScheduleAdvanceDialog
extends TimebucketActionDialog {
    private static final String LABEL_RUN_TIMES = _bundle.getString("label_runtimes");
    private Monitor _schedule;
    private JTextField _startTime;
    private JButton _start;
    private JButton _end;
    private JTextField _endTime;
    private JTextField _repetitions;
    private long _checkedStartTime;
    private long _checkedEndTime;
    private int _checkedRepetitions;
    private long _timebucketId;
    private String _timebucketName;

    public ScheduleAdvanceDialog(JDialog jDialog, String string, boolean bl2, Monitor monitor) {
        super(jDialog, string, bl2);
        this.initSchedule(monitor);
        this.initComponent();
        this.initUserData();
    }

    private void initSchedule(Monitor monitor) {
        this._schedule = monitor;
    }

    private void initComponent() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getDefaultPanel(), "South");
        this.pack();
    }

    @Override
    protected void doDefault() {
        this.getTimebucketBox().setSelectedItem("7*24");
        Date date = new Date();
        this._startTime.setText(CommonUtil.getDateFormat().format(date));
        this._checkedStartTime = date.getTime();
        this._endTime.setText(String.valueOf(0));
        this._checkedEndTime = 0L;
        this._repetitions.setText("-1");
    }

    protected JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p,5dlu,p", "p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(this.getConfigLabel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.getConfigBox(), cellConstraints.xy(3, 1));
        CalendarAction calendarAction = new CalendarAction();
        panelBuilder.addLabel(DialogConstants.LABEL_START_TIME, cellConstraints.xy(1, 3));
        this._startTime = new JTextField();
        this._startTime.setToolTipText(_bundle.getString("tooltip_scheduleStartTime"));
        this._startTime.setEditable(false);
        this._startTime.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._startTime, cellConstraints.xy(3, 3));
        ImageIcon imageIcon = SwingUtil.getImage("jdaychoosercolor16.gif");
        this._start = new JButton(imageIcon);
        this._start.addActionListener(calendarAction);
        panelBuilder.add((Component)this._start, cellConstraints.xy(5, 3));
        panelBuilder.addLabel(DialogConstants.LABEL_END_TIME, cellConstraints.xy(1, 5));
        this._endTime = new JTextField(String.valueOf(0));
        this._endTime.setToolTipText(_bundle.getString("tooltip_scheduleEndTime"));
        this._endTime.setEditable(false);
        this._endTime.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._endTime, cellConstraints.xy(3, 5));
        this._end = new JButton(imageIcon);
        this._end.addActionListener(calendarAction);
        panelBuilder.add((Component)this._end, cellConstraints.xy(5, 5));
        panelBuilder.addLabel(LABEL_RUN_TIMES, cellConstraints.xy(1, 7));
        this._repetitions = new JTextField("-1");
        this._repetitions.setToolTipText(_bundle.getString("tooltip_repetition"));
        this._repetitions.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._repetitions, cellConstraints.xy(3, 7));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        this.getTimebucketBox().setSelectedItem(this._schedule.getTimebucketName());
        this._checkedStartTime = this._schedule.getStartDateTime();
        SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
        String string = simpleDateFormat.format(new Date(this._checkedStartTime));
        this._startTime.setText(string);
        this._checkedEndTime = this._schedule.getEndDateTime();
        if (this._checkedEndTime != 0L) {
            String string2 = simpleDateFormat.format(new Date(this._schedule.getEndDateTime()));
            this._endTime.setText(string2);
        } else {
            this._endTime.setText(String.valueOf(0));
        }
        this._repetitions.setText(String.valueOf(this._schedule.getRepetitions()));
    }

    private void setCalendar(boolean bl2) {
        CalendarDialog calendarDialog = (CalendarDialog)DialogProvider.createCalendarDialog(this);
        if (calendarDialog.isPut()) {
            Date date = calendarDialog.getDate();
            SimpleDateFormat simpleDateFormat = CommonUtil.getDateFormat();
            String string = simpleDateFormat.format(date);
            long l2 = date.getTime();
            if (bl2) {
                if (this._checkedEndTime != 0L && l2 >= this._checkedEndTime) {
                    JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_START_END);
                    return;
                }
                this._startTime.setText(string);
                this._checkedStartTime = l2;
            } else {
                if (l2 <= this._checkedStartTime) {
                    JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_START_END);
                    return;
                }
                this._endTime.setText(string);
                this._checkedEndTime = l2;
            }
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkAdvancedInfo()) {
            this.setAdvancedInfo();
            this.dispose();
        }
    }

    private boolean checkAdvancedInfo() {
        Integer n2 = (Integer)SingletonValidator.checkAllDialog(this, LABEL_RUN_TIMES, this._repetitions.getText(), RepetitionValidator.CLASS);
        if (n2 == null) {
            return false;
        }
        JComboBox jComboBox = this.getTimebucketBox();
        int n3 = jComboBox.getSelectedIndex();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_TIMEBUCKET, n3, SelectionValidator.CLASS);
        if (object == null) {
            return false;
        }
        this._timebucketName = (String)jComboBox.getItemAt(n3);
        this._timebucketId = ((Timebucket)this._timebucketNameToObject.get(this._timebucketName)).getTimebucketId();
        this._checkedRepetitions = n2;
        return true;
    }

    private void setAdvancedInfo() {
        this._schedule.setTimebucketId(this._timebucketId);
        this._schedule.setTimebucketName(this._timebucketName);
        this._schedule.setStartDateTime(this._checkedStartTime);
        this._schedule.setEndDateTime(this._checkedEndTime);
        this._schedule.setRepetitions(this._checkedRepetitions);
    }

    private class CalendarAction
    implements ActionListener {
        private CalendarAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(ScheduleAdvanceDialog.this._start)) {
                ScheduleAdvanceDialog.this.setCalendar(true);
            } else if (object.equals(ScheduleAdvanceDialog.this._end)) {
                ScheduleAdvanceDialog.this.setCalendar(false);
            }
        }
    }
}

