/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.tree;

import com.sysuptime.common.graph.CustomerGraphModel;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.IGraphParameters;
import com.sysuptime.common.graph.MasterGraphModel;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.SubnetGraphModel;
import com.sysuptime.common.graph.TopologyGraphModel;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.Path;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.nodes.BeanTreeNode;
import com.sysuptime.mainframe.nodes.CustomerTreeNode;
import com.sysuptime.mainframe.nodes.DeviceTreeNode;
import com.sysuptime.mainframe.nodes.SubnetTreeNode;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.nodes.display.SubDeviceTreeNodeDisplay;
import com.sysuptime.mainframe.tree.StructuralTreeManager;
import com.sysuptime.mainframe.tree.TreeManager;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openide.nodes.Node;

public class TopologyTreeManager
extends StructuralTreeManager {
    private static final Logger _logger = Logger.getLogger((String)TopologyTreeManager.class.getName());
    private Map _path2TreeNodeMap = new Hashtable();

    public TopologyTreeManager(TreeNode treeNode) {
        super(treeNode);
    }

    @Override
    public void createTree() {
        boolean bl2 = TreeManager.c();
        this._path2TreeNodeMap.clear();
        boolean bl3 = bl2;
        TopologyData topologyData = GraphLoader.getInstance().getData();
        if (topologyData != null && !topologyData.isEmpty()) {
            Iterator iterator = topologyData.customersIterator();
            while (iterator.hasNext()) {
                CustomerNode customerNode = (CustomerNode)iterator.next();
                Path path = new Path(customerNode.getCustomerID());
                TreeNode treeNode = this.a(customerNode, IGraphParameters.MASTER_MASTER, path);
                this._root.getChildren().add(new Node[]{treeNode});
                this._path2TreeNodeMap.put(path, treeNode);
                if (!bl3) continue;
            }
        }
    }

    private TreeNode a(CustomerNode customerNode, GraphID graphID, Path path) {
        CustomerTreeNode customerTreeNode = new CustomerTreeNode(customerNode, graphID);
        boolean bl2 = TreeManager.c();
        if (customerNode.hasChildren()) {
            Iterator iterator = customerNode.childrenIterator();
            while (iterator.hasNext()) {
                TopoNode topoNode = (TopoNode)iterator.next();
                Path path2 = new Path(path);
                path2.setSubDeviceID(topoNode.getPrivateID());
                GraphID graphID2 = new GraphID(customerNode.getCustomerID(), "customer");
                TreeNode treeNode = null;
                if (topoNode instanceof SubnetNode) {
                    SubnetNode subnetNode = (SubnetNode)topoNode;
                    treeNode = this.a(subnetNode, graphID2, path2);
                } else {
                    treeNode = new DeviceTreeNode((DeviceNode)topoNode, graphID2);
                    treeNode.setDisplay(new SubDeviceTreeNodeDisplay((DeviceTreeNode)treeNode));
                }
                customerTreeNode.getChildren().add(new Node[]{treeNode});
                this._path2TreeNodeMap.put(path2, treeNode);
                if (!bl2) continue;
            }
        }
        return customerTreeNode;
    }

    private TreeNode a(SubnetNode subnetNode, GraphID graphID, Path path) {
        SubnetTreeNode subnetTreeNode;
        block5: {
            SubnetTreeNode subnetTreeNode2 = new SubnetTreeNode(subnetNode, graphID);
            boolean bl2 = TreeManager.c();
            if (subnetNode.hasChildren()) {
                Iterator iterator = subnetNode.childrenIterator();
                while (iterator.hasNext()) {
                    try {
                        DeviceNode deviceNode = (DeviceNode)iterator.next();
                        Path path2 = new Path(path);
                        path2.setDeviceID(deviceNode.getPrivateID());
                        GraphID graphID2 = new GraphID(path2.getCustomerID(), path2.getSubDeviceID());
                        DeviceTreeNode deviceTreeNode = new DeviceTreeNode(deviceNode, graphID2);
                        subnetTreeNode = subnetTreeNode2;
                        if (!bl2) {
                            subnetTreeNode.getChildren().add(new Node[]{deviceTreeNode});
                            this._path2TreeNodeMap.put(path2, deviceTreeNode);
                            continue;
                        }
                        break block5;
                    }
                    catch (Throwable throwable) {
                        _logger.error((Object)"", throwable);
                        if (!bl2) continue;
                    }
                }
            }
            subnetTreeNode = subnetTreeNode2;
        }
        return subnetTreeNode;
    }

    @Override
    public TreeNode getTreeNode(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        Path path = ((TopologyGraphModel)networkGraphModel).getNodePath(networkNode);
        return (TreeNode)((Object)this._path2TreeNodeMap.get(path));
    }

    @Override
    public void insert(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        block8: {
            TopoNode topoNode;
            Node node;
            BeanTreeNode beanTreeNode;
            TopologyGraphModel topologyGraphModel;
            BeanTreeNode beanTreeNode2;
            block12: {
                Path path;
                boolean bl2;
                block9: {
                    block11: {
                        block10: {
                            block7: {
                                TopologyGraphModel topologyGraphModel2 = (TopologyGraphModel)networkGraphModel;
                                bl2 = TreeManager.c();
                                Path path2 = topologyGraphModel2.getNodePath(networkNode);
                                TopoNode topoNode2 = topologyGraphModel2.getNode(path2);
                                GraphID graphID = networkGraphModel.getID();
                                beanTreeNode2 = null;
                                beanTreeNode2 = topoNode2 instanceof CustomerNode ? new CustomerTreeNode((CustomerNode)topoNode2, graphID) : (topoNode2 instanceof SubnetNode ? new SubnetTreeNode((SubnetNode)topoNode2, graphID) : new DeviceTreeNode((DeviceNode)topoNode2, graphID));
                                if (!(networkGraphModel instanceof MasterGraphModel)) break block7;
                                this._path2TreeNodeMap.put(((MasterGraphModel)networkGraphModel).getNodePath(networkNode), beanTreeNode2);
                                this._root.getChildren().add(new Node[]{beanTreeNode2});
                                if (!bl2) break block8;
                            }
                            if (!(networkGraphModel instanceof SubnetGraphModel)) break block9;
                            topologyGraphModel = (SubnetGraphModel)networkGraphModel;
                            path = ((TopologyGraphModel)networkGraphModel).getPath();
                            beanTreeNode = (BeanTreeNode)((Object)this._path2TreeNodeMap.get(path));
                            if (beanTreeNode.getChildren().getNodesCount() <= 0) break block10;
                            this._path2TreeNodeMap.put(topologyGraphModel.getNodePath(networkNode), beanTreeNode2);
                            beanTreeNode.getChildren().add(new Node[]{beanTreeNode2});
                            if (!bl2) break block11;
                        }
                        node = beanTreeNode.getParentNode();
                        node.getChildren().remove(new Node[]{beanTreeNode});
                        this._path2TreeNodeMap.remove(((SubnetGraphModel)topologyGraphModel).getPath());
                        topoNode = beanTreeNode.getNode();
                        beanTreeNode = new SubnetTreeNode((SubnetNode)topoNode, networkGraphModel.getParentGraph());
                        this._path2TreeNodeMap.put(topologyGraphModel.getNodePath(networkNode), beanTreeNode2);
                        beanTreeNode.getChildren().add(new Node[]{beanTreeNode2});
                        this._path2TreeNodeMap.put(((SubnetGraphModel)topologyGraphModel).getPath(), beanTreeNode);
                        node.getChildren().add(new Node[]{beanTreeNode});
                    }
                    if (!bl2) break block8;
                }
                if (!(networkGraphModel instanceof CustomerGraphModel)) break block8;
                if (beanTreeNode2 instanceof DeviceTreeNode) {
                    beanTreeNode2.setDisplay(new SubDeviceTreeNodeDisplay((DeviceTreeNode)beanTreeNode2));
                }
                if ((beanTreeNode = (BeanTreeNode)((Object)this._path2TreeNodeMap.get(path = (topologyGraphModel = (CustomerGraphModel)networkGraphModel).getPath()))).getChildren().getNodesCount() <= 0) break block12;
                this._path2TreeNodeMap.put(topologyGraphModel.getNodePath(networkNode), beanTreeNode2);
                beanTreeNode.getChildren().add(new Node[]{beanTreeNode2});
                if (!bl2) break block8;
            }
            node = beanTreeNode.getParentNode();
            node.getChildren().remove(new Node[]{beanTreeNode});
            this._path2TreeNodeMap.remove(topologyGraphModel.getPath());
            topoNode = beanTreeNode.getNode();
            beanTreeNode = new CustomerTreeNode((CustomerNode)topoNode, networkGraphModel.getParentGraph());
            this._path2TreeNodeMap.put(topologyGraphModel.getNodePath(networkNode), beanTreeNode2);
            beanTreeNode.getChildren().add(new Node[]{beanTreeNode2});
            this._path2TreeNodeMap.put(topologyGraphModel.getPath(), beanTreeNode);
            node.getChildren().add(new Node[]{beanTreeNode});
        }
    }

    @Override
    public void remove(NetworkNode networkNode, NetworkGraphModel networkGraphModel) {
        TopologyGraphModel topologyGraphModel = (TopologyGraphModel)networkGraphModel;
        Path path = topologyGraphModel.getPath();
        TreeNode treeNode = (TreeNode)((Object)this._path2TreeNodeMap.get(path));
        Path path2 = topologyGraphModel.getNodePath(networkNode);
        TreeNode treeNode2 = (TreeNode)((Object)this._path2TreeNodeMap.get(path2));
        if (networkGraphModel instanceof MasterGraphModel) {
            treeNode = this._root;
        }
        this._path2TreeNodeMap.remove(path2);
        treeNode.getChildren().remove(new Node[]{treeNode2});
    }
}

