/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.update;

import com.sysuptime.common.update.AnalysePatchFile;
import com.sysuptime.common.update.UpdateFileUtil;
import com.sysuptime.common.util.callback.CallbackClient;
import com.sysuptime.mainframe.Startup;
import com.sysuptime.mainframe.login.GlobalCallbackServerProxyInvoker;
import com.sysuptime.mainframe.update.UpdateClient;
import com.sysuptime.mainframe.update.UpdateClientDialog;
import com.sysuptime.mainframe.update.UpdateSystemMBeanInvoker;
import com.sysuptime.mainframe.util.ClientConfig;
import com.sysuptime.server.msp.Command;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.zip.ZipEntry;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class InstallPatch
implements Runnable {
    private static final Logger _logger = Logger.getLogger((String)InstallPatch.class.getName());
    private static final String BASEDIRECTORY = UpdateFileUtil.getSystemHome() + "/";
    private UpdateClientDialog _dialog;
    private File _patchFile;
    private AnalysePatchFile _analyse;
    private boolean _isRestart;
    private Vector _delFiles;

    public InstallPatch(File file, AnalysePatchFile analysePatchFile, boolean bl2, UpdateClientDialog updateClientDialog) {
        this._dialog = updateClientDialog;
        this._delFiles = new Vector();
        this._patchFile = file;
        this._analyse = analysePatchFile;
        this._isRestart = bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = UpdateClientDialog.b();
        try {
            block24: {
                block22: {
                    boolean bl2 = this.updateClient();
                    boolean bl3 = this.updateServer();
                    try {
                        if (!bl2 || !bl3) break block22;
                    }
                    catch (Exception exception) {
                        throw InstallPatch.a(exception);
                    }
                    try {
                        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_server_update_success"));
                        this._dialog.addItem("");
                        this.updateFilesSuccess();
                        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"update_configure_file"));
                        ClientConfig.setProperty("patchVersion", "" + this._analyse.getValidVersion());
                        ClientConfig.setProperty("patchDate", "" + this._analyse.getPatchDate().getTime());
                        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_install_success"));
                        if (this._isRestart) {
                            this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"restart_server"));
                        }
                    }
                    finally {
                        this._dialog.setOKEnable(true);
                    }
                    CallbackClient callbackClient = Startup.getGlobalCallbackClient();
                    try {
                        GlobalCallbackServerProxyInvoker.notifyAllClients(callbackClient, "ApplyPatch");
                    }
                    catch (Exception exception) {
                        _logger.error((Object)"notify all clients", (Throwable)exception);
                    }
                    if (string == null) break block24;
                }
                try {
                    this.resumeAllFiles();
                }
                finally {
                    this._dialog.setOKEnable(true);
                }
            }
            try {
                this._analyse.getAnalyticFile().close();
            }
            catch (IOException iOException) {
                _logger.error((Object)"get analytic file", (Throwable)iOException);
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)"Error", throwable);
        }
        finally {
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(InstallPatch.class, (String)"update_done"));
        }
    }

    public void resumeAllFiles() {
        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"update_resume_files"));
        UpdateSystemMBeanInvoker.resumeServersFiles();
        UpdateFileUtil.resumeFiles(BASEDIRECTORY, this._delFiles);
    }

    public void updateFilesSuccess() {
        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"update_delete_temp_files"));
        UpdateSystemMBeanInvoker.updateAllServersSuccess(this._isRestart);
        UpdateFileUtil.delTMPFiles(BASEDIRECTORY, this._delFiles);
    }

    public boolean updateServer() {
        _logger.info((Object)"Start updating server...");
        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_upload"));
        byte[] byArray = this.a();
        _logger.info((Object)"To update server...");
        return UpdateSystemMBeanInvoker.updateAllServers(byArray);
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateClient() {
        block5: {
            v0 = UpdateClientDialog.b();
            InstallPatch._logger.info((Object)"update client...");
            this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_client"));
            this._dialog.addItem(NbBundle.getMessage(UpdateClient.class, (String)"update_delete_invalid_files"));
            UpdateFileUtil.deleteInvalidFiles(InstallPatch.BASEDIRECTORY, this._analyse.getInvalidFilesName(), this._delFiles);
            var1_1 = v0;
            var2_2 = false;
            var3_3 = this._analyse.getFileEntries().iterator();
            while (var3_3.hasNext()) {
                var4_4 = (ZipEntry)var3_3.next();
                var5_5 = var4_4.getName();
                v1 = var5_5.startsWith("server");
                if (var1_1 == null) {
                    if (v1) {
                        if (var1_1 == null) continue;
                        Command.b(new int[5]);
                    }
                    var5_5 = File.separator + (String)var5_5;
                    this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_file") + ": " + (String)var5_5);
                    var2_2 = UpdateFileUtil.copyFile(InstallPatch.BASEDIRECTORY, (String)var5_5, this._analyse.getDataFromZipEntry(var4_4), this._delFiles);
                    if (var2_2) continue;
                    this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_file") + (String)var5_5 + NbBundle.getMessage(InstallPatch.class, (String)"update_failed"));
                    return false;
                }
                ** GOTO lbl28
            }
            var3_3 = this._analyse.getCommonEntries().iterator();
            block1: while (true) {
                v1 = var3_3.hasNext();
lbl28:
                // 2 sources

                if (!v1) break block5;
                var4_4 = (ZipEntry)var3_3.next();
                var5_5 = this._analyse.clientCommonFileName(var4_4);
                this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_file") + ": " + (String)var5_5);
                InstallPatch._logger.info((Object)("CurrentFileName:" + (String)var5_5 + ", BaseDir:" + InstallPatch.BASEDIRECTORY));
                var2_2 = UpdateFileUtil.copyFile(InstallPatch.BASEDIRECTORY, (String)var5_5, this._analyse.getDataFromZipEntry(var4_4), this._delFiles);
                InstallPatch._logger.info((Object)("CopyFile returns:" + var2_2));
                v2 = var2_2;
                do {
                    if (v2) continue block1;
                    this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_update_file") + " " + (String)var5_5 + " " + NbBundle.getMessage(InstallPatch.class, (String)"update_failed"));
                    v2 = false;
                } while (var1_1 != null);
                break;
            }
            return v2;
        }
        this._dialog.addItem(NbBundle.getMessage(InstallPatch.class, (String)"patch_client_update_success"));
        this._dialog.addItem("");
        return true;
    }

    private byte[] a() {
        try {
            byte[] byArray = new byte[(int)this._patchFile.length()];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this._patchFile));
            bufferedInputStream.read(byArray, 0, byArray.length);
            bufferedInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

