/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Dependency;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.ThresholdResultProcessor;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DependencyReader {
    public static void setDependency(Connection connection, Dependency dependency, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "SELECT direct_dependency_c, dependency_condition_c FROM PM_DEPENDENCY WHERE SCHEDULE_ID_C =?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            dependency.setScheduleId(n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                if (resultSet.next()) {
                    dependency.setDirectDependency(resultSet.getInt(1));
                    dependency.setConditionOk(SqlUtil.getBoolean(resultSet, 2));
                }
            }
            catch (SQLException sQLException) {
                throw DependencyReader.a(sQLException);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_dependency data: " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static List getAllDependencies(Connection connection) throws SQLException {
        ArrayList<Object> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<Object>();
            int n2 = ExecutorHelper.c();
            try {
                String string = "SELECT DIRECT_DEPENDENCY_C FROM PM_DEPENDENCY";
                preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getObject(1));
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw DependencyReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_dependency data: " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static List getOtherDependencies(Connection connection, int n2) throws SQLException {
        ArrayList<Object> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            int n3 = ExecutorHelper.c();
            arrayList = new ArrayList<Object>();
            try {
                String string = "SELECT DIRECT_DEPENDENCY_C FROM PM_DEPENDENCY WHERE SCHEDULE_ID_C<>?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        arrayList.add(resultSet.getObject(1));
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw DependencyReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_dependency data: " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    public static boolean isDependencyPermitted(Connection connection, int n2) throws SQLException {
        boolean bl2;
        block12: {
            Map map = DependencyReader.getAllDependencyIdToCondition(connection, n2);
            int n3 = ExecutorHelper.b();
            for (Map.Entry entry : map.entrySet()) {
                boolean bl3;
                int n4;
                block14: {
                    n4 = ((Number)entry.getKey()).intValue();
                    Monitor monitor = MonitorCache.getMonitor(n4);
                    try {
                        block13: {
                            try {
                                try {
                                    bl2 = monitor.isSuspended();
                                    if (n3 == 0) break block12;
                                    if (bl2) break block13;
                                }
                                catch (SQLException sQLException) {
                                    throw DependencyReader.a(sQLException);
                                }
                                if (!monitor.isExpired()) break block14;
                            }
                            catch (SQLException sQLException) {
                                throw DependencyReader.a(sQLException);
                            }
                        }
                        return false;
                    }
                    catch (SQLException sQLException) {
                        throw DependencyReader.a(sQLException);
                    }
                }
                try {
                    bl3 = !ThresholdResultProcessor.isScheduleAlarm(n4);
                }
                catch (SQLException sQLException) {
                    throw DependencyReader.a(sQLException);
                }
                Boolean bl4 = bl3;
                try {
                    if (!entry.getValue().equals(bl4)) {
                        return false;
                    }
                }
                catch (SQLException sQLException) {
                    throw DependencyReader.a(sQLException);
                }
                if (n3 != 0) continue;
            }
            bl2 = true;
        }
        return bl2;
    }

    public static Map getAllDependencyIdToCondition(Connection connection, int n2) throws SQLException {
        HashMap hashMap = new HashMap();
        int n3 = DependencyReader.getDependencyIdToCondition(connection, hashMap, n2);
        int n4 = ExecutorHelper.b();
        while (n3 != -1) {
            n3 = DependencyReader.getDependencyIdToCondition(connection, hashMap, n3);
            if (n4 != 0) continue;
        }
        return hashMap;
    }

    public static int getDependencyIdToCondition(Connection connection, Map map, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        int n3 = -1;
        try {
            String string = "SELECT D.DIRECT_DEPENDENCY_C, D.DEPENDENCY_CONDITION_C FROM PM_DEPENDENCY D WHERE D.SCHEDULE_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                map.put(resultSet.getObject(1), SqlUtil.getBoolean(resultSet, 2));
                n3 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_dependency data: " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return n3;
    }

    public static List getInverseDependencies(Connection connection, int n2) throws SQLException {
        ArrayList arrayList;
        HashSet hashSet;
        block2: {
            int n3 = ExecutorHelper.b();
            hashSet = new HashSet();
            ArrayList arrayList2 = DependencyReader.a(connection, n2);
            hashSet.addAll(arrayList2);
            int n4 = arrayList2.size();
            int n5 = n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList = arrayList2;
                if (n5 != 0) {
                    int n6 = (Integer)arrayList.get(i2);
                    List list = DependencyReader.getInverseDependencies(connection, n6);
                    hashSet.addAll(list);
                    if (n5 != 0) continue;
                }
                break block2;
            }
            arrayList = new ArrayList();
        }
        ArrayList arrayList3 = arrayList;
        arrayList3.addAll(hashSet);
        return arrayList3;
    }

    private static ArrayList a(Connection connection, int n2) throws SQLException {
        ArrayList<Integer> arrayList;
        block8: {
            PreparedStatement preparedStatement = null;
            arrayList = new ArrayList<Integer>();
            int n3 = ExecutorHelper.b();
            try {
                String string = "SELECT D.SCHEDULE_ID_C FROM PM_DEPENDENCY D WHERE D.DIRECT_DEPENDENCY_C=?";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setInt(1, n2);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n4 = resultSet.getInt(1);
                    try {
                        arrayList.add(n4);
                        if (n3 != 0) {
                            if (n3 != 0) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (SQLException sQLException) {
                        throw DependencyReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_dependency data: " + sQLException.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return arrayList;
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

