/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.Monitor;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.SqlUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DependencyWriter {
    private DependencyWriter() {
    }

    public static void storeDependencyData(Connection connection, Monitor monitor) throws SQLException {
        try {
            if (monitor.getDirectDependency() == -1) {
                return;
            }
        }
        catch (SQLException sQLException) {
            throw DependencyWriter.a(sQLException);
        }
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_DEPENDENCY(schedule_id_c, direct_dependency_c, dependency_condition_c) VALUES(?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            int n2 = monitor.getScheduleId();
            preparedStatement.setInt(1, n2);
            int n3 = monitor.getDirectDependency();
            preparedStatement.setInt(2, n3);
            SqlUtil.setBoolean(preparedStatement, 3, monitor.isConditionOk());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Store pm_dependency data " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void resetDependency(Connection connection, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_DEPENDENCY SET direct_dependency_c= ? WHERE direct_dependency_c= ?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, -1);
            preparedStatement.setInt(2, n2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Reset pm_dependency data " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void modifyDependency(Monitor monitor) throws SQLException {
        PreparedStatement preparedStatement = null;
        Connection connection = DefaultConnection.getConnection();
        try {
            String string = "DELETE FROM pm_dependency WHERE schedule_id_c = ?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setInt(1, monitor.getScheduleId());
            preparedStatement.executeUpdate();
            DependencyWriter.storeDependencyData(connection, monitor);
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("delete pm_dependency data " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeConnection(connection, preparedStatement);
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

