/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IQueryExecutor;
import com.sysuptime.common.performance.ProcessResult;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.ProcessUtils$Result;
import com.sysuptime.server.performance.ConciseSshExecutor;
import com.sysuptime.server.performance.ConciseWmiExecutor;
import com.sysuptime.server.performance.DatabaseElement;
import com.sysuptime.server.performance.MetricsParameterElement;
import com.sysuptime.server.performance.ProtocolParameterElement;
import com.sysuptime.server.performance.XmlPath;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ExecutorHelper {
    public static final String ORACLE = "ORACLE";
    public static final String SNMP = "SNMP";
    public static final String HTTP = "HTTP";
    private static final Logger _logger = Logger.getLogger((String)ExecutorHelper.class.getName());
    private static Map<String, Integer> _constantNameToId;
    private static Map<Integer, String> _constantIdToName;
    private static Map<String, DatabaseElement> _databaseMap;
    private static Map<Integer, ProtocolParameterElement> _protocolMap;
    private static List<Integer> _remoteHostProtocols;
    static String[] _pm_table_names;
    private static int a;

    private ExecutorHelper() {
    }

    private static Document a(File file) throws MalformedURLException, DocumentException {
        SAXReader sAXReader = new SAXReader();
        return sAXReader.read(file);
    }

    private static void a(Document document) {
        Element element = document.getRootElement();
        ExecutorHelper.a(element);
        ExecutorHelper.b(element);
        ExecutorHelper.c(element);
        ExecutorHelper.e(element);
    }

    private static void a(Element element) {
        List list = element.elements("Constant");
        int n2 = list.size();
        _constantNameToId = new HashMap<String, Integer>(n2);
        _constantIdToName = new HashMap<Integer, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)list.get(i2);
            String string = element2.attributeValue("name");
            Integer n3 = Integer.valueOf(element2.attributeValue("id"));
            _constantNameToId.put(string, n3);
            _constantIdToName.put(n3, string);
        }
    }

    private static void b(Element element) {
        List list = element.elements("Database");
        int n2 = list.size();
        _databaseMap = new HashMap<String, DatabaseElement>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)list.get(i2);
            String string = element2.attributeValue("name");
            String string2 = element2.attributeValue("driver");
            String string3 = element2.attributeValue("url");
            DatabaseElement databaseElement = new DatabaseElement(string, string2, string3);
            _databaseMap.put(string, databaseElement);
        }
    }

    private static void c(Element element) {
        List list = element.elements("Protocol");
        int n2 = list.size();
        _protocolMap = new HashMap<Integer, ProtocolParameterElement>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)list.get(i2);
            Integer n3 = _constantNameToId.get(element2.attributeValue("name"));
            String string = element2.attributeValue("parameter");
            String string2 = element2.attributeValue("class");
            String string3 = element2.attributeValue("result");
            Map map = ExecutorHelper.d(element2);
            ProtocolParameterElement protocolParameterElement = new ProtocolParameterElement(n3, string, string2, string3, map);
            _protocolMap.put(n3, protocolParameterElement);
        }
    }

    private static Map d(Element element) {
        List list = element.elements("Metrics");
        int n2 = list.size();
        HashMap<Integer, MetricsParameterElement> hashMap = new HashMap<Integer, MetricsParameterElement>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)list.get(i2);
            String string = element2.attributeValue("name");
            String string2 = element2.attributeValue("parameter");
            Integer n3 = _constantNameToId.get(string);
            MetricsParameterElement metricsParameterElement = new MetricsParameterElement(n3, string2);
            hashMap.put(n3, metricsParameterElement);
        }
        return hashMap;
    }

    private static void e(Element element) {
        List list = element.elements("RemoteHostProtocol");
        int n2 = list.size();
        _remoteHostProtocols = new ArrayList<Integer>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)list.get(i2);
            _remoteHostProtocols.add(_constantNameToId.get(element2.getTextTrim()));
        }
    }

    public static String getDriver(String string) {
        DatabaseElement databaseElement = _databaseMap.get(string);
        return databaseElement.getDriver();
    }

    public static String getUrl(String string) {
        DatabaseElement databaseElement = _databaseMap.get(string);
        return databaseElement.getUrl();
    }

    public static ProtocolParameterElement getProtocol(int n2) {
        ProtocolParameterElement protocolParameterElement = _protocolMap.get(n2);
        return protocolParameterElement;
    }

    public static QueryParameter getParameter(int n2) throws Exception {
        ProtocolParameterElement protocolParameterElement = _protocolMap.get(n2);
        Class<?> clazz = Class.forName(protocolParameterElement.getParameter());
        return (QueryParameter)clazz.newInstance();
    }

    public static IQueryExecutor getExecutor(int n2) throws Exception {
        ProtocolParameterElement protocolParameterElement = _protocolMap.get(n2);
        try {
            if (protocolParameterElement == null) {
                _logger.error((Object)("protocol is null of ID:" + n2 + "; map.size:" + _protocolMap.size()));
                return null;
            }
        }
        catch (Exception exception) {
            throw ExecutorHelper.a(exception);
        }
        Class<?> clazz = Class.forName(protocolParameterElement.getClassName());
        return (IQueryExecutor)clazz.newInstance();
    }

    public static String getResultTableName(int n2) {
        ProtocolParameterElement protocolParameterElement = _protocolMap.get(n2);
        try {
            if (protocolParameterElement == null) {
                _logger.error((Object)("getResultTableName, protocol is null. protocolType:" + n2));
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecutorHelper.a(illegalArgumentException);
        }
        return protocolParameterElement.getResult();
    }

    public static String[] getAllResultTableNames() {
        int n2 = ExecutorHelper.b();
        if (_pm_table_names == null) {
            String[] stringArray;
            block5: {
                Object[] objectArray = _protocolMap.values().toArray();
                int n3 = objectArray.length;
                String[] stringArray2 = new String[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    try {
                        stringArray = stringArray2;
                        if (n2 != 0) {
                            stringArray[i2] = ((ProtocolParameterElement)objectArray[i2]).getResult();
                            if (n2 != 0) continue;
                            break;
                        }
                        break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ExecutorHelper.a(illegalArgumentException);
                    }
                }
                stringArray = stringArray2;
            }
            return stringArray;
        }
        return _pm_table_names;
    }

    public static QueryParameter getMetricsParameter(int n2, int n3) throws Exception {
        ProtocolParameterElement protocolParameterElement = _protocolMap.get(n2);
        Map map = protocolParameterElement.getMetricsParametersMap();
        MetricsParameterElement metricsParameterElement = (MetricsParameterElement)map.get(n3);
        try {
            if (metricsParameterElement == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw ExecutorHelper.a(exception);
        }
        Class<?> clazz = Class.forName(metricsParameterElement.getParameter());
        return (QueryParameter)clazz.newInstance();
    }

    public static Map getConstantsNameToId() {
        return _constantNameToId;
    }

    public static Map getConstantsIdToName() {
        return _constantIdToName;
    }

    public static int getId(String string) {
        try {
            if (_constantNameToId == null) {
                return 0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecutorHelper.a(illegalArgumentException);
        }
        Integer n2 = _constantNameToId.get(string);
        try {
            if (n2 != null) {
                return n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecutorHelper.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("No such constant name in the server-monitor.xml ");
    }

    public static String getName(int n2) {
        String string = _constantIdToName.get(n2).toString();
        try {
            if (string != null) {
                return string;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecutorHelper.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("No such constant id in the server-monitor.xml ");
    }

    public static List getRemoteHostProtocol() {
        return _remoteHostProtocols;
    }

    public static ProcessResult getConciseWmiCommandExecResult(String string, long l2, int n2, String string2) {
        ConciseWmiExecutor conciseWmiExecutor = new ConciseWmiExecutor();
        ProcessUtils$Result processUtils$Result = conciseWmiExecutor.getResult(string, l2, n2, string2);
        return new ProcessResult(processUtils$Result.isException(), processUtils$Result.getExit(), processUtils$Result.getResult());
    }

    public static ResultValue getConciseSshCommandExecResult(String string, long l2, int n2) {
        ConciseSshExecutor conciseSshExecutor = new ConciseSshExecutor();
        return conciseSshExecutor.getResult(string, l2, n2);
    }

    public static ProcessResult getProperties(String string, long l2, int n2, String string2) {
        ConciseWmiExecutor conciseWmiExecutor = new ConciseWmiExecutor();
        ProcessUtils$Result processUtils$Result = conciseWmiExecutor.getProperties(string, l2, n2, string2);
        return new ProcessResult(processUtils$Result.isException(), processUtils$Result.getExit(), processUtils$Result.getResult());
    }

    static {
        ExecutorHelper.b(88);
        try {
            File file = new File(XmlPath.getConfXmlPath("server-monitor.xml"));
            Document document = ExecutorHelper.a(file);
            ExecutorHelper.a(document);
        }
        catch (MalformedURLException malformedURLException) {
            _logger.error((Object)malformedURLException);
        }
        catch (DocumentException documentException) {
            _logger.error((Object)documentException);
        }
        catch (Exception exception) {
            _logger.error((Object)"Read server-monitor.xml occurs ", (Throwable)exception);
        }
        _pm_table_names = null;
    }

    public static void b(int n2) {
        a = n2;
    }

    public static int b() {
        return a;
    }

    public static int c() {
        int n2 = ExecutorHelper.b();
        try {
            if (n2 == 0) {
                return 78;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ExecutorHelper.a(illegalArgumentException);
        }
        return 0;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

