/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.ireasoning.protocol.h;
import com.ireasoning.protocol.snmp.SnmpDataType;
import com.ireasoning.protocol.snmp.SnmpVarBind;
import com.ireasoning.protocol.snmp.a0;
import com.ireasoning.protocol.snmp.aC;
import com.ireasoning.protocol.snmp.ac;
import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.sysuptime.common.performance.Baseline;
import com.sysuptime.common.performance.CloserThreshold;
import com.sysuptime.common.performance.FixedThreshold;
import com.sysuptime.common.performance.Metrics;
import com.sysuptime.common.performance.MetricsTimebucket;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.ProtocolQueryResult;
import com.sysuptime.common.performance.ResultData;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.performance.StatisticalThreshold;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.msp.ActionProxy;
import com.sysuptime.server.performance.DoubleValue;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.I18NOctetString;
import com.sysuptime.server.performance.IProtocolQueryExecutor;
import com.sysuptime.server.performance.IProtocolQueryExecutor$IUserStddev;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.MonitorHostProcessor;
import com.sysuptime.server.performance.MonitorProcessor;
import com.sysuptime.server.performance.PerformanceConfigProcessor;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.ProtocolQueryExecutor$StateInfo;
import com.sysuptime.server.performance.ProtocolQueryExecutor$UserStddev;
import com.sysuptime.server.performance.ProtocolQueryResultProcessor;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.performance.Simulator;
import com.sysuptime.server.performance.ThresholdResultProcessor;
import com.sysuptime.server.trapreceiver.TrapReceiver;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProtocolQueryExecutor
implements IProtocolQueryExecutor {
    protected Logger _logger = Logger.getLogger((String)this.getClass().getName());
    private Monitor _monitor;
    private List _metricsList;
    private int _id;
    private long _hostId;
    private String _hostName;
    private long _startTime;
    private long _period;
    private ResultValue[] _resultValues;
    private int[] _resultTypeIds;
    private boolean _isMultiple;
    private long _runDateTime;
    private Set _noStartThresholdResultTypes = new HashSet();
    private Map _resultTypeToUserStddev = new Hashtable();
    private Map<Integer, CloserThreshold> _resultTypeToCloserThreshold = new Hashtable<Integer, CloserThreshold>();
    private int _retries = 0;

    @Override
    public void startService(Monitor monitor, long l2, long l3) throws Exception {
        Object object;
        try {
            this.a(monitor, l2, l3);
            this.startQuery();
            if (!MonitorCache.isMonitorInCache(this._id)) {
                return;
            }
        }
        catch (Exception exception) {
            throw ProtocolQueryExecutor.a(exception);
        }
        this.a();
        if (monitor.isSaved()) {
            int n2 = -1;
            if (!this._isMultiple) {
                n2 = -2;
            }
            object = new ResultData();
            ((ResultData)object).setProtocolType(this._monitor.getProtocolType());
            ((ResultData)object).setHostId(this._hostId);
            ((ResultData)object).setRunDateTime(this._runDateTime);
            ((ResultData)object).setResultTypeIds(this._resultTypeIds);
            ((ResultData)object).setResultValues(this._resultValues);
            ((ResultData)object).setPeriodIndex(n2);
            ActionProxy.getInstance().storeKnownThresholdStateResultData((ResultData)object);
        }
        HashSet hashSet = new HashSet();
        try {
            if (this.a(hashSet)) {
                return;
            }
        }
        catch (Exception exception) {
            throw ProtocolQueryExecutor.a(exception);
        }
        object = PerformanceServerUtil.getConfigedUnknownResult(this._resultTypeIds, this._resultValues);
        try {
            this._noStartThresholdResultTypes.addAll(object.keySet());
            this._noStartThresholdResultTypes.addAll(hashSet);
            if (this._noStartThresholdResultTypes.size() == this._resultTypeIds.length) {
                return;
            }
        }
        catch (Exception exception) {
            throw ProtocolQueryExecutor.a(exception);
        }
        this.d();
    }

    private void a() throws SQLException {
        int n2 = this._resultTypeIds.length;
        int n3 = ExecutorHelper.c();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ThresholdResultProcessor.isHostMetricsAlarm(this._hostId, this._resultTypeIds[i2])) continue;
            ResultValue resultValue = this._resultValues[i2];
            resultValue.setBeforeAlarm(true);
            resultValue.setThresholdState("B");
            if (n3 == 0) continue;
        }
    }

    private boolean a(Set set) {
        int n2;
        block2: {
            int n3 = ExecutorHelper.c();
            int n4 = this._monitor.getMetricsListSize();
            for (int i2 = 0; i2 < n4; ++i2) {
                Metrics metrics = this._monitor.getMetrics(i2);
                n2 = metrics.isThresholdEnabled() ? 1 : 0;
                if (n3 == 0) {
                    if (n2 != 0) continue;
                    set.add(metrics.getResultTypeId());
                    if (n3 == 0) continue;
                }
                break block2;
            }
            n2 = set.size();
        }
        return n2 == this._resultTypeIds.length;
    }

    public void startQuery() throws Exception {
        block17: {
            block16: {
                int n2 = ExecutorHelper.b();
                try {
                    if (System.currentTimeMillis() > this._runDateTime + this._period) {
                        this._logger.info((Object)("monitor (" + this._monitor.getScheduleName() + ") didn't finish retries because timeout value is too large"));
                        return;
                    }
                }
                catch (Exception exception) {
                    throw ProtocolQueryExecutor.a(exception);
                }
                try {
                    if (!MonitorCache.isMonitorInCache(this._id)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    throw ProtocolQueryExecutor.a(exception);
                }
                IQueryExecutor iQueryExecutor = QueryFactory.makeQueryExecutor(this._monitor.getProtocolType());
                IExecutorParameter iExecutorParameter = QueryFactory.makeExecutorParameter(this._hostName, this._monitor.getQueryParameters(), PerformanceServerUtil.getResultTypeValues(this._metricsList), this._monitor.getScheduleName(), this._monitor.getScheduleId());
                try {
                    this._logger.info((Object)("To run monitor:" + this._monitor.getScheduleName() + "; ID:" + this._monitor.getScheduleId()));
                    this._resultValues = iQueryExecutor.startExecuting(iExecutorParameter);
                    if (!MonitorCache.isMonitorInCache(this._id)) {
                        return;
                    }
                }
                catch (Exception exception) {
                    throw ProtocolQueryExecutor.a(exception);
                }
                try {
                    if (this._retries >= 1 || this._resultValues == null) break block16;
                }
                catch (Exception exception) {
                    throw ProtocolQueryExecutor.a(exception);
                }
                for (ResultValue resultValue : this._resultValues) {
                    try {
                        try {
                            if (n2 == 0) break block17;
                            if (!resultValue.isError()) continue;
                        }
                        catch (Exception exception) {
                            throw ProtocolQueryExecutor.a(exception);
                        }
                        this._logger.info((Object)("Monitor (" + this._monitor.getScheduleName() + "): Error occurred, try again."));
                        ++this._retries;
                        this.startQuery();
                        return;
                    }
                    catch (Exception exception) {
                        throw ProtocolQueryExecutor.a(exception);
                    }
                }
            }
            PerformanceServerUtil.setResultErrorUnknownMessage(this._metricsList, this._resultValues);
        }
    }

    @Override
    public Object[] getQueryResults() {
        return this._resultValues;
    }

    private void a(Monitor monitor, long l2, long l3) throws SQLException {
        this._monitor = monitor;
        this._id = monitor.getScheduleId();
        this._hostId = l2;
        this._startTime = monitor.getStartDateTime();
        this._period = monitor.getPeriod();
        this._hostName = MonitorHostProcessor.getIpAddress(l2);
        this._metricsList = monitor.getMetricsList();
        this.a(this._metricsList);
        this._runDateTime = l3;
        this._isMultiple = PerformanceServerUtil.isMultiple(this._startTime, l3, this._period, monitor.getMultiple());
    }

    private void a(List list) {
        int n2 = list.size();
        this._resultTypeIds = new int[n2];
        int n3 = ExecutorHelper.c();
        for (int i2 = 0; i2 < n2; ++i2) {
            Baseline baseline = (Baseline)list.get(i2);
            this._resultTypeIds[i2] = baseline.getResultTypeId();
            if (n3 == 0) continue;
        }
    }

    @Override
    public int[] getResultTypes() {
        return this._resultTypeIds;
    }

    protected int b() {
        return this._id;
    }

    protected long c() {
        return this._hostId;
    }

    /*
     * Unable to fully structure code
     */
    private void d() throws SQLException {
        var2_1 = this._monitor.getProtocolType();
        var4_3 = this._metricsList.size();
        var1_4 = ExecutorHelper.b();
        for (var3_2 = 0; var3_2 < var4_3; ++var3_2) {
            block94: {
                block101: {
                    block105: {
                        block104: {
                            block99: {
                                block96: {
                                    block92: {
                                        block103: {
                                            block89: {
                                                block90: {
                                                    block88: {
                                                        var5_5 = (Baseline)this._metricsList.get(var3_2);
                                                        try {
                                                            if (this.a(var5_5.getResultTypeId()) && var1_4 != 0) continue;
                                                        }
                                                        catch (SQLException v0) {
                                                            throw ProtocolQueryExecutor.a(v0);
                                                        }
                                                        var6_6 = var5_5.getFixedStatisticalId();
                                                        var7_7 = 0.0;
                                                        var9_8 = this._resultValues[var3_2];
                                                        var10_9 = false;
                                                        if (var9_8.getValue() instanceof Number) {
                                                            var7_7 = ((Number)var9_8.getValue()).doubleValue();
                                                            var10_9 = true;
                                                        }
                                                        var11_10 = var5_5.getResultTypeId();
                                                        var12_11 = var9_8.isNormal();
                                                        var13_12 = new DoubleValue(var7_7);
                                                        if (var6_6 != 0) break block103;
                                                        var14_13 = this.a(var5_5, var9_8, var10_9, var13_12);
                                                        var7_7 = var13_12.value;
                                                        try {
                                                            block87: {
                                                                try {
                                                                    try {
                                                                        if (var14_13[0].getSeverity() == -1) break block87;
                                                                        if (!this.a(var11_10, var14_13[0].getSeverity(), var5_5.getArmBreaks(), var9_8)) break block88;
                                                                    }
                                                                    catch (SQLException v1) {
                                                                        throw ProtocolQueryExecutor.a(v1);
                                                                    }
                                                                    this.a(var11_10, var7_7, var6_6, var9_8, 1, var14_13[0].getSeverity(), String.valueOf(var14_13[0].getFixed()), String.valueOf(var14_13[0].getStat()), var12_11, this._monitor);
                                                                    if (var1_4 != 0) break block88;
                                                                }
                                                                catch (SQLException v2) {
                                                                    throw ProtocolQueryExecutor.a(v2);
                                                                }
                                                            }
                                                            ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), false);
                                                        }
                                                        catch (SQLException v3) {
                                                            throw ProtocolQueryExecutor.a(v3);
                                                        }
                                                    }
                                                    try {
                                                        try {
                                                            if (var14_13[1].getSeverity() != -1) {
                                                                if (!this.a(var11_10, var5_5.getRearmBreaks(), var9_8)) break block89;
                                                            }
                                                            ** GOTO lbl60
                                                        }
                                                        catch (SQLException v4) {
                                                            throw ProtocolQueryExecutor.a(v4);
                                                        }
                                                        if (var7_7 != -2.012) break block90;
                                                    }
                                                    catch (SQLException v5) {
                                                        throw ProtocolQueryExecutor.a(v5);
                                                    }
                                                    var7_7 = -1.012;
                                                }
                                                try {
                                                    this.a(var11_10, var7_7, var6_6, var9_8, 0, var14_13[1].getSeverity(), String.valueOf(var14_13[1].getFixed()), String.valueOf(var14_13[1].getStat()), var12_11, this._monitor);
                                                    if (var1_4 != 0) break block89;
lbl60:
                                                    // 2 sources

                                                    ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), true);
                                                }
                                                catch (SQLException v6) {
                                                    throw ProtocolQueryExecutor.a(v6);
                                                }
                                            }
                                            if (var1_4 != 0) continue;
                                        }
                                        var14_14 = this.a(var5_5.getPeriod());
                                        var15_15 = this.a(var5_5, var2_1, var7_7, var14_14, var9_8.isNormal());
                                        try {
                                            block91: {
                                                try {
                                                    try {
                                                        try {
                                                            if (var6_6 == 1) {
                                                                if (var15_15[0].getSeverity() == -1) break block91;
                                                            }
                                                            ** GOTO lbl114
                                                        }
                                                        catch (SQLException v7) {
                                                            throw ProtocolQueryExecutor.a(v7);
                                                        }
                                                        if (!this.a(var11_10, var15_15[0].getSeverity(), var5_5.getArmBreaks(), var9_8)) break block92;
                                                    }
                                                    catch (SQLException v8) {
                                                        throw ProtocolQueryExecutor.a(v8);
                                                    }
                                                    this.a(var11_10, var7_7, var6_6, var9_8, 1, var15_15[0].getSeverity(), String.valueOf(var15_15[0].getFixed()), String.valueOf(var15_15[0].getStat()), var12_11, this._monitor);
                                                    if (var1_4 != 0) break block92;
                                                }
                                                catch (SQLException v9) {
                                                    throw ProtocolQueryExecutor.a(v9);
                                                }
                                            }
                                            ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), false);
                                        }
                                        catch (SQLException v10) {
                                            throw ProtocolQueryExecutor.a(v10);
                                        }
                                    }
                                    try {
                                        try {
                                            block93: {
                                                try {
                                                    try {
                                                        if (var15_15[1].getSeverity() == -1) break block93;
                                                        if (!this.a(var11_10, var5_5.getRearmBreaks(), var9_8)) break block94;
                                                    }
                                                    catch (SQLException v11) {
                                                        throw ProtocolQueryExecutor.a(v11);
                                                    }
                                                    this.a(var11_10, var7_7, var6_6, var9_8, 0, var15_15[1].getSeverity(), String.valueOf(var15_15[1].getFixed()), String.valueOf(var15_15[1].getStat()), var12_11, this._monitor);
                                                    if (var1_4 != 0) break block94;
                                                }
                                                catch (SQLException v12) {
                                                    throw ProtocolQueryExecutor.a(v12);
                                                }
                                            }
                                            ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), true);
                                            if (var1_4 != 0) break block94;
                                        }
                                        catch (SQLException v13) {
                                            throw ProtocolQueryExecutor.a(v13);
                                        }
lbl114:
                                        // 2 sources

                                        if (var6_6 == 3) {
                                        }
                                        ** GOTO lbl194
                                    }
                                    catch (SQLException v14) {
                                        throw ProtocolQueryExecutor.a(v14);
                                    }
                                    var16_16 = this.a(var5_5, var9_8, var10_9, var13_12);
                                    try {
                                        block97: {
                                            try {
                                                try {
                                                    try {
                                                        block95: {
                                                            try {
                                                                try {
                                                                    if (var16_16[0].getSeverity() == -1) break block95;
                                                                    if (!this.a(var11_10, var16_16[0].getSeverity(), var5_5.getArmBreaks(), var9_8)) break block96;
                                                                }
                                                                catch (SQLException v15) {
                                                                    throw ProtocolQueryExecutor.a(v15);
                                                                }
                                                                this.a(var11_10, var7_7, var6_6, var9_8, 1, var16_16[0].getSeverity(), String.valueOf(var16_16[0].getFixed()), String.valueOf(var15_15[0].getStat()), var12_11, this._monitor);
                                                                if (var1_4 != 0) break block96;
                                                            }
                                                            catch (SQLException v16) {
                                                                throw ProtocolQueryExecutor.a(v16);
                                                            }
                                                        }
                                                        if (var15_15[0].getSeverity() == -1) break block97;
                                                    }
                                                    catch (SQLException v17) {
                                                        throw ProtocolQueryExecutor.a(v17);
                                                    }
                                                    if (!this.a(var11_10, var15_15[0].getSeverity(), var5_5.getArmBreaks(), var9_8)) break block96;
                                                }
                                                catch (SQLException v18) {
                                                    throw ProtocolQueryExecutor.a(v18);
                                                }
                                                this.a(var11_10, var7_7, var6_6, var9_8, 1, var16_16[0].getSeverity(), String.valueOf(var16_16[0].getFixed()), String.valueOf(var15_15[0].getStat()), var12_11, this._monitor);
                                                if (var1_4 != 0) break block96;
                                            }
                                            catch (SQLException v19) {
                                                throw ProtocolQueryExecutor.a(v19);
                                            }
                                        }
                                        ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), false);
                                    }
                                    catch (SQLException v20) {
                                        throw ProtocolQueryExecutor.a(v20);
                                    }
                                }
                                try {
                                    block100: {
                                        try {
                                            try {
                                                try {
                                                    block98: {
                                                        try {
                                                            try {
                                                                if (var16_16[1].getSeverity() == -1) break block98;
                                                                if (!this.a(var11_10, var5_5.getRearmBreaks(), var9_8)) break block99;
                                                            }
                                                            catch (SQLException v21) {
                                                                throw ProtocolQueryExecutor.a(v21);
                                                            }
                                                            this.a(var11_10, var7_7, var6_6, var9_8, 0, var16_16[1].getSeverity(), String.valueOf(var16_16[1].getFixed()), String.valueOf(var15_15[1].getStat()), var12_11, this._monitor);
                                                            if (var1_4 != 0) break block99;
                                                        }
                                                        catch (SQLException v22) {
                                                            throw ProtocolQueryExecutor.a(v22);
                                                        }
                                                    }
                                                    if (var15_15[1].getSeverity() == -1) break block100;
                                                }
                                                catch (SQLException v23) {
                                                    throw ProtocolQueryExecutor.a(v23);
                                                }
                                                if (!this.a(var11_10, var5_5.getRearmBreaks(), var9_8)) break block99;
                                            }
                                            catch (SQLException v24) {
                                                throw ProtocolQueryExecutor.a(v24);
                                            }
                                            this.a(var11_10, var7_7, var6_6, var9_8, 0, var15_15[1].getSeverity(), String.valueOf(var16_16[1].getFixed()), String.valueOf(var15_15[1].getStat()), var12_11, this._monitor);
                                            if (var1_4 != 0) break block99;
                                        }
                                        catch (SQLException v25) {
                                            throw ProtocolQueryExecutor.a(v25);
                                        }
                                    }
                                    ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), true);
                                }
                                catch (SQLException v26) {
                                    throw ProtocolQueryExecutor.a(v26);
                                }
                            }
                            try {
                                if (var1_4 != 0) break block94;
lbl194:
                                // 2 sources

                                if (var6_6 != 2) break block94;
                            }
                            catch (SQLException v27) {
                                throw ProtocolQueryExecutor.a(v27);
                            }
                            var16_16 = this.a(var5_5, var9_8, var10_9, var13_12);
                            try {
                                if (var16_16[0].getSeverity() != -1 && var15_15[0].getSeverity() != -1) {
                                }
                                ** GOTO lbl220
                            }
                            catch (SQLException v28) {
                                throw ProtocolQueryExecutor.a(v28);
                            }
                            var17_17 = 0;
                            if (var16_16[0].getSeverity() <= var15_15[0].getSeverity()) break block104;
                            var17_17 = var16_16[0].getSeverity();
                            if (var1_4 != 0) break block105;
                        }
                        var17_17 = var15_15[0].getSeverity();
                    }
                    try {
                        if (this.a(var11_10, var17_17, var5_5.getArmBreaks(), var9_8)) {
                            this.a(var11_10, var7_7, var6_6, var9_8, 1, var15_15[0].getSeverity(), String.valueOf(var16_16[0].getFixed()), String.valueOf(var15_15[0].getStat()), var12_11, this._monitor);
                        }
                    }
                    catch (SQLException v29) {
                        throw ProtocolQueryExecutor.a(v29);
                    }
                    try {
                        if (var1_4 != 0) break block101;
lbl220:
                        // 2 sources

                        ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), false);
                    }
                    catch (SQLException v30) {
                        throw ProtocolQueryExecutor.a(v30);
                    }
                }
                try {
                    block102: {
                        try {
                            try {
                                try {
                                    if (var16_16[1].getSeverity() == -1 || var15_15[1].getSeverity() == -1) break block102;
                                }
                                catch (SQLException v31) {
                                    throw ProtocolQueryExecutor.a(v31);
                                }
                                if (!this.a(var11_10, var5_5.getRearmBreaks(), var9_8)) break block94;
                            }
                            catch (SQLException v32) {
                                throw ProtocolQueryExecutor.a(v32);
                            }
                            this.a(var11_10, var7_7, var6_6, var9_8, 0, var15_15[1].getSeverity(), String.valueOf(var16_16[1].getFixed()), String.valueOf(var15_15[1].getStat()), var12_11, this._monitor);
                            if (var1_4 != 0) break block94;
                        }
                        catch (SQLException v33) {
                            throw ProtocolQueryExecutor.a(v33);
                        }
                    }
                    ThresholdResultProcessor.resetBreaksCountState(this._hostId, var5_5.getResultTypeId(), true);
                }
                catch (SQLException v34) {
                    throw ProtocolQueryExecutor.a(v34);
                }
            }
            try {
                if (!this._isMultiple) continue;
                ProtocolQueryResultProcessor.updatePeriodIndex(var2_1, this._hostId, this._runDateTime, var5_5.getResultTypeId(), var14_14);
                continue;
            }
            catch (SQLException v35) {
                throw ProtocolQueryExecutor.a(v35);
            }
        }
    }

    private boolean a(int n2) {
        return this._noStartThresholdResultTypes.contains(n2);
    }

    private ProtocolQueryExecutor$StateInfo[] a(Baseline baseline, ResultValue resultValue, boolean bl2, DoubleValue doubleValue) {
        ProtocolQueryExecutor$StateInfo[] protocolQueryExecutor$StateInfoArray;
        block8: {
            MetricsTimebucket metricsTimebucket;
            block11: {
                boolean bl3;
                int n2;
                MetricsTimebucket metricsTimebucket2;
                block10: {
                    block9: {
                        boolean bl4;
                        block7: {
                            int n3 = PerformanceServerUtil.getTimebucketIndex(baseline.getMetricsTimebucketList(), this._runDateTime);
                            metricsTimebucket2 = baseline.getMetricsTimebucket(n3);
                            n2 = ExecutorHelper.b();
                            if (resultValue.isNormal() && bl2) {
                                double d10 = ((Number)resultValue.getValue()).doubleValue();
                                this._resultTypeToCloserThreshold.put(baseline.getResultTypeId(), metricsTimebucket2.getCloserThreshold(d10));
                            }
                            bl4 = PerformanceServerUtil.containsAlarmOrRearmThreshold(metricsTimebucket2.getThresholdList(), false);
                            bl3 = PerformanceServerUtil.containsAlarmOrRearmThreshold(metricsTimebucket2.getThresholdList(), true);
                            protocolQueryExecutor$StateInfoArray = new ProtocolQueryExecutor$StateInfo[]{new ProtocolQueryExecutor$StateInfo(), new ProtocolQueryExecutor$StateInfo()};
                            if (!bl4 || !bl3) break block7;
                            this.a(metricsTimebucket2.getThresholdList(), resultValue, bl2, protocolQueryExecutor$StateInfoArray, doubleValue);
                            if (n2 != 0) break block8;
                        }
                        int n4 = PerformanceServerUtil.getDefaultTimebucketIndex(baseline.getMetricsTimebucketList());
                        metricsTimebucket = baseline.getMetricsTimebucket(n4);
                        if (!bl4) break block9;
                        this.a(metricsTimebucket2.getThresholdList(false), resultValue, bl2, protocolQueryExecutor$StateInfoArray, doubleValue);
                        if (n2 != 0) break block10;
                    }
                    this.a(metricsTimebucket.getThresholdList(false), resultValue, bl2, protocolQueryExecutor$StateInfoArray, doubleValue);
                }
                if (!bl3) break block11;
                this.a(metricsTimebucket2.getThresholdList(true), resultValue, bl2, protocolQueryExecutor$StateInfoArray, doubleValue);
                if (n2 != 0) break block8;
            }
            this.a(metricsTimebucket.getThresholdList(true), resultValue, bl2, protocolQueryExecutor$StateInfoArray, doubleValue);
        }
        return protocolQueryExecutor$StateInfoArray;
    }

    private void a(List list, ResultValue resultValue, boolean bl2, ProtocolQueryExecutor$StateInfo[] protocolQueryExecutor$StateInfoArray, DoubleValue doubleValue) {
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = ExecutorHelper.c();
        int n3 = list.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl5;
            FixedThreshold fixedThreshold = (FixedThreshold)list.get(i2);
            boolean bl6 = fixedThreshold.isClearAlarm();
            if (bl6) {
                if (bl4) {
                    if (n2 == 0) continue;
                }
            } else if (bl3 && n2 == 0) continue;
            if (!(bl5 = this.a(fixedThreshold, resultValue, bl2, bl6, doubleValue))) continue;
            if (bl6) {
                bl4 = true;
                protocolQueryExecutor$StateInfoArray[1].setSeverity(fixedThreshold.getSeverityId());
                protocolQueryExecutor$StateInfoArray[1].setFixed(fixedThreshold.getFixedThreshold());
                if (n2 == 0) continue;
            }
            bl3 = true;
            protocolQueryExecutor$StateInfoArray[0].setSeverity(fixedThreshold.getSeverityId());
            protocolQueryExecutor$StateInfoArray[0].setFixed(fixedThreshold.getFixedThreshold());
            if (n2 == 0) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    private ProtocolQueryExecutor$StateInfo[] a(Baseline var1_1, short var2_2, double var3_3, int var5_4, boolean var6_5) throws SQLException {
        block30: {
            block26: {
                block25: {
                    var8_6 = new ProtocolQueryExecutor$StateInfo[]{new ProtocolQueryExecutor$StateInfo(), new ProtocolQueryExecutor$StateInfo()};
                    var9_7 = var1_1.getResultTypeId();
                    var10_8 = var1_1.getStatThreshold(0).isStddev();
                    var11_9 = -1.0;
                    var7_10 = ExecutorHelper.c();
                    var13_11 = -1.0;
                    var15_12 = this.a(var2_2, var9_7, var1_1.getBaselineConditionId(), var1_1.getBaselineThreshold(), var5_4, var10_8, var6_5);
                    try {
                        if (var15_12 == null) {
                            return var8_6;
                        }
                    }
                    catch (Exception v0) {
                        throw ProtocolQueryExecutor.a(v0);
                    }
                    var11_9 = var15_12[0];
                    var13_11 = var15_12[1];
                    var16_13 = 0.0;
                    if (!var6_5) break block30;
                    var18_14 = var9_7;
                    var19_17 = (StatisticalThreshold)var1_1.getStatThresholdList(false).get(0);
                    try {
                        this._resultTypeToCloserThreshold.put(var18_14, var19_17.getCloserThreshold(var13_11, var11_9, var19_17.getStatisticalConditionId()));
                        if (var13_11 != 0.0) {
                            if (!var10_8) break block25;
                        }
                        ** GOTO lbl35
                    }
                    catch (Exception v1) {
                        throw ProtocolQueryExecutor.a(v1);
                    }
                    var16_13 = (var3_3 - var11_9) / var13_11;
                    if (var7_10 == 0) break block26;
                }
                var16_13 = var3_3 / var13_11;
                try {
                    if (var7_10 == 0) break block26;
lbl35:
                    // 2 sources

                    if (var3_3 < var11_9) {
                    }
                    ** GOTO lbl43
                }
                catch (Exception v2) {
                    throw ProtocolQueryExecutor.a(v2);
                }
                var16_13 = -Infinity;
                try {
                    if (var7_10 == 0) break block26;
lbl43:
                    // 2 sources

                    if (!(var3_3 > var11_9)) break block26;
                }
                catch (Exception v3) {
                    throw ProtocolQueryExecutor.a(v3);
                }
                var16_13 = Infinity;
            }
            this._resultTypeToUserStddev.put(var18_14, new ProtocolQueryExecutor$UserStddev(var16_13, var5_4));
        }
        if (Simulator.isStatTest()) {
            try {
                Simulator.testStddev(var13_11);
            }
            catch (Exception var18_15) {
                this._logger.info((Object)var18_15);
            }
        }
        var18_16 = false;
        var19_18 = false;
        var21_20 = var1_1.getStatThresholdListSize();
        for (var20_19 = 0; var20_19 < var21_20; ++var20_19) {
            block29: {
                block28: {
                    var22_21 = var1_1.getStatThreshold(var20_19);
                    var23_22 = var22_21.isClearAlarm();
                    try {
                        try {
                            block27: {
                                try {
                                    try {
                                        if (!var23_22) break block27;
                                        if (!var19_18) break block28;
                                    }
                                    catch (Exception v4) {
                                        throw ProtocolQueryExecutor.a(v4);
                                    }
                                    if (var7_10 == 0) continue;
                                }
                                catch (Exception v5) {
                                    throw ProtocolQueryExecutor.a(v5);
                                }
                            }
                            if (!var18_16) break block28;
                        }
                        catch (Exception v6) {
                            throw ProtocolQueryExecutor.a(v6);
                        }
                        if (var7_10 == 0) continue;
                    }
                    catch (Exception v7) {
                        throw ProtocolQueryExecutor.a(v7);
                    }
                }
                var24_23 = this.a(var22_21, var3_3, var13_11, var11_9, var6_5, var23_22, var10_8);
                try {
                    if (!var24_23) continue;
                    if (!var23_22) break block29;
                }
                catch (Exception v8) {
                    throw ProtocolQueryExecutor.a(v8);
                }
                var19_18 = true;
                var8_6[1].setSeverity(var22_21.getSeverityId());
                var8_6[1].setStat(var22_21.getStatisticalThreshold());
                if (var7_10 == 0) continue;
            }
            var18_16 = true;
            var8_6[0].setSeverity(var22_21.getSeverityId());
            var8_6[0].setStat(var22_21.getStatisticalThreshold());
            if (var7_10 == 0) continue;
        }
        return var8_6;
    }

    private String a(short s2) {
        String string = null;
        if (s2 != -1) {
            string = FixedThreshold.BASELINE_CONDITIONS[s2];
        }
        return string;
    }

    private double[] a(short s2, int n2, short s3, double d10, int n3, boolean bl2, boolean bl3) throws SQLException {
        block3: {
            String string = this.a(s3);
            int n4 = ProtocolQueryResultProcessor.getResultRecords(s2, this._hostId, n2, string, d10, n3);
            if (n4 > 0) {
                block4: {
                    int n5 = PerformanceConfigProcessor.getMinRecords();
                    try {
                        if (n4 < n5) break block3;
                        if (!bl3) break block4;
                    }
                    catch (SQLException sQLException) {
                        throw ProtocolQueryExecutor.a(sQLException);
                    }
                    int n6 = PerformanceConfigProcessor.getMaxRecords();
                    return ProtocolQueryResultProcessor.getAggregateResultValue(s2, this._hostId, n2, string, d10, n3, n6, bl2);
                }
                return new double[]{0.0, 0.0};
            }
        }
        return null;
    }

    private int a(long l2) {
        long l3 = (this._runDateTime - this._startTime) % this._period;
        long l4 = (this._runDateTime - this._startTime - l3) % l2;
        return (int)(l4 / this._period);
    }

    private boolean a(StatisticalThreshold statisticalThreshold, double d10, double d11, double d12, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        block16: {
            double d13;
            block17: {
                short s2;
                int n2;
                block9: {
                    block11: {
                        double d14;
                        block15: {
                            double d15;
                            block14: {
                                block13: {
                                    block12: {
                                        block10: {
                                            n2 = ExecutorHelper.c();
                                            if (!bl2) {
                                                return !bl3;
                                            }
                                            bl5 = false;
                                            s2 = statisticalThreshold.getStatisticalConditionId();
                                            double d16 = statisticalThreshold.getStatisticalThreshold();
                                            d13 = d16 * d11;
                                            if (!bl4) break block9;
                                            d15 = d12 - d13;
                                            d14 = d12 + d13;
                                            if (s2 != 0) break block10;
                                            if (!(d10 > d14)) break block11;
                                            bl5 = true;
                                            if (n2 == 0) break block11;
                                        }
                                        if (s2 != 4) break block12;
                                        if (!(d10 < d15)) break block11;
                                        bl5 = true;
                                        if (n2 == 0) break block11;
                                    }
                                    if (s2 != 1) break block13;
                                    if (!(d10 > d15)) break block11;
                                    bl5 = true;
                                    if (n2 == 0) break block11;
                                }
                                if (s2 != 2) break block14;
                                if (!(d10 >= d15) || !(d10 <= d14)) break block11;
                                bl5 = true;
                                if (n2 == 0) break block11;
                            }
                            if (s2 != 3) break block15;
                            if (!(d10 > d14) && !(d10 < d15)) break block11;
                            bl5 = true;
                            if (n2 == 0) break block11;
                        }
                        if (s2 == 5 && d10 <= d14) {
                            bl5 = true;
                        }
                    }
                    if (n2 == 0) break block16;
                }
                if (s2 != 0) break block17;
                if (!(d10 > d13)) break block16;
                bl5 = true;
                if (n2 == 0) break block16;
            }
            if (d10 < d13) {
                bl5 = true;
            }
        }
        return bl5;
    }

    private boolean a(FixedThreshold fixedThreshold, ResultValue resultValue, boolean bl2, boolean bl3, DoubleValue doubleValue) {
        boolean bl4;
        block11: {
            String string;
            short s2;
            block19: {
                String[] stringArray;
                double d10;
                int n2;
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block10: {
                                                n2 = ExecutorHelper.b();
                                                if (!resultValue.isNormal()) {
                                                    return !bl3;
                                                }
                                                if (resultValue.isNoThreshold()) {
                                                    return bl3;
                                                }
                                                bl4 = false;
                                                s2 = fixedThreshold.getFixedConditionId();
                                                string = fixedThreshold.getFixedThreshold();
                                                d10 = 0.0;
                                                if (bl2) {
                                                    d10 = ((Number)resultValue.getValue()).doubleValue();
                                                }
                                                if (s2 != 0) break block10;
                                                if (!(d10 > Double.parseDouble(string))) break block11;
                                                bl4 = true;
                                                if (n2 != 0) break block11;
                                            }
                                            if (s2 != 1) break block12;
                                            if (!(d10 >= Double.parseDouble(string))) break block11;
                                            bl4 = true;
                                            if (n2 != 0) break block11;
                                        }
                                        if (s2 != 8) break block13;
                                        if (!(d10 < Double.parseDouble(string))) break block11;
                                        bl4 = true;
                                        if (n2 != 0) break block11;
                                    }
                                    if (s2 != 9) break block14;
                                    if (!(d10 <= Double.parseDouble(string))) break block11;
                                    bl4 = true;
                                    if (n2 != 0) break block11;
                                }
                                if (s2 != 2) break block15;
                                if (d10 != Double.parseDouble(string)) break block11;
                                bl4 = true;
                                if (n2 != 0) break block11;
                            }
                            if (s2 != 7) break block16;
                            if (d10 == Double.parseDouble(string)) break block11;
                            bl4 = true;
                            if (n2 != 0) break block11;
                        }
                        if (s2 != 3) break block17;
                        bl4 = StringUtil.include(string, resultValue.getValue().toString());
                        if (!bl4) break block11;
                        doubleValue.value = -2.012;
                        if (n2 != 0) break block11;
                    }
                    if (s2 != 4) break block18;
                    stringArray = string.replaceAll("[-,~,,,;,|,&,#,:]+", "~").split("~");
                    if (d10 >= Double.parseDouble(stringArray[0].trim()) && d10 < Double.parseDouble(stringArray[1].trim())) {
                        bl4 = true;
                    }
                    if (n2 != 0) break block11;
                }
                if (s2 != 5) break block19;
                stringArray = string.replaceAll("[-,~,,,;,|,&,#,:]+", "~").split("~");
                if (d10 < Double.parseDouble(stringArray[0].trim()) || d10 >= Double.parseDouble(stringArray[1].trim())) {
                    bl4 = true;
                }
                if (n2 != 0) break block11;
            }
            if (s2 == 6) {
                boolean bl5 = bl4 = !StringUtil.include(string, resultValue.getValue().toString());
                if (bl4) {
                    doubleValue.value = -2.012;
                }
            }
        }
        return bl4;
    }

    /*
     * Unable to fully structure code
     */
    private boolean a(int var1_1, short var2_2, short var3_3, ResultValue var4_4) throws SQLException {
        block29: {
            block33: {
                block28: {
                    block27: {
                        block30: {
                            block26: {
                                block32: {
                                    block31: {
                                        var6_5 = 0;
                                        var5_6 = ExecutorHelper.c();
                                        var7_7 = ThresholdResultProcessor.isEmptyBreaks(this._hostId, var1_1, false);
                                        if (!var7_7) break block30;
                                        var8_8 = new short[ITrapConstants.SEVERITIES.length];
                                        if (var3_3 > 1) break block31;
                                        var8_8[var2_2] = -2;
                                        var6_5 = 1;
                                        if (var5_6 == 0) break block32;
                                    }
                                    for (var9_9 = 0; var9_9 <= var2_2; ++var9_9) {
                                        try {
                                            var8_8[var9_9] = 1;
                                            if (var5_6 == 0) {
                                                if (var5_6 == 0) continue;
                                                break;
                                            }
                                            break block26;
                                        }
                                        catch (SQLException v0) {
                                            throw ProtocolQueryExecutor.a(v0);
                                        }
                                    }
                                }
                                ThresholdResultProcessor.storeThresholdResultData(this._hostId, var1_1, false, var8_8);
                            }
                            if (var5_6 == 0) break block33;
                        }
                        var8_8 = ThresholdResultProcessor.getBreaksCount(this._hostId, var1_1, false);
                        var9_9 = ITrapConstants.SEVERITIES.length;
                        var10_10 = -1;
                        for (var11_11 = var9_9 - 1; var11_11 >= 0; --var11_11) {
                            try {
                                v1 = var8_8[var11_11];
                                v2 = -2;
                                if (var5_6 != 0) break block27;
                                if (v1 != v2) continue;
                            }
                            catch (SQLException v3) {
                                throw ProtocolQueryExecutor.a(v3);
                            }
                            var10_10 = var11_11;
                            try {
                                if (var5_6 == 0) break;
                                if (var5_6 == 0) continue;
                                break;
                            }
                            catch (SQLException v4) {
                                throw ProtocolQueryExecutor.a(v4);
                            }
                        }
                        v1 = var2_2;
                        v2 = var10_10;
                    }
                    if (v1 <= v2) break block33;
                    var11_11 = var2_2;
                    while (var11_11 > var10_10) {
                        try {
                            v5 = var8_8[var11_11] + 1;
                            v6 = var3_3;
                            if (var5_6 != 0) break block28;
                            if (v5 >= v6) {
                            }
                            ** GOTO lbl63
                        }
                        catch (SQLException v7) {
                            throw ProtocolQueryExecutor.a(v7);
                        }
                        var8_8[var11_11] = -2;
                        var6_5 = 1;
                        try {
                            if (var5_6 == 0) break;
lbl63:
                            // 2 sources

                            v8 = var11_11--;
                            var8_8[v8] = (short)(var8_8[v8] + 1);
                            if (var5_6 == 0) continue;
                            break;
                        }
                        catch (SQLException v9) {
                            throw ProtocolQueryExecutor.a(v9);
                        }
                    }
                    v5 = var2_2;
                    v6 = 1;
                }
                for (var11_11 = (v1209019) + (v1209020); var11_11 < var9_9; ++var11_11) {
                    try {
                        try {
                            v10 = var11_11;
                            if (var5_6 != 0) break block29;
                            if (v10 <= var10_10) break;
                        }
                        catch (SQLException v11) {
                            throw ProtocolQueryExecutor.a(v11);
                        }
                        var8_8[var11_11] = 0;
                        if (var5_6 == 0) continue;
                        break;
                    }
                    catch (SQLException v12) {
                        throw ProtocolQueryExecutor.a(v12);
                    }
                }
                ThresholdResultProcessor.updateBreaksCountState(this._hostId, var1_1, false, var8_8);
            }
            v10 = var6_5;
        }
        try {
            if (v10 != 0) {
                this.a(var1_1, var4_4, "A");
            }
        }
        catch (SQLException v13) {
            throw ProtocolQueryExecutor.a(v13);
        }
        return (boolean)var6_5;
    }

    /*
     * Unable to fully structure code
     */
    private boolean a(int var1_1, short var2_2, ResultValue var3_3) throws SQLException {
        block12: {
            block11: {
                var5_4 = false;
                var6_5 = var3_3.isBeforeAlarm();
                var4_6 = ExecutorHelper.c();
                if (!var6_5) break block12;
                var7_7 = ThresholdResultProcessor.isEmptyBreaks(this._hostId, var1_1, true);
                try {
                    if (!var7_7) break block11;
                    if (var2_2 <= 1) {
                    }
                    ** GOTO lbl18
                }
                catch (SQLException v0) {
                    throw ProtocolQueryExecutor.a(v0);
                }
                ThresholdResultProcessor.storeThresholdResultData(this._hostId, var1_1, true, new short[]{0});
                ThresholdResultProcessor.resetBreaksCountState(this._hostId, var1_1);
                var5_4 = true;
                try {
                    if (var4_6 == 0) break block12;
lbl18:
                    // 2 sources

                    ThresholdResultProcessor.storeThresholdResultData(this._hostId, var1_1, true, new short[]{1});
                    if (var4_6 == 0) break block12;
                }
                catch (SQLException v1) {
                    throw ProtocolQueryExecutor.a(v1);
                }
            }
            if ((var8_8 = ThresholdResultProcessor.getBreaksCount(this._hostId, var1_1, true))[0] + 1 < var2_2) ** GOTO lbl29
            ThresholdResultProcessor.resetBreaksCountState(this._hostId, var1_1);
            var5_4 = true;
            try {
                if (var4_6 == 0) break block12;
lbl29:
                // 2 sources

                var8_8[0] = (short)(var8_8[0] + 1);
                ThresholdResultProcessor.updateBreaksCountState(this._hostId, var1_1, true, var8_8);
            }
            catch (SQLException v2) {
                throw ProtocolQueryExecutor.a(v2);
            }
        }
        try {
            if (var5_4) {
                this.a(var1_1, var3_3, "R");
            }
        }
        catch (SQLException v3) {
            throw ProtocolQueryExecutor.a(v3);
        }
        return var5_4;
    }

    /*
     * Unable to fully structure code
     */
    private void a(int var1_1, double var2_2, short var4_3, ResultValue var5_4, int var6_5, int var7_6, String var8_7, String var9_8, boolean var10_9, Monitor var11_10) throws SQLException {
        block25: {
            block26: {
                block29: {
                    block24: {
                        block23: {
                            var12_11 = ExecutorHelper.c();
                            if (var6_5 != 0) ** GOTO lbl10
                            try {
                                block28: {
                                    var5_4.setThresholdState("R");
                                    if (var12_11 == 0) break block23;
                                    break block28;
                                    catch (Exception v0) {
                                        throw ProtocolQueryExecutor.a(v0);
                                    }
                                }
                                var5_4.setThresholdState("A");
                            }
                            catch (Exception v1) {
                                throw ProtocolQueryExecutor.a(v1);
                            }
                        }
                        var13_12 = new aC();
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.20.0", (SnmpDataType)new ac(this._id)));
                        var14_13 = MonitorProcessor.getScheduleName(this._id);
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.21.0", (SnmpDataType)new I18NOctetString(var14_13)));
                        var15_14 = null;
                        var15_14 = MonitorHost.isMultiHosts(this._hostName) != false ? MonitorHost.getMetricsHost(this._hostName, ExecutorHelper.getName(var1_1)) : this._hostName;
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.22.0", (SnmpDataType)new I18NOctetString(var15_14)));
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.23.0", (SnmpDataType)new ac(var1_1)));
                        if (!var10_9) {
                            var6_5 = 2;
                        }
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.24.0", (SnmpDataType)new ac(var6_5)));
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.25.0", (SnmpDataType)new ac(var7_6)));
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.26.0", (SnmpDataType)new ac(var4_3)));
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.27.0", (SnmpDataType)new I18NOctetString(var8_7)));
                        var16_15 = String.valueOf(var2_2);
                        try {
                            if (var10_9) break block24;
                            var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.28.0", (SnmpDataType)new I18NOctetString("N/A")));
                            var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.29.0", (SnmpDataType)new I18NOctetString(var9_8)));
                            var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.30.0", (SnmpDataType)new I18NOctetString("N/A")));
                            var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.31.0", (SnmpDataType)new I18NOctetString(var5_4.getErrorUnknownMessage())));
                            if (var12_11 == 0) break block25;
                        }
                        catch (Exception v2) {
                            throw ProtocolQueryExecutor.a(v2);
                        }
                    }
                    var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.28.0", (SnmpDataType)new I18NOctetString(ProtocolQueryResult.getGraceValue(var16_15, 3))));
                    var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.29.0", (SnmpDataType)new I18NOctetString(var9_8)));
                    var17_16 = this.getUserStddev(var1_1);
                    if (var17_16 == null) ** GOTO lbl59
                    if (var17_16.getPeriodIndex() == -1) ** GOTO lbl59
                    break block29;
                    catch (Exception v3) {
                        throw ProtocolQueryExecutor.a(v3);
                    }
                }
                try {
                    block30: {
                        var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.30.0", (SnmpDataType)new I18NOctetString(ProtocolQueryResult.getUserStddevText(var17_16.getUserStddev()))));
                        if (var12_11 == 0) break block26;
                        break block30;
                        catch (Exception v4) {
                            throw ProtocolQueryExecutor.a(v4);
                        }
                    }
                    var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.30.0", (SnmpDataType)new I18NOctetString("N/A")));
                }
                catch (Exception v5) {
                    throw ProtocolQueryExecutor.a(v5);
                }
            }
            var13_12.add(new SnmpVarBind(".1.3.6.1.4.1.15145.100.31.0", (SnmpDataType)new I18NOctetString("")));
        }
        try {
            block27: {
                block32: {
                    block31: {
                        var17_16 = new a0(".1.3.6.1.4.1.15145.100");
                        var17_16.setGeneric(6);
                        var18_18 = InetAddress.getByName(var15_14);
                        var17_16.setIpAddress(var18_18);
                        if (var6_5 != 1) ** GOTO lbl80
                        var17_16.setSpecific(1001);
                        if (var12_11 == 0) break block27;
                        break block31;
                        catch (Exception v6) {
                            throw ProtocolQueryExecutor.a(v6);
                        }
                    }
                    if (var6_5 != 2) ** GOTO lbl93
                    break block32;
                    catch (Exception v7) {
                        throw ProtocolQueryExecutor.a(v7);
                    }
                }
                try {
                    block33: {
                        var17_16.setSpecific(1002);
                        if (var12_11 == 0) break block27;
                        break block33;
                        catch (Exception v8) {
                            throw ProtocolQueryExecutor.a(v8);
                        }
                    }
                    var17_16.setSpecific(1000);
                }
                catch (Exception v9) {
                    throw ProtocolQueryExecutor.a(v9);
                }
            }
            var17_16.addVarBinds(var13_12);
            TrapReceiver.processInternalTrap((h)var17_16, var6_5, var11_10);
        }
        catch (Exception var17_17) {
            this._logger.error((Object)"Trap receiver on process intertrap method ", (Throwable)var17_17);
        }
    }

    @Override
    public IProtocolQueryExecutor$IUserStddev getUserStddev(Integer n2) {
        return (IProtocolQueryExecutor$IUserStddev)this._resultTypeToUserStddev.get(n2);
    }

    @Override
    public CloserThreshold getCloserThreshold(Integer n2) {
        return this._resultTypeToCloserThreshold.get(n2);
    }

    private void a(int n2, ResultValue resultValue, String string) throws SQLException {
        resultValue.setThresholdState(string);
        ProtocolQueryResultProcessor.updateThresholdState(this._monitor.getProtocolType(), this._hostId, this._runDateTime, n2, string);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

