/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.MonitorHost;
import com.sysuptime.common.performance.MonitorSnapshot;
import com.sysuptime.common.performance.ProtocolQueryResult;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.server.msp.Command;
import com.sysuptime.server.msp.ProbeDao;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.MonitorCache;
import com.sysuptime.server.performance.ProtocolQueryResultReader$CountKey;
import com.sysuptime.server.performance.ProtocolQueryResultReader$DataStruct;
import com.sysuptime.server.performance.ProtocolQueryResultReader$ScheduleHostMetrics;
import com.sysuptime.server.performance.ReportMonitorBean;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.ServerBundle;
import com.sysuptime.server.util.ServerPropertiesFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProtocolQueryResultReader {
    private static final Logger _logger = Logger.getLogger((String)ProtocolQueryResultReader.class.getName());
    public static final String NORMAL_CONDITION = " WHERE SCHEDULE_HOST_ID_C=? AND RESULT_TYPE_ID_C=? AND PERIOD_INDEX_C=? AND ERROR_CODE_C=? AND THRESHOLD_STATE_C<>? AND THRESHOLD_STATE_C<>? ";
    private static String _stddev = ServerBundle.getSqlStatement("stddev");

    private ProtocolQueryResultReader() {
    }

    public static double getResultValue(Connection connection, String string, long l2, int n2) throws SQLException {
        double d10 = 0.0;
        PreparedStatement preparedStatement = null;
        try {
            String string2 = "SELECT RESULT_VALUE_C FROM " + string + " WHERE SCHEDULE_HOST_ID_C=? AND RESULT_TYPE_ID_C=? ";
            preparedStatement = connection.prepareStatement(string2);
            preparedStatement.setLong(1, l2);
            preparedStatement.setInt(2, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                d10 = resultSet.getDouble(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_protocol_result to get value " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return d10;
    }

    public static int getResultRows(Connection connection, String string, long l2, int n2, String string2, double d10, int n3) throws SQLException {
        int n4 = 0;
        PreparedStatement preparedStatement = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT COUNT(*) FROM ");
            try {
                stringBuffer.append(string);
                stringBuffer.append(NORMAL_CONDITION);
                if (string2 != null) {
                    stringBuffer.append("AND RESULT_VALUE_C ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" ?");
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            try {
                preparedStatement.setLong(1, l2);
                preparedStatement.setInt(2, n2);
                preparedStatement.setInt(3, n3);
                preparedStatement.setString(4, "N");
                preparedStatement.setString(5, "A");
                preparedStatement.setString(6, "B");
                if (string2 != null) {
                    preparedStatement.setDouble(7, d10);
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n4 = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_protocol_result to get records count " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return n4;
    }

    public static double getResultValueAvg(Connection connection, String string, long l2, int n2, String string2, double d10, int n3, int n4) throws SQLException {
        return ProtocolQueryResultReader.a(connection, string, l2, n2, string2, d10, n3, n4, "AVG");
    }

    public static double getResultValueStddev(Connection connection, String string, long l2, int n2, String string2, double d10, int n3, int n4) throws SQLException {
        return ProtocolQueryResultReader.a(connection, string, l2, n2, string2, d10, n3, n4, _stddev);
    }

    private static double a(Connection connection, String string, long l2, int n2, String string2, double d10, int n3, int n4, String string3) throws SQLException {
        double d11 = 0.0;
        PreparedStatement preparedStatement = null;
        try {
            StringBuffer stringBuffer = new StringBuffer("SELECT ");
            stringBuffer.append(string3);
            stringBuffer.append("(RS.RESULT_VALUE_C) FROM (");
            StringBuffer stringBuffer2 = new StringBuffer("RESULT_VALUE_C FROM ");
            try {
                stringBuffer2.append(string);
                stringBuffer2.append(NORMAL_CONDITION);
                if (string2 != null) {
                    stringBuffer2.append(" AND RESULT_VALUE_C ");
                    stringBuffer2.append(string2);
                    stringBuffer2.append(" ? ");
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            stringBuffer2.append(" ");
            stringBuffer.append(ServerBundle.getSqlString(stringBuffer2.toString(), n4));
            stringBuffer.append(" ) RS ");
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            try {
                preparedStatement.setMaxRows(n4);
                preparedStatement.setLong(1, l2);
                preparedStatement.setInt(2, n2);
                preparedStatement.setInt(3, n3);
                preparedStatement.setString(4, "N");
                preparedStatement.setString(5, "A");
                preparedStatement.setString(6, "B");
                if (string2 != null) {
                    preparedStatement.setDouble(7, d10);
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                d11 = resultSet.getDouble(1);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Read pm_protocol_result to get stddev " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return d11;
    }

    /*
     * Unable to fully structure code
     */
    public static List getQueryResult(Connection var0, String var1_1, long var2_2, int var4_3, long var5_4, long var7_5, int var9_6) throws SQLException {
        block17: {
            var11_7 = null;
            var12_8 = new ArrayList<ProtocolQueryResult>();
            var10_9 = ExecutorHelper.b();
            try {
                block16: {
                    var13_10 = new StringBuffer("SELECT RUN_DATE_TIME_C, RESULT_VALUE_C, THRESHOLD_STATE_C, ERROR_CODE_C FROM ");
                    var13_10.append(var1_1);
                    var13_10.append(" WHERE SCHEDULE_HOST_ID_C=? AND RESULT_TYPE_ID_C=? ");
                    if (var9_6 >= 0) ** GOTO lbl19
                    try {
                        block19: {
                            var13_10.append(" AND RUN_DATE_TIME_C>=? AND RUN_DATE_TIME_C<=? ORDER BY RUN_DATE_TIME_C");
                            if (var10_9 != 0) break block16;
                            break block19;
                            catch (SQLException v0) {
                                throw ProtocolQueryResultReader.a(v0);
                            }
                        }
                        var13_10.append(" order by run_date_time_c desc limit " + var9_6);
                    }
                    catch (SQLException v1) {
                        throw ProtocolQueryResultReader.a(v1);
                    }
                }
                ProtocolQueryResultReader._logger.info((Object)("ScheduleHostID:" + var2_2 + ". ProtocolQueryResultReader.getQueryResult.SQL:" + var13_10));
                var11_7 = var0.prepareStatement(var13_10.toString());
                try {
                    var11_7.setLong(1, var2_2);
                    var11_7.setInt(2, var4_3);
                    if (var9_6 < 0) {
                        var11_7.setLong(3, var5_4);
                        var11_7.setLong(4, var7_5);
                    }
                }
                catch (SQLException v2) {
                    throw ProtocolQueryResultReader.a(v2);
                }
                var14_12 = var11_7.executeQuery();
                while (var14_12.next()) {
                    block18: {
                        var15_13 = TargetFactory.getProtocolResult();
                        var15_13.setScheduleHostId(var2_2);
                        var15_13.setResultTypeId(var4_3);
                        var15_13.setRunDateTime(var14_12.getLong(1));
                        var16_14 = var14_12.getDouble(2);
                        var15_13.setThresholdState(var14_12.getString(3));
                        var18_15 = var14_12.getString(4);
                        var15_13.setResultState(var18_15);
                        var15_13.setResultValue(var16_14, var18_15);
                        if (var10_9 == 0) break block17;
                        try {
                            block20: {
                                if ("N".equals(var18_15)) break block18;
                                break block20;
                                catch (SQLException v3) {
                                    throw ProtocolQueryResultReader.a(v3);
                                }
                            }
                            var15_13.setErrorCodeText(ServerBundle.getMessage(String.valueOf((long)var16_14)));
                        }
                        catch (SQLException v4) {
                            throw ProtocolQueryResultReader.a(v4);
                        }
                    }
                    var12_8.add(var15_13);
                    if (var10_9 != 0) continue;
                }
            }
            catch (SQLException var13_11) {
                try {
                    throw new SQLException("Read pm_protocol_query_result to get data list " + var13_11);
                }
                catch (Throwable var19_16) {
                    DefaultConnection.closeStatement(var11_7);
                    throw var19_16;
                }
            }
            DefaultConnection.closeStatement(var11_7);
        }
        return var12_8;
    }

    public static List getRecentQueryResults(Connection connection, long l2, long l3) throws SQLException {
        return ProtocolQueryResultReader.getRecentQueryResults(connection, l2, l3, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List getRecentQueryResults(Connection var0, long var1_1, long var3_2, String var5_3, boolean var6_4) throws SQLException {
        block22: {
            var8_5 = null;
            var9_6 = new ArrayList<MonitorSnapshot>();
            var10_7 = System.currentTimeMillis() - var3_2;
            var12_8 = new StringBuffer();
            var7_9 = ExecutorHelper.b();
            try {
                var12_8.append("select g.group_id_c, g.group_name_c, s.schedule_id_c, s.schedule_name_c, h.ip_address_c, h.schedule_host_id_c, q.protocol_type_c, m.result_type_id_c ").append("from pm_schedule s inner join pm_group g on g.group_id_c=s.group_id_c ").append("inner join pm_protocol_query q on s.schedule_id_c=q.schedule_id_c ").append("inner join pm_schedule_host h on h.schedule_id_c=s.schedule_id_c ").append("inner join pm_metrics m on m.schedule_id_c=s.schedule_id_c ").append("where s.is_expired_c='N' AND s.is_suspended_c='N' ");
                if (var5_3 != null) {
                    var12_8.append(" AND s.schedule_id_c IN ").append(var5_3);
                }
            }
            catch (SQLException v0) {
                throw ProtocolQueryResultReader.a(v0);
            }
            try {
                if (var1_1 != -2L) {
                    var12_8.append(" AND G.GROUP_ID_C=").append(var1_1);
                }
            }
            catch (SQLException v1) {
                throw ProtocolQueryResultReader.a(v1);
            }
            var8_5 = var0.prepareStatement(var12_8.toString());
            try {
                var13_10 = var8_5.executeQuery();
                while (var13_10.next()) {
                    block23: {
                        block24: {
                            var14_13 = new MonitorSnapshot();
                            var15_14 = var13_10.getLong(1);
                            var14_13.setGroupId(var13_10.getInt(1));
                            if (var7_9 == 0) break block22;
                            if (var15_14 != -1L) ** GOTO lbl43
                            break block24;
                            catch (SQLException v2) {
                                throw ProtocolQueryResultReader.a(v2);
                            }
                        }
                        try {
                            block25: {
                                var14_13.setGroupName(Snippet.getBundledString(var13_10.getString(2)));
                                if (var7_9 != 0) break block23;
                                break block25;
                                catch (SQLException v3) {
                                    throw ProtocolQueryResultReader.a(v3);
                                }
                            }
                            var14_13.setGroupName(var13_10.getString(2));
                        }
                        catch (SQLException v4) {
                            throw ProtocolQueryResultReader.a(v4);
                        }
                    }
                    var14_13.setMonitorName(var13_10.getString(4));
                    var17_15 = var13_10.getInt(3);
                    var14_13.setScheduleId(var17_15);
                    var18_16 = var13_10.getString(5);
                    var19_17 = var13_10.getLong(6);
                    var14_13.setScheduleHostId(var19_17);
                    var21_18 = var13_10.getInt(7);
                    var22_19 = var13_10.getInt(8);
                    if (ServerPropertiesFile.isMaster()) {
                        var23_20 = ProbeDao.getInstance().getProbe(var17_15).getName();
                        var14_13.setProbeName(var23_20);
                    }
                    if (ProtocolQueryResultReader.a(var0, var23_20 = ExecutorHelper.getResultTableName(var21_18), var14_13, var19_17, var10_7, var22_19, var6_4)) {
                        var24_21 = ExecutorHelper.getName(var22_19);
                        if (MonitorHost.isMultiHosts(var18_16)) {
                            var18_16 = MonitorHost.getMetricsHost(var18_16, var24_21);
                        }
                        var14_13.setHostName(var18_16);
                        var14_13.setLocaleMetricsName(Snippet.getBundledString(var24_21));
                        var9_6.add(var14_13);
                    }
                    if (var7_9 != 0) continue;
                    break;
                }
            }
            catch (SQLException var13_11) {
                ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var13_11);
                throw new SQLException("Read pm_protocol_query_result to get snapshot" + var13_11);
            }
            catch (Exception var13_12) {
                ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var13_12);
            }
            finally {
                DefaultConnection.closeStatement(var8_5);
            }
        }
        return var9_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List getTopNQueryResults(Connection var0, int[] var1_1, int var2_2, int var3_3, String var4_4, int var5_5, boolean var6_6) throws SQLException {
        block36: {
            block34: {
                block33: {
                    var8_7 = null;
                    var9_8 = new ArrayList<Object>();
                    var10_9 = new StringBuffer();
                    var7_10 = ExecutorHelper.b();
                    var10_9.append("select g.group_id_c, g.group_name_c, s.schedule_id_c, s.schedule_name_c, h.ip_address_c, h.schedule_host_id_c, q.protocol_type_c, m.result_type_id_c ").append("from pm_schedule s inner join pm_group g on g.group_id_c=s.group_id_c ").append("inner join pm_protocol_query q on s.schedule_id_c=q.schedule_id_c ").append("inner join pm_schedule_host h on h.schedule_id_c=s.schedule_id_c ").append("inner join pm_metrics m on m.schedule_id_c=s.schedule_id_c ").append("where s.is_expired_c='N' AND s.is_suspended_c='N' ");
                    if (var4_4 == null) break block33;
                    try {
                        block38: {
                            if (var4_4.length() <= 0) break block33;
                            break block38;
                            catch (SQLException v0) {
                                throw ProtocolQueryResultReader.a(v0);
                            }
                        }
                        var10_9.append(" AND h.ip_address_c='").append(var4_4).append("'");
                    }
                    catch (SQLException v1) {
                        throw ProtocolQueryResultReader.a(v1);
                    }
                }
                try {
                    if (var2_2 > 0) {
                        var10_9.append(" AND q.protocol_type_c=").append(var2_2);
                    }
                }
                catch (SQLException v2) {
                    throw ProtocolQueryResultReader.a(v2);
                }
                try {
                    if (var3_3 > 0) {
                        var10_9.append(" AND m.result_type_id_c=").append(var3_3);
                    }
                }
                catch (SQLException v3) {
                    throw ProtocolQueryResultReader.a(v3);
                }
                if (var1_1 == null) break block34;
                var11_11 = null;
                for (int var15_18 : var1_1) {
                    block35: {
                        try {
                            v4 = var11_11;
                            if (var7_10 == 0) break block34;
                            if (v4 == null) {
                            }
                            ** GOTO lbl49
                        }
                        catch (SQLException v5) {
                            throw ProtocolQueryResultReader.a(v5);
                        }
                        var11_11 = new StringBuffer("(");
                        try {
                            if (var7_10 != 0) break block35;
lbl49:
                            // 2 sources

                            var11_11.append(",");
                        }
                        catch (SQLException v6) {
                            throw ProtocolQueryResultReader.a(v6);
                        }
                    }
                    var11_11.append(var15_18);
                    if (var7_10 != 0) continue;
                }
                var11_11.append(")");
                v4 = var10_9.append(" AND s.GROUP_ID_C IN ").append(var11_11.toString());
            }
            var8_7 = var0.prepareStatement(var10_9.toString());
            try {
                var11_11 = var8_7.executeQuery();
                while (var11_11.next()) {
                    block37: {
                        block39: {
                            var12_14 = new MonitorSnapshot();
                            var13_16 = var11_11.getLong(1);
                            var12_14.setGroupId(var11_11.getInt(1));
                            if (var7_10 == 0) break block36;
                            if (var13_16 != -1L) ** GOTO lbl83
                            break block39;
                            catch (SQLException v7) {
                                throw ProtocolQueryResultReader.a(v7);
                            }
                        }
                        try {
                            block40: {
                                var12_14.setGroupName(Snippet.getBundledString(var11_11.getString(2)));
                                if (var7_10 != 0) break block37;
                                break block40;
                                catch (SQLException v8) {
                                    throw ProtocolQueryResultReader.a(v8);
                                }
                            }
                            var12_14.setGroupName(var11_11.getString(2));
                        }
                        catch (SQLException v9) {
                            throw ProtocolQueryResultReader.a(v9);
                        }
                    }
                    var12_14.setMonitorName(var11_11.getString(4));
                    var15_18 = var11_11.getInt(3);
                    var12_14.setScheduleId(var15_18);
                    var16_19 = var11_11.getString(5);
                    var17_20 = var11_11.getLong(6);
                    var12_14.setScheduleHostId(var17_20);
                    var2_2 = var11_11.getInt(7);
                    var19_21 = var11_11.getInt(8);
                    if (ServerPropertiesFile.isMaster()) {
                        var20_22 = ProbeDao.getInstance().getProbe(var15_18).getName();
                        var12_14.setProbeName(var20_22);
                    }
                    if (ProtocolQueryResultReader.a(var0, var20_22 = ExecutorHelper.getResultTableName(var2_2), (MonitorSnapshot)var12_14, var17_20, var5_5, var19_21, var6_6)) {
                        var21_23 = ExecutorHelper.getName(var19_21);
                        if (MonitorHost.isMultiHosts(var16_19)) {
                            var16_19 = MonitorHost.getMetricsHost(var16_19, var21_23);
                        }
                        var12_14.setHostName(var16_19);
                        var12_14.setLocaleMetricsName(Snippet.getBundledString(var21_23));
                        var9_8.add(var12_14);
                    }
                    if (var7_10 != 0) continue;
                    break;
                }
            }
            catch (SQLException var11_12) {
                ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var11_12);
                throw new SQLException("Read pm_protocol_query_result to get snapshot" + var11_12);
            }
            catch (Exception var11_13) {
                ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var11_13);
            }
            finally {
                DefaultConnection.closeStatement(var8_7);
            }
        }
        return var9_8;
    }

    /*
     * Unable to fully structure code
     */
    public static List getMonitorSnapshots(Connection var0, String[] var1_1, long var2_2) throws SQLException {
        block21: {
            block20: {
                var5_3 = null;
                var6_4 = new ArrayList<MonitorSnapshot>();
                var4_5 = ExecutorHelper.c();
                var7_6 = System.currentTimeMillis() - var2_2;
                var9_7 = new StringBuffer();
                var9_7.append("select g.group_id_c, g.group_name_c, s.schedule_id_c, s.schedule_name_c, h.ip_address_c, h.schedule_host_id_c, q.protocol_type_c, m.result_type_id_c ").append("from pm_schedule s inner join pm_group g on g.group_id_c=s.group_id_c ").append("inner join pm_protocol_query q on s.schedule_id_c=q.schedule_id_c ").append("inner join pm_schedule_host h on h.schedule_id_c=s.schedule_id_c ").append("inner join pm_metrics m on m.schedule_id_c=s.schedule_id_c ").append("where s.is_expired_c='N' AND s.is_suspended_c='N'");
                if (var1_1.length > 0) {
                    var9_7.append(" AND (h.ip_address_c='").append(var1_1[0]).append("'");
                    for (var10_8 = 1; var10_8 < var1_1.length; ++var10_8) {
                        try {
                            var9_7.append(" OR h.ip_address_c='").append(var1_1[var10_8]).append("'");
                            if (var4_5 == 0) {
                                if (var4_5 == 0) continue;
                                break;
                            }
                            break block20;
                        }
                        catch (SQLException v0) {
                            throw ProtocolQueryResultReader.a(v0);
                        }
                    }
                    var9_7.append(")");
                }
            }
            var5_3 = var0.prepareStatement(var9_7.toString());
            try {
                var10_9 = var5_3.executeQuery();
                while (var10_9.next()) {
                    block22: {
                        block23: {
                            var11_11 = new MonitorSnapshot();
                            var12_12 = var10_9.getLong(1);
                            var11_11.setGroupId(var10_9.getInt(1));
                            if (var4_5 != 0) break block21;
                            if (var12_12 != -1L) ** GOTO lbl45
                            break block23;
                            catch (SQLException v1) {
                                throw ProtocolQueryResultReader.a(v1);
                            }
                        }
                        try {
                            block24: {
                                var11_11.setGroupName(Snippet.getBundledString(var10_9.getString(2)));
                                if (var4_5 == 0) break block22;
                                break block24;
                                catch (SQLException v2) {
                                    throw ProtocolQueryResultReader.a(v2);
                                }
                            }
                            var11_11.setGroupName(var10_9.getString(2));
                        }
                        catch (SQLException v3) {
                            throw ProtocolQueryResultReader.a(v3);
                        }
                    }
                    var11_11.setMonitorName(var10_9.getString(4));
                    var14_13 = var10_9.getInt(3);
                    var11_11.setScheduleId(var14_13);
                    var15_14 = var10_9.getString(5);
                    var16_15 = var10_9.getLong(6);
                    var11_11.setScheduleHostId(var16_15);
                    var18_16 = var10_9.getInt(7);
                    var19_17 = var10_9.getInt(8);
                    if (ServerPropertiesFile.isMaster()) {
                        var20_18 = ProbeDao.getInstance().getProbe(var14_13).getName();
                        var11_11.setProbeName(var20_18);
                    }
                    if (ProtocolQueryResultReader.a(var0, var20_18 = ExecutorHelper.getResultTableName(var18_16), var11_11, var16_15, var7_6, var19_17, false)) {
                        var21_19 = ExecutorHelper.getName(var19_17);
                        if (MonitorHost.isMultiHosts(var15_14)) {
                            var15_14 = MonitorHost.getMetricsHost(var15_14, var21_19);
                        }
                        var11_11.setHostName(var15_14);
                        var11_11.setLocaleMetricsName(Snippet.getBundledString(var21_19));
                        var6_4.add(var11_11);
                    }
                    if (var4_5 == 0) continue;
                    break;
                }
            }
            catch (SQLException var10_10) {
                ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var10_10);
                throw new SQLException("Read pm_protocol_query_result to get snapshot" + var10_10);
            }
            finally {
                DefaultConnection.closeStatement(var5_3);
            }
        }
        return var6_4;
    }

    private static void a(Connection connection, String string, long l2, ProtocolQueryResultReader$DataStruct protocolQueryResultReader$DataStruct, long l3, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        protocolQueryResultReader$DataStruct.runTime = l2;
        try {
            String string2 = "SELECT  result_value_c , error_code_c, threshold_state_c from " + string + " where run_date_time_c=" + l2 + " AND schedule_host_id_c=" + l3 + " AND result_type_id_c=" + n2;
            preparedStatement = connection.prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                if (resultSet.next()) {
                    protocolQueryResultReader$DataStruct.value = resultSet.getDouble(1);
                    protocolQueryResultReader$DataStruct.errorCode = resultSet.getString(2);
                    protocolQueryResultReader$DataStruct.state = resultSet.getString(3);
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("fetchLastResult error: " + sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    private static ProtocolQueryResultReader$DataStruct a(Connection connection, String string, boolean bl2, long l2, long l3, int n2) throws SQLException {
        ProtocolQueryResultReader$DataStruct protocolQueryResultReader$DataStruct;
        PreparedStatement preparedStatement = null;
        try {
            ProtocolQueryResultReader$DataStruct protocolQueryResultReader$DataStruct2 = new ProtocolQueryResultReader$DataStruct();
            int n3 = 0;
            long l4 = 0L;
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("SELECT COUNT(*) ");
                if (!bl2) {
                    stringBuffer.append(", MAX(RUN_DATE_TIME_C) ");
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            try {
                stringBuffer.append(" from ").append(string).append(" where schedule_host_id_c=").append(l2).append(" AND RUN_DATE_TIME_C > ").append(l3).append(" AND ");
                stringBuffer.append(" PERIOD_INDEX_C <> ").append(-2).append(" AND result_type_id_c=").append(n2);
                if (bl2) {
                    stringBuffer.append(" AND THRESHOLD_STATE_C<> '").append("N").append("'");
                    stringBuffer.append(" AND THRESHOLD_STATE_C<> '").append("R").append("'");
                }
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            preparedStatement = connection.prepareStatement(stringBuffer.toString());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n3 = resultSet.getInt(1);
                if (!bl2) {
                    l4 = resultSet.getLong(2);
                    ProtocolQueryResultReader.a(connection, string, l4, protocolQueryResultReader$DataStruct2, l2, n2);
                }
                protocolQueryResultReader$DataStruct2.count = n3;
            }
            protocolQueryResultReader$DataStruct = protocolQueryResultReader$DataStruct2;
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Get count error:" + sQLException);
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return protocolQueryResultReader$DataStruct;
    }

    /*
     * Loose catch block
     */
    private static boolean a(Connection connection, String string, MonitorSnapshot monitorSnapshot, long l2, int n2, int n3, boolean bl2) throws SQLException {
        try {
            block9: {
                String string2;
                block10: {
                    int n4 = ProtocolQueryResultReader.a(connection, string, monitorSnapshot, l2, n2, n3);
                    if (n4 == 0) {
                        return false;
                    }
                    string2 = monitorSnapshot.getThresholdState();
                    if (!bl2) break block9;
                    if ("E".equals(string2)) break block9;
                    break block10;
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                }
                try {
                    block11: {
                        if ("A".equals(string2)) break block9;
                        break block11;
                        catch (SQLException sQLException) {
                            throw ProtocolQueryResultReader.a(sQLException);
                        }
                    }
                    if ("B".equals(string2)) break block9;
                }
                catch (SQLException sQLException) {
                    throw ProtocolQueryResultReader.a(sQLException);
                }
                return false;
            }
            monitorSnapshot.setResultTypeId(n3);
        }
        catch (SQLException sQLException) {
            throw new SQLException("fetchAlarmRate: " + sQLException);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static int a(Connection var0, String var1_1, MonitorSnapshot var2_2, long var3_3, int var5_4, int var6_5) throws SQLException {
        var8_6 = null;
        var7_7 = ExecutorHelper.c();
        try {
            block21: {
                block18: {
                    var9_8 = new StringBuffer();
                    var9_8.append("SELECT result_value_c, error_code_c, threshold_state_c, RUN_DATE_TIME_C ");
                    var9_8.append(" from ").append(var1_1).append(" where schedule_host_id_c=").append(var3_3).append(" AND error_code_c <> '").append("U");
                    var9_8.append("' AND PERIOD_INDEX_C <> ").append(-2).append(" AND result_type_id_c=").append(var6_5);
                    var9_8.append(" order by run_date_time_c desc limit " + var5_4);
                    var8_6 = var0.prepareStatement(var9_8.toString());
                    var10_10 = var8_6.executeQuery();
                    var11_11 = 0;
                    var12_12 = 0;
                    var13_13 = new ArrayList<Double>();
                    while (var10_10.next()) {
                        block20: {
                            block19: {
                                var14_14 = var10_10.getDouble(1);
                                var15_16 = var10_10.getString(2);
                                var16_17 = var10_10.getString(3);
                                if (var7_7 != 0) break block18;
                                try {
                                    block22: {
                                        if (var11_11 != 0) break block19;
                                        break block22;
                                        catch (SQLException v0) {
                                            throw ProtocolQueryResultReader.a(v0);
                                        }
                                    }
                                    var2_2.setResultValue(var14_14, var15_16);
                                    var2_2.setThresholdState(var16_17);
                                    var2_2.setRunDateTime(var10_10.getLong(4));
                                }
                                catch (SQLException v1) {
                                    throw ProtocolQueryResultReader.a(v1);
                                }
                            }
                            if (var16_17.equals("N")) break block20;
                            try {
                                block23: {
                                    if (var16_17.equals("R")) break block20;
                                    break block23;
                                    catch (SQLException v2) {
                                        throw ProtocolQueryResultReader.a(v2);
                                    }
                                }
                                ++var12_12;
                            }
                            catch (SQLException v3) {
                                throw ProtocolQueryResultReader.a(v3);
                            }
                        }
                        try {
                            if (!"E".equals(var15_16)) {
                                var13_13.add(var14_14);
                            }
                        }
                        catch (SQLException v4) {
                            throw ProtocolQueryResultReader.a(v4);
                        }
                        ++var11_11;
                        if (var7_7 == 0) continue;
                    }
                    Collections.reverse(var13_13);
                    var2_2.setValues(var13_13);
                }
                var14_15 = 1.0;
                if (var11_11 <= 0) ** GOTO lbl67
                var14_15 = (double)var12_12 / ((double)var11_11 * 1.0);
                try {
                    if (var7_7 == 0) break block21;
lbl67:
                    // 2 sources

                    if (var12_12 != 0) break block21;
                }
                catch (SQLException v5) {
                    throw ProtocolQueryResultReader.a(v5);
                }
                var14_15 = 0.0;
            }
            var2_2.setAlarmsPertentage(var14_15);
            var16_18 = var11_11;
        }
        catch (SQLException var9_9) {
            try {
                throw new SQLException("Get count error:" + var9_9);
            }
            catch (Throwable var17_19) {
                DefaultConnection.closeStatement(var8_6);
                throw var17_19;
            }
        }
        DefaultConnection.closeStatement(var8_6);
        return var16_18;
    }

    /*
     * Loose catch block
     */
    private static boolean a(Connection connection, String string, MonitorSnapshot monitorSnapshot, long l2, long l3, int n2, boolean bl2) throws SQLException {
        try {
            ProtocolQueryResultReader$DataStruct protocolQueryResultReader$DataStruct;
            block9: {
                block10: {
                    protocolQueryResultReader$DataStruct = ProtocolQueryResultReader.a(connection, string, false, l2, l3, n2);
                    if (protocolQueryResultReader$DataStruct.count == 0) {
                        return false;
                    }
                    if (!bl2) break block9;
                    if ("E".equals(protocolQueryResultReader$DataStruct.state)) break block9;
                    break block10;
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                }
                try {
                    block11: {
                        if ("A".equals(protocolQueryResultReader$DataStruct.state)) break block9;
                        break block11;
                        catch (SQLException sQLException) {
                            throw ProtocolQueryResultReader.a(sQLException);
                        }
                    }
                    if ("B".equals(protocolQueryResultReader$DataStruct.state)) break block9;
                }
                catch (SQLException sQLException) {
                    throw ProtocolQueryResultReader.a(sQLException);
                }
                return false;
            }
            ProtocolQueryResultReader$DataStruct protocolQueryResultReader$DataStruct2 = ProtocolQueryResultReader.a(connection, string, true, l2, l3, n2);
            double d10 = 0.0;
            d10 = (double)protocolQueryResultReader$DataStruct2.count / ((double)protocolQueryResultReader$DataStruct.count * 1.0);
            monitorSnapshot.setAlarmsPertentage(d10);
            monitorSnapshot.setResultValue(protocolQueryResultReader$DataStruct.value, protocolQueryResultReader$DataStruct.errorCode);
            monitorSnapshot.setResultTypeId(n2);
            monitorSnapshot.setThresholdState(protocolQueryResultReader$DataStruct.state);
            monitorSnapshot.setRunDateTime(protocolQueryResultReader$DataStruct.runTime);
        }
        catch (SQLException sQLException) {
            throw new SQLException("fetchAlarmRate: " + sQLException);
        }
        return true;
    }

    public static Map getCountMap(Connection connection, Object[] objectArray, boolean bl2, long l2) throws SQLException {
        HashMap<ProtocolQueryResultReader$ScheduleHostMetrics, Object> hashMap;
        block14: {
            PreparedStatement preparedStatement = null;
            int n2 = ExecutorHelper.b();
            hashMap = new HashMap<ProtocolQueryResultReader$ScheduleHostMetrics, Object>();
            try {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = objectArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    try {
                        stringBuffer.append(" SELECT R.SCHEDULE_HOST_ID_C, R.RESULT_TYPE_ID_C, COUNT(*), MAX(R.RUN_DATE_TIME_C)");
                        stringBuffer.append(" FROM ").append(objectArray[i2]).append(" R");
                        stringBuffer.append(" WHERE");
                        if (bl2) {
                            stringBuffer.append(" R.THRESHOLD_STATE_C<> '").append("N").append("'");
                            stringBuffer.append(" AND R.THRESHOLD_STATE_C<> '").append("R").append("'");
                            stringBuffer.append(" AND");
                        }
                    }
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                    try {
                        stringBuffer.append(" R.RUN_DATE_TIME_C>").append(l2).append(" AND");
                        stringBuffer.append(" R.PERIOD_INDEX_C<>").append(-2);
                        stringBuffer.append(" GROUP BY R.SCHEDULE_HOST_ID_C, R.RESULT_TYPE_ID_C");
                        if (i2 == n3 - 1) continue;
                        stringBuffer.append(" UNION ");
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                }
                preparedStatement = connection.prepareStatement(stringBuffer.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    try {
                        hashMap.put(new ProtocolQueryResultReader$ScheduleHostMetrics(resultSet.getLong(1), resultSet.getInt(2)), resultSet.getObject(3));
                        if (n2 != 0) {
                            if (n2 != 0) continue;
                            break;
                        }
                        break block14;
                    }
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                }
            }
            catch (SQLException sQLException) {
                try {
                    throw new SQLException("Read pm_protocol_query_result to count alarms " + sQLException);
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
            DefaultConnection.closeStatement(preparedStatement);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    public static List getReportAvgList(Connection var0, String var1_1, int var2_2, long var3_3, long var5_4, boolean var7_5, int var8_6, String var9_7, String var10_8, int var11_9) throws SQLException {
        block22: {
            var13_10 = null;
            var14_11 = new ArrayList<ReportMonitorBean>();
            var12_12 = ExecutorHelper.b();
            try {
                block21: {
                    var15_13 = new StringBuffer(" H.SCHEDULE_ID_C, H.IP_ADDRESS_C, AVG(R.RESULT_VALUE_C) FROM ");
                    var15_13.append(var1_1);
                    var15_13.append(" R INNER JOIN PM_SCHEDULE_HOST H ON H.SCHEDULE_HOST_ID_C=R.SCHEDULE_HOST_ID_C WHERE R.RESULT_TYPE_ID_C=");
                    var15_13.append(var2_2);
                    if (var11_9 == 1) ** GOTO lbl19
                    try {
                        block24: {
                            if (var11_9 != 2) break block21;
                            break block24;
                            catch (SQLException v0) {
                                throw ProtocolQueryResultReader.a(v0);
                            }
                        }
                        var15_13.append(" AND H.SCHEDULE_ID_C= ");
                        var15_13.append(Integer.parseInt(var9_7));
                        var15_13.append(" AND H.IP_ADDRESS_C= '");
                        var15_13.append(var10_8).append("'");
                    }
                    catch (SQLException v1) {
                        throw ProtocolQueryResultReader.a(v1);
                    }
                }
                try {
                    var15_13.append(" AND (R.ERROR_CODE_C='");
                    var15_13.append("N");
                    var15_13.append("' OR R.ERROR_CODE_C='").append("R");
                    var15_13.append("' OR R.ERROR_CODE_C='").append("A").append("' OR R.ERROR_CODE_C='");
                    var15_13.append("B");
                    var15_13.append("') AND R.RUN_DATE_TIME_C BETWEEN ");
                    var15_13.append(var3_3);
                    var15_13.append(" AND ");
                    var15_13.append(var5_4);
                    var15_13.append(" AND R.PERIOD_INDEX_C<>");
                    var15_13.append(-2);
                    var15_13.append(" GROUP BY H.SCHEDULE_ID_C, H.IP_ADDRESS_C ORDER BY AVG(R.RESULT_VALUE_C)");
                    if (!var7_5) {
                        var15_13.append(" DESC ");
                    }
                }
                catch (SQLException v2) {
                    throw ProtocolQueryResultReader.a(v2);
                }
                if (var8_6 == -1) {
                    var13_10 = var0.prepareStatement("SELECT" + var15_13.toString());
                } else {
                    var13_10 = var0.prepareStatement(ServerBundle.getSqlString(var15_13.toString(), var8_6));
                    var13_10.setMaxRows(var8_6);
                }
                var16_15 = var13_10.executeQuery();
                var17_16 = 0;
                while (var16_15.next()) {
                    block23: {
                        var18_17 = var16_15.getInt(1);
                        var19_18 = var16_15.getString(2);
                        try {
                            if (var12_12 == 0) break block22;
                            if (!MonitorHost.isMultiHosts(var19_18)) break block23;
                        }
                        catch (SQLException v3) {
                            throw ProtocolQueryResultReader.a(v3);
                        }
                        var19_18 = MonitorHost.getMetricsHost(var19_18, ExecutorHelper.getName(var2_2));
                    }
                    var20_19 = ProtocolQueryResult.getGraceValue(String.valueOf(var16_15.getDouble(3)), 3);
                    try {
                        v4 = v5;
                        v6 = v5;
                        v7 = MonitorCache.getMonitorName(var18_17);
                        v8 = var19_18;
                        v9 = var20_19;
                        v10 = var17_16 % 2 == 0;
                    }
                    catch (SQLException v11) {
                        throw ProtocolQueryResultReader.a(v11);
                    }
                    v4(v7, v8, v9, v10, var18_17);
                    var21_20 = v6;
                    var14_11.add(var21_20);
                    ++var17_16;
                    if (var12_12 != 0) continue;
                }
            }
            catch (SQLException var15_14) {
                try {
                    ProtocolQueryResultReader._logger.error((Object)"", (Throwable)var15_14);
                    throw new SQLException("Read pm_protocol_query_result to get report data list " + var15_14);
                }
                catch (Throwable var22_21) {
                    DefaultConnection.closeStatement(var13_10);
                    throw var22_21;
                }
            }
            DefaultConnection.closeStatement(var13_10);
        }
        try {
            v12 = var14_11;
            if (Command.b() != null) {
                ExecutorHelper.b(++var12_12);
            }
        }
        catch (SQLException v13) {
            throw ProtocolQueryResultReader.a(v13);
        }
        return v12;
    }

    public static List getReportAlarmList(Connection connection, String string, int n2, long l2, long l3, boolean bl2, int n3, QueryParameter queryParameter, int n4) throws SQLException {
        Object object;
        Object object2;
        int n5;
        Object[] objectArray;
        int n6;
        int n7;
        block25: {
            int n8;
            block27: {
                block26: {
                    int n9;
                    block21: {
                        Map map = ProtocolQueryResultReader.getCountMap(connection, string, n2, l2, l3, false, queryParameter, n4);
                        n7 = map.size();
                        n6 = ExecutorHelper.b();
                        try {
                            if (n7 == 0) {
                                return new ArrayList(0);
                            }
                        }
                        catch (SQLException sQLException) {
                            throw ProtocolQueryResultReader.a(sQLException);
                        }
                        Map map2 = ProtocolQueryResultReader.getCountMap(connection, string, n2, l2, l3, true, queryParameter, n4);
                        objectArray = new ProtocolQueryResultReader$CountKey[n7];
                        n5 = 0;
                        for (Map.Entry object32 : map.entrySet()) {
                            block24: {
                                block23: {
                                    block22: {
                                        object2 = (ProtocolQueryResultReader$CountKey)object32.getKey();
                                        try {
                                            try {
                                                n9 = bl2 ? 1 : 0;
                                                if (n6 == 0) break block21;
                                                if (n9 == 0) break block22;
                                            }
                                            catch (SQLException sQLException) {
                                                throw ProtocolQueryResultReader.a(sQLException);
                                            }
                                            ((ProtocolQueryResultReader$CountKey)object2).setAsc(true);
                                        }
                                        catch (SQLException sQLException) {
                                            throw ProtocolQueryResultReader.a(sQLException);
                                        }
                                    }
                                    object = (Number)map2.get(object2);
                                    try {
                                        if (object != null) break block23;
                                        ((ProtocolQueryResultReader$CountKey)object2).setValue(0.0);
                                        if (n6 != 0) break block24;
                                    }
                                    catch (SQLException sQLException) {
                                        throw ProtocolQueryResultReader.a(sQLException);
                                    }
                                }
                                double string6 = ((Number)object32.getValue()).intValue();
                                ((ProtocolQueryResultReader$CountKey)object2).setValue(((Number)object).doubleValue() / string6);
                            }
                            objectArray[n5] = object2;
                            ++n5;
                            if (n6 != 0) continue;
                        }
                        Arrays.sort(objectArray);
                        n9 = n3;
                    }
                    try {
                        try {
                            if (n9 == -1) break block25;
                            if (n3 >= n7) break block26;
                        }
                        catch (SQLException sQLException) {
                            throw ProtocolQueryResultReader.a(sQLException);
                        }
                        n8 = n3;
                        break block27;
                    }
                    catch (SQLException sQLException) {
                        throw ProtocolQueryResultReader.a(sQLException);
                    }
                }
                n8 = n7;
            }
            n7 = n8;
        }
        ArrayList<ReportMonitorBean> arrayList = new ArrayList<ReportMonitorBean>(n7);
        object2 = ExecutorHelper.getName(n2);
        for (n5 = 0; n5 < n7; ++n5) {
            boolean bl3;
            String string2;
            String string3;
            String string4;
            ReportMonitorBean reportMonitorBean;
            ReportMonitorBean reportMonitorBean2;
            ArrayList<ReportMonitorBean> arrayList2;
            String string5;
            String string6;
            block29: {
                block28: {
                    object = objectArray[n5];
                    string6 = MonitorCache.getMonitorName(((ProtocolQueryResultReader$CountKey)object)._id);
                    if (!MonitorHost.isMultiHosts(((ProtocolQueryResultReader$CountKey)object)._host)) break block28;
                    string5 = MonitorHost.getMetricsHost(((ProtocolQueryResultReader$CountKey)object)._host, (String)object2);
                    if (n6 != 0) break block29;
                }
                string5 = ((ProtocolQueryResultReader$CountKey)object)._host;
            }
            String string7 = ProtocolQueryResult.getGraceValue(String.valueOf(((ProtocolQueryResultReader$CountKey)object)._value * 100.0), 2);
            try {
                ReportMonitorBean reportMonitorBean3;
                arrayList2 = arrayList;
                reportMonitorBean2 = reportMonitorBean3;
                reportMonitorBean = reportMonitorBean3;
                string4 = string6;
                string3 = string5;
                string2 = string7;
                bl3 = n5 % 2 == 0;
            }
            catch (SQLException sQLException) {
                throw ProtocolQueryResultReader.a(sQLException);
            }
            reportMonitorBean2(string4, string3, string2, bl3, ((ProtocolQueryResultReader$CountKey)object)._id);
            arrayList2.add(reportMonitorBean);
            if (n6 != 0) continue;
        }
        return arrayList;
    }

    /*
     * Unable to fully structure code
     */
    public static Map getCountMap(Connection var0, String var1_1, int var2_2, long var3_3, long var5_4, boolean var7_5, QueryParameter var8_6, int var9_7) throws SQLException {
        block16: {
            var11_8 = null;
            var12_9 = new HashMap<ProtocolQueryResultReader$CountKey, Object>();
            var10_10 = ExecutorHelper.c();
            try {
                block15: {
                    var13_11 = new StringBuffer("SELECT H.SCHEDULE_ID_C, H.IP_ADDRESS_C, COUNT(*) FROM ");
                    var13_11.append(var1_1);
                    var13_11.append(" R INNER JOIN PM_SCHEDULE_HOST H ON H.SCHEDULE_HOST_ID_C=R.SCHEDULE_HOST_ID_C WHERE R.RESULT_TYPE_ID_C=");
                    var13_11.append(var2_2);
                    if (var9_7 == 1) ** GOTO lbl19
                    try {
                        block17: {
                            if (var9_7 != 2) break block15;
                            break block17;
                            catch (SQLException v0) {
                                throw ProtocolQueryResultReader.a(v0);
                            }
                        }
                        var13_11.append(" AND H.SCHEDULE_ID_C= ");
                        var13_11.append(Integer.parseInt(var8_6.get(6).toString()));
                        var13_11.append(" AND H.IP_ADDRESS_C= '");
                        var13_11.append(var8_6.get(5).toString()).append("'");
                    }
                    catch (SQLException v1) {
                        throw ProtocolQueryResultReader.a(v1);
                    }
                }
                try {
                    if (var7_5) {
                        var13_11.append(" AND R.THRESHOLD_STATE_C<> '");
                        var13_11.append("N");
                        var13_11.append("' AND R.THRESHOLD_STATE_C<> '");
                        var13_11.append("R");
                        var13_11.append("' AND R.THRESHOLD_STATE_C<> '").append("U").append("'");
                    }
                }
                catch (SQLException v2) {
                    throw ProtocolQueryResultReader.a(v2);
                }
                var13_11.append(" AND R.RUN_DATE_TIME_C BETWEEN ");
                var13_11.append(var3_3);
                var13_11.append(" AND ");
                var13_11.append(var5_4);
                var13_11.append(" AND R.PERIOD_INDEX_C<>");
                var13_11.append(-2);
                var13_11.append(" GROUP BY H.SCHEDULE_ID_C, H.IP_ADDRESS_C");
                var11_8 = var0.prepareStatement(var13_11.toString());
                var14_13 = var11_8.executeQuery();
                while (var14_13.next()) {
                    var15_14 = var14_13.getInt(1);
                    var16_15 = var14_13.getString(2);
                    try {
                        var12_9.put(new ProtocolQueryResultReader$CountKey(var15_14, var16_15), var14_13.getObject(3));
                        if (var10_10 == 0) {
                            if (var10_10 == 0) continue;
                            break;
                        }
                        break block16;
                    }
                    catch (SQLException v3) {
                        throw ProtocolQueryResultReader.a(v3);
                    }
                }
            }
            catch (SQLException var13_12) {
                try {
                    throw new SQLException("Read pm_protocol_query_result to get report data list " + var13_12);
                }
                catch (Throwable var17_16) {
                    DefaultConnection.closeStatement(var11_8);
                    throw var17_16;
                }
            }
            DefaultConnection.closeStatement(var11_8);
        }
        return var12_9;
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

