/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.server.performance.RemoteHostReader;
import com.sysuptime.server.performance.RemoteHostWriter;
import com.sysuptime.server.util.DefaultConnection;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;

public class RemoteHostProcessor
implements Serializable {
    private static Hashtable _hostMap = new Hashtable();

    private RemoteHostProcessor() {
    }

    public static List getFlagedRemoteHostList() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = RemoteHostReader.getFlagedRemoteHostList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static List getRemoteHostNameList() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = RemoteHostReader.getRemoteHostNameList(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static List getRemoteHosts(int n2) throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = RemoteHostReader.getRemoteHosts(connection, n2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    public static List getRemoteHosts() throws SQLException {
        List list = null;
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            list = RemoteHostReader.getRemoteHosts(connection);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteHost getRemoteHostByHostId(long l2) throws SQLException {
        RemoteHost remoteHost = null;
        Long l3 = l2;
        remoteHost = (RemoteHost)_hostMap.get(l3);
        try {
            if (remoteHost != null) {
                return remoteHost;
            }
        }
        catch (SQLException sQLException) {
            throw RemoteHostProcessor.a(sQLException);
        }
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            remoteHost = RemoteHostReader.getRemoteHost(connection, l2);
            try {
                if (remoteHost != null) {
                    _hostMap.put(l3, remoteHost);
                }
            }
            catch (SQLException sQLException) {
                throw RemoteHostProcessor.a(sQLException);
            }
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
        return remoteHost;
    }

    public static void storeRemoteHost(RemoteHost remoteHost) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            RemoteHostWriter.storeRemoteHost(connection, remoteHost);
            Long l2 = remoteHost.getHostId();
            _hostMap.put(l2, remoteHost);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void updateRemoteHost(RemoteHost remoteHost) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            RemoteHostWriter.updateRemoteHost(connection, remoteHost);
            Long l2 = remoteHost.getHostId();
            _hostMap.put(l2, remoteHost);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    public static void removeRemoteHost(long l2) throws SQLException {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            RemoteHostWriter.deleteRemoteHost(connection, l2);
            _hostMap.remove(l2);
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }

    private static SQLException a(SQLException sQLException) {
        return sQLException;
    }
}

