/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.ServerBundle;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class TempResultReader {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List getResultConditions(Connection connection) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = ExecutorHelper.c();
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(" SELECT DISTINCT RESULT_CONDITION_C FROM PM_TEMP_RESULT ");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    arrayList.add(resultSet.getObject(1));
                    if (n2 != 0) return arrayList;
                    if (n2 == 0) continue;
                    return arrayList;
                }
                catch (Exception exception) {
                    throw TempResultReader.a(exception);
                    return arrayList;
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException("Read pm_temp_result to get stddev " + exception.toString());
        }
        finally {
            DefaultConnection.closeStatement(preparedStatement);
        }
    }

    public static double getResultValueAvg(Connection connection, int n2) throws SQLException {
        double d10 = 0.0;
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(" SELECT AVG(RESULT_VALUE_C) FROM PM_TEMP_RESULT WHERE RESULT_CONDITION_C=?");
            preparedStatement.setInt(1, n2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                d10 = resultSet.getDouble(1);
            }
        }
        catch (Exception exception) {
            throw new SQLException("Read pm_temp_result to get stddev " + exception.toString());
        }
        finally {
            DefaultConnection.closeStatement(preparedStatement);
        }
        return d10;
    }

    public static double getResultValueStddev(Connection connection, int n2, double d10) throws SQLException {
        PreparedStatement preparedStatement;
        double d11;
        block11: {
            d11 = 0.0;
            int n3 = ExecutorHelper.c();
            preparedStatement = null;
            try {
                double d12;
                block12: {
                    if (ServerBundle.isFireBird()) {
                        preparedStatement = connection.prepareStatement("SELECT * FROM PM_TEMP_RESULT_DEV(?,?)");
                        preparedStatement.setInt(1, n2);
                        preparedStatement.setDouble(2, d10);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        if (resultSet.next()) {
                            d11 = Math.sqrt(resultSet.getDouble(1));
                        }
                        break block11;
                    }
                    preparedStatement = connection.prepareStatement("SELECT result_value_c FROM PM_TEMP_RESULT WHERE result_condition_c = ?");
                    preparedStatement.setInt(1, n2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    d12 = 0.0;
                    int n4 = 0;
                    while (resultSet.next()) {
                        double d13 = resultSet.getDouble(1) - d10;
                        d12 += d13 * d13;
                        try {
                            ++n4;
                            if (n3 == 0) {
                                if (n3 == 0) continue;
                                break;
                            }
                            break block12;
                        }
                        catch (Exception exception) {
                            throw TempResultReader.a(exception);
                        }
                    }
                    if (n4 > 1) {
                        d12 /= (double)(n4 - 1);
                    }
                }
                d11 = Math.sqrt(d12);
            }
            catch (Exception exception) {
                try {
                    throw new SQLException("Read pm_temp_result to get stddev " + exception.toString());
                }
                catch (Throwable throwable) {
                    DefaultConnection.closeStatement(preparedStatement);
                    throw throwable;
                }
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
        return d11;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

