/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.server.util.GraceConfig;
import com.sysuptime.server.util.MBeanManager;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.log4j.Logger;
import org.jboss.util.threadpool.ThreadPool;

public class BootFinder {
    private static final Logger _logger = Logger.getLogger((String)BootFinder.class.getName());
    private static MBeanServer _server;
    private static String _nodeName;
    private static ThreadPool _threadPool;
    private static String _bindAddress;
    private static int _hajndiPort;
    public static boolean IS_SINGLE_SERVER;

    private BootFinder() {
    }

    public static boolean isSingleServer() {
        return true;
    }

    public static MBeanServer getServer() {
        return MBeanManager.getInstance().getMBeanServer();
    }

    public static ThreadPool getThreadPool() {
        return _threadPool;
    }

    public static String getLocalNodeName() {
        return _nodeName;
    }

    public static int getNodesSize() {
        return 1;
    }

    public static List getCurrentNodes() {
        if (IS_SINGLE_SERVER) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            arrayList.add(_nodeName);
            return arrayList;
        }
        List list = null;
        try {
            ObjectName objectName = GraceConfig.getPartitionName();
            list = (List)_server.getAttribute(objectName, "CurrentView");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            _logger.error((Object)attributeNotFoundException);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            _logger.error((Object)instanceNotFoundException);
        }
        catch (MBeanException mBeanException) {
            _logger.error((Object)mBeanException);
        }
        catch (ReflectionException reflectionException) {
            _logger.error((Object)reflectionException);
        }
        return list;
    }

    public static String getLocalBindAddress() {
        return _bindAddress;
    }

    public static int getHajndiPort() {
        return _hajndiPort;
    }

    static {
        IS_SINGLE_SERVER = true;
    }
}

