/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.common.util.TimebasedCache;
import com.sysuptime.common.util.TimebasedCacheObject;
import com.sysuptime.server.util.ServerConfig;
import java.util.ArrayList;

public class WebClients {
    private static WebClients _instance = new WebClients();
    public static final boolean DEMO_MODE = false;
    static long _clientMaxIdleTime = 1557628928L;
    static TimebasedCache _clientCache;

    private WebClients() {
    }

    public static WebClients getInstance() {
        return _instance;
    }

    public ArrayList removeExpiredClients() {
        return _clientCache.removeExpiredObjects(_clientMaxIdleTime);
    }

    public void addClient(String string) {
        _clientCache.add(new TimebasedCacheObject(string), _clientMaxIdleTime, true);
    }

    public void removeClient(TimebasedCacheObject timebasedCacheObject) {
        _clientCache.remove(timebasedCacheObject);
    }

    public void removeClient(String string) {
        this.removeClient(new TimebasedCacheObject(string));
    }

    public boolean removeOneClient() {
        int n2 = this.getClientSize();
        if (n2 <= 0) {
            return false;
        }
        ArrayList arrayList = _clientCache.getValidObjects(_clientMaxIdleTime);
        if (arrayList.size() <= 0) {
            return false;
        }
        this.removeClient(new TimebasedCacheObject(arrayList.get(0)));
        return true;
    }

    public int getClientSize() {
        return _clientCache.getSize();
    }

    public boolean checkSession(String string) {
        return this.checkSession(string, true);
    }

    public boolean checkSession(String string, boolean bl2) {
        TimebasedCacheObject timebasedCacheObject = new TimebasedCacheObject(string);
        _clientCache.removeExpiredObjects(_clientMaxIdleTime);
        if (!_clientCache.contains(timebasedCacheObject)) {
            return false;
        }
        if (bl2) {
            _clientCache.add(new TimebasedCacheObject(string), _clientMaxIdleTime, true);
        }
        return true;
    }

    static {
        String string = ServerConfig.getProperty("web.clientIdleTime");
        if (string != null) {
            _clientMaxIdleTime = Long.parseLong(string);
        }
        _clientCache = new TimebasedCache();
    }
}

