/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.client.auth.TunnelAuthenticator;
import net.sf.jradius.exception.StandardViolatedException;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.RadiusResponse;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.standard.RadiusStandard;
import net.sf.jradius.util.RadiusRandom;

public class RadClient {
    private static RadiusClient client;

    private static void usage() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("RadClient Arguments: [options] server secret file\n");
        sb.append("\tserver\t\t\t= RADIUS server hostname or ip\n");
        sb.append("\tsecret\t\t\t= Shared secret to use\n");
        sb.append("\tfile\t\t\t= File containing the attribute name/value pairs\n");
        sb.append("\nOptions:\n");
        sb.append("\t-d java-class\t= Java class name of the attribute dictionary\n");
        sb.append("\t                 (default: net.sf.jradius.dictionary.RadiusDictionaryImpl)\n");
        sb.append("\t-s java-class\t= Java class name of the attribute checker\n");
        sb.append("\t                 (e.g net.sf.jradius.standard.WISPrStandard)\n");
        sb.append("\t-a auth-mode\t= Either PAP (default), CHAP, MSCHAP, MSCHAPv2,\n");
        sb.append("\t                 EAP-MD5, EAP-MSCHAPv2, or EAP-TLS (see below for format)\n");
        sb.append("\t                 (provide the plain-text password in User-Password)\n");
        sb.append("\t-T tunnel-mode\t= Only EAP-TTLS is currently supported (see below for info)\n");
        sb.append("\t-A\t\t= Generate a unique Acct-Session-Id in Accounting Requests\n");
        sb.append("\nUsing EAP-TLS and EAP-TTLS:\n");
        sb.append("\n");
        sb.append("(See http://jradius.sourceforge.net/radclient.html)\n");
        sb.append("\n");
        System.out.print(sb.toString());
    }

    private static boolean loadAttributes(AttributeList list, BufferedReader in) throws IOException {
        String line;
        boolean allowLine = true;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.equals("")) {
                if (allowLine) continue;
                break;
            }
            if (line.startsWith("sleep ")) {
                allowLine = true;
                try {
                    int i = Integer.parseInt(line.substring(6));
                    if (i <= 0) continue;
                    Thread.sleep(i * 1000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            allowLine = false;
            try {
                RadiusAttribute a = AttributeFactory.attributeFromString(line);
                if (a == null) continue;
                list.add(a, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return line != null;
    }

    public static void main(String[] args) {
        int op;
        Getopt g = new Getopt("RadClient", args, "s:a:d:t:p:T:A");
        String dictClass = "net.sf.jradius.dictionary.AttributeDictionaryImpl";
        String check = null;
        RadiusAuthenticator auth = null;
        int authPort = 1812;
        int acctPort = 1813;
        int timeout = 60;
        boolean tunneledRequest = false;
        boolean generateSessionId = false;
        RadiusAttribute generatedSessionId = null;
        block17: while ((op = g.getopt()) != -1) {
            switch (op) {
                case 65: {
                    generateSessionId = true;
                    continue block17;
                }
                case 115: {
                    check = g.getOptarg();
                    continue block17;
                }
                case 100: {
                    dictClass = g.getOptarg();
                    continue block17;
                }
                case 116: {
                    timeout = Integer.parseInt(g.getOptarg());
                    continue block17;
                }
                case 112: {
                    authPort = Integer.parseInt(g.getOptarg());
                    acctPort = authPort + 1;
                    continue block17;
                }
                case 84: {
                    tunneledRequest = true;
                }
                case 97: {
                    String arg = g.getOptarg();
                    auth = RadiusClient.getAuthProtocol(arg);
                    if (auth != null) continue block17;
                    System.err.println("Unsupported authentication protocol " + arg);
                    continue block17;
                }
            }
            RadClient.usage();
            return;
        }
        int gidx = g.getOptind();
        if (args.length - gidx < 3) {
            RadClient.usage();
            return;
        }
        String host = args[gidx];
        String secret = args[gidx + 1];
        String file = args[gidx + 2];
        AttributeFactory.loadAttributeDictionary(dictClass);
        try {
            boolean active = true;
            InetAddress inet = InetAddress.getByName(host);
            BufferedReader in = new BufferedReader(new FileReader(file));
            RadiusStandard standard = null;
            client = new RadiusClient(inet, secret, authPort, acctPort, timeout);
            if (check != null) {
                Class<?> c = Class.forName(check);
                try {
                    standard = (RadiusStandard)c.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            while (active) {
                RadiusResponse reply;
                RadiusRequest request;
                Integer status;
                AttributeList attributes = new AttributeList();
                active = RadClient.loadAttributes(attributes, in);
                if (attributes.getSize() == 0) continue;
                RadiusAttribute attr = attributes.get(40);
                if (attr != null && (status = (Integer)attr.getValue().getValueObject()) != null && status <= 3) {
                    request = new AccountingRequest(client, attributes);
                    if (generateSessionId) {
                        if (generatedSessionId == null) {
                            generatedSessionId = AttributeFactory.newAttribute("Acct-Session-Id", "JRadius-" + RadiusRandom.getRandomString(16), "=");
                        }
                        request.overwriteAttribute(generatedSessionId);
                    }
                    reply = client.accounting((AccountingRequest)request, 5);
                } else {
                    request = new AccessRequest(client, attributes);
                    if (tunneledRequest) {
                        if (auth instanceof TunnelAuthenticator) {
                            AttributeList attrs = new AttributeList();
                            active = RadClient.loadAttributes(attrs, in);
                            ((TunnelAuthenticator)((Object)auth)).setTunneledAttributes(attrs);
                        } else {
                            System.err.println("Error: -T option used with a non-tunnel authenticator: " + auth.getClass().getName());
                        }
                    }
                    reply = client.authenticate((AccessRequest)request, auth, 5);
                }
                if (standard != null) {
                    try {
                        standard.checkPacket(request);
                    }
                    catch (StandardViolatedException e) {
                        System.err.println("Warning: Access Request Missing " + standard.getName() + " Attributes:\n\t" + e.listAttributes());
                    }
                    try {
                        standard.checkPacket(reply);
                    }
                    catch (StandardViolatedException e) {
                        System.err.println("Warning: Access Reply Missing " + standard.getName() + " Attributes:\n\t" + e.listAttributes());
                    }
                }
                if (request != null) {
                    System.out.println(request.toString());
                }
                if (reply == null) continue;
                System.out.println(reply.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

