/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client;

import gnu.crypto.jce.GnuCrypto;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.sf.jradius.client.auth.PAPAuthenticator;
import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.exception.RadiusSecurityException;
import net.sf.jradius.exception.TimeoutException;
import net.sf.jradius.exception.UnknownAttributeException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.AccessChallenge;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.AccountingResponse;
import net.sf.jradius.packet.PacketFactory;
import net.sf.jradius.packet.RadiusFormat;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.RadiusResponse;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.session.JRadiusSession;
import net.sf.jradius.util.MD5;

public class RadiusClient {
    private static final int defaultAuthPort = 1812;
    private static final int defaultAcctPort = 1813;
    private static final int defaultTimeout = 60;
    protected InetAddress remoteInetAddress;
    protected String sharedSecret;
    protected int authPort = 1812;
    protected int acctPort = 1813;
    protected int socketTimeout = 60000;
    protected DatagramSocket socket;
    private MessageDigest md5Digest;
    protected JRadiusSession session;
    private static final RadiusFormat format = new RadiusFormat();
    protected static final LinkedHashMap authenticators = new LinkedHashMap();
    static /* synthetic */ Class class$net$sf$jradius$client$auth$PAPAuthenticator;
    static /* synthetic */ Class class$net$sf$jradius$client$auth$CHAPAuthenticator;
    static /* synthetic */ Class class$net$sf$jradius$client$auth$MSCHAPv1Authenticator;
    static /* synthetic */ Class class$net$sf$jradius$client$auth$MSCHAPv2Authenticator;
    static /* synthetic */ Class class$net$sf$jradius$client$auth$EAPMD5Authenticator;
    static /* synthetic */ Class class$net$sf$jradius$client$auth$EAPMSCHAPv2Authenticator;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;

    public RadiusClient() {
        try {
            this.socket = new DatagramSocket();
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            RadiusLog.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public RadiusClient(InetAddress address, String secret) {
        this();
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
    }

    public RadiusClient(InetAddress address, String secret, int authPort, int acctPort, int timeout) {
        this();
        this.setRemoteInetAddress(address);
        this.setSharedSecret(secret);
        this.setAuthPort(authPort);
        this.setAcctPort(acctPort);
        this.setSocketTimeout(timeout);
    }

    public static void registerAuthenticator(String name, Class c) {
        authenticators.put(name, c);
    }

    public static void registerAuthenticator(String name, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        authenticators.put(name, c);
    }

    public static RadiusAuthenticator getAuthProtocol(String protocolName) {
        Class c;
        RadiusAuthenticator auth = null;
        String[] args = null;
        int i = protocolName.indexOf(58);
        if (i > 0) {
            if (i < protocolName.length()) {
                args = protocolName.substring(i + 1).split(":");
            }
            protocolName = protocolName.substring(0, i);
        }
        if ((c = (Class)authenticators.get(protocolName = protocolName.toLowerCase())) == null) {
            return null;
        }
        try {
            auth = (RadiusAuthenticator)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (args != null) {
            HashMap<String, PropertyDescriptor> elements = new HashMap<String, PropertyDescriptor>();
            Class<?> clazz = auth.getClass();
            PropertyDescriptor[] props = null;
            try {
                props = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
            }
            catch (Exception e) {
                RadiusLog.error("Could not instanciate authenticator " + protocolName);
                return auth;
            }
            for (int p = 0; p < props.length; ++p) {
                PropertyDescriptor pd = props[p];
                Method m = pd.getWriteMethod();
                if (m == null) continue;
                elements.put(pd.getName(), pd);
            }
            for (int a = 0; a < args.length; ++a) {
                int eq = args[a].indexOf("=");
                if (eq <= 0) continue;
                String name = args[a].substring(0, eq);
                String value = args[a].substring(eq + 1);
                PropertyDescriptor pd = (PropertyDescriptor)elements.get(name);
                Method m = pd.getWriteMethod();
                if (m == null) {
                    RadiusLog.error("Authenticator " + protocolName + " does not have a writable attribute " + name);
                    continue;
                }
                Object valueObject = value;
                Class<?> cType = pd.getPropertyType();
                if (cType == (class$java$lang$Boolean == null ? RadiusClient.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    valueObject = new Boolean(value);
                } else if (cType == (class$java$lang$Integer == null ? RadiusClient.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    valueObject = new Integer(value);
                }
                try {
                    m.invoke((Object)auth, valueObject);
                    continue;
                }
                catch (Exception e) {
                    RadiusLog.error("Error setting attribute " + name + " for authenticator " + protocolName + ": " + e.getMessage());
                }
            }
        }
        return auth;
    }

    public RadiusResponse authenticate(AccessRequest p, RadiusAuthenticator auth, int retries) throws RadiusException, UnknownAttributeException {
        RadiusResponse reply;
        if (auth == null) {
            auth = new PAPAuthenticator();
        }
        auth.setupRequest(this, p);
        auth.processRequest(p);
        while ((reply = this.sendReceive(p, this.remoteInetAddress, this.authPort, retries)) instanceof AccessChallenge) {
            auth.processChallenge(p, reply);
        }
        return reply;
    }

    private void generateMessageAuthenticator(RadiusPacket request) {
        byte[] hash = new byte[16];
        request.overwriteAttribute(AttributeFactory.newAttribute(80, hash));
        System.arraycopy(MD5.hmac_md5(format.packPacket(request), this.sharedSecret.getBytes()), 0, hash, 0, 16);
    }

    private boolean verifyMessageAuthenticator(RadiusRequest request, RadiusResponse reply, boolean required) {
        byte[] requestAuth = request.getAuthenticator();
        byte[] replyAuth = reply.getAuthenticator();
        byte[] hash = new byte[16];
        RadiusAttribute attr = reply.findAttribute(80);
        if (attr == null) {
            return !required;
        }
        byte[] pval = attr.getValue().getBytes();
        attr.setValue(hash);
        reply.setAuthenticator(requestAuth);
        System.arraycopy(MD5.hmac_md5(format.packPacket(reply), this.sharedSecret.getBytes()), 0, hash, 0, 16);
        reply.setAuthenticator(replyAuth);
        return Arrays.equals(pval, hash);
    }

    private boolean verifyAuthenticator(RadiusRequest request, RadiusResponse reply) {
        return reply.verifyAuthenticator(this, request.getAuthenticator());
    }

    public AccountingResponse accounting(AccountingRequest p, int retries) throws RadiusException {
        RadiusResponse response = this.sendReceive(p, this.remoteInetAddress, this.acctPort, retries);
        if (!(response instanceof AccountingResponse)) {
            throw new RadiusException("Received something other than AccountingResponse to a AccountingRequest");
        }
        return (AccountingResponse)response;
    }

    public RadiusResponse sendReceive(RadiusRequest p, InetAddress a, int port, int retries) throws RadiusException {
        RadiusResponse r = null;
        int tries = 0;
        if (p instanceof AccessRequest) {
            this.generateMessageAuthenticator(p);
        }
        if (retries < 0) {
            retries = 0;
        }
        ++retries;
        while (tries < retries) {
            try {
                if (this.socketTimeout > 0) {
                    this.socket.setSoTimeout(this.socketTimeout);
                }
                this.send(p, a, port, tries);
                r = this.receive();
                break;
            }
            catch (SocketTimeoutException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++tries;
        }
        if (tries == retries) {
            throw new TimeoutException("Timeout: No Response from RADIUS Server");
        }
        if (!this.verifyAuthenticator(p, r)) {
            throw new RadiusSecurityException("Invalid RADIUS Authenticator");
        }
        if (!this.verifyMessageAuthenticator(p, r, r.findAttribute(79) != null)) {
            throw new RadiusSecurityException("Invalid RADIUS Message-Authenticator");
        }
        return r;
    }

    protected void send(RadiusPacket p, InetAddress a, int port, int attempt) throws IOException {
        if (attempt > 1) {
            RadiusLog.warn("RadiusClient retrying request (attempt " + attempt + ")...");
        }
        byte[] b = format.packPacket(p);
        DatagramPacket request = new DatagramPacket(b, b.length, a, port);
        this.socket.send(request);
    }

    protected RadiusResponse receive() throws IOException, RadiusException {
        byte[] replyBytes = new byte[4096];
        DatagramPacket reply = new DatagramPacket(replyBytes, replyBytes.length);
        this.socket.receive(reply);
        RadiusPacket replyPacket = PacketFactory.parse(reply);
        if (!(replyPacket instanceof RadiusResponse)) {
            throw new RadiusException("Received something other than a RADIUS Response to a Request");
        }
        return (RadiusResponse)replyPacket;
    }

    public MessageDigest getMD() {
        return this.md5Digest;
    }

    public int getAcctPort() {
        return this.acctPort;
    }

    public void setAcctPort(int acctPort) {
        this.acctPort = acctPort;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public void setAuthPort(int authPort) {
        this.authPort = authPort;
    }

    public int getSocketTimeout() {
        return this.socketTimeout / 1000;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout * 1000;
    }

    public InetAddress getRemoteInetAddress() {
        return this.remoteInetAddress;
    }

    public void setRemoteInetAddress(InetAddress remoteInetAddress) {
        this.remoteInetAddress = remoteInetAddress;
    }

    public InetAddress getLocalInetAddress() {
        return this.socket.getLocalAddress();
    }

    public void setLocalInetAddress(InetAddress localInetAddress) {
    }

    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RadiusClient.registerAuthenticator("pap", class$net$sf$jradius$client$auth$PAPAuthenticator == null ? (class$net$sf$jradius$client$auth$PAPAuthenticator = RadiusClient.class$("net.sf.jradius.client.auth.PAPAuthenticator")) : class$net$sf$jradius$client$auth$PAPAuthenticator);
        RadiusClient.registerAuthenticator("chap", class$net$sf$jradius$client$auth$CHAPAuthenticator == null ? (class$net$sf$jradius$client$auth$CHAPAuthenticator = RadiusClient.class$("net.sf.jradius.client.auth.CHAPAuthenticator")) : class$net$sf$jradius$client$auth$CHAPAuthenticator);
        RadiusClient.registerAuthenticator("mschapv1", class$net$sf$jradius$client$auth$MSCHAPv1Authenticator == null ? (class$net$sf$jradius$client$auth$MSCHAPv1Authenticator = RadiusClient.class$("net.sf.jradius.client.auth.MSCHAPv1Authenticator")) : class$net$sf$jradius$client$auth$MSCHAPv1Authenticator);
        RadiusClient.registerAuthenticator("mschapv2", class$net$sf$jradius$client$auth$MSCHAPv2Authenticator == null ? (class$net$sf$jradius$client$auth$MSCHAPv2Authenticator = RadiusClient.class$("net.sf.jradius.client.auth.MSCHAPv2Authenticator")) : class$net$sf$jradius$client$auth$MSCHAPv2Authenticator);
        RadiusClient.registerAuthenticator("mschap", class$net$sf$jradius$client$auth$MSCHAPv2Authenticator == null ? (class$net$sf$jradius$client$auth$MSCHAPv2Authenticator = RadiusClient.class$("net.sf.jradius.client.auth.MSCHAPv2Authenticator")) : class$net$sf$jradius$client$auth$MSCHAPv2Authenticator);
        RadiusClient.registerAuthenticator("eap-md5", class$net$sf$jradius$client$auth$EAPMD5Authenticator == null ? (class$net$sf$jradius$client$auth$EAPMD5Authenticator = RadiusClient.class$("net.sf.jradius.client.auth.EAPMD5Authenticator")) : class$net$sf$jradius$client$auth$EAPMD5Authenticator);
        RadiusClient.registerAuthenticator("eap-mschapv2", class$net$sf$jradius$client$auth$EAPMSCHAPv2Authenticator == null ? (class$net$sf$jradius$client$auth$EAPMSCHAPv2Authenticator = RadiusClient.class$("net.sf.jradius.client.auth.EAPMSCHAPv2Authenticator")) : class$net$sf$jradius$client$auth$EAPMSCHAPv2Authenticator);
        try {
            RadiusClient.registerAuthenticator("eap-tls", "net.sf.jradius.client.auth.EAPTLSAuthenticator");
            RadiusClient.registerAuthenticator("eap-ttls", "net.sf.jradius.client.auth.EAPTTLSAuthenticator");
        }
        catch (ClassNotFoundException e) {
            RadiusLog.warn("EAP-TLS and EAP-TTLS are only available with Java 1.5");
        }
        Security.addProvider((Provider)new GnuCrypto());
    }
}

