/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.auth;

import java.nio.ByteBuffer;
import net.sf.jradius.client.auth.RadiusAuthenticator;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.log.RadiusLog;
import net.sf.jradius.packet.RadiusPacket;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;

public abstract class EAPAuthenticator
extends RadiusAuthenticator {
    private byte eapType;
    public static final int EAP_HEADERLEN = 4;
    public static final int EAP_REQUEST = 1;
    public static final int EAP_RESPONSE = 2;
    public static final int EAP_SUCCESS = 3;
    public static final int EAP_FAILURE = 4;
    public static final int EAP_IDENTITY = 1;
    public static final int EAP_NOTIFICATION = 2;
    public static final int EAP_NAK = 3;
    public static final int EAP_MD5 = 4;
    public static final int EAP_OTP = 5;
    public static final int EAP_GTC = 6;
    public static final int EAP_TLS = 13;
    public static final int EAP_LEAP = 17;
    public static final int EAP_SIM = 18;
    public static final int EAP_TTLS = 21;
    public static final int EAP_PEAP = 25;
    public static final int EAP_MSCHAPV2 = 26;
    public static final int EAP_CISCO_MSCHAPV2 = 29;
    public static final int EAP_TLV = 33;

    public void processRequest(RadiusPacket p) throws RadiusException {
        p.removeAttribute(2);
        RadiusAttribute a = AttributeFactory.newAttribute(79, null);
        p.overwriteAttribute(a);
    }

    public void processChallenge(RadiusPacket p, RadiusPacket r) throws RadiusException {
        int len;
        RadiusAttribute a;
        p.setIdentifier((byte)0);
        Object[] aList = r.findAttributes(79);
        if (aList == null) {
            throw new RadiusException("No EAP-Message in AccessChallenge");
        }
        int eapLength = 0;
        for (int i = 0; i < aList.length; ++i) {
            a = (RadiusAttribute)aList[i];
            byte[] b = a.getValue().getBytes();
            if (b == null) continue;
            eapLength += b.length;
        }
        byte[] eapReply = new byte[eapLength];
        int eapOffset = 0;
        for (int i = 0; i < aList.length; ++i) {
            a = (RadiusAttribute)aList[i];
            byte[] b = a.getValue().getBytes();
            System.arraycopy(b, 0, eapReply, eapOffset, b.length);
            eapOffset += b.length;
        }
        byte[] eapMessage = this.doEAP(eapReply);
        a = r.findAttribute(24);
        if (a != null) {
            p.overwriteAttribute(a);
        }
        if ((a = p.findAttribute(79)) != null) {
            p.removeAttribute(a);
        }
        int offset = 0;
        for (int left = eapMessage == null ? 0 : eapMessage.length; left > 0; left -= len) {
            len = 253;
            if (left < 253) {
                len = left;
            }
            byte[] b = new byte[len];
            System.arraycopy(eapMessage, offset, b, 0, len);
            a = AttributeFactory.newAttribute(79, b);
            p.addAttribute(a);
            offset += len;
        }
        RadiusLog.debug("Sending Challenge:\n" + p.toString());
    }

    public byte getEAPType() {
        return this.eapType;
    }

    public void setEAPType(int eapType) {
        this.eapType = (byte)eapType;
    }

    public abstract byte[] doEAPType(byte var1, byte[] var2) throws RadiusException;

    protected byte[] doEAP(byte[] eapReply) throws RadiusException {
        if (eapReply != null) {
            ByteBuffer bb = ByteBuffer.wrap(eapReply);
            byte rtype = bb.get();
            byte id = bb.get();
            short dlen = bb.getShort();
            if (rtype != 1) {
                RadiusLog.error("Expecting an EAP-Request.. got code: " + rtype);
                return null;
            }
            byte eapcode = 0;
            byte[] data = null;
            if (dlen > 4) {
                eapcode = bb.get();
                if ((dlen = (short)(dlen - 4 - 1)) > 0) {
                    data = new byte[dlen];
                    bb.get(data);
                }
            }
            if (eapcode == 1) {
                return this.eapResponse(1, id, this.getUsername());
            }
            if (eapcode != this.eapType) {
                return this.negotiateEAPType(id, this.eapType);
            }
            return this.eapResponse(this.eapType, id, this.doEAPType(id, data));
        }
        return null;
    }

    protected byte[] negotiateEAPType(byte id, byte eapType) {
        return this.eapResponse(3, id, new byte[]{eapType});
    }

    protected byte[] eapResponse(int type, byte id, byte[] data) {
        int length = 5;
        if (data != null) {
            length = (short)(length + data.length);
        }
        byte[] Response = new byte[length];
        Response[0] = 2;
        Response[1] = id;
        Response[2] = (byte)(length >> 8 & 0xFF);
        Response[3] = (byte)(length & 0xFF);
        Response[4] = (byte)(type & 0xFF);
        if (data != null) {
            System.arraycopy(data, 0, Response, 5, data.length);
        }
        return Response;
    }
}

