/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.client.gui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import net.sf.jradius.client.gui.AttributesTableEntry;
import net.sf.jradius.exception.RadiusException;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.RadiusAttribute;

public class AttributesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private final String[] headers = new String[]{"Attribute Name", "AccessReq", "TunnelReq", "AcctStart", "AcctUpdate", "AcctStop", "Attribute Value"};
    private ArrayList entries = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public String getColumnName(int count) {
        return this.headers[count];
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int row, int col) {
        AttributesTableEntry entry = (AttributesTableEntry)this.entries.get(row);
        switch (col) {
            case 0: {
                return entry.getAttributeName();
            }
            case 1: {
                return entry.getAccessRequest();
            }
            case 2: {
                return entry.getTunnelRequest();
            }
            case 3: {
                return entry.getAccountingStart();
            }
            case 4: {
                return entry.getAccountingUpdate();
            }
            case 5: {
                return entry.getAccountingStop();
            }
            case 6: {
                return entry.getAttributeValue();
            }
        }
        return null;
    }

    public Class getColumnClass(int col) {
        if (col == 0 || col == 6) {
            return class$java$lang$String == null ? (class$java$lang$String = AttributesTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AttributesTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public void setValueAt(Object v, int row, int col) {
        AttributesTableEntry entry = (AttributesTableEntry)this.entries.get(row);
        switch (col) {
            case 0: {
                entry.setAttributeName((String)v);
                break;
            }
            case 1: {
                entry.setAccessRequest((Boolean)v);
                break;
            }
            case 2: {
                entry.setTunnelRequest((Boolean)v);
                break;
            }
            case 3: {
                entry.setAccountingStart((Boolean)v);
                break;
            }
            case 4: {
                entry.setAccountingUpdate((Boolean)v);
                break;
            }
            case 5: {
                entry.setAccountingStop((Boolean)v);
                break;
            }
            case 6: {
                entry.setAttributeValue((String)v);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public AttributesTableEntry addAttribute(String attributeName) throws RadiusException {
        RadiusAttribute attribute = AttributeFactory.newAttribute(attributeName);
        AttributesTableEntry entry = new AttributesTableEntry();
        entry.setAttributeName(attributeName);
        entry.setValueClass(attribute.getValue().getClass());
        this.entries.add(entry);
        return entry;
    }

    public AttributesTableEntry addAttribute(RadiusAttribute attribute) throws RadiusException {
        AttributesTableEntry entry = new AttributesTableEntry();
        entry.setAttributeName(attribute.getAttributeName());
        entry.setValueClass(attribute.getValue().getClass());
        this.entries.add(entry);
        return entry;
    }

    public ArrayList getEntries() {
        return this.entries;
    }

    public void setEntries(ArrayList entries) {
        if (entries != null) {
            this.entries = entries;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

