/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jradius.example;

import java.net.InetAddress;
import net.sf.jradius.client.RadiusClient;
import net.sf.jradius.client.auth.MSCHAPv2Authenticator;
import net.sf.jradius.dictionary.Attr_AcctInputOctets;
import net.sf.jradius.dictionary.Attr_AcctOutputOctets;
import net.sf.jradius.dictionary.Attr_AcctSessionId;
import net.sf.jradius.dictionary.Attr_AcctSessionTime;
import net.sf.jradius.dictionary.Attr_AcctStatusType;
import net.sf.jradius.dictionary.Attr_AcctTerminateCause;
import net.sf.jradius.dictionary.Attr_NASPort;
import net.sf.jradius.dictionary.Attr_NASPortType;
import net.sf.jradius.dictionary.Attr_UserName;
import net.sf.jradius.dictionary.Attr_UserPassword;
import net.sf.jradius.packet.AccessAccept;
import net.sf.jradius.packet.AccessRequest;
import net.sf.jradius.packet.AccountingRequest;
import net.sf.jradius.packet.RadiusRequest;
import net.sf.jradius.packet.RadiusResponse;
import net.sf.jradius.packet.attribute.AttributeFactory;
import net.sf.jradius.packet.attribute.AttributeList;
import net.sf.jradius.packet.attribute.RadiusAttribute;
import net.sf.jradius.util.RadiusRandom;

public class ExampleRadiusClient {
    public static void main(String[] args) {
        try {
            AttributeFactory.loadAttributeDictionary("net.sf.jradius.dictionary.AttributeDictionaryImpl");
            InetAddress host = InetAddress.getByName("localhost");
            RadiusClient rc = new RadiusClient(host, "test");
            AttributeList attrs = new AttributeList();
            attrs.add((RadiusAttribute)new Attr_UserName("test"));
            attrs.add((RadiusAttribute)new Attr_NASPortType("Wireless-802.11"));
            attrs.add((RadiusAttribute)new Attr_NASPort(new Integer(1)));
            RadiusRequest request = new AccessRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_UserPassword("test"));
            System.out.println("Sending:\n" + request.toString());
            RadiusResponse reply = rc.authenticate((AccessRequest)request, new MSCHAPv2Authenticator(), 5);
            System.out.println("Received:\n" + reply.toString());
            boolean isAuthenticated = reply instanceof AccessAccept;
            String replyMessage = (String)reply.getAttributeValue(18);
            if (replyMessage != null) {
                System.out.println("Reply Message: " + replyMessage);
            }
            if (!isAuthenticated) {
                return;
            }
            attrs.add((RadiusAttribute)new Attr_AcctSessionId(RadiusRandom.getRandomString(24)));
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType("Start"));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
            request = new AccountingRequest(rc, attrs);
            request.addAttribute((RadiusAttribute)new Attr_AcctStatusType("Stop"));
            request.addAttribute((RadiusAttribute)new Attr_AcctInputOctets(new Integer(10)));
            request.addAttribute((RadiusAttribute)new Attr_AcctOutputOctets(new Integer(10)));
            request.addAttribute((RadiusAttribute)new Attr_AcctSessionTime(new Integer(60)));
            request.addAttribute((RadiusAttribute)new Attr_AcctTerminateCause("User-Request"));
            System.out.println("Sending:\n" + request.toString());
            reply = rc.accounting((AccountingRequest)request, 5);
            System.out.println("Received:\n" + reply.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

